rem
rem Header: create_lexer.sql 16-May-03
rem
rem Copyright (c) 2001 Oracle Corporation.  All rights reserved.
rem
rem Owner  : 
rem
rem NAME
rem   create_lexer.sql - Script for createing lexer.
rem
rem DESCRIPTON
rem   
rem
rem MODIFIED   (MM/DD/YY)

REM ==========================================
REM Drop existing common preferences
REM ==========================================


exec ctx_ddl.drop_preference('GLOBAL_LEXER');
exec ctx_ddl.drop_preference('ENGLISH_LEXER');
exec ctx_ddl.drop_preference('JAPANESE_LEXER');
exec ctx_ddl.drop_preference('CHINESE_LEXER');
exec ctx_ddl.drop_preference('KOREAN_LEXER');
exec ctx_ddl.drop_preference('MY_FILTER');

REM ==========================================
REM Set INSO Filter to search Word, Excel, PPT, PDF files
REM ==========================================

exec ctx_ddl.create_preference('MY_FILTER','INSO_FILTER');

REM ==========================================
REM Set Basic lexer
REM ==========================================

exec ctx_ddl.create_preference('ENGLISH_LEXER','basic_lexer');
exec ctx_ddl.set_attribute('ENGLISH_LEXER','index_themes','yes');
exec ctx_ddl.set_attribute('ENGLISH_LEXER','theme_language','english');

REM ==========================================
REM Set Japanese Lexer
REM ==========================================

exec ctx_ddl.create_preference('JAPANESE_LEXER','japanese_vgram_lexer');

REM ==========================================
REM Set Chinese Lexer
REM ==========================================

exec ctx_ddl.create_preference('CHINESE_LEXER','chinese_vgram_lexer');

REM ==========================================
REM Set Korean Lexer
REM ==========================================

exec ctx_ddl.create_preference('KOREAN_LEXER','korean_morph_lexer');

REM ==========================================
REM Set Multi-lexer named GLOBAL_LEXER
REM ==========================================

exec ctx_ddl.create_preference('GLOBAL_LEXER', 'multi_lexer');

REM ==========================================
REM Set Language specific lexers to the Multi-lexer
REM The 4th parameter is identifiers of the lexers. 
REM Each document datum should have one of the values to 
REM indicate what language is used for the document.
REM ==========================================

exec ctx_ddl.add_sub_lexer('GLOBAL_LEXER','default','ENGLISH_LEXER');
exec ctx_ddl.add_sub_lexer('GLOBAL_LEXER','traditional chinese','CHINESE_LEXER','chn');
exec ctx_ddl.add_sub_lexer('GLOBAL_LEXER','japanese','JAPANESE_LEXER','jpn');
exec ctx_ddl.add_sub_lexer('GLOBAL_LEXER','korean','KOREAN_LEXER','kor');

REM ==========================================
REM End of the script
REM ==========================================

