set echo on pagesize 999 linesize 132 trimspool on

drop table emp_ext;

CREATE TABLE emp_ext
  (first_name, last_name, department_name)
   ORGANIZATION EXTERNAL
    (
     TYPE ORACLE_DATAPUMP
     DEFAULT DIRECTORY ext_tab_dir
     LOCATION
      ('emp1.exp','emp2.exp')
    )
   PARALLEL
AS
SELECT e.first_name
,      e.last_name
,      d.department_name
FROM   hr.employees   e JOIN
       hr.departments d USING (department_id)
WHERE  d.department_name
       in ('Marketing', 'Purchasing');
