package oracle.i18n.demo.obe.gdkshop.bean;
import java.io.Serializable;
import java.util.Comparator;
import oracle.i18n.text.OraCollationKey;
public class OrderItem implements Serializable
{
  public long orderId;
  public long productId;
  public String productName;
  public String productDescription;
  public double unitPrice;
  public int quantity;
  public OraCollationKey ocolkey;

  // Sorting order Ascendant
  public static final Comparator sortProdNameAsc =
    new Comparator()
    {
      public int compare(Object a, Object b)
      {
        OrderItem s = (OrderItem) a;
        OrderItem d = (OrderItem) b;
        return s.ocolkey.compareTo(d.ocolkey);
      }
    };

  // Sorting order Descendant
  public static final Comparator sortProdNameDesc =
    new Comparator()
    {
      public int compare(Object a, Object b)
      {
        OrderItem s = (OrderItem) a;
        OrderItem d = (OrderItem) b;

        return d.ocolkey.compareTo(s.ocolkey);
      }
    };

}