package oracle.i18n.demo.obe.gdkshop;

import oracle.i18n.demo.obe.gdkshop.bean.Customer;
import oracle.i18n.demo.obe.gdkshop.bean.Order;

import java.util.Comparator;
import java.util.List;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class OrderInformationAction extends HttpServlet
{
  public void doGet(HttpServletRequest request, HttpServletResponse response)
  {
    String userid = (String) request.getSession().getAttribute("userid");
    try
    {
      if (userid != null)
      {
        long orderId = ShopAction.getOrderId(request);
        Comparator sortDir = ShopAction.getSortDir(request);
        List orderItemList = ShopAction.getOrderItems(orderId, sortDir);
        request.setAttribute("orderitems", orderItemList);
        request.setAttribute("comparator", sortDir);
        Customer customer = ShopAction.getCustomer(userid);
        request.setAttribute("customer", customer);
        Order od = ShopAction.getOrder(orderId);
        request.setAttribute("order", od);
        request.getRequestDispatcher("orderinformation.jsp").forward(request,
          response
        );
      }
      else
        request.getRequestDispatcher("index.jsp").forward(request, response);
    }
    catch (Exception e)
    {
      throw new IllegalStateException(e.getMessage());
    }
  }
}
