col prod format a10
WITH v AS
         (SELECT
         p.Prod_Name Product_Name,
         t.Calendar_Year Year,
         t.Calendar_Week_Number Week,
         SUM(Amount_Sold) Sales
         FROM Sales s, Times t, Products p
         WHERE s.Time_id = t.Time_id AND
         s.Prod_id = p.Prod_id AND
         p.Prod_name in ('Y Box') AND
         t.Calendar_Year in (2000,2001) AND
         t.Calendar_Week_Number BETWEEN 30 AND 40
         GROUP BY p.Prod_Name, t.Calendar_Year, t.Calendar_Week_Number
         )
         SELECT substr(Product_Name,1,12) Prod, 
         Year, 
         Week, 
         Sales, 
         Weekly_ytd_sales wk_ytd_sales,
         Weekly_ytd_sales_prior_year wk_ytd_sales_pr_yr
         FROM
         (SELECT --Start of year_over_year sales
         Product_Name, Year, Week, Sales, Weekly_ytd_sales,
         LAG(Weekly_ytd_sales, 1) OVER
         (PARTITION BY Product_Name, Week ORDER BY Year)
         Weekly_ytd_sales_prior_year
         FROM
         (SELECT --Start of dense_sales
         v.Product_Name Product_Name,
         t.Year Year,
         t.Week Week,
         NVL(v.Sales,0) Sales,
         SUM(NVL(v.Sales,0)) OVER
         (PARTITION BY v.Product_Name, t.Year
         ORDER BY t.week) weekly_ytd_sales
         FROM v 
         PARTITION BY (v.Product_Name) 
         RIGHT OUTER JOIN
         (SELECT DISTINCT
         Calendar_Week_Number Week,
         Calendar_Year Year
         FROM Times
         WHERE Calendar_Year IN (2000, 2001)
         ) t
         ON (v.week = t.week AND v.Year = t.Year)
         ) dense_sales
         ) year_over_year_sales
         WHERE Year = 2001 AND
         Week BETWEEN 30 AND 40 
         ORDER BY 1, 2, 3;