col Product_Name format a25
SELECT Product_Name, t.Year, t.Week, Sales, Weekly_ytd_sales 
FROM  
  (SELECT 
    SUBSTR(p.Prod_Name,1,15) Product_Name,
    t.Calendar_Year Year,
    t.Calendar_Week_Number Week,
    NVL(SUM(Amount_Sold),0) Sales,
    SUM(SUM(Amount_Sold)) OVER
     (PARTITION BY p.Prod_Name, t.Calendar_Year
      ORDER BY t.Calendar_Week_Number) Weekly_ytd_sales
    FROM Sales s, Times t, Products p
    WHERE s.Time_id = t.Time_id AND
      s.Prod_id = p.Prod_id AND
      p.Prod_name IN ('Bounce') AND
      t.Calendar_Year IN (2000,2001)  AND
      t.Calendar_Week_Number BETWEEN  20 AND 30   
    GROUP BY p.Prod_Name, t.Calendar_Year, t.Calendar_Week_Number
   )  v
PARTITION BY  (v.Product_Name) 
  RIGHT OUTER JOIN
    (SELECT DISTINCT
      Calendar_Week_Number Week,
      Calendar_Year Year
     FROM Times
     WHERE Calendar_Year in (2000, 2001)
    ) t
  ON (v.week = t.week AND v.Year = t.Year) 
WHERE t.Week BETWEEN 20 AND 30 
ORDER BY 1, 2, 3;
