#!/bin/sh -e

# === upgradecommon.inc ===
#!/bin/sh
# $Revision$

check_upgrade_version() {
	INSTALLED_VERSION="${1:?Missing installed verison string}"
	MINIMAL_UPGRADE_VERSION="8.0.0"

	v1=${INSTALLED_VERSION%%.*}
	v2=${MINIMAL_UPGRADE_VERSION%%.*}
	[ $v1 -lt $v2 ] && return 1
	[ $v1 -gt $v2 ] && return 0

	v1=`echo $INSTALLED_VERSION | sed 's/^[0-9]*\.\([0-9]*\)\..*/\1/'`
	v2=`echo $MINIMAL_UPGRADE_VERSION | sed 's/^[0-9]*\.\([0-9]*\)\..*/\1/'`
	[ $v1 -lt $v2 ] && return 1
	[ $v1 -gt $v2 ] && return 0

	v1=`echo $INSTALLED_VERSION | sed 's/^[0-9]*\.[0-9]*\.\([0-9]*\).*/\1/'`
	v2=`echo $MINIMAL_UPGRADE_VERSION | sed 's/^[0-9]*\.[0-9]*\.\([0-9]*\).*/\1/'`
	[ $v1 -lt $v2 ] && return 1
	return 0
}

grubenv_create() {
	grubenv="${1:?Missing grubenv file}"
	if which grub-editenv >/dev/null; then
		grub-editenv "$grubenv" create
	else
		echo "# GRUB Environment Block" > "$grubenv"
		for i in `seq 1 27`; do echo -n "#####################################" >> "$grubenv"; done # dump 27*37=999 x '#'
	fi
}
# ================
if ! check_upgrade_version "`cat /etc/version`"; then
	error 305 "Kerio Control can't be upgraded from this version."
	exit 1
fi

if [ "64" = "64" ]; then
	if ! grep -q -w "^flags.* lm" /proc/cpuinfo; then
		error 306 "This version of Kerio Control doesn't support your 32-bit hardware. Upgrade your hardware to 64-bit."
		exit 1
	fi
fi

# === firebirdbackup.inc ===
star_fdb=/opt/kerio/winroute/star/data/star.fdb
star_fbk=/opt/kerio/winroute/star/data/star.fbk

odsVersion=$(fbstat ${star_fdb} 2>/dev/null | awk '/ODS version/ {print $3*10}')
if [ "$odsVersion" -lt 110 ]; then
	if ! gbak -backup_database ${star_fdb} ${star_fbk} -password masterkey -user sysdba -verify; then
		error 307 "Failed to backup Star database."
		exit 1
	fi
fi
# ================

if [ ! -s /boot/boot/version ] || [ $(cat /boot/boot/version) -lt 1 ]; then
	if ! tar -xzvf "$1" -C /tmp grub; then
		error 302 "Failed to extract grub images."
		exit 1
	fi
	disk_=`grep " / " /proc/mounts | grep -v rootfs | sed 's/[23] .*//'`
	echo "(hd0) $disk_" > /tmp/grub-device.map
	PATH="$PATH:/tmp/grub"
	if ! grub-setup --root-device="(hd0,1)" --device-map=/tmp/grub-device.map --directory=/tmp/grub "(hd0)"; then
		error 302 "Failed to install grub images."
		exit 1
	fi

	flock=`which flock || echo true`
	exec 9>/tmp/trial.lock
	$flock 9

	if ! mount -o remount,rw /boot; then
		$flock -u 9
		error 302 "Failed to install grub images."
		exit 1
	fi
	UUID=`blkid ${disk_}1 | sed 's/.*UUID="\([^"]*\)".*/\1/'`
	sed "s/loader=UUID:\S*/loader=UUID:$UUID/" /tmp/grub/grub.cfg > /boot/boot/grub/grub.cfg
	echo 1 > /boot/boot/version
	mount -o remount,ro /boot
	$flock -u 9
fi

[ -f /var/boot/grubenv ] || grubenv_create /var/boot/grubenv
