#!/bin/sh
####################################
#
# Personaltiy tarball creation. Transfer handling for tftp.
#
####################################

dev_pers="/var/tmp/.my_device_personality"
dev_pers_tar_log="/var/log/device_pers_create_tarball_log"
device_pers_pkg="/var/etc/device_pers_pkg"
remote_server=$3

hostname_value=${remote_server#*@}

ping -c 2 $hostname_value >/dev/null
if [ $? -ne 0 ]; then
    echo "server unreachable"
    #use the below here - exit 68
    exit 68
fi

cleanup_dev_pers_tar_log_file()
{
    if [ -f $dev_pers_tar_log ] ; then
	rm -f $dev_pers_tar_log
    fi
}

cleanup_opt_dir_list()
{
    if [ -f $dev_pers/dir-list1 ] ; then
        rm -rf $dev_pers/dir-list1
    fi
    
    if [ -f $dev_pers/dir-list2 ] ; then
        rm -rf $dev_pers/dir-list2
    fi
}

cleanup_dev_pers_dir()
{
    if [ -d "$dev_pers" ] ; then
	rm -rf $dev_pers
    fi
}

cleanup_all()
{
    local exit_code="$1"
    cleanup_dev_pers_tar_log_file
    cleanup_opt_dir_list
    cleanup_dev_pers_dir
    exit "$exit_code"
}

cleanup_dev_pers_tar_log_file
cleanup_opt_dir_list
cleanup_dev_pers_dir


if [ ! -d "$dev_pers" ]
then
    /bin/mkdir -p $dev_pers
fi


if [ ! -f "$dev_pers_tar_log" ]
then
    touch $dev_pers_tar_log
fi

archive_file=$1


/usr/sbin/cli -c "show configuration system personality-file-list-of-directories | display set" > $dev_pers/dir-list1
sed 's/set system personality-file-list-of-directories //g' $dev_pers/dir-list1 > $dev_pers/dir-list2

#if the device personalty package directory exists, then write it into the list file
if [ -d "$device_pers_pkg" ] ; then
    echo "/var/etc/device_pers_pkg" >> $dev_pers/dir-list2
fi

extension="${archive_file##*.}"
filename="${archive_file%.*}"

if [ "$extension" = "gz" ]; then
    extension="${filename##*.}"
    filename="${filename%.*}"
    if [ "$extension" = "tar" ]; then
        tar cvzf $dev_pers/$filename.tar.gz /config /var/db --files-from $dev_pers/dir-list2 >> ${dev_pers_tar_log} 2>&1
	final_archive=$dev_pers/$filename.tar.gz
    else
	cleanup_all 1
    fi	
else
    echo "Please provide valid extensions for tarball"
    echo "Supported tarball formats : .tar.gz"
    cleanup_all 1
fi

if [ "$2" = tftp ]; then

    #before "connect", try to ping the same. Else we cannot catch this failure and a successful file transfer log would be thrown
    ping -c 2 $3 >/dev/null
    if [ $? -ne 0 ]; then
	echo "server unreachable"
	#use the below here - exit 68
	cleanup_all 68
    fi

    tftpfile="/var/tmp/tftpfile"

    if [ ! -f "$tftpfile" ]
    then
        touch $tftpfile
    fi


    echo "connect $3" > ${tftpfile}
    echo "mode binary" >> ${tftpfile}
    echo "put $final_archive $4/$1" >> ${tftpfile}
    echo "quit" >> ${tftpfile}
    transfer_arguments=${tftpfile}

    $2 < ${transfer_arguments}
    transfer_res=$?

    if [ -f "$tftpfile" ] ; then
	rm $tftpfile
    fi

    if [ ${transfer_res} -ne 0 ] ; then
	cleanup_all "$transfer_res"
    fi

fi


cleanup_opt_dir_list

