\ $Id: $
\
\ Copyright (c) 2014, Juniper Networks, Inc.
\ All rights reserved

include /boot/support.4th
also support-functions

vocabulary ffp-cookie also ffp-cookie definitions

variable fips-rng-debug

: debug? ( -- flag )
        fips-rng-debug @
        ;

: fips-rng ( -- )
        s" hmac-drbg"
        ;

: set-fips-rng ( -- )
        fips-rng s" kern.random.active_adaptor" setenv
        ;

: parse-ffp-cookie ( ptr/len -- )
        O_RDONLY fopen dup -1 = if
                debug? if
                        s" can't open ffp cookie file" type cr
                then
                drop
        else
                debug? if
                        s" success openning FFP cookie" type cr
                then
                fd !
                debug? if s" Reading FFP boot cookies" type cr then
                begin
                        end_of_file? 0=
                while
                        read_line
                        line_buffer strget s" fips-rng" compare if
                                debug? if
                                        line_buffer strget type
                                        s"  != fips-rng" type cr
                                then
                        else
                                debug? if
                                        line_buffer strget type
                                        s"  == fips-rng, enabing FIPS rng" type cr
                                then
                                set-fips-rng
                        then
                repeat
        then
        ;

: set-rts-filter-flags-off
        \ If /etc/no_rts_filter_usr_flags exists, set net. environment variable
        \ net.rts_filter_enhance_on to 0
        s" /etc/no_rts_filter_usr_flags_on" O_RDONLY fopen dup -1 <> if
                fclose s" set net.rts_filter_usr_flags_on=0" evaluate
        else
                drop
        then
        ;

\ evaluate the env net.rts_filter_usr_flags_on
set-rts-filter-flags-off

\ enable or disable debugging
false fips-rng-debug !
s" /boot/ffp.cookie" parse-ffp-cookie

only forth also definitions
