\ $Id: $
\
\ Copyright (c) 2014, 2018, Juniper Networks, Inc.
\ All rights reserved

\
\ This script is used by both legacy and bsdx, proceed with caution
\

\ Save the wid for the compile stack
get-current ( -- wid )

also support-functions

\ Create a new vocabulary for the ffp-cookie words
vocabulary ffp-cookie
also ffp-cookie definitions

hide ( -- wid )
\ vocabulary ffp-cookie - private definitions

: debug? ( -- flag)
	s" DEBUG" getenv?
	;

: fips-rng ( -- )
        s" hmac-drbg"
        ;

: set-fips-rng ( -- )
        fips-rng s" kern.random.active_adaptor" setenv
        ;

set-current ( wid -- )
\ vocabulary ffp-cookie - public definitions

: parse-ffp-cookie ( ptr/len -- )
        O_RDONLY fopen dup -1 = if
                debug? if ." can't open ffp cookie file" cr then
                drop
        else
                debug? if ." success openning FFP cookie" cr then
                fd !
                debug? if ." Reading FFP boot cookies" cr then
                begin
                        end_of_file? 0=
                while
                        read_line
                        \ Check if cookie is set to "fips-rng"
                        line_buffer strget debug? if 2dup then
                        s" fips-rng" compare 0 = if
                                debug? if type ."  == fips-rng, enabing FIPS rng" cr then
                                set-fips-rng
                        else
                                debug? if type ."  != fips-rng" cr then
                        then
                repeat
                fd @ fclose
        then
        ;

previous
\ vocabulary ffp-cookie - end of definitions

\ Create a new vocabulary for the rts-filter words
vocabulary rts-filter
also rts-filter definitions

\ vocabulary rts-filter - public definitions

: set-rts-filter-flags-off
        \ If /etc/no_rts_filter_usr_flags exists, set net. environment variable
        \ net.rts_filter_enhance_on to 0
        s" /etc/no_rts_filter_usr_flags_on" O_RDONLY fopen dup -1 <> if
                fclose s" set net.rts_filter_usr_flags_on=0" evaluate
        else
                drop
        then
        ;

\ vocabulary rts-filter - end of definitions

\ evaluate the env net.rts_filter_usr_flags_on
set-rts-filter-flags-off

\ Read the ffp.cookie file
s" /boot/ffp.cookie" parse-ffp-cookie

\ pop rts-filter, ffp-cookie, and support-functions off the search list
previous previous previous

\ Restore the compile stack
set-current ( wid -- )

