#!/bin/sh
####################################
#
# Fetch the tarball (tftp). Apply personality of device.
#
####################################


TARGETDIR=$5
archive_file=$4
remote_server=$2

if [ ! -d "$TARGETDIR" ]
then
    echo "Retrieve location does not exist. Please specify a valid location"
    exit 1
else
fi

hostname_value=${remote_server#*@}

dev_pers_untar_log="/var/log/device_pers_retrieve_tarball_log"
device_pers_pkg_dir=/var/etc/device_pers_pkg
tmp_device_pers_pkg_dir=/var/tmp/tmp_device_pers_pkg

cleanup_dev_pers_untar_log_file()
{
    if [ -f $dev_pers_untar_log ] ; then
	rm -f $dev_pers_untar_log
    fi
}

cleanup_dev_pers_tarball()
{
    if [ -f "$TARGETDIR/$archive_file" ] ; then
	rm -f $TARGETDIR/$archive_file
    fi
}

clean_exit()
{
    local exit_code="$1"
    cleanup_dev_pers_untar_log_file
    cleanup_dev_pers_tarball
    mount -u -o ro /
    exit "$exit_code"
}

ping -c 2 $hostname_value >/dev/null
if [ $? -ne 0 ]; then
    echo "server unreachable"
    cleanup_dev_pers_tarball
    #use the below here - exit 68
    exit 68
fi

cleanup_dev_pers_untar_log_file


dev_apply_pers()
{
    if [ -f "$TARGETDIR/$archive_file" ] ; then
	/usr/sbin/cli -c "edit; load override /config/juniper.conf.gz;commit"
    fi
}

dev_install_pkg()
{
    if [ -d "$device_pers_pkg_dir" ]
    then
        if [ ! -d "$tmp_device_pers_pkg_dir" ]
        then
            /bin/mkdir -p $tmp_device_pers_pkg_dir
        fi
        for pkg in "$device_pers_pkg_dir"/* ; do
            #copy the installables from preserved location to working directory
            if [ ! -h "$pkg" ]; then
                cp $pkg ${tmp_device_pers_pkg_dir}/
            fi
        done
        for pkg in "$tmp_device_pers_pkg_dir"/* ; do
            cli_add_pkg="request system software add $pkg"
            /usr/sbin/cli -c "${cli_add_pkg}"
        done
        if [ -d "$tmp_device_pers_pkg_dir" ] ; then
            rm -rf $tmp_device_pers_pkg_dir
        fi
    fi
}

if [ "$1" = tftp ]; then

    #before "connect", try to ping the same. Else we cannot catch this failure and a successful file retrieve log would be thrown
    ping -c 2 $2 >/dev/null
    if [ $? -ne 0 ]; then
        echo "server unreachable"
        #use the below here - exit 68
        clean_exit 68
    fi

    tftpfile="/var/tmp/tftpfile"

    if [ ! -f "$tftpfile" ]
    then
        touch $tftpfile
    else
    fi
    
    echo "connect $2" > ${tftpfile}
    echo "mode binary" >> ${tftpfile}
    echo "get $3$4 $TARGETDIR/$4" >> ${tftpfile}
    echo "quit" >> ${tftpfile}
    transfer_arguments=${tftpfile}

    $1 < ${transfer_arguments}
    transfer_res=$?

    if [ -f "$tftpfile" ] ; then
	rm $tftpfile
    fi

    #handle the case where either the transfer timed out or if the tftp succeded the file/path was incorrect. Hence delete it
    if [ -f "$TARGETDIR/$archive_file" ] && [ ! -s "$TARGETDIR/$archive_file" ]; then
        if [ ${transfer_res} -ne 0 ] ; then
	    clean_exit "$transfer_res"
	else
	    clean_exit 1
        fi
    fi
fi


extension="${archive_file##*.}"
filename="${archive_file%.*}"

mount -u -o rw /
mount_res=$?

if [ ${mount_res} -ne 0 ]; then
    #for some reason mount has failed. Exit
    clean_exit "$mount_res"
fi

if [ ! -f "$dev_pers_untar_log" ]
then
    touch $dev_pers_untar_log
fi


if [ "$extension" = "gz" ]; then
    extension="${filename##*.}"
    filename="${filename%.*}"
    if [ "$extension" = "tar" ]; then
	tar -C / -xvzf "$5/$archive_file" >> ${dev_pers_untar_log} 2>&1
	dev_apply_pers
	dev_install_pkg
    else
	clean_exit 1
    fi
else
    echo "Please provide valid extensions for tarball"
    echo "Supported tarball formats : .tar.gz"
    clean_exit 1
fi

mount -u -o ro /

