/*
 * Copyright (c) 2002, 2003 by cisco Systems, Inc.
 * All rights reserved.
 */
 
 function Cookie(document, name, hours, path, domain, secure){
  this.$document=document;
        this.$name=name;
        if (hours){ 
          this.$expiration=new Date( new Date().getTime() + 3600000*hours);
        }
        if (path){ this.$path=path; } else { this.$path=null; }
        if (domain){ this.$domain=domain; } else { this.$domain=null; }
        if (secure){ this.$secure=secure; } else { this.$secure=null; }
}

function _Cookie_store(){
  var cookieval="";
        for (var prop in this){
          if ((prop.charAt(0)=="$")||(typeof this[prop]=="function")){ continue; }
                if (cookieval != ""){ cookieval += "&"; }
                cookieval += prop + ":" + escape( this[prop]);
        }
        var cookie = this.$name + "=" + cookieval;
        if (this.$expiration){ 
          cookie += "; expires=" + this.$expiration.toGMTString();
        }
        if (this.$path){ cookie += "; path=" + this.$path; }
        if (this.$domain){ cookie += "; domain=" + this.$domain; }
        if (this.$secure){ cookie += "; secure"; }
        this.$document.cookie=cookie;
}

function _Cookie_load(){
  var allcookies = this.$document.cookie;
        if ((typeof allcookies == "undefined") || (allcookies == "")){ 
          return false; 
        }
        var start = allcookies.indexOf( this.$name + "=" );
        if (start < 0){ 
          return false; 
        }
        start += this.$name.length+1;
        var end = allcookies.indexOf( ";", start);
        if (end < 0){ end = allcookies.length; }
        var cookieval = allcookies.substring( start, end);
        var a = cookieval.split("&");
        for (var i=0; i < a.length; i++){
          a[i] = a[i].split(":");
                this[a[i][0]] = unescape( a[i][1]);
        }
        return true;
}

function _Cookie_remove(){
  var cookie;
        cookie=this.$name+"=";
        if (this.$path){ cookie+= "; path=" + this.$path; }
        if (this.$domain){ cookie+= "; domain=" + this.$domain; }
        cookie+= "; expires=Fri, 02-Jan-1970 00:00:00 GMT";
        this.$document.cookie=cookie;
}

Cookie.prototype.store=_Cookie_store;
Cookie.prototype.load=_Cookie_load;
Cookie.prototype.remove=_Cookie_remove;

function _Cookies_supported(){
  var c = new Cookie(document,"_dummy");
        c["foo"]="bar";
        c.store();
        var result = c.load();
        c.remove();
        return result;
}

Cookie.supported=_Cookies_supported();

var CMD_MAX_SIZE = 1500;
var MAX_COOKIE_NB = 2;

function cookieElement() {
 this.name = "";
 this.cmd = "";
}

function parseCmd(cmd, size) {
   var pattern, index = 0, i;

   pattern = "]\n";
   if (size > cmd.length) {
      return 0;
   }
   i = cmd.substring(0, size).search(pattern);
   while (i != -1) {
     index += i + pattern.length;
     i = cmd.substring(index, size).search(pattern);
   }
 
   if (index != cmd.length) {
      return(index);
   } else {
      return 0;
   }

}

function storeCmd(cmd, name, cookieName) {
   var count = 0;
   var cmdSend = "", pattern, index, cookieCmd;
   var cookieTable = new Array();

   index = parseCmd(cmd, CMD_MAX_SIZE);
   if (index) {
      cookieCmd = cmd.substring(index);
      cmdSend = cmd.substring(0, index);
   } else {
      cmdSend = cmd;
      cookieCmd = "";
   }
   do {
      index = parseCmd(cookieCmd, CMD_MAX_SIZE);
      cookieTable[count] = new Cookie(document, cookieName + count);
      cookieTable[count].name = name;
      if (index) {
         cookieTable[count].cmd = cookieCmd.substring(0, index);
         cookieCmd = cookieCmd.substring(index);
      } else {
        cookieTable[count].cmd = cookieCmd;
        cookieCmd = "";
      }
      cookieTable[count].store();
      count++;
   } while (cookieCmd.length && count < MAX_COOKIE_NB);
   cookieTable[0].totalCookies = count;
   cookieTable[0].store();
   if ((count == MAX_COOKIE_NB) || !cookieTable[0].load()) {
      cmdSend = ""
      return cmdSend;
   }
   return cmdSend;

}

function getCookieCmd(element, cookieName) {
   var i, nb;
   var cookieTable = new Array();
   
   cookieTable[0] = new Cookie(document, cookieName + '0');

   if (cookieTable[0].load()) {
      element.cmd = cookieTable[0].cmd;
      element.name = cookieTable[0].name;
      nb = cookieTable[0].totalCookies - 1;
      if ((cookieTable[0].totalCookies > MAX_COOKIE_NB) || (cookieTable[0].totalCookies < 1)) {
         return false;
      }
      for (i = 0; i < nb; i++) {
         cookieTable[i+1] = new Cookie(document, cookieName + (i+1));
         if (cookieTable[i+1].load()) {
            cookieTable[i].cmd = cookieTable[i+1].cmd;
            cookieTable[i].totalCookies = nb;
            cookieTable[i].store();
         }
      }
      if (i == 0) {
        cookieTable[i].cmd = "";
		cookieTable[i].totalCookies = 1;
        cookieTable[i].store();
      } else {
        cookieTable[i].remove();
      }
      return true;
   } else {
      return false;
   }
}

