// Copyright (c) 2005-2006 by Cisco Systems, Inc.

var portRoleRec = replaceTags(re_diag_smport_Lbl,new Array("<A href='javascript:invokeMenuForLink(&quot;portRole&quot;)'></A>"));
var passwdRec = replaceTags(re_diag_usrpwd_Lbl,new Array("<A href='javascript:invokeMenuForLink(&quot;passwdRec&quot;)'></A>"));

function invokeMenuForLink(str){
   var space=" ";
   var gt=">";
   var menu="";
   if(str=="portRole"){
   	menu=top.leftFrame.re_menu_txt_configure + space + gt + space + top.leftFrame.re_menu_txt_smartports;
   }else if(str=="passwdRec"){
   	menu=top.leftFrame.re_menu_txt_configure + space + gt + space + top.leftFrame.re_menu_txt_userpass;
   }
   top.selectMenu(menu);
}

function Error() {
	this.entity = "";
	this.port = null;
	this.code = "";
	this.sev = 3;
	this.details = "";
	this.recommendation = "";
	this.fixit = false;
	this.fixclis = "";
	this.fixed = false;
}

function parseDeviceErrors(tmp) {
	var tmpErrors = new Array();
	var dErrors = new Array();

	if(tmp.search(/\S/) == -1) {
		return dErrors;
	} else if(tmp.indexOf("Global Errors :") != -1) {
		tmp = token_string("Global Errors :",1,tmp);
		if(tmp.search(/\S/) == -1)
			return dErrors;
	}

	tmp = trim_string(tmp);
	if (tmp.indexOf("Error Code:") != -1) {
		tmpErrors = split("Error Code:", tmp);
	}
	for(var i=0; i<tmpErrors.length; i++) {
		if(tmpErrors[i].indexOf("Timestamp:") == -1) continue;
		var errObj = new Error();
		var lines = split("\n", tmpErrors[i]);
		errObj.code = trim_string(lines[0].substring(lines[0].indexOf(":") + 1));
		errObj.entity = getErrorEntity(errObj.code);
		errObj.sev =split("-",errObj.code)[1];// getErrorSeverity(errObj.code);
		errObj.details = trim_string(getDescription(errObj.code));
		errObj.recommendation = trim_string(getRecommendation(errObj.code));
		errObj.recommendation += getErrorFixRec(errObj.code);
		dErrors[dErrors.length] = errObj;
	}
	return dErrors;
}

function parsePortErrors(tmp) {
	var tmpInts = new Array();
	var pErrors = new Array();
	if(tmp.indexOf("Interface :") != -1) {
		tmpInts = split("Interface :", tmp)
		tmpInts.shift();
	}
	for(var k=0; k<tmpInts.length; k++) {
		var tmpInt = tmpInts[k];
		var tmpErrors = new Array();
		var port = null;
		if (tmpInt.indexOf("Error Code:") != -1) {
			port = token_string("Error Code:", 0, tmpInt)
			tmpErrors = split("Error Code:", tmpInt);
			tmpErrors.shift();
		}
		for(var i=0; i<tmpErrors.length; i++) {
			var errObj = new Error();
			var lines = split("\n", tmpErrors[i]);
			errObj.port = trim_string(port);
			if(lines[0]) errObj.code = trim_string(lines[0].substring(lines[0].indexOf(":") + 1));
			else continue;
			errObj.sev = split("-",errObj.code)[1];//getErrorSeverity(errObj.code);
			errObj.entity = re_diag_port_Lbl+"&nbsp;" + errObj.port;
			errObj.fixclis = getFixItClis(port, errObj.code);
			if(lines[2]) {
				errObj.details = trim_string(getDescription(errObj.code));
				errObj.details = errObj.entity + ": " + errObj.details;
			} else continue;
			if(lines[3]) {
				errObj.recommendation = trim_string(getRecommendation(errObj.code));
				errObj.recommendation += getErrorFixRec(errObj.code);
			} else continue;
			pErrors[pErrors.length] = errObj;
		}
	}
	return pErrors;
}
function getDescription(errorCode){
   var desc="";
   desc="re_diag_des_"+split("-",errorCode)[2];
   return eval(desc);
}

function getRecommendation(errorCode){
   var rec="";
   rec="re_diag_rec_"+split("-",errorCode)[2];
   return eval(rec);
}

function getFixItClis(port,code) {
	var cmd = "";
	/*if(code == "CDP_DUPLEX_WARNING_CHK") {
		cmd += "interface " + port + "\n";
		cmd += "duplex full\n";
		cmd += "duplex auto\n";
	}*/
	if(code == "ADMIN_DOWN_CHK") {
		cmd += "interface " + port + "\n";
		cmd += "no shutdown\n";
	}
	return cmd;
}

function getErrorEntity(code) {
	var entity = "Switch Hardware";
	return entity;
}

function getErrorFixRec(code) {
	var rec = "";
	if(code == "ALERT-4-PORT_ROLE_MISMATCH")
		rec += "&nbsp;" +portRoleRec;
	else if (code == "ALERT-5-PASSWD")
		rec += "&nbsp;" +passwdRec;
	return rec;
}

function sortErrors(errors) {
	errors.sort(function sortBySev(a,b) {
		if(a.sev > b.sev) {
			return 1;
		} else if(a.sev < b.sev) {
			return -1;
		} else {
			if(a.entity.indexOf("Switch") != -1 && b.entity.indexOf("Port") != -1) {
				return -1;
			} else if(a.entity.indexOf("Port") != -1 && b.entity.indexOf("Switch") != -1) {
				return 1;
			} else if(a.entity.indexOf("Port") != -1 && b.entity.indexOf("Port") != -1) {
				var int1 = a.entity.substring(5);
				var int2 = b.entity.substring(5);
				var ret = compareInterfaceName(int1, int2);
				if(ret == 1 || ret == -1) {
					return ret;
				} else if(ret == 0) {
					if(a.code > b.code) { 
						return 1;
					} else if(a.code < b.code) {
						return -1;	
					}
				}
			}

			if(a.entity > b.entity) { 
				return 1;
			} else if(a.entity < b.entity) {
				return -1;
			}

			if(a.code > b.code) { 
				return 1;
			} else if(a.code < b.code) {
				return -1;	
			}

			return 0;
		}
	});

}

//////////// added for interface comparison

var LONGER = 1;
var SAME = 0;
var SHORTER = -1;

var BIGGER = 1;
var EQUAL = 0;
var SMALLER = -1;
var UNKNOWN = 1000;

var sizeFlag;

var str1 = null;
var str2 = null;

function compareInterfaceName(a,b) {

  var result = UNKNOWN;

  result = validateComparatees(a, b);
  if (result != UNKNOWN)
  {
	 return result;
  }

  //divide the cellValue1 and cellValue2 into subgroups
  var group1 = new Array();
  var group2 = new Array();
  var types1 = new Array();
  var types2 = new Array();

  //divideStringByTypes((String)cellValue1, group1, types1);
  //divideStringByTypes((String)cellValue2, group2, types2);

  divideStringByTypes(str1, group1, types1);
  divideStringByTypes(str2, group2, types2);

  if (group1.length>group2.length)
  {
	 sizeFlag = LONGER;
  }
  else if (group1.length==group2.length)
  {
	 sizeFlag = SAME;
  }
  else
  {
	 sizeFlag = SHORTER;
  }

  var size = sizeFlag==LONGER?group2.length:group1.length;

  for (var i=0; i<size; ++i)
  {
	 var lType = types1[i];
	 var rType = types2[i];

	 if ((lType == rType)&&(lType == true))
	 {
		//check number
		var lInt = parseInt(group1[i]);
		var rInt = parseInt(group2[i]);
		if(lInt == rInt) result = 0;
		else if (lInt > rInt) result = 1;
		else result = -1;
	 }
	 else
	 {
		var lString = group1[i];
		var rString = group2[i];
		if(lString == rString) result = 0;
		else if (lString > rString) result = 1;
		else result = -1;
	 }

	 if (result != EQUAL)
	 {
		break;
	 }
  }

  if (result == EQUAL)
  {
	 if (sizeFlag == LONGER)
	 {
		result = BIGGER;
	 }
	 else if (sizeFlag == SHORTER)
	 {
		result = SMALLER;
	 }
  }

  return result;
}

function validateComparatees(a, b)
{
  str1 = a;
  str2 = b;

  if ((str1==null)&&(str2==null))
  {
	 return EQUAL;
  }

  if ((str1==null)&&(str2 !=null))
  {
	 return SMALLER;
  }

  if ((str1 !=null)&&(str2==null))
  {
	 return BIGGER;
  }

  var length1 = str1.length;
  var length2 = str2.length;

  if ((length1==0)&&(length2==0))
  {
	 return EQUAL;
  }
  else if (length1==0)
  {
	 return SMALLER;
  }
  else if (length2==0)
  {
	 return BIGGER;
  }

  return UNKNOWN;
}

function divideStringByTypes(target, dividedGroup, itemTypes) {
  var typeFlag = (!isNaN(target.charAt(0)));
  var index = 0;
  var buffer = "";

  for (var i=0; i<target.length; ++i)
  {
	 if (typeFlag==(!isNaN(target.charAt(i))))
	 {
		buffer += target.charAt(i);
	 }
	 else
	 {
		dividedGroup[dividedGroup.length] = buffer;
		itemTypes[itemTypes.length] = typeFlag;
		typeFlag = !typeFlag;
		buffer = "";
		buffer += target.charAt(i);
	 }
  }
  dividedGroup[dividedGroup.length] = buffer;
  itemTypes[itemTypes.length] = typeFlag;
}

// added till here for interface comparison

