<!-- Copyright (c) 2005 by Cisco Systems, Inc. -->
// discover.js for Macchiato devices.

// 1950 models.
// Support added for WS-C1950G-24TX-C, WS-C1950G-24P-C, WS-C1950G-12TX-C, WS-C1950G-24FP-C

function WSC1950_24_2(int_status, media_type) 
{
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c1950_24_2.gif";

	drawLeds(dev);

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 135;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(var i=0; i<24; i++) 
	{       
		if(i%2 == 0) 
		{
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		}
		else 
		{
			yPortCoord = 39;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) 
		{
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) 
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 GigabitEthernet ports
	xPortCoord = 500;
	yPortCoord = 41;
	xPortGap = 42;
	for(var i=24; i<26; i++) 
	{

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC1950_24_24POE(int_status, media_type) 
{
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c1950_24_24-poe.gif";

	drawLeds(dev);


	// Create PoE LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POE"] = tempLed;

	// Create RPS LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 54;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 135;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(var i=0; i<24; i++) 
	{       
		if(i%2 == 0) 
		{
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		}
		else 
		{
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) 
		{
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) 
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
        // Now add the two composite ports
        xPortCoord = 488;
        yPortCoord = 40;
        for(i=24; i<26; i++) 
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portImages,true);
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 44;
                port.height = 17;
                port.sfpx = 22;
                port.sfpy = 0;
                port.rj45x = 1;
                port.rj45y = 1;
                port.id = "port_" + i;
                dev.addPort(port);
                xPortCoord += 61;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}


function WSC1950_24_4POE(int_status, media_type) 
{
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c1950_24_4-poe.gif";

	drawLeds(dev);


	// Create PoE LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POE"] = tempLed;

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 135;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(var i=0; i<24; i++) 
	{       
		if(i%2 == 0) 
		{
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		}
		else 
		{
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) 
		{
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) 
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	// Now add the two composite ports
	xPortCoord = 488;
	yPortCoord = 40;
	for(i=24; i<26; i++) 
	{
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
		port = new top.rj45Compositeport(intType,portImages,true);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.width = 44;
		port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 61;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC1950_12(int_status, media_type) 
{
	var dev = new top.device();

	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c1950_12.gif";

	drawLeds(dev);

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 103;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 41;

	// Add the 8 GigabitEthernet ports in linear fashion.
	for(var i=0; i<8; i++) 
	{       
			yPortCoord = 41;
			port = new top.rj45port(portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			dev.addPort(port);
			xPortCoord += portWidth+xPortGap;
	}
        // Now add the 4 composite ports
        xPortCoord = 357;
        yPortCoord = 40;
        for(i=8; i<12; i++)
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portImages,true);
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 44;
                port.height = 17;
                port.sfpx = 22;
                port.sfpy = 0;
                port.rj45x = 1;
                port.rj45y = 1;
                port.id = "port_" + i;
                dev.addPort(port);
                xPortCoord += 64;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED");
	return dev;
}

function drawLeds(dev) 
{

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 36;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	// Create SETUP LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 42;
	tempLed.id = "alert_led";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["ALERT"] = tempLed;

	// Create SETUP LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 609;
	tempLed.y = 60;
	tempLed.id = "setup_led";
	tempLed.device = dev;
	dev.sysleds["SETUP"] = tempLed;
		
}

function createDevice(int_status, media_type, deviceType) 
{
	var device = null;
	if(deviceType == null)
		return device;

	if(deviceType == "WS-CE500-24TT") 
	{
		device = new WSC1950_24_2(int_status, media_type);
	}
	else if(deviceType == "WS-CE500-24LC") 
	{
		device = new WSC1950_24_4POE(int_status, media_type);
	}
	else if(deviceType == "WS-CE500G-12TC") 
	{
		device = new WSC1950_12(int_status, media_type);
	}
	else if(deviceType == "WS-CE500-24PC") 
	{
		device = new WSC1950_24_24POE(int_status, media_type);
	}

	if(device != null) 
	{
		device.type = deviceType;
		device.family = "Express 500";
	}

	return device;
}
