/*
 *------------------------------------------------------------------
 * ip.js --  IP Utility methods
 *
 *
 * Copyright (c) 2003-2004, 2006-2008 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */
 
function ip2decimal(ip) {
	var _tmpArr = ip.split(".");
	var inputStr1 = _tmpArr[0];
	var inputStr2 = _tmpArr[1];
	var inputStr3 = _tmpArr[2];
	var inputStr4 = _tmpArr[3];
	
	var doneVal;
	var ok2Cont   = true
	
	if (isEmpty(inputStr1) || isEmpty(inputStr2) || isEmpty(inputStr3) || isEmpty(inputStr4)) ok2Cont = false;

	if (ok2Cont) {
		// Concatenate binary characters
		doneVal = toBin(inputStr1) + toBin(inputStr2) + toBin(inputStr3) + toBin(inputStr4) ;
		// strip any leading zero
		doneVal = stripZeros(doneVal) ;
		return (parseInt(doneVal, 2));
		// convert binary to decimal
		//form.result.value = "HTTP://" + parseInt(doneVal, 2) ;
	}
	else
		return -1;
	
}

// JavaScript sees numbers with leading zeros as octal values, so strip zeros
function stripZeros(inputStr) {
	var result = inputStr
	while (result.substring(0,1) == "0") {
		result = result.substring(1,result.length)
	}
	return result
}

// general purpose function to see if an input value has been entered at all
function isEmpty(inputStr) {
	if (inputStr == "" || inputStr == null) {
		return true
	}
	return false
}

// general purpose function to see if a suspected numeric input
// is a positive integer
function isNumber(inputStr) {
	for (var i = 0; i < inputStr.length; i++) {
		var oneChar = inputStr.substring(i, i + 1)
		if (oneChar < "0" || oneChar > "9") {
			return false
		}
	}
	return true
}

// function to determine if value is in acceptable range for this application
function inRange(inputStr) {
	num = parseInt(inputStr)
	if ((num < 0) || (num > 255)) {
		return false
	}
	return true
}

function isValid(inputStr) {
	if (isEmpty(inputStr)) {
		alert("Please enter a number")
		return false
	} else {
		if (!isNumber(inputStr)) {
			alert("Please enter numbers only")
			return false
		} else {
			if (!inRange(inputStr)) {
				alert("Valid range is 0 - 255")
				return false
			}
		}
	}
	return true
}

// Decimal to binary, returns an eight character string
function toBin(inVal) {
   base = 2 ;
   num = parseInt(inVal);
   binNum = num.toString(base);
   // pad leading spaces with "0"
   binNum = padTextPrefix(binNum, "0", 8) ;

   return binNum
}

// equiv to padl()
function padTextPrefix (InString, PadChar, DefLength)  {
   if (InString.length >= DefLength)
      return (InString);
   OutString = InString
   for (Count = InString.length; Count < DefLength; Count++)  {
      OutString = PadChar + OutString;
   }
   return (OutString);
}

function decimal2ip(_ip) {
	var tmp = new Array();
	tmp[3] = _ip & _ip & 0xFF;
	_ip = (_ip >>> 8);
	tmp[2] = _ip & 0xFF;
	_ip = (_ip >>> 8);
	tmp[1] = _ip & 0xFF;
	_ip = (_ip >>> 8);
	tmp[0] = _ip & 0xFF;
	
	return tmp.join(".");
}

function getLastIP(_subnet, _netmask) {
	var _tmpArr1 = _subnet.split(".");
	var _tmpArr2 = _netmask.split(".");
	var _tmpArr3 = new Array();
	for(var i=0; i<4; i++) _tmpArr3[i] = _tmpArr1[i] | (~ _tmpArr2[i] & 0xff);
	return _tmpArr3.join(".");
}

function getSubnet(_ip, _mask) {
	var t1 = _ip.split(".");
	var t2 = _mask.split(".");
	var str = "";
	for(i=0; i<t1.length; i++) t1[i] = (t1[i] & t2[i]);
	return t1.join(".");
}

function inSameSubnet(_ip1, _ip2, _mask) {
	return ((getSubnet(_ip1, _mask) == getSubnet(_ip2, _mask)) ? true : false);
}
