<!-- Copyright (c) 2005-2011 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for Cat3750 devices and Mirage devices.
// <include a list of SKUs here>
/*
	NME-16ES-1G-P 			:	16 ports + 1G + 1G(int)
	NME-X-23ES-1G-P 		:	23 ports + 1G + 1G(int)
	NME-XD-24ES-1S-P		:	24 ports + 1G + 1G(int)
	NME-XD-48ES-2S-P		:	48 ports + 2G + 2G(int)
        NME-16ES-1G                     :       16 ports + 1G + 1G(int), No ILP
        NME-X-23ES-1G                   :       23 ports + 1G + 1G(int), No ILP
        NME-XD-24ES-1S                  :       24 ports + 1G + 1G(int), No ILP
        NME-XD-48ES-2S                  :       48 ports + 2G + 2G(int), No ILP
*/
/*
 Mr. Incredible Catalyst 3750 X series
 24 data WS-C3750X-24T 
 48 data WS-C3750X-48T 
 24 PoE+ WS-C3750X-24P 
 48 PoE+ WS-C3750X-48P 
*/
/*
Sheyojee2 - WK100FX
*/

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType == null)
		return device;	
        if ((deviceType == "NME-16ES-1G-P") || (deviceType == "NME-16ES-1G") ) {
		uiPortDataArr = removeInternalPorts(new Array("17"));
		device = new NME16ES1GE(uiPortDataArr);
        } else if((deviceType == "NME-X-23ES-1G-P") || (deviceType == "NME-X-23ES-1G")) {
		uiPortDataArr = removeInternalPorts(new Array("24"));
		device = new NMEX24ES1GE(uiPortDataArr);
        } else if((deviceType == "NME-XD-24ES-1S-P") || (deviceType == "NME-XD-24ES-1S")) {
		uiPortDataArr = removeInternalPorts(new Array("25"));
		device = new NMEXD24ES2ST(uiPortDataArr);
        } else if((deviceType == "NME-XD-48ES-2S-P") || (deviceType == "NME-XD-48ES-2S")) {
		uiPortDataArr = removeInternalPorts(new Array("50", "51"));
		device = new NMEXD48ES2GE(uiPortDataArr);
	} else if((deviceType == "WS-C3750-24P") || (deviceType == "WS-C3750-24TS") || (deviceType == "WS-C3750V2-24PS") || (deviceType == "WS-C3750V2-24TS") ) {
		device = new WSC3750242(uiPortDataArr);
	} else if(deviceType == "WS-C3750G-12S" || deviceType == "WS-C3750G-12S-D") {
		device = new WSC3750G12S(uiPortDataArr);
	} else if(deviceType == "WS-C3750-48P") {
		device = new WSC375048P(uiPortDataArr);
	} else if(deviceType == "WS-C3750G-24T") {
		device = new WSC3750G24T(uiPortDataArr);
	} else if((deviceType == "WS-C3750G-24TS") || (deviceType == "WS-C3750G-24PS") || 
			(deviceType == "WS-C3750G-24TS-1U")) {
		device = new WSC3750G244(uiPortDataArr);
	} else if(deviceType == "WS-C3750G-16TD") {
		device = new WSC3750G16TD(uiPortDataArr);
	} else if((deviceType == "WS-C3750G-48TS") || (deviceType == "WS-C3750G-48PS") || 
			(deviceType == "WS-C3750-48TS") || (deviceType == "WS-C3750-48")) {
		device = new WSC3750G484(uiPortDataArr);
	} else if ((deviceType == "WS-C3750-24FS") ) {
		device = new WSC375024FS(uiPortDataArr);
	} else if((deviceType == "WS-C3750G-24PS-W12") || (deviceType == "WS-C3750G-24PS-W24") || (deviceType == "WS-C3750G-24WS-S12") || (deviceType == "WS-C3750G-24WS-S24") || (deviceType == "WS-C3750G-24WS-S25") || (deviceType == "WS-C3750G-24WS-S50")) {
		device = new WSC3750G24PSFOXHOUND(uiPortDataArr);
	} else if ((deviceType.indexOf("WS-C3750E-24TD") != -1) || (deviceType.indexOf("WS-C3750E-24PD") != -1)) {
		device = new WSC3750E24(uiPortDataArr);
	} else if ((deviceType.indexOf("WS-C3750E-48TD") != -1) || (deviceType.indexOf("WS-C3750E-48PD") != -1)) {
		device = new WSC3750E48(uiPortDataArr);
	} else if (deviceType.indexOf("WS-C3750E-12SD") != -1){
		device = new WSC3750E12SD(uiPortDataArr);
	}else if (deviceType == "WS-C3750V2-48PS" || deviceType == "WS-C3750V2-48TS"){
		device = new WSC3750F48(uiPortDataArr);
	}else if (deviceType == "WS-C3750X-24P" || deviceType == "WS-C3750X-24"){
		device = new WSC3750X24(uiPortDataArr);
	}else if (deviceType == "WS-C3750X-48P" || deviceType == "WS-C3750X-48"){
		device = new WSC3750X48(uiPortDataArr);
	}else if (deviceType == "WS-C3750V2-24FX"){//SYJ2 WK100FX 
		device = new WSC3750V224FX(uiPortDataArr);
	}else if (deviceType.indexOf("WS-C3750X-24S") != -1) {//Syndrome 24
		device = new WSC3750X24S(uiPortDataArr);
	}else if (deviceType.indexOf("WS-C3750X-12S") != -1) {//Syndrome 12
		device = new WSC3750X12S(uiPortDataArr);
	}
}

function WSC3750E24(uiPortDataArr) {
	var MAX_PORTS = 28;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<24; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if (portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/25") > 0 || uiPortDataArr[portId].portName.indexOf("/26") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
		//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		
		
		for (var portId=0; portId<24; portId++) {
			// This is extra space between port groups
			if(portId == 12) {
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row
			if (portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/27") > 0 || uiPortDataArr[portId].portName.indexOf("/28") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

function WSC3750E48(uiPortDataArr) {
	var MAX_PORTS = 52;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount ; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/49") > 0 || uiPortDataArr[portId].portName.indexOf("/50") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/51") > 0 || uiPortDataArr[portId].portName.indexOf("/52") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function NME16ES1GE(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "20" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	//Odd numbered ports in first row in reverse order: 15 - 1
	for (var portId = portCount-2; portId >= 0 ; portId--) {
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty row for padding
	document.writeln('<tr><td colspan= "20" height="5" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	//Even numbered ports in second row in reverse order: 16 - 2							  
	for (var portId = portCount-2; portId >= 0 ; portId--) {
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>');
		}
	}
	
	//For spacing between second row even ports and external Gigabit port
	document.writeln('<td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//One external Gigabit port in second row: Gig1
	for (var portId = portCount-1; portId < portCount ; portId++) {
		//if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>');
		//}
	}
	
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "20" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function NMEX24ES1GE(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		// This is extra space between port 11 and 13
		if(portId == 10) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row in reverse order: 23 - 3
		if (portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		//External Gigabit port at the end of first row
		for (var portId = portCount-1; portId < portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-2; portId >=0 ; portId--) {
			// This is extra space between port 12 and 14
			if(portId == 10) {
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row in reverse order: 24 - 2
			if (portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

function NMEXD24ES2ST(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "24" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		// This is extra space between port 11 and 13
		if( portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row in reverse order: 23 - 1
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty rows for padding
	document.writeln('<tr><td colspan= "24" height="5" bgcolor="#f4f4f4"></td></tr>');	
	document.writeln('<tr><td colspan= "24" height="3" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
		//Space between 12 and 14
		if( portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row in reverse order: 24 - 2
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();

	for (var portId = portCount-1; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
	}
	
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "24" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function NMEXD48ES2GE(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
  		// This is extra space between port 15 & 17 and 31 & 33
		if(portId == 15 || portId == 31) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row in reverse order: 47 - 1		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
		// This is extra space between port 15 & 17 and 31 & 33
		if(portId == 15 || portId == 31) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row in reverse order: 48 - 2
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//External Gigabit ports in second row in reverse order: 2 - 1 (3 and 4 are internal ports)		
	for (var portId = portCount-1; portId >=portCount-2 ; portId--) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function getPortLabel(intName) {
	var tmpStr = intName.substring(intName.indexOf('/')+1);
	var intNumber = tmpStr.substring(tmpStr.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}

//removes internal ports from the two port arrays and returns the UI port array
function removeInternalPorts(excludePortsArr) {
	var tempArr1 = uiPortDataArr;
	var tempArr2 = devicePortDataArr;
	if(excludePortsArr.length > 0) {
		for(var i=excludePortsArr.length-1; i>=0; i--) {
			tempArr1 = tempArr1.slice(0, parseInt(excludePortsArr[i]));
			tempArr2 = tempArr2.slice(0, parseInt(excludePortsArr[i]));
		}
		uiPortDataArr = tempArr1;
		devicePortDataArr = tempArr2;
		return uiPortDataArr;
	}
}

function WSC3750G16TD(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "33" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
	// This is extra space between port 15 and 17
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
	}
		
	document.writeln('\
			  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
	for (var portId = portCount-2; portId < portCount ; portId++) {
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
	}				  

	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')				  				  
   document.writeln('\
			  <tr>')
	writeSpaceCell();
										  
	for (var portId = 0; portId < portCount ; portId ++) {
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
		}
	}
		
	document.writeln('\
			  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell(); 
	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')			
}
function WSC375048P(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "33" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}
function WSC3750G12S(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "18" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "32" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')					
}

function WSC3750G24T(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
  		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')				  				  
   	document.writeln('\
			  <tr>')
	writeSpaceCell();
							  
	for (var portId = 0; portId < portCount ; portId++) {
		if( (portId) % 12 == 0)
			document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		if ( portId % 2 != 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
		}	
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();                             
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')			
}

function WSC3750242(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}
/*
 *  This is unit tested.
 */

function WSC3750G484(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		} 				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC3750G244(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC356024PS(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

function WSC375024FS(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "35" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0 ) {
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if ( portId == 25 ) { //space between gigabit ports
			document.writeln('\
			<td nowrap width="5" bgcolor="#f4f4f4">&nbsp;</td>');
		}
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "35" height="9" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')					
}

function WSC3750G24PSFOXHOUND(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	//skip internal ports 27 and 28
	for (var portId = portCount-2; portId < portCount; portId++)
		uiPortDataArr[portId].macro = MACRO_NULL;
	
	document.writeln('<tr><td colspan= "22" height="3" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr>');
	writeSpaceCell();
	
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between ports 11 and 13
		if( (portId) % 12 == 0)
		  document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
	}
	
	document.writeln('<td nowrap colspan="5" bgcolor="#f4f4f4">&nbsp;</td>');				  

	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	
	document.writeln('<tr><td colspan= "22" height="5" bgcolor="#f4f4f4"></td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();
								  
	for (var portId = 0; portId < portCount-4 ; portId++) {
		// This is extra space between ports 12 and 14
		if( (portId) % 12 == 0)
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		if ( portId % 2 != 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	for (var portId = portCount-4; portId < portCount-2 ; portId++) {
		document.writeln('\
			<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
			onMouseOver="showPortInfo(\'',portId, '\', \'',uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
			onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
			onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
			onMouseUp="window.status=\'\'; return true"\
			onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
			src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
			border="0"\
			width="21" height="21" name="cell', '_', portId, '"></a><br>\
			<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '</font>\
			</td>');
		document.writeln('<td nowrap bgcolor="#f4f4f4">&nbsp;</td>');
	}
	
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
	document.writeln('</tr>');

	document.writeln('<tr><td colspan= "22" height="5" bgcolor="#f4f4f4"></td></tr>');
}
function WSC3750E12SD(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "38" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
				if(portId == 3 || portId == 7 || portId == 11){
						writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
				}
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "38" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')					
}

function WSC3750F48(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}

function WSC3750X48(uiPortDataArr) {
	var MAX_PORTS=54;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "54" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	//1st row 24 ports , 
	for (var portId = 0; portId < 48 ; portId++) {
  		// This is extra space between port 11 & 13 ,23 & 25 and 35 & 37
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if(portCount == 52 || portCount == 54 ) { 
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		}
					
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "54" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
		//2nd row  24 ports						  
		 for (var portId = 0; portId < 48 ; portId++) {
	  		// This is extra space between port 12 & 14 ,24 & 26 and 36 & 38
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		 } 

			
			if(portCount > 52){//For 54 port device // 10 Giga N/W module
				var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
				var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
				var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
				var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
				var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
				var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
				
				for(var i=0;i<intArray.length;i++){
				if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
					nmmodule_gigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
					nmmodule_gigaport2=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
					nmmodule_gigaport3=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
					nmmodule_gigaport4=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
					nmmodule_tengigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
					nmmodule_tengigaport2=intArray[i];
				}
			
			}
			//Wall E support
			if(portCount == MAX_PORTS-2 && uiPortDataArr[MAX_PORTS-6].portName.indexOf("1/2") != -1) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			drawWallEModule(uiPortDataArr,intArray,MAX_PORTS);//
			}
			else if((portCount > 48 && portCount == 52) ||
				((nmmodule_tengigaport2.indexOf("Te") != -1 &
				nmmodule_tengigaport2.indexOf("Not Present") > 0) &
				 (nmmodule_tengigaport1.indexOf("Te") != -1 & 
				nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			for (var portId = 48; portId < 52 ; portId++)
					{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				   writeSpaceCell(); writeSpaceCell(); 					
			   }
			   if(portCount == 54){
			   uiPortDataArr[52].macro = MACRO_NULL;
				uiPortDataArr[53].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 49) portId+=3;// for Te2
					 if(portId == 53) { 
						 writeSpaceCell(); writeSpaceCell(); 
						 uiPortDataArr[50].macro = MACRO_NULL;
						  uiPortDataArr[51].macro = MACRO_NULL;
						   uiPortDataArr[52].macro = MACRO_NULL;
						 }
					}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 48) {
								uiPortDataArr[48].macro = MACRO_NULL;
								uiPortDataArr[49].macro = MACRO_NULL;
								uiPortDataArr[53].macro = MACRO_NULL;
								portId=portId+4;
							}
							document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 52) portId=portId-3;
					 if(portId == 51) {portId=portId+2;writeSpaceCell(); writeSpaceCell();}

						}
						else {
					if(portId == 48){ 
					uiPortDataArr[48].macro = MACRO_NULL;
					uiPortDataArr[49].macro = MACRO_NULL;
					uiPortDataArr[50].macro = MACRO_NULL;
					uiPortDataArr[51].macro = MACRO_NULL;
					portId=portId+4;
					}// Te1,Te2
						document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 53) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			} 
		
	document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
					 
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "54" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
		
}

function WSC3750X24(uiPortDataArr) {
	var MAX_PORTS=30;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "30" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < 24 ; portId++) {
  		// This is extra space between port 11 & 13 
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
	
		if(portCount == 28 || portCount == 30 ) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	}
		
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "30" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < 24 ; portId++) {
	  		// This is extra space between port 12 & 14 
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		} 
		if(portCount > 28){//For 30 port device // 10 Giga N/W module
	var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
	var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
	var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
	var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
	var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
	var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
		
		for(var i=0;i<intArray.length;i++){
		if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
			nmmodule_gigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
			nmmodule_gigaport2=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
			nmmodule_gigaport3=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
			nmmodule_gigaport4=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
			nmmodule_tengigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
			nmmodule_tengigaport2=intArray[i];
		}
	
	}
		
			if(portCount == MAX_PORTS-2 && uiPortDataArr[MAX_PORTS-6].portName.indexOf("1/2") != -1) { 	//Wall E support
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			drawWallEModule(uiPortDataArr,intArray,MAX_PORTS);//
			} 
			else if((portCount > 24 && portCount == 28) ||
			   ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				 nmmodule_tengigaport2.indexOf("Not Present") > 0) &&
			    (nmmodule_tengigaport1.indexOf("Te") != -1 &&
				 nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
					  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
				for (var portId = 24; portId < 28 ; portId++)
					{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				   writeSpaceCell(); writeSpaceCell(); 					
				 }
				  if(portCount == 30){
						 uiPortDataArr[28].macro = MACRO_NULL;
							uiPortDataArr[29].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 25) portId+=3;// for Te2
					 if(portId == 29) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell();
					 	 uiPortDataArr[26].macro = MACRO_NULL;
						  uiPortDataArr[27].macro = MACRO_NULL;
						   uiPortDataArr[28].macro = MACRO_NULL;
						   }
						}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 24) {
							portId=portId+4;
							 uiPortDataArr[24].macro = MACRO_NULL;
							  uiPortDataArr[25].macro = MACRO_NULL;
							   uiPortDataArr[29].macro = MACRO_NULL;
							   }
							document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 28) portId=portId-3;
					 if(portId == 27) {portId=portId+2;writeSpaceCell(); writeSpaceCell();
					 }

						}
						else {
					if(portId == 24) {
						portId=portId+4; // Te1,Te2
					uiPortDataArr[24].macro = MACRO_NULL;
					uiPortDataArr[25].macro = MACRO_NULL;
					uiPortDataArr[26].macro = MACRO_NULL;
					uiPortDataArr[27].macro = MACRO_NULL;
					}
						document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 29) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			}
	document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
	
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');		
}
//Started SYJ2 WK100FX
function WSC3750V224FX(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "35" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	//For 24 FX ports
	for (var portId = 0; portId < portCount-2 ; portId++) {
  		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();  
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();	writeSpaceCell();	
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();	writeSpaceCell();

	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "35" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')				  				  
   	document.writeln('\
			  <tr>')
	writeSpaceCell();
							  
	for (var portId = 0; portId < portCount-2 ; portId++) {
		if( (portId) % 8 == 0)
			document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		if ( portId % 2 != 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
		}	
	}
	//For 2 SFP ports
	for (var portId = portCount-2 ; portId < portCount ; portId++) {
  		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
				<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();  
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();	writeSpaceCell();	
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "35" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')		
} //End of WK100FX

//Started Syndrome 24
function WSC3750X24S(uiPortDataArr) {
	var MAX_PORTS=30;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "45" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	//For 24 SFP ports
	for (var portId = 0; portId < 24 ; portId++) {
  		if( (portId) % 6 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		
	}
				
	document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
   

	if(portCount > 28){//For 30 port device // 10 Giga N/W module
	var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
	var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
	var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
	var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
	var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
	var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
		
		for(var i=0;i<intArray.length;i++){
		if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
			nmmodule_gigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
			nmmodule_gigaport2=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
			nmmodule_gigaport3=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
			nmmodule_gigaport4=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
			nmmodule_tengigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
			nmmodule_tengigaport2=intArray[i];
		}
	
	}
			if(portCount == MAX_PORTS-2 && uiPortDataArr[MAX_PORTS-6].portName.indexOf("1/2") != -1) { 	//Wall E support
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			drawWallEModule(uiPortDataArr,intArray,MAX_PORTS);//
			} 
		else if((portCount > 24 && portCount == 28) ||
			   ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				 nmmodule_tengigaport2.indexOf("Not Present") > 0) &&
			    (nmmodule_tengigaport1.indexOf("Te") != -1 &&
				 nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
					  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
				for (var portId = 24; portId < 28 ; portId++)
					{
				document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
				   writeSpaceCell(); writeSpaceCell(); 					
				 }
				  if(portCount == 30){
						 uiPortDataArr[28].macro = MACRO_NULL;
							uiPortDataArr[29].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 25) portId+=3;// for Te2
					 if(portId == 29) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell();
					 	 uiPortDataArr[26].macro = MACRO_NULL;
						  uiPortDataArr[27].macro = MACRO_NULL;
						   uiPortDataArr[28].macro = MACRO_NULL;
						   }
						}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 24) {
							portId=portId+4;
							 uiPortDataArr[24].macro = MACRO_NULL;
							  uiPortDataArr[25].macro = MACRO_NULL;
							   uiPortDataArr[29].macro = MACRO_NULL;
							   }
							document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 28) portId=portId-3;
					 if(portId == 27) {portId=portId+2;writeSpaceCell(); writeSpaceCell();
					 }

						}
						else {
					if(portId == 24) {
						portId=portId+4; // Te1,Te2
					uiPortDataArr[24].macro = MACRO_NULL;
					uiPortDataArr[25].macro = MACRO_NULL;
					uiPortDataArr[26].macro = MACRO_NULL;
					uiPortDataArr[27].macro = MACRO_NULL;
					}
					document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 29) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			}
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "45" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')		
}

function WSC3750X12S(uiPortDataArr) {
	var MAX_PORTS=18;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "45" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	//For 12 SFP ports
	for (var portId = 0; portId < 12 ; portId++) {
  		if( (portId) % 6 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
		
	}
				
	document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')


	if(portCount > 16){//For 18 port device // 10 Giga N/W module
	var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
	var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
	var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
	var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
	var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
	var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
		
		for(var i=0;i<intArray.length;i++){
		if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
			nmmodule_gigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
			nmmodule_gigaport2=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
			nmmodule_gigaport3=intArray[i];
		else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
			nmmodule_gigaport4=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
			nmmodule_tengigaport1=intArray[i];
		else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
			nmmodule_tengigaport2=intArray[i];
		}
	
	}
	
			if(portCount == MAX_PORTS-2 && uiPortDataArr[MAX_PORTS-6].portName.indexOf("1/2") != -1) { 	//Wall E support
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			drawWallEModule(uiPortDataArr,intArray,MAX_PORTS);//
			}  else if((portCount > 12 && portCount == 16) ||
			   ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				 nmmodule_tengigaport2.indexOf("Not Present") > 0) &&
			    (nmmodule_tengigaport1.indexOf("Te") != -1 &&
				 nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
					  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
				for (var portId = 12; portId < 16 ; portId++)
					{
				document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
				   writeSpaceCell(); writeSpaceCell(); 					
				 }
				  if(portCount == 18){
						 uiPortDataArr[16].macro = MACRO_NULL;
							uiPortDataArr[17].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 13) portId+=3;// for Te2
					 if(portId == 17) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell();
					 	 uiPortDataArr[14].macro = MACRO_NULL;
						  uiPortDataArr[15].macro = MACRO_NULL;
						   uiPortDataArr[16].macro = MACRO_NULL;
						   }
						}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 12) {
							portId=portId+4;
							 uiPortDataArr[12].macro = MACRO_NULL;
							  uiPortDataArr[13].macro = MACRO_NULL;
							   uiPortDataArr[17].macro = MACRO_NULL;
							   }
							document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 16) portId=portId-3;
					 if(portId == 15) {portId=portId+2;writeSpaceCell(); writeSpaceCell();
					 }

						}
						else {
					if(portId == 12) {
						portId=portId+4; // Te1,Te2
					uiPortDataArr[12].macro = MACRO_NULL;
					uiPortDataArr[13].macro = MACRO_NULL;
					uiPortDataArr[14].macro = MACRO_NULL;
					uiPortDataArr[15].macro = MACRO_NULL;
					}
					document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 17) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			}
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "45" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')		
}
function drawWallEModule(uiPortDataArr,intArray,MAX_PORTS){

	//Possible ports --> [G2 G4] or [Te1 Te2]or [G2 Te2] or [Te1 G4]
	
	 for (var portId=MAX_PORTS-6;portId<MAX_PORTS-4 ;portId++) //52 ports in WallE --> 48 to 52
	 {
		if(intArray[portId].indexOf("Not Present") == -1) 
		{
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\</td>')
				writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
				uiPortDataArr[i+2].macro = MACRO_NULL;
		}
		else {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId+2, '\', \'', uiPortDataArr[portId+2].portName, '\', \'', uiPortDataArr[portId+2].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId+2, '\')"\
				onMouseDown="lower(\'', portId+2, '\', \'', uiPortDataArr[portId+2].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId+2, '\', \'', uiPortDataArr[portId+2].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId+2].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId+2, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId+2].portName), '\</td>')
				writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
				uiPortDataArr[i].macro = MACRO_NULL;
		}
			
	 }
	 writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 

}