/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.ClassFile;
import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.ccl.ClassData;
import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.util.ArrayList;
import java.util.Iterator;

class Component
implements Handler,
VersionXml,
ClassData {
    private static final byte NOT_LOADED = 0;
    private static final byte LOADED = 1;
    private static final byte NOT_FOUND = 2;
    private Package container;
    private String name;
    private boolean isSigned;
    private boolean isStored = false;
    private int version;
    private int size;
    private ArrayList markedSuper;
    private boolean isLatest = false;
    private byte loadState = 0;
    private byte[] contents;
    private CharString currElem;

    Component(Package container) {
        this.container = container;
    }

    String getName() {
        return this.name;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public void setStored(boolean v) {
        this.isStored = v;
    }

    int getSize() {
        return this.size;
    }

    Package getPackage() {
        return this.container;
    }

    int getVersion() {
        return this.version;
    }

    boolean isLatest() {
        return this.isLatest;
    }

    void setLatest(boolean isLatest) {
        if (this.isLatest != isLatest) {
            this.isLatest = isLatest;
            this.container.updateNumLatest(isLatest);
        }
    }

    ArrayList getMarkedSuper() {
        return this.markedSuper;
    }

    String getClassName() {
        return ClassFile.getClassName(this.name);
    }

    synchronized void setContents(byte[] contents) {
        this.contents = contents;
        this.loadState = 1;
        this.isStored = false;
        this.notifyAll();
    }

    public int getMajorVersion() {
        return this.container.getMajorVersion();
    }

    synchronized void setContentsNotFound() {
        if (!this.isLatest) {
            return;
        }
        this.loadState = (byte)2;
        this.notifyAll();
    }

    synchronized boolean isContentsLoaded() {
        return this.loadState == 1;
    }

    synchronized boolean isContentsNotFound() {
        return this.loadState == 2;
    }

    public synchronized byte[] getContents() {
        return this.contents;
    }

    synchronized void setSigned(boolean isSigned) {
        this.isSigned = isSigned;
    }

    public synchronized boolean isSigned() {
        return this.isSigned;
    }

    boolean isNewerThan(Component comp) {
        return this.name.equals(comp.name) && this.version > comp.version;
    }

    public boolean equals(Object object) {
        Component comp;
        if (object == null) {
            return false;
        }
        try {
            comp = (Component)object;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (!this.name.equals(comp.name)) {
            return false;
        }
        return this.version == comp.version;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString element) throws ParseException {
        this.currElem = null;
        if (element.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (element.equals(VersionXml.VERSION)) {
            this.currElem = VersionXml.VERSION;
        } else if (element.equals(VersionXml.SIZE)) {
            this.currElem = VersionXml.SIZE;
        } else if (element.equals(VersionXml.MARKED_SUPER)) {
            this.currElem = VersionXml.MARKED_SUPER;
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString data) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = data.toString();
        } else if (this.currElem == VersionXml.VERSION) {
            this.version = data.toInt();
        } else if (this.currElem == VersionXml.SIZE) {
            this.size = data.toInt();
        } else if (this.currElem == VersionXml.MARKED_SUPER) {
            if (this.markedSuper == null) {
                this.markedSuper = new ArrayList();
            }
            this.markedSuper.add(data.toString());
        }
    }

    public void ignoredData(Parser parser, CharString data) throws ParseException {
        throw new ParseException(parser, "Unexpected ignored data");
    }

    public void endElement(Parser parser, CharString element) throws ParseException {
        if (element.equals(VersionXml.COMPONENT)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }

    public void generateVersionFile(StringBuffer out) {
        this.generatePrologue(out);
        this.generateEpilogue(out);
    }

    private void generatePrologue(StringBuffer out) {
        out.append("   <");
        out.append(VersionXml.COMPONENT);
        out.append(">\n");
        out.append("    <");
        out.append(VersionXml.NAME);
        out.append(">");
        out.append(this.name);
        out.append("</");
        out.append(VersionXml.NAME);
        out.append(">\n");
        out.append("    <");
        out.append(VersionXml.VERSION);
        out.append(">");
        out.append(this.version);
        out.append("</");
        out.append(VersionXml.VERSION);
        out.append(">\n");
        out.append("    <");
        out.append(VersionXml.SIZE);
        out.append(">");
        out.append(this.size);
        out.append("</");
        out.append(VersionXml.SIZE);
        out.append(">\n");
        if (this.markedSuper != null) {
            Iterator it = this.markedSuper.iterator();
            while (it.hasNext()) {
                String superClass = (String)it.next();
                out.append("    <");
                out.append(VersionXml.MARKED_SUPER);
                out.append(">");
                out.append(superClass);
                out.append("</");
                out.append(VersionXml.MARKED_SUPER);
                out.append(">\n");
            }
        }
    }

    private void generateEpilogue(StringBuffer out) {
        out.append("   </");
        out.append(VersionXml.COMPONENT);
        out.append(">\n");
    }
}

