/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.CSIProperties;
import com.cisco.cpnm.boot.internal.Component;
import com.cisco.cpnm.boot.internal.ComponentHelper;
import com.cisco.cpnm.boot.internal.Distribution;
import com.cisco.cpnm.boot.internal.DynamicDiscoveryDb;
import com.cisco.cpnm.boot.internal.InstallContext;
import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.PackageLoadHandler;
import com.cisco.cpnm.boot.internal.RemoveCompleteEvent;
import com.cisco.cpnm.boot.internal.RemoveFailEvent;
import com.cisco.cpnm.boot.internal.SaveCompleteEvent;
import com.cisco.cpnm.boot.internal.SaveFailEvent;
import com.cisco.cpnm.boot.internal.VersionFile;
import com.cisco.cpnm.boot.internal.VersionIntegrator;
import com.cisco.cpnm.boot.internal.VersionIntgHandler;
import com.cisco.cpnm.boot.internal.VersionReadHandler;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.ccl.ClassData;
import com.cisco.cpnm.boot.internal.jobq.JobHandler;
import com.cisco.cpnm.boot.internal.jobq.JobOwner;
import com.cisco.cpnm.boot.internal.jobq.JobQueue;
import com.cisco.cpnm.boot.internal.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ComponentDb
implements JobOwner,
Cloneable,
BootDebug {
    private static final VersionNumber CURR_JRE_VER = new VersionNumber(System.getProperty("java.version"));
    private static VersionNumber CURR_PLUGIN_VER = null;
    private static VersionNumber CURR_BOOT_VER = null;
    private Map compMap;
    private HashSet seenSet = new HashSet();
    private ComponentDb clone_cdb = null;
    private DynamicDiscoveryDb dynDiscDb;
    private List versionFiles;
    private boolean parsedFileSeen;
    private boolean majorCompatibleFileSeen;
    private boolean jreCompatibleFileSeen;
    private VersionNumber minJre;
    private VersionNumber minPlugin;
    private boolean bootCompatibleFileSeen;
    private VersionNumber minBoot;
    private VersionIntegrator integrator;
    private JobQueue verReadQ;
    private JobQueue verIntgQ;
    private JobQueue pkgLoadQ;
    private JobQueue cmpSaveQ;
    private CSIProperties csi;
    private int saveCount = 0;
    private int totalCount = 0;
    private ComponentHelper cif;
    private boolean isClone = false;

    ComponentDb(DynamicDiscoveryDb dynDiscDb, VersionIntegrator integrator, CSIProperties csi, ComponentHelper cif) {
        this.csi = csi;
        this.cif = cif;
        this.compMap = new HashMap();
        this.versionFiles = new ArrayList(20);
        this.verReadQ = new JobQueue(this, 0);
        this.verIntgQ = new JobQueue(this, 1);
        this.pkgLoadQ = new JobQueue(this, 0);
        this.dynDiscDb = dynDiscDb;
        this.integrator = integrator;
        String plugin = System.getProperty("CMS_PLUGIN_VERSION");
        if (plugin != null) {
            CURR_PLUGIN_VER = new VersionNumber(plugin);
        }
        CURR_BOOT_VER = cif.getBootVersion();
    }

    public boolean isCsiEnabled() {
        return this.csi.isEnabled();
    }

    protected Object clone() throws CloneNotSupportedException {
        ComponentDb clone_cdb = (ComponentDb)super.clone();
        clone_cdb.compMap = (HashMap)((HashMap)this.compMap).clone();
        clone_cdb.versionFiles = (ArrayList)((ArrayList)this.versionFiles).clone();
        clone_cdb.setClone(true);
        return clone_cdb;
    }

    public boolean isClone() {
        return this.isClone;
    }

    public void setClone(boolean v) {
        this.isClone = v;
    }

    public Map getCompMap() {
        return this.compMap;
    }

    public boolean hasNewVersions(VersionFile version) {
        List dists = version.getDistributions();
        if (dists == null) {
            return false;
        }
        Iterator v_iter = dists.iterator();
        while (v_iter.hasNext()) {
            Distribution dist = (Distribution)v_iter.next();
            Iterator d_iter = dist.getPackages().iterator();
            while (d_iter.hasNext()) {
                Package pkg = (Package)d_iter.next();
                Iterator c_iter = pkg.getComponents().iterator();
                while (c_iter.hasNext()) {
                    Component cmp = (Component)c_iter.next();
                    Component existing = (Component)this.compMap.get(cmp.getName());
                    if (existing != null && !cmp.isNewerThan(existing)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSaveNeeded() {
        boolean saveNeeded = false;
        Iterator it = this.compMap.values().iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            if (comp.isStored()) continue;
            saveNeeded = true;
            break;
        }
        return saveNeeded;
    }

    public ComponentDb integrateFilesystem(URL[] codebase) {
        try {
            if (this.clone_cdb == null) {
                this.clone_cdb = (ComponentDb)this.clone();
            }
            int i = 0;
            while (i < codebase.length) {
                VersionFile version = VersionFile.loadSwitchVersionFile(codebase[i]);
                this.clone_cdb.integrateFile(version);
                ++i;
            }
            this.clone_cdb.saveIfNeeded();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return this.clone_cdb;
    }

    public void saveIfNeeded() {
        if (this.cif.csiLock()) {
            this.cif.saving(true);
            if (this.isSaveNeeded()) {
                this.totalCount = this.getSaveCount();
                Iterator it = this.versionFiles.iterator();
                while (it.hasNext()) {
                    VersionFile vf = (VersionFile)it.next();
                    this.saveFromVersionFile(vf);
                }
                if (this.saveCount > 0) {
                    this.outputVersionFile();
                }
            }
        } else {
            this.cif.distributeBootEvent(new SaveFailEvent());
        }
        this.cif.saving(false);
        this.cif.csiUnlock();
        this.cif.setEnabled(true);
        this.cif.save();
        this.cif.distributeBootEvent(new SaveCompleteEvent());
    }

    private void saveFromVersionFile(VersionFile version) {
        if (version.isContributing()) {
            Iterator iter = version.getDistributions().iterator();
            while (iter.hasNext()) {
                Distribution dist = (Distribution)iter.next();
                if (dist.isLocal()) continue;
                this.saveDistribution(dist);
            }
        }
    }

    public int getSaveCount() {
        int count = 0;
        Iterator c_it = this.compMap.values().iterator();
        while (c_it.hasNext()) {
            Component cmp = (Component)c_it.next();
            if (!cmp.isLatest() || cmp.isStored()) continue;
            ++count;
        }
        return count;
    }

    private void saveDistribution(Distribution dist) {
        if (dist.isContributing()) {
            Iterator iter = dist.getPackages().iterator();
            while (iter.hasNext()) {
                Package pkg = (Package)iter.next();
                this.savePackage(pkg);
            }
        }
    }

    private void savePackage(Package pkg) {
        Iterator iter = pkg.getComponents().iterator();
        while (iter.hasNext()) {
            Component cmp = (Component)iter.next();
            if (!cmp.isLatest() || cmp.isStored()) continue;
            this.saveComponent(cmp);
        }
    }

    private void saveComponent(Component cmp) {
        byte[] contents = this.getContents(cmp);
        String name = cmp.getName();
        String filename = this.fabricateFilename(cmp);
        File outFile = new File(filename);
        File outDirectory = new File(outFile.getParent());
        if (!outDirectory.exists()) {
            outDirectory.mkdirs();
        }
        try {
            FileOutputStream csiFile = new FileOutputStream(outFile);
            csiFile.write(contents);
            csiFile.close();
            cmp.setStored(true);
            ++this.saveCount;
            this.cif.progressUpdate(this.saveCount, this.totalCount);
        }
        catch (FileNotFoundException ex) {
            System.out.println("File Not Found!");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("IO Exception!");
            ex.printStackTrace();
        }
        filename = null;
    }

    private String fabricateFilename(Component cmp) {
        StringBuffer filename = new StringBuffer();
        filename.append(this.csi.getRepository());
        filename.append("/v");
        filename.append(cmp.getMajorVersion());
        if (cmp.isSigned()) {
            filename.append("/signed/");
        } else {
            filename.append("/unsigned/");
        }
        filename.append(cmp.getName());
        return filename.toString();
    }

    public void uninstall() {
        Thread worker = new Thread(){

            public void run() {
                if (ComponentDb.this.cif.csiLock()) {
                    int totalCount = ComponentDb.this.getStoredCount();
                    File repository = new File(ComponentDb.this.csi.getRepository());
                    ComponentDb.this.removeDirectory(repository, 0, totalCount);
                    File versionFile = new File(repository, "version.xml");
                    if (versionFile.exists()) {
                        versionFile.delete();
                    }
                    if (repository.exists()) {
                        repository.delete();
                    }
                    ComponentDb.this.cif.progressUpdate(totalCount, totalCount);
                    ComponentDb.this.cif.csiUnlock();
                    ComponentDb.this.cif.setEnabled(false);
                    ComponentDb.this.cif.save();
                    ComponentDb.this.cif.setRebootRequired(true);
                    ComponentDb.this.cif.distributeBootEvent(new RemoveCompleteEvent());
                } else {
                    ComponentDb.this.cif.distributeBootEvent(new RemoveFailEvent());
                }
            }
        };
        worker.start();
    }

    private int removeDirectory(File dir, int count, int totalCount) {
        File[] entries = dir.listFiles();
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                File entry = entries[i];
                if (entry.isFile()) {
                    this.cif.progressUpdate(++count, totalCount);
                    if (entry.exists()) {
                        entry.delete();
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < entries.length) {
                File entry = entries[i2];
                if (entry.isDirectory()) {
                    count = this.removeDirectory(entry, count, totalCount);
                }
                ++i2;
            }
        }
        this.cif.progressUpdate(++count, totalCount);
        if (dir.exists()) {
            dir.delete();
        }
        return count;
    }

    void integrateFile(URL filesystem, InputStream versionFile) {
        VersionFile file = new VersionFile(filesystem, versionFile);
        this.verReadQ.submit(file, false);
    }

    void integrateFile(InstallContext context, InputStream versionFile) {
        VersionFile file = new VersionFile(context, versionFile);
        this.verReadQ.submit(file, false);
    }

    void integrateFile(VersionFile versionFile) {
        boolean integrate = this.addVersionFile(versionFile);
        if (integrate) {
            this.integrator.integrateFile(versionFile, this);
            this.cif.setRebootRequired(true);
        }
    }

    void waitForCompletion() {
        this.verReadQ.waitForCompletion();
        this.verIntgQ.waitForCompletion();
    }

    boolean addVersionFile(VersionFile verFile) {
        this.versionFiles.add(verFile);
        if (verFile.getParseException() != null) {
            return false;
        }
        this.parsedFileSeen = true;
        if (verFile.getMajorVersion() != 1) {
            return false;
        }
        this.majorCompatibleFileSeen = true;
        VersionNumber verFileJre = verFile.getJreVersion();
        if (this.minJre == null || verFileJre.compareTo(this.minJre) < 0) {
            this.minJre = verFileJre;
        }
        VersionNumber verFilePlugin = verFile.getMinPlugin();
        if (this.minPlugin == null || verFilePlugin.compareTo(this.minPlugin) < 0) {
            this.minPlugin = verFilePlugin;
        }
        if (CURR_PLUGIN_VER != null) {
            if (verFilePlugin == null) {
                return false;
            }
            if (verFilePlugin.compareTo(CURR_PLUGIN_VER) > 0) {
                return false;
            }
            this.jreCompatibleFileSeen = true;
        } else {
            if (verFileJre.compareTo(CURR_JRE_VER) > 0) {
                return false;
            }
            this.jreCompatibleFileSeen = true;
        }
        VersionNumber verFileBoot = verFile.getMinBoot();
        if (verFileBoot == null) {
            return false;
        }
        if (this.minBoot == null || verFileBoot.compareTo(this.minBoot) < 0) {
            this.minBoot = verFileBoot;
        }
        if (verFileBoot.compareTo(CURR_BOOT_VER) > 0) {
            return false;
        }
        this.bootCompatibleFileSeen = true;
        return true;
    }

    int getStartupError() {
        if (!this.parsedFileSeen) {
            return 1;
        }
        if (!this.majorCompatibleFileSeen) {
            return 2;
        }
        if (!this.jreCompatibleFileSeen) {
            return 3;
        }
        if (!this.bootCompatibleFileSeen) {
            return 4;
        }
        return 0;
    }

    List getContribDistsNames() {
        ArrayList<String> contrib = new ArrayList<String>();
        Iterator verFiles = this.versionFiles.iterator();
        while (verFiles.hasNext()) {
            VersionFile verFile = (VersionFile)verFiles.next();
            if (!verFile.isContributing()) continue;
            Iterator dists = verFile.getDistributions().iterator();
            while (dists.hasNext()) {
                Distribution dist = (Distribution)dists.next();
                if (!dist.isContributing()) continue;
                contrib.add(dist.getName());
            }
        }
        return contrib;
    }

    List getContribDists() {
        ArrayList<Distribution> contrib = new ArrayList<Distribution>();
        Iterator verFiles = this.versionFiles.iterator();
        while (verFiles.hasNext()) {
            VersionFile verFile = (VersionFile)verFiles.next();
            if (!verFile.isContributing()) continue;
            Iterator dists = verFile.getDistributions().iterator();
            while (dists.hasNext()) {
                Distribution dist = (Distribution)dists.next();
                if (!dist.isContributing()) continue;
                contrib.add(dist);
            }
        }
        return contrib;
    }

    void integrateWithoutChecking(Package intgPkg) {
        List components = intgPkg.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            String compName = component.getName();
            this.compMap.put(compName, component);
            this.replaceComponent(null, component);
        }
    }

    void integrateWithChecking(Package intgPkg) {
        List components = intgPkg.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            String compName = component.getName();
            Component existing = (Component)this.compMap.get(compName);
            if (existing == null) {
                this.compMap.put(compName, component);
                this.replaceComponent(null, component);
                continue;
            }
            if (!component.isNewerThan(existing)) continue;
            this.compMap.put(compName, component);
            this.replaceComponent(existing, component);
        }
    }

    private void replaceComponent(Component oldComp, Component newComp) {
        ArrayList oldSuper = null;
        ArrayList newSuper = null;
        if (oldComp != null) {
            oldComp.setLatest(false);
            oldSuper = oldComp.getMarkedSuper();
        }
        newComp.setLatest(true);
        newSuper = newComp.getMarkedSuper();
        if (oldSuper != null) {
            if (oldSuper.equals(newSuper)) {
                return;
            }
            this.dynDiscDb.removeDiscovered(oldSuper, oldComp.getClassName());
        }
        if (newSuper != null) {
            this.dynDiscDb.addDiscovered(newSuper, newComp.getClassName());
        }
    }

    ClassData getClassData(String name) {
        String classFilename = name.replace('.', '/') + ".class";
        Component component = (Component)this.compMap.get(classFilename);
        if (component == null) {
            return null;
        }
        byte[] bytecode = this.getContents(component);
        if (bytecode == null) {
            return null;
        }
        return component;
    }

    InputStream getStream(String name) {
        Component component = (Component)this.compMap.get(name);
        if (component == null) {
            return null;
        }
        byte[] bytes = this.getContents(component);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        return stream;
    }

    protected boolean contains(String name) {
        return this.compMap.get(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getContents(Component component) {
        Component component2 = component;
        synchronized (component2) {
            if (component.isContentsLoaded()) {
                return component.getContents();
            }
            if (component.isContentsNotFound()) {
                return null;
            }
            Package pkg = component.getPackage();
            this.pkgLoadQ.submit(pkg, false);
            do {
                try {
                    component.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (!component.isContentsLoaded() && !component.isContentsNotFound());
            return component.getContents();
        }
    }

    public JobHandler createHandler(JobQueue queue) {
        JobHandler handler = null;
        if (queue == this.verReadQ) {
            handler = new VersionReadHandler(this.verIntgQ);
        } else if (queue == this.verIntgQ) {
            handler = new VersionIntgHandler(this, this.integrator);
        } else if (queue == this.pkgLoadQ) {
            handler = new PackageLoadHandler();
        }
        return handler;
    }

    public void outputVersionFile() {
        String versionFileName = this.csi.getRepository() + "/version.xml";
        this.outputVersionFile(versionFileName);
    }

    public void outputVersionFile(String filename) {
        try {
            File version = new File(filename);
            PrintWriter out = new PrintWriter(new FileOutputStream(version));
            this.outputPrologue(out);
            this.outputVersionFile(out);
            this.outputEpilogue(out);
            out.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private void outputPrologue(PrintWriter out) {
        int majVer = -1;
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.print("<");
        out.print(VersionXml.VERSION_FILE);
        out.println(">");
        out.print(" <");
        out.print(VersionXml.MINIMUM_JRE);
        out.print(">");
        out.print(this.minJre);
        out.print("</");
        out.print(VersionXml.MINIMUM_JRE);
        out.println(">");
        out.print(" <");
        out.print(VersionXml.MINIMUM_BOOT);
        out.print(">");
        if (this.minBoot != null) {
            out.print(this.minBoot);
        } else {
            out.print("0.0");
        }
        out.print("</");
        out.print(VersionXml.MINIMUM_BOOT);
        out.println(">");
        out.print(" <");
        out.print(VersionXml.MINIMUM_PLUGIN);
        out.print(">");
        if (this.minPlugin != null) {
            out.print(this.minPlugin);
        } else {
            out.print("0.0");
        }
        out.print("</");
        out.print(VersionXml.MINIMUM_PLUGIN);
        out.println(">");
        Iterator verFiles = this.versionFiles.iterator();
        while (verFiles.hasNext()) {
            VersionFile verFile = (VersionFile)verFiles.next();
            if (!verFile.isContributing()) continue;
            Iterator dists = verFile.getDistributions().iterator();
            while (dists.hasNext()) {
                Distribution dist = (Distribution)dists.next();
                if (!dist.isContributing() || dist.getMajorVersion() <= majVer) continue;
                majVer = dist.getMajorVersion();
            }
        }
        out.print(" <");
        out.print(VersionXml.MAJOR_VERSION);
        out.print(">");
        out.print(majVer);
        out.print("</");
        out.print(VersionXml.MAJOR_VERSION);
        out.println(">");
    }

    public void outputVersionFile(PrintWriter out) {
        List dists = this.getContribDists();
        Iterator iter = dists.iterator();
        while (iter.hasNext()) {
            Distribution dist = (Distribution)iter.next();
            dist.outputVersionFile(out);
        }
    }

    private void outputEpilogue(PrintWriter out) {
        out.print("</");
        out.print(VersionXml.VERSION_FILE);
        out.println(">");
    }

    public int getStoredCount() {
        int totalCount = 0;
        Iterator verFiles = this.versionFiles.iterator();
        while (verFiles.hasNext()) {
            VersionFile verFile = (VersionFile)verFiles.next();
            totalCount += this.totalCount(verFile, false);
        }
        return totalCount;
    }

    private int totalCount(VersionFile version, boolean unsavedOnly) {
        int count = 0;
        if (version.isContributing()) {
            Iterator iter = version.getDistributions().iterator();
            while (iter.hasNext()) {
                Distribution dist = (Distribution)iter.next();
                if (unsavedOnly) {
                    if (dist.isLocal()) continue;
                    count += this.countDistribution(dist, unsavedOnly);
                    continue;
                }
                count += this.countDistribution(dist, unsavedOnly);
            }
        }
        return count;
    }

    private int countDistribution(Distribution dist, boolean unsavedOnly) {
        int count = 0;
        if (dist.isContributing()) {
            Iterator iter = dist.getPackages().iterator();
            while (iter.hasNext()) {
                Package pkg = (Package)iter.next();
                count += this.countPackage(pkg, unsavedOnly);
            }
        }
        return count;
    }

    private int countPackage(Package pkg, boolean unsavedOnly) {
        int count = 0;
        Iterator iter = pkg.getComponents().iterator();
        while (iter.hasNext()) {
            Component cmp = (Component)iter.next();
            if (!cmp.isLatest()) continue;
            if (unsavedOnly) {
                if (cmp.isStored()) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public void addSeen(List dists) {
        Iterator it = dists.iterator();
        while (it.hasNext()) {
            Distribution dist = (Distribution)it.next();
            this.addSeen(dist.getName());
        }
    }

    public void addSeen(String name) {
        this.seenSet.add(name);
    }

    public boolean alreadySeen(String name) {
        boolean result = this.seenSet.contains(name);
        return result;
    }
}

