/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.external.BootApp;
import com.cisco.cpnm.boot.external.BootedApp;
import com.cisco.cpnm.boot.internal.ApiMap;
import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.CSIContext;
import com.cisco.cpnm.boot.internal.CSIProperties;
import com.cisco.cpnm.boot.internal.ComponentClassLoader;
import com.cisco.cpnm.boot.internal.ComponentDb;
import com.cisco.cpnm.boot.internal.ComponentHelper;
import com.cisco.cpnm.boot.internal.DynamicDiscoveryDb;
import com.cisco.cpnm.boot.internal.FilesysDiscoverer;
import com.cisco.cpnm.boot.internal.HybridVersionIntegrator;
import com.cisco.cpnm.boot.internal.InstallContext;
import com.cisco.cpnm.boot.internal.StartupError;
import com.cisco.cpnm.boot.internal.SwitchContext;
import com.cisco.cpnm.boot.internal.util.VersionNumber;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JApplet;

public class BootstrapApplet
extends JApplet
implements BootApp,
BootDebug {
    static final int MAJOR_VERSION = 1;
    private ComponentDb cdb;
    private CSIProperties csi;
    private ComponentHelper cif;
    private DynamicDiscoveryDb dynDiscDb;
    private BootedApp mDelegate;
    private ClassLoader mClassLoader;
    private VersionNumber bootVersion;
    private ApiMap interfaces;
    private static Class[] mBootClasses = new Class[]{class$com$cisco$cpnm$boot$external$BootApp == null ? (class$com$cisco$cpnm$boot$external$BootApp = BootstrapApplet.class$("com.cisco.cpnm.boot.external.BootApp")) : class$com$cisco$cpnm$boot$external$BootApp, class$com$cisco$cpnm$boot$external$BootedApp == null ? (class$com$cisco$cpnm$boot$external$BootedApp = BootstrapApplet.class$("com.cisco.cpnm.boot.external.BootedApp")) : class$com$cisco$cpnm$boot$external$BootedApp, class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem == null ? (class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem = BootstrapApplet.class$("com.cisco.cpnm.boot.external.DynamicDiscoverySystem")) : class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem, class$com$cisco$cpnm$boot$external$DynamicDiscoveryListener == null ? (class$com$cisco$cpnm$boot$external$DynamicDiscoveryListener = BootstrapApplet.class$("com.cisco.cpnm.boot.external.DynamicDiscoveryListener")) : class$com$cisco$cpnm$boot$external$DynamicDiscoveryListener, class$com$cisco$cpnm$boot$external$ComponentIF == null ? (class$com$cisco$cpnm$boot$external$ComponentIF = BootstrapApplet.class$("com.cisco.cpnm.boot.external.ComponentIF")) : class$com$cisco$cpnm$boot$external$ComponentIF, class$com$cisco$cpnm$boot$external$BootEvent == null ? (class$com$cisco$cpnm$boot$external$BootEvent = BootstrapApplet.class$("com.cisco.cpnm.boot.external.BootEvent")) : class$com$cisco$cpnm$boot$external$BootEvent, class$com$cisco$cpnm$boot$external$BootEventListener == null ? (class$com$cisco$cpnm$boot$external$BootEventListener = BootstrapApplet.class$("com.cisco.cpnm.boot.external.BootEventListener")) : class$com$cisco$cpnm$boot$external$BootEventListener, class$com$cisco$cpnm$boot$external$DistInfo == null ? (class$com$cisco$cpnm$boot$external$DistInfo = BootstrapApplet.class$("com.cisco.cpnm.boot.external.DistInfo")) : class$com$cisco$cpnm$boot$external$DistInfo};
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$BootApp;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$BootedApp;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$DynamicDiscoveryListener;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$ComponentIF;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$BootEvent;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$BootEventListener;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$external$DistInfo;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$internal$CSIProperties;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$internal$ComponentDb;

    public void init() {
        this.loadBootInfo();
        this.interfaces = new ApiMap();
        this.csi = new CSIProperties();
        this.interfaces.putInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = BootstrapApplet.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties, this.csi);
        if (!this.csi.existed()) {
            this.csi.setEnabled(false);
            this.csi.save();
        }
        this.cif = new ComponentHelper(this);
        this.interfaces.putInstance(class$com$cisco$cpnm$boot$external$ComponentIF == null ? (class$com$cisco$cpnm$boot$external$ComponentIF = BootstrapApplet.class$("com.cisco.cpnm.boot.external.ComponentIF")) : class$com$cisco$cpnm$boot$external$ComponentIF, this.cif);
        this.discoverComponents();
        int errorVal = this.cdb.getStartupError();
        if (errorVal != 0) {
            StartupError error = new StartupError(errorVal, this, this.cdb);
            error.show();
            return;
        }
        this.mClassLoader = new ComponentClassLoader(mBootClasses, this.cdb);
        this.createDelegate();
        this.mDelegate.setBootApp(this);
        this.mDelegate.init();
    }

    public Object getInstance(Class obclass) {
        return this.interfaces.getInstance(obclass);
    }

    public boolean supports(Class obclass) {
        return this.interfaces.supports(obclass);
    }

    private void loadBootInfo() {
        block3: {
            Object bootUrl = null;
            try {
                ClassLoader mycl = this.getClass().getClassLoader();
                URL info = mycl.getResource("bootinfo.dat");
                if (info == null) break block3;
                InputStream is = info.openStream();
                Properties bootProps = new Properties();
                bootProps.load(is);
                String value = bootProps.getProperty("Boot-Version");
                if (value != null) {
                    this.bootVersion = new VersionNumber(value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void start() {
        if (this.mDelegate == null) {
            return;
        }
        this.mDelegate.start();
    }

    public void stop() {
        if (this.mDelegate == null) {
            return;
        }
        this.mDelegate.stop();
    }

    public void destroy() {
        if (this.mDelegate == null) {
            return;
        }
        this.mDelegate.destroy();
    }

    public VersionNumber getBootVersion() {
        return this.bootVersion;
    }

    private void discoverComponents() {
        URL codebase = this.getCodeBase();
        InstallContext context = new SwitchContext(codebase);
        if (this.csi.isEnabled()) {
            File version = new File(this.csi.getRepository(), "version.xml");
            if (version.exists()) {
                try {
                    codebase = new URL("file", null, this.csi.getRepository());
                    context = new CSIContext(codebase);
                }
                catch (MalformedURLException ex) {
                    System.out.println("CSI Repository invalid, reverting to default codebase!");
                    System.out.println("CSI Repository is : " + this.csi.getRepository());
                    ex.printStackTrace();
                }
            } else {
                System.out.println("CSI Repository empty, reverting to default codebase!");
            }
        }
        this.dynDiscDb = new DynamicDiscoveryDb();
        HybridVersionIntegrator integrator = new HybridVersionIntegrator();
        this.cdb = new ComponentDb(this.dynDiscDb, integrator, this.csi, this.cif);
        FilesysDiscoverer filesysDisc = new FilesysDiscoverer(context, this.cdb);
        this.interfaces.putInstance(class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem == null ? (class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem = BootstrapApplet.class$("com.cisco.cpnm.boot.external.DynamicDiscoverySystem")) : class$com$cisco$cpnm$boot$external$DynamicDiscoverySystem, this.dynDiscDb);
        this.interfaces.putInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = BootstrapApplet.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb, this.cdb);
        filesysDisc.submit(context);
        filesysDisc.waitForCompletion();
        this.cdb.waitForCompletion();
    }

    private void createDelegate() {
        Class<?> c;
        String delegateClass = this.getParameter("delegate");
        if (delegateClass == null) {
            System.out.println("Error: \"delegate\" parameter missing.");
            return;
        }
        try {
            c = this.mClassLoader.loadClass(delegateClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error: unable to find class " + delegateClass);
            e.printStackTrace();
            return;
        }
        try {
            this.mDelegate = (BootedApp)c.newInstance();
        }
        catch (Exception e) {
            System.out.println("Error: Unable to instantiate " + delegateClass);
            e.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

