/*
 *------------------------------------------------------------------
 * Copyright (c) 2003-2008, 2010 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

function StringBuffer() { 
   this.buffer = []; 
 } 

 StringBuffer.prototype.append = function append(string) { 
   this.buffer.push(string); 
   return this; 
 }; 

 StringBuffer.prototype.toString = function toString() { 
   return this.buffer.join(""); 
 }; 

function lineGraph(_id) {
	this.id = _id;
	this.spacing = 50;
	this.scale = 1;
	this.baseHeight = 30;
	this.lineColor = "#000000"; //black
	this.secLineColor = "#808080"; //gray
	this.pointColor = "none";
	this.lineWidth = 1;
	this.xlineWidth = 1;
	this.yMax = 300;
	this.yScale = 20;
	this.yAxisBorder = 1;
	this.skipX = 1;
	this.xNumbers = true;
	this.dropLines = true;
	this.connectLines = false;
	this.yText = "%";
	this.xText = top.resourceFrame.re_frmWrk_GraphTimeSlots;
	this.showMaxValue = false; // flag to indicate if peek value should be marked with horizontal line
	this.coordLength = 60; // max number of bars to be displayed in the graph
	this.restartXAfterArray=new Array();
	this.restartXAfter = 0;
	this.coordinates = new Array();
	this.secCoordinates = new Array();
	this.build = drawLineGraph;
	this.draw = drawLineGraph;
	this.generateYAxisText = generateYAxisText;
	this.generateCellText = generateCellText;
	this.drawLegend=false;
	this.portUtilTooltip=false;
	this.receiveText="";
	this.transmitText="";
	this.utilText="";
	this.setLegend = _setLegendGraph;
	this.isPixar=false;
	this.isDelphinium=false;
	this.xAxisNum=new Array();
	this.scaleTextAsPortName=false;
	this.isFa0=false;
	this.totalPorts=0;
	this.isXmen2=false;
	this.intArray=new Array(); //Added for X-Men2 for actual interface name as tooltip.

}

function _setLegendGraph() {
	this.legends = arguments;
}

function drawLineGraph() {
var RexScaleTextArray =new Array();	
var RexToolTipPortNameArray =new Array();
	if(deviceType.indexOf("WS-C3560E-12D") != -1){
		var rxIndx=0;
		var portsString=top.dataCache.get("portString");
		for(var t=1;t<13;t++){
			if(portsString.indexOf("Te0/"+t+"#") != -1){
				RexScaleTextArray[rxIndx]="X2-"+t;
				RexToolTipPortNameArray[rxIndx]="Te0/"+t;
				rxIndx++;
			}else{
				RexScaleTextArray[rxIndx]=(t*2)-1;
				RexToolTipPortNameArray[rxIndx]="Gi0/"+((t*2)-1);
				rxIndx++;
				RexScaleTextArray[rxIndx]=(t*2);
				RexToolTipPortNameArray[rxIndx]="Gi0/"+(t*2);
				rxIndx++;
			}
		}	
	}

var maxValue = 2;
var maxValueStyle = "";
if(this.showMaxValue) {
	var temp = this.coordinates.join(",");
	temp = temp.split(",");
	for(var i=0; i<temp.length; i++) {
		temp[i] = parseInt(temp[i])
	}
	temp = temp.sort(function compareNumbers(a, b) { return a - b });
	if(temp[temp.length-1] > 0) {
		maxValue = temp[temp.length-1];
		maxValueStyle = "border-top:1px solid black;";
	}
}
	var graphStr = new StringBuffer();
	var graphRows = (this.yMax/this.yScale) + 1;	
	var xAxisScale = new StringBuffer();
	var xAxisNumbers = new StringBuffer();
	var xAxisCounter = 0;
	var isCounterReset=false;
	var j=0;var k=0;var t=0;
	var portNames=new Array();
	var x2Portname=new Array();
	if(this.skipX >1) j=1;
	graphStr.append("<table cellpadding='3' cellspacing='0' height='100%' width='100%' border='0'>");
	graphStr.append("<tr>");
	if(this.isXmen2){ 
	  if(this.totalPorts <=10)
	  graphStr.append("<td  width='45%'>");
	}else if(this.totalPorts <=10)
		graphStr.append("<td  width='25%'>");
	else if(this.totalPorts >10 && this.totalPorts <=20)
		graphStr.append("<td  width='25%'>");
	else
	    graphStr.append("<td  width='10%'>");
 	graphStr.append("</td>");
	graphStr.append("<td align='right' valign='middle' style='width:10px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;'>");
	graphStr.append(this.yText);
	graphStr.append("</td>");
	//graph cell
	graphStr.append("<td valign='bottom'>");
	//inner table which contains the graph
	graphStr.append("<table id='" + this.id + "_Graph_Table' cellpadding='0' cellspacing='0' height='100%' border='0'>");
	graphStr.append("<tr>");
	//yaxis
	graphStr.append("<td style='padding:0px;' valign='bottom'>");
	graphStr.append(this.generateYAxisText());
	graphStr.append("</td>");
	if(this.secCoordinates.length > 0) 
		this.xlineWidth = this.lineWidth * 2;
	else 
		this.xlineWidth = this.lineWidth;
		
	if(deviceType=="WS-CBS3120X-S" || deviceType.indexOf("WS-CBS3130X-S")!=-1 || deviceType=="WS-CBS3125X-S"){
		var count=this.coordinates.length;
		for(var i=0;i<this.intArray.length;i++){
		if(this.intArray[i].indexOf("Te")!=-1)
			  x2Portname.push(this.intArray[i]);
		}
	}
	for(var i=0; i<this.coordinates.length; i++) {	
		if(i==0){
				graphStr.append( "<td style='width:"+this.spacing+"px;border-left:1px solid black;border-bottom:1px solid black;' valign='bottom' rowspan2='" + graphRows + "'><div style='height:"+maxValue+"px;width:5px;"+maxValueStyle+"'><!----></div></td>");
		}else{ 
			// spacing column
				graphStr.append("<td style='width:2px;border-bottom:1px solid black;' valign='bottom'><div style='width:"+this.spacing+"px;height:"+maxValue+"px;"+maxValueStyle+"'><!----></div></td>");	
		}		
		//this block generates x axis scale lines
		{
			//var lineColor = "none";
			//if((i+1) % (this.skipX) == 0) {
				lineColor = "black";
			//}
			// to compensate for spacing column
			if(i == 0) {
				xAxisScale.append("<td style='width:" + this.spacing + "px;border-left:1px solid black;' valign='bottom'>");
				xAxisScale.append("<div style='width:" + this.spacing + "px;height:10px;'><!-- --></div>");
				xAxisScale.append("</td>");
			}
			else {
				xAxisScale.append("<td style='width:" + this.spacing + "px;' valign='bottom'><!-- --></td>");
			}
			xAxisScale.append("<td style='height:10px;width:" + this.xlineWidth + "px;padding:0px;' align='center'>");
			xAxisScale.append("<div style='background:" + lineColor + ";width:1px;height:10px;'><!-- --></div>");
			xAxisScale.append("</td>");
		}
		//this block generates x axis scale numbers
		{
			if(i % this.skipX == 0) {
				var scaleText = 0;
				if(this.isXmen2){
					if(this.restartXAfterArray.length!=0){
						if(xAxisCounter==this.restartXAfterArray[i]){ 
							xAxisCounter = 0;
							isCounterReset=true;
						}
					}
			  }else if(this.restartXAfter!=0){
					if(xAxisCounter==this.restartXAfter){
						xAxisCounter = 0;
						isCounterReset=true;
					}
				}
			if( deviceType=="WS-CBS3120X-S" || deviceType=="WS-CBS3125X-S") 
					{ 
							if(this.restartXAfter==18 ){
							if(count==26){
							  if(i==19)				
							     xAxisCounter=20;
							}
							else if(count==25){
								if(i==20)
								   xAxisCounter=22;
							}			
						}
						else if(this.restartXAfter==20){
							if(i==20)
							  xAxisCounter=1;
							if(i==21) 
								xAxisCounter=22;
						}
					}	
			if(deviceType=="WS-CBS3110G-S-TEL" || deviceType=="WS-CBS3110G-S-I-TEL" || top.getSelectedDevice().type == "WS-CBS3012-IBM-TEL" || top.getSelectedDevice().type == "WS-CBS3012-IBM-I-TEL"){
					if(i==8 && this.restartXAfter==8){
						xAxisCounter=14;
					}
				}
			if(top.getSelectedDevice().type == "WS-CBS3012-IBM-I-BCS" || top.getSelectedDevice().type == "WS-CBS3012-IBM-BCS"){
			
					if(i==6 && this.restartXAfter==6){
						xAxisCounter=14;
					}
				}	
				
				scaleText = xAxisCounter + this.skipX;
				
				
				if(this.isFa0){
					if(this.coordinates.length-1==xAxisCounter){
						scaleText="Fa0";
					}	
					else if(i==15 && (deviceType=="WS-CBS3110X-S" || deviceType=="WS-CBS3110X-S-I" || deviceType=="WS-CBS3110X-S-HT-TEL" || deviceType=="WS-CBS3110X-S-I-HT-TEL")){	
						scaleText="Fa0";
					}
					else if(i==12 && (deviceType=="WS-CBS3110G-S-TEL" || deviceType=="WS-CBS3110G-S-I-TEL" || top.getSelectedDevice().type == "WS-CBS3012-IBM-TEL" || top.getSelectedDevice().type == "WS-CBS3012-IBM-I-TEL")){
						scaleText="Fa0";
					}
					else if(i==10 && (top.getSelectedDevice().type == "WS-CBS3012-IBM-I-BCS" || top.getSelectedDevice().type == "WS-CBS3012-IBM-BCS")){
						scaleText="Fa0";
						}
					else if(i==9 && (deviceType=="WS-CBS3110X-S-TEL" ||deviceType=="WS-CBS3110X-S-I-TEL")){
						scaleText="Fa0";
					}
					if((deviceType=="WS-CBS3120X-S" || deviceType=="WS-CBS3125X-S")&& this.restartXAfter==20){
						if(i==24)
						 scaleText=26;
						if(i==25) 
						 scaleText="Fa0";
					}
					else if((deviceType=="WS-CBS3120X-S" || deviceType=="WS-CBS3125X-S") && this.restartXAfter==18){
						if(count==26){
						     if(i==24)
							    scaleText=26;
						     else if(i==25)	 
							    scaleText="Fa0";
						}
						else if(count==25)	{
							if(i==22)
							   scaleText=25;
						    else if(i==23)
							   scaleText=26;
						    else if(i==24)	 
							   scaleText="Fa0";
						} 
					}	
				}
				if(isCounterReset){
					if(this.isPixar || this.isDelphinium){ 	
						if((deviceType.indexOf("WS-C3560X") != -1 || deviceType.indexOf("WS-C3750X") != -1) && ( this.restartXAfter == 48)) {
								scaleText=this.xAxisNum[j++];
								j++;
							}
						else
							scaleText=this.xAxisNum[j++];
					}
				}
				if(deviceType.indexOf("WS-C3560E-12D") != -1){
					scaleText=RexScaleTextArray[i];	
				}
				
				// to compensate for spacing column
				if(i == 0) {
					xAxisNumbers.append("<td style='width:" + this.spacing + "px;border-left2:1px solid black;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE: 10px;' valign='bottom'>");
					xAxisNumbers.append("<div style='width:" + this.spacing + "px;height:10px;'><!-- --></div>");
					xAxisNumbers.append("</td>");
				}
				xAxisNumbers.append("<td style='height:10px;width:" + ((this.xlineWidth*this.skipX) + (this.spacing*this.skipX)) + "px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE: 10px;padding:0px;' colspan='" + (this.skipX*2) + "' align='right'>");
				xAxisNumbers.append("<div style='width:100%' align='right'>");
				xAxisNumbers.append("<table cellspacing='0' cellpadding='0' width='100%'>");
				xAxisNumbers.append("<tr>");
				var scaleTextLength = (""+scaleText).length;
				var cellWidth1 = (this.xlineWidth * (this.skipX-1)) + (this.spacing * (this.skipX-1));
				// 5 is used because the width occupied a single digit is approximately 5px
				var cellWidth2 = scaleTextLength * 5;
				var cellWidth3 = (this.xlineWidth * this.skipX) + (this.spacing * this.skipX) - (cellWidth1 + cellWidth2);
				xAxisNumbers.append("<td style='height:10px;width:" + cellWidth1 + "px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE: 10px;padding:0px;' align='right'>");
				xAxisNumbers.append("<div style='width:100%;'><!----></div>");
				xAxisNumbers.append("</td>");
				if(deviceType.indexOf("WS-C3560E-12D") != -1){
					xAxisNumbers.append("<td style='height:10px;width:" + cellWidth2 + "px;FONT-FAMILY: Helvetica;FONT-SIZE: 9px;padding:0px;' align='right'>");
				}else{
					xAxisNumbers.append("<td style='height:10px;width:" + cellWidth2 + "px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE: 10px;padding:0px;' align='right'>");
				}
				
				xAxisNumbers.append("<div style='width:100%;'>" + scaleText + "</div>");
				xAxisNumbers.append("</td>");
				if(cellWidth3 > 0) {
					xAxisNumbers.append("<td style='height:10px;width:" + cellWidth3 + "px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE: 10px;padding:0px;' align='right'>");
					xAxisNumbers.append("<div style='width:100%;'><!----></div>");
					xAxisNumbers.append("</td>");
				}
				xAxisNumbers.append("</tr>");
				xAxisNumbers.append("</table>");
				xAxisNumbers.append("</div>");
				xAxisNumbers.append("</td>");
			}
			xAxisCounter++;
			portNames[i]=xAxisCounter;
			
			
			if(this.isFa0){
				if(scaleText=="Fa0")
					portNames[i]="Fa0";
			}
			if(isCounterReset){
				if(this.isPixar ){
					if(this.scaleTextAsPortName){ 	
					 	portNames[i]=scaleText;
					 if(deviceType.indexOf("WS-C3560E-12SD") != -1 && interfaceArray[i].indexOf("Te")!=-1 ){
							portNames[i]=interfaceArray[i];
						}
					}
					else
					portNames[i]=this.xAxisNum[k++];
				}
				else if(this.isDelphinium){
					if(this.scaleTextAsPortName) 	
					 	{
							 var temp=this.xAxisNum[k++];
							 if(temp==2)
							   portNames[i]=x2Portname[0];
							 else  
							 portNames[i]=temp;
						}
					else{
						 var temp=this.xAxisNum[k++];
						 if(temp==1)
						      portNames[i]=x2Portname[0];
						 else if(temp==2)	
						 	   portNames[i]=x2Portname[1];	
						 else 	 
						     portNames[i]=temp;
						}
				}
			}
			if(this.isXmen2){
				portNames[i]=this.intArray[i];
			}
		}
			if(deviceType.indexOf("WS-C3560E-12D") != -1){
					portNames[i]=RexToolTipPortNameArray[i];
				}
		if((deviceType=="WS-CBS3110X-S-TEL" || deviceType=="WS-CBS3110X-S-I-TEL") && i==8 && this.restartXAfter==8 ){
			portNames[i]=interfaceArray[i];
		}
		else if((deviceType=="WS-CBS3110X-S" || deviceType=="WS-CBS3110X-S-HT-TEL" || deviceType=="WS-CBS3110X-S-I" || deviceType=="WS-CBS3110X-S-I-HT-TEL") && i==14 && this.restartXAfter==14  ){
			portNames[i]=interfaceArray[i];
		}
		else if( (deviceType=="WS-CBS3120X-S" || deviceType=="WS-CBS3125X-S") && this.restartXAfter==20 && i==20) {
			portNames[i]=x2Portname[0];
		}
		else if(( deviceType=="WS-CBS3120X-S"  || deviceType=="WS-CBS3125X-S")  && this.restartXAfter==18) {
			if(count==26 && i==18)
			  portNames[i]=x2Portname[0];
			else if(count==25 ){
			  if(i==18)  
			  portNames[i]=x2Portname[0];
			  if(i==19)
			   portNames[i]=x2Portname[1];
			   }
		}
		graphStr.append("<td style='width:1px;border-bottom:1px solid black;' valign='bottom'>");
		graphStr.append("<table height='100%' width='100%' cellspacing='0' cellpadding='0'>");
		graphStr.append("<tr>");
		var space=" ";
		if(this.portUtilTooltip){
			var titleValue=re_dshBrd_TltpPort +space+ portNames[i] +":" + space + this.receiveText + space +this.utilText + space + space + this.coordinates[i] + "%"
			graphStr.append("<td valign='bottom' title=' "+ titleValue + "'>");
		}else if(this.isXmen2){
		 if(this.portUtilTooltip){
		 	graphStr.append("<td valign='bottom' title=' " + portNames[i]+space+this.coordinates[i] + "% '>");
		 }
		}else{
			graphStr.append("<td valign='bottom' title=' " + this.coordinates[i] + "% '>");
		}
		graphStr.append("<div style='width:" + this.lineWidth + "px;height:" + this.coordinates[i]/this.scale + "px;background:" + this.lineColor + ";'><!----></div>");
		graphStr.append("</td>");
		if(this.secCoordinates.length > 0){
			if(this.portUtilTooltip){
				var secTitleValue=re_dshBrd_TltpPort +space+ portNames[i] +":" + space + this.transmitText + space +this.utilText + space + space + this.secCoordinates[i] + "%"
				graphStr.append("<td valign='bottom' title=' " + secTitleValue + " '>");
			}else{
				graphStr.append("<td valign='bottom' title=' " + this.secCoordinates[i] + "% '>");
			}
			graphStr.append("<div style='width:" + this.lineWidth + "px;height:" + this.secCoordinates[i]/this.scale + "px;background:" + this.secLineColor + ";'><!----></div>");
			graphStr.append("</td>");
		}
		graphStr.append( "</tr>");
		graphStr.append("</table>");
		graphStr.append("</td>");
	}
		//additional cell for the last number in x axis
		graphStr.append("<td style='width:2px;border-bottom:1px solid black;' valign='bottom'><div style='height:"+maxValue+"px;width:"+this.spacing+"px;"+maxValueStyle+"'><!----></div></td>");
		graphStr.append("</tr>");	//end of graph
		//start of x axis numbers
		graphStr.append("<tr>");
		//cell to display zero common to both axes
		graphStr.append("<td rowspan='2' valign='top' align='right' style='FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;'>0&nbsp;</td>");
		//x axis vertical lines
		graphStr.append(xAxisScale.toString());
		//additional cell for the last number in x axis
		graphStr.append("<td style='width:" + this.spacing + "px;' valign='bottom'><!-- --></td>");
		graphStr.append("</tr>");
		graphStr.append("<tr>");
		graphStr.append(xAxisNumbers.toString());
		//additional cell for the last number in x axis
		graphStr.append("<td style='width:" + this.spacing + "px;' valign='bottom'><!-- --></td>");
		graphStr.append("</tr>");
		graphStr.append("</table>"); //end of graph table
		graphStr.append("</td>");
		graphStr.append("</tr>");
		graphStr.append("<tr>");
		graphStr.append("<td align='center' valign='middle' style='FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;'></td>");
		graphStr.append("<td></td>");
		graphStr.append("<td  align='center' valign='middle' style='FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;'>");
		graphStr.append(this.xText);
		graphStr.append("</td>");
		if(this.isXmen2){
		  if(this.totalPorts <=10)
		  	graphStr.append("<td  width='45%'></td>"); 
		}else if(this.totalPorts <=10)
			graphStr.append("<td  width='25%'></td>"); //15%
		else if(this.totalPorts >10 && this.totalPorts <=20)
			graphStr.append("<td  width='25%'>");
		graphStr.append("</tr>");
		graphStr.append("</table>");
		graphStr.append("<table width=100% cellpadding='3' cellspacing='0'>");
			if(this.drawLegend){
				graphStr.append("<tr width='100%'>");
				graphStr.append("<td width='100%' style='padding-left:2px'; class='graphcontent' align=left NOWRAP>" + top.resourceFrame.re_frmWrk_GraphLegend + ": ");
				for(var i = 0; i < this.legends.length; i++) {
					if(!this.legends[i]) continue;
					graphStr.append("<span style='width:10px;height:12px;border:1px solid black;background:"+this.legends[i]+";' >&nbsp;&nbsp;&nbsp;</span>&nbsp;"+this.legends[++i]+"&nbsp;");
			}
		 graphStr.append("</td>");
 		 graphStr.append("</tr>");
	 }
	 graphStr.append("</table>");
	 return graphStr.toString();
}

function generateCellText(_width, _height, _color, _bgColor, _border) {
	var cellText = new StringBuffer();
	cellText.append("<div style='width:" + _width + "px;height:" + _height + "px;");
	if(_border) 
		cellText.append("border-top:1px solid " + _color + ";");
	cellText.append("background:" + _bgColor + ";'><!----></div>");
	return cellText;
}

function generateYAxisText() {
	var str = new StringBuffer();
	str.append("<table cellpadding='0' cellspacing='0' height='100px' border='0' style='border:none'>");
	for(var i=0; i<5; i++) {
		str.append("<tr>");
		str.append("<td style='height:20px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;padding:0px;' align='right'>" + ((100) - (i*20)) + "&nbsp;</td>");
		str.append("<td style='height:20px;padding:0px;' align='center'>");
		str.append("<div style='height:1px;width:7px;background:black;'><!----></div>");
		str.append("</td>");
		str.append("</tr>");
	}
	str.append("<tr>");
	str.append("<td style='height:10px;FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif;FONT-SIZE:10px;padding:0px;' align='right'><!----></td>");
	str.append("<td style='height:10px;padding:0px;border-bottom:1px solid black;' align='center'>");
	str.append("<div style='height:1px;width:7px;'><!----></div>");
	str.append("</tr>"); 
	str.append("</table>");
	return str.toString();
}

