/*
 *------------------------------------------------------------------
 * fpv.js
 *
 * Copyright (c) 2005-2008 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */
function device() {
	this.name = "Switch";
	this.type = "";
	this.noofports = 0;
	this.x=0;
	this.y=0;
	this.modes = new Array();
	this.modeAliases = new Array();
	this.ports = new Array();
	this.labels = new Array();
	this.portLabels = new Array();
	this.sysleds = new Array();
	this.portLeds = new Array();
	this.portDescrs = new Array();
	this.upTime = "";
	this.ipAddress = "";
	this.macAddress = "";
	this.swVersion = "";
	this.serialNo = "";
	this.hardLeds = new Array();
	this.setMode = _setMode;
	this.refresh = _refreshDevice;
	this.draw = _drawDevice;
	this.addPort = _addPortToDevice;
	this.addLabel = _addLabelToDevice;
	this.addPortLabel = _addPortLabelToDevice;
	this.expander1 = "";
	this.expander2 = "";
	this.brand = "";
	this.FaultLed="";
}

function _setMode(mode, frame) {
	if(frame == null) frame = top.topFrame.document;
	var x;
	for(x in this.modes) {
		var y = this.modes[x];		
		if(this.sysleds[y]) {
			if(y == mode) {
				this.sysleds[y].color = "GREEN";
			} else {
				if(this.type.indexOf("WS-CBS3110")!=-1)
					this.sysleds[y].color = this.FaultLed;
				else	
				this.sysleds[y].color = "BLACK";
			}
		}
	}
	for (i =0; i < this.ports.length; i++) {
		this.ports[i].color = this.hardLed[mode][i];
	}
	this.refresh(frame);
}

function _addPortToDevice(port) {
	port.device = this;
	this.ports[this.ports.length] = port;
}

function _addLabelToDevice(label) {
	label.device = this;
	this.labels[this.labels.length] = label;
}

function _addPortLabelToDevice(portlabel) {
	portlabel.device = this;
	this.portLabels[this.portLabels.length] = portlabel;
}

function _refreshDevice(frame) {
	for (var i =0; i < this.ports.length; i++) {
		this.ports[i].refresh(frame);
	}
	var sysled;
	for (sysled in this.sysleds) {
		this.sysleds[sysled].refresh(frame);
	}	
	for (var i=0; i < this.labels.length; i++) {
		this.labels[i].refresh(frame);
	}

}

function _drawDevice() {
	var str = new StringBuffer();
	var startpos =0;
	str.append("<img id='"+ this.id +"' style='position:absolute; left:" + this.x +"px; top:" + this.y + "px; z-index:300'");
	str.append(" src='" + this.image + "' name='" + this.name +"' border='0'>");
	if (this.expander1 != "" ){
		startpos = this.x+200;	
		str.append("<img id='expand1' style='position:absolute; left:" + startpos +"px; top:" + this.y + "px; z-index:300'");
		str.append(" src='" + this.expander1 + "' name='expand1' border='0'>");
	}
	if (this.expander2 != "" ){
		startpos = this.x+300;	
		str.append("<img id='expand2' style='position:absolute; left:" + startpos +"px; top:" + this.y + "px; z-index:300'");
		str.append(" src='" + this.expander2 + "' name='expand2' border='0'>");
	}
	return str;
}

function modebtn(modeImage) {
	this.name = "";
	this.x = 0;
	this.y = 0;
	this.id = "";
	this.device = "";
	this.index = 0;
	this.image = modeImage;
	this.draw = _drawModeBtn;
}

function _drawModeBtn() {
	var str = new StringBuffer();
	str.append("<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;"); 
	str.append(" cursor: pointer; cursor: hand; z-index:400' src=" + this.image + " name='" + this.id +"' border='0' onClick='updateDisplayMode();'");
	if(this.height)
		str.append(" width='" + this.width + "' height='" + this.height + "'");
	str.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x + 1) +";'");
	str.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x) + ";'");
	str.append(" title='"+top.topFrame.re_fpv_Tltp_different_mode+"'>");
	return str;
}

function led(ledImages) {
	this.name = "";
	this.x = 0;
	this.y = 0;
	this.id = "";
	this.color = "BLACK";
	this.descr = "";
	this.device = "";
	this.width = 7;
	this.height = 3;
	this.tooltip = "";
	this.images = (ledImages==null)?preloadImage("/images/led_gray.gif"):ledImages;
	this.draw = _drawLed;
	this.refresh = _refreshPortandLED;
	this.showPopup = false;
}

function _drawLed() {
	var str = new StringBuffer();
	var imag = this.images.src;
	str.append("<div id='"+ this.id +"_div_id' style=' position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
	str.append("<img id='"+ this.id +"' src='"+imag+"' style='position:relative; z-index:400'");
	str.append(" width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0'");
	if(this.showPopup) {
		str.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showLedTooltip(&quot;" + this.tooltip + "&quot;);'");
		str.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(1000);'");
	}
	str.append(">");
	str.append("</div>");
	return str;
}

function unknownDevice() {
	var dev = new device();
	dev.draw = _drawUnknownDevice;
	return dev;
}

function _drawUnknownDevice() {
	var str = '<table align="center" bgcolor="#DADADA" width="100%" height="100%"><tr><td height="80" align="center" valign="middle" class="fpvcontentbold">Unsupported Device</td></tr></table>';
	return str;
}

function label(x, y, width, height, text) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
	this.text = "";
	if(text != null) 
		this.text = text;
	this.id = "";
	this.fontfamily = "Verdana, Arial, Helvetica, sans-serif";
	this.fontsize = "8pt";
	this.color = "#000000";
	this.device = null;
	this.draw = _drawLabel;
	this.refresh = _refreshLabel;
}

function _drawLabel() {
	var str = "<div id='"+ this.id +"' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;";
	str += " width:" + this.width + "px; height=:" + this.height + "px; overflow: hidden; vertical-align: middle; font-family: " + this.fontfamily + ";";
	str += " font-size: " + this.fontsize + "; color: " + this.color + "; z-index:800;'>" + this.text + "</div>";
	return str;
}

function _refreshLabel(frame) {
	if(top.topFrame && top.topFrame.set_layercontent) {
		top.topFrame.set_layercontent(this.id, this.text);
	} else {
		frame.getElementById(this.id).innerHTML = this.text;
	}
}

function portLabel(x, y, width, height, image) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
	this.image = image;
	this.id = "";
	this.device = null;
	this.draw = _drawPortLabel;
}

function _drawSmartPort() {
	var str = new StringBuffer();
//	alert( this.spRole);
	var imageObject = getSmartPortImage( this.spRole );
	var imag = imageObject.src;
	var smartportleft = this.device.x + this.x;
	var smartporttop = this.device.y + this.y;
	if (this.sfpPort != null ){
		if ( this.width > 25)
			smartportleft += ( this.width -19 ) / 2 ;
		else ( this.height > 25)
			smartporttop += ( this.height -16 ) / 2 ;		
	}
	var smartportwidth = 19;
	var smartportheight = 16;
	if ( !this.smartportRedraw){
		str.append("<div id='"+ this.id +"_div_id_smartport' style=' position:absolute; left:" + (smartportleft) +"px; top:" + (smartporttop) + "px; width:" + smartportwidth + "px; height: " + smartportheight + "px; z-index:1500'>");
	}
	str.append("<img id='"+ this.id +"_image_smartport' src='"+imag+"' style='position:relative; z-index:1600;'");
	str.append(" width='" + smartportwidth + "' height='" + smartportheight + "' name='" + this.id +"_image_smartport' border='0' ");
	str.append(" onMouseOver='document.images[&quot;" + this.id + "_image_smartport&quot;].border=1; showTooltip(" + this.index + ");'");
	str.append(" onMouseOut='document.images[&quot;" + this.id + "_image_smartport&quot;].border=0; resetPort(); hideLayerWrapper(1700);'>");
	if ( !this.smartportRedraw){
		str.append("</div>");
	}
	return str;
}

function _drawPortLabel() {
	var str = new StringBuffer();
	str.append("<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;"); 
	str.append(" z-index:400' src=" + this.image + " name='" + this.id +"' border='0'");
	str.append(" width='" + this.width + "' height='" + this.height + "'>");
	return str;

}

function port(portImages) {
	this.name = "";
	this.x = 0;
	this.y = 0;
	this.id = "";
	this.index = 0;
	this.color = "BLACK";
	this.descr = "";
	this.device = "";
	this.images = portImages;
	this.width = 19;
	this.height = 15;
	this.draw = _drawPort;
	this.refresh = _refreshPortandLED;
	this.pluggable = false;
	this.redraw = false;
        this.smartportDraw = _drawSmartPort;
        this.smartportRedraw = false;
}

function _refreshPortandLED(frame) {
	var col = this.color;
	var divObject = frame.getElementById(this.id+"_div_id");	
	if (col.indexOf("BLINK")!=-1 || col.indexOf("ALT_")!=-1 ){
		var bgimage = getBackgroundBlinkImage(col, this.images.src);
		divObject.style.backgroundImage=bgimage;
		divObject.style.backgroundRepeat="repeat";
	}
	else{
		divObject.style.backgroundImage="";
		var colcode=getHtmlColorCode(col, this.images.src);
		divObject.style.backgroundColor=colcode;
	}
}

function _drawPort() {
	var str = new StringBuffer();
	var imag = this.images.src;
	if ( !this.redraw){
		str.append("<div id='"+ this.id +"_div_id' style=' position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
	}
	str.append("<img id='"+ this.id +"' src='"+imag+"' style='position:relative; z-index:400;'");
	str.append(" width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' ");
	str.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");'");
	str.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>");
	if ( !this.redraw){
		str.append("</div>");
	}
	return str;
}

function hbport(portImages, cType) {
	var p = new port(portImages);
	p.width = 11;
	p.height = 11;
	if(cType != null) {
		p.connType = cType;
	}
	return p;
}

function rj45port(portImages) {
	var p = new port(portImages);
	return p;
}

function rj45portInv(portImages) {
	var p = new port(portImages);
	return p;
}

function internalport(portImages) {
   var p = new port(portImages);
   return p;
}
function stackPort(portImages) {
   var p = new port(portImages);
   p.width=20;
   p.height=10;
   return p;
}
function rj45portSide(portImages) {
   var p = new port(portImages);
   p.width = 15;
   p.height = 19;
   return p;
}

function rj45portInvSide(portImages) {
   var p = new port(portImages);
   p.width = 15;
   p.height = 19;
   return p;
}

function fxport(portImages) {
	var p = new port(portImages);
	return p;
}

function fxportside(portImages) {
	var p = new port(portImages);
	p.width = 15;
	p.height = 19;
	return p;
}

function fxportInvside(portImages) {
	var p = new port(portImages);
	p.width = 15;
	p.height = 19;
	return p;
}

function GBICport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseCX") != -1) {
		p.images = preloadImage("/images/gbic_base.gif");
		p.draw = _drawRazorPort;
		p.refresh = _refreshRazorPort;
		p.leftImg = preloadImage("/images/gbic_rzr_gray.gif");		
		p.rightImg = p.leftImg;
		p.connWidth = 14;
		p.connHeight = 9;
	} else if (cType.indexOf ("1000BaseTX") != -1) {
		p.images = preloadImage("/images/gbic_t_gray.gif");
	} else if (cType.indexOf ("1000BaseSX") != -1 ||
		   cType.indexOf ("1000BaseLX") != -1 ||
		   cType.indexOf ("1000BaseZX") != -1 ||
		   cType.indexOf ("DWDM") != -1) {
		p.images = preloadImage("/images/gbic_lx_gray.gif");
	} else if (cType.toUpperCase().indexOf("10GBASE") != -1) {
		p.images = preloadImage("/images/10gig_gray.gif");
	} else if (cType.indexOf ("CWDM") != -1) {
		p.images = preloadImage("/images/gbic_lx_gray.gif");
		p.draw = _drawCWDMPort;
		p.cwdmImages = preloadImage("/images/cwdm_led_big_gray.gif");
		p.cwdmleftx = 8;
		p.cwdmlefty = 6;
		p.cwdmrightx = 24;
		p.cwdmrighty = 6;
		p.cwdmwidth = 5;
		p.cwdmheight = 5;		
	} else {
		p.images = preloadImage("/images/gbic_empty.gif");
	}
	p.width = 36;
	p.height = 18;
	p.connType = cType;
	p.pluggable = true;
	return p;
}

function _refreshRazorPort(frame) {
	var col = this.color;
	var divLeftObject = frame.getElementById(this.id+"_div_id_left");	
	var divRightObject = frame.getElementById(this.id+"_div_id_right");	
	if (col.indexOf("BLINK")!=-1 || col.indexOf("ALT_")!=-1 ){
		var bgimage = getBackgroundBlinkImage(col);
		divLeftObject.style.backgroundImage=bgimage;
		divLeftObject.style.backgroundRepeat="repeat";
		divRightObject.style.backgroundImage=bgimage;
		divRightObject.style.backgroundRepeat="repeat";
	}
	else{
		divLeftObject.style.backgroundImage="";
		divRightObject.style.backgroundImage="";
		var colcode=getHtmlColorCode(col);
		if (col == "BLACK") colcode ="#949494";
		divLeftObject.style.backgroundColor=colcode;
		divRightObject.style.backgroundColor=colcode;
	}
}

function _drawRazorPort() {
	var baseimg = this.images.src;
	var moduleimage = this.leftImg.src;
	var str = new StringBuffer();
	var mouseOverStr = new StringBuffer();
	mouseOverStr.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; document.getElementById(&quot;"+this.id+"_div_id_left&quot;).style.left=4; document.getElementById(&quot;"+this.id+"_div_id_left&quot;).style.top=6;document.getElementById(&quot;"+this.id+"_div_id_right&quot;).style.left=21; document.getElementById(&quot;"+this.id+"_div_id_right&quot;).style.top=6;showTooltip(" + this.index + ");'");

	mouseOverStr.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; document.getElementById(&quot;"+this.id+"_div_id_left&quot;).style.left=3; document.getElementById(&quot;"+this.id+"_div_id_left&quot;).style.top=5;document.getElementById(&quot;"+this.id+"_div_id_right&quot;).style.left=20; document.getElementById(&quot;"+this.id+"_div_id_right&quot;).style.top=5;resetPort(); hideLayerWrapper(2000);'>");
	if ( !this.redraw){
		str.append("<div id='"+ this.id +"_div_id' style=' position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
	}
	str.append("<img id='"+ this.id +"' src='"+baseimg+"' style='position:relative; z-index:350'");
	str.append(" width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' ");
	str.append(mouseOverStr);
	str.append("<div id='"+ this.id +"_div_id_left' style='position:absolute; left:3px; top:5px; width:" + this.connWidth + "px; height: " + this.connHeight + "px; z-index:400'>");
	str.append("<img id='"+ this.id +"_left'  src='"+moduleimage+"' style='position:relative; z-index:450'");
	str.append(" width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_left' border='0' ");
	str.append(mouseOverStr);
	str.append("</div>");
	str.append("<div id='"+ this.id +"_div_id_right' style='position:absolute; left:20px; top:5px; width:" + this.connWidth + "px; height: " + this.connHeight + "px; z-index:400'>");
	str.append("<img id='"+ this.id +"_right'  src='"+moduleimage+"' style='position:relative; z-index:450'");
	str.append(" width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_right' border='0' ");
	str.append(mouseOverStr);
	str.append("</div>");
	if ( !this.redraw){
		str.append("</div>");
	}
	return str;
}

function SFPCommonport(cType, images, position) {
	var p = new port(images)
	if (cType.indexOf ("1000BaseSX") != -1 ||
	    cType.indexOf ("1000BaseLX") != -1 ||
	    cType.indexOf ("1000BaseZX") != -1 ||
	    cType.indexOf ("1000BaseCX") != -1 ||
	    cType.indexOf ("1000BaseBX") != -1 ||
	    cType.indexOf ("100BaseBX-10D") != -1 || 
	    cType.indexOf ("100BaseBX-10U") != -1 ||
	    cType.indexOf ("100BaseLX") != -1 || 
	    cType.indexOf ("100BaseFX SFP") != -1 || 
	    cType.indexOf ("100BaseFX-FE") != -1 ||
		cType.indexOf ("100BaseFX") != -1) {
			if ( position == "side" ) p.images = preloadImage("/images/sfp_side_gray.gif");
			else if ( position == "sideinverse" ) p.images = preloadImage("/images/sfp_sideinverse_gray.gif");
			else p.images = preloadImage("/images/sfp_gray.gif");
	} else if (cType.indexOf ("CWDM") != -1) {
		p.draw = _drawCWDMPort;
		p.cwdmImages = preloadImage("/images/cwdm_led_gray.gif");
		if ( position == "side" || position == "sideinverse"){ 
			if ( position == "side" ) 
				p.images = preloadImage("/images/sfp_side_gray.gif");
			else if (position == "sideinverse ")
				p.images = preloadImage("/images/sfp_sideinverse_gray.gif");
			p.cwdmleftx = 6;
			p.cwdmlefty = 4;
			p.cwdmrightx = 6;
			p.cwdmrighty = 12;
			p.cwdmwidth = 5;
			p.cwdmheight = 5;
			p.cwdmwavelength = cType;		
		}else{
			p.images = preloadImage("/images/sfp_gray.gif");
			p.cwdmleftx = 4;
			p.cwdmlefty = 6;
			p.cwdmrightx = 12;
			p.cwdmrighty = 6;
			p.cwdmwidth = 5;
			p.cwdmheight = 5;		
			p.cwdmwavelength = cType;
		 }
	} else if (cType.indexOf ("1000BaseTX") != -1) {
		if ( position == "side" ) p.images = preloadImage("/images/sfp_side_tx_gray.gif");
		else if (position == "sideinverse") p.images = preloadImage("/images/sfp_sideinverse_tx_gray.gif");
		else p.images = preloadImage("/images/sfp_tx_gray.gif");
	} else {
		if ( position == "side" ) p.images = preloadImage("/images/sfp_side_empty_gray.gif");
		else if ( position == "sideinverse" ) p.images = preloadImage("/images/sfp_sideinverse_empty_gray.gif");
		else p.images = preloadImage("/images/sfp_empty_gray.gif");
	}
	return p;
}

function SFPport(cType, images) {
	var p = SFPCommonport(cType, images, "");
	p.width = 21;
	p.height = 16;
	p.connType = cType;
	p.pluggable = true;
	return p;
}


function SFPsideport(cType, images) {
	var p = SFPCommonport(cType, images, "side");
	p.width = 16;
	p.height = 21;
	p.connType = cType;
	p.pluggable = true;
	return p;
}

function SFPsideinverseport(cType, images) {
	var p = SFPCommonport(cType, images, "sideinverse");
	p.width = 16;
	p.height = 21;
	p.connType = cType;
	p.pluggable = true;
	return p;
}

function tenGbSFPCommonport(cType,images,position){
	var p = new port(images);
	if (cType.indexOf("10GBase-ER") != -1 || 
	    cType.indexOf("10GBase-LR") != -1 || 
	    cType.indexOf("10GBase-SR") != -1 || 
	    cType.indexOf("10GBase-LX4") != -1 ) {
		if ( position == "Vertical" ) p.images = preloadImage("/images/10gb_sfp_type1_Vertical_gray.gif");
		else p.images = preloadImage("/images/10gb_sfp_type1_gray.gif"); 
	} 
	else if (cType.indexOf("10GBase-CX4") != -1) {
		if ( position == "Vertical" )p.images = preloadImage("/images/10gb_sfp_type2_Vertical_gray.gif");
		else p.images = preloadImage("/images/10gb_sfp_type2_gray.gif");
	}
	else {
		if ( position == "Vertical" )p.images = preloadImage("/images/10gb_sfp_empty_Vertical_gray.gif");
		else p.images = preloadImage("/images/10gb_sfp_empty_gray.gif");
		
	}
	return p;
}
function tenGbSFPVerticalport(cType, images){
	var p = new tenGbSFPCommonport(cType,images,"Vertical");
	p.width = 16;
	p.height = 43;
	p.connType = cType;
	return p;
}
function tenGbSFPport(cType, images){
	var p = new tenGbSFPCommonport(cType,images,"Normal");
	p.width = 43;
	p.height = 16;
	p.connType = cType;
	return p;
}

function _drawCWDMPort() {
	var backimage = this.images.src;
	var cwdmimage = this.cwdmImages.src;
	var type = this.connType;
	var colcode;
	if(type.indexOf("SFP") != -1) {
		type = type.substring(0,type.indexOf("SFP")).replace(/^\s+/,'').replace(/\s+$/,'');
	}
	colcode=getHtmlColorCode(type);
	var mouseOvr =  new StringBuffer();
	var str =  new StringBuffer();
	mouseOvr.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.left="+( this.cwdmleftx+1)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.top="+(this.cwdmlefty + 1) +";document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.left="+(this.cwdmrightx+1)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.top="+(this.cwdmrighty + 1) +";showTooltip(" + this.index + ");'");
	mouseOvr.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0;document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.left="+(this.cwdmleftx)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.top="+( this.cwdmlefty) +"; document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.left="+( this.cwdmrightx)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.top="+( this.cwdmrighty) +";resetPort(); hideLayerWrapper(2000);'>");
	if ( !this.redraw){
		str.append("<div id='"+ this.id +"_div_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
	}
	str.append("<img id='"+ this.id +"' src='"+backimage+"' style='position:relative; z-index:400'");
	str.append(" width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' ");
	str.append(mouseOvr);
	str.append("<div id='"+ this.id +"_div_id_cwdm' style='background-color:"+colcode+"; position:absolute; left:" + ( this.cwdmleftx ) +"px; top:" + (this.cwdmlefty) + "px; width:" + this.cwdmwidth + "px; height: " + this.cwdmheight + "px; z-index:500'>");
	str.append("<img id='"+ this.id +"_color' src='"+cwdmimage+"' style='position:relative; z-index:550'");
	str.append(" width='" + this.cwdmwidth + "' height='" + this.cwdmwidth + "' name='" + this.id +"_color' border='0' ");
	str.append(mouseOvr);
	str.append("</div>");
	str.append("<div id='"+ this.id +"_div_id_cwdm_right' style='background-color:"+colcode+"; position:absolute; left:" + (this.cwdmrightx ) +"px; top:" + (this.cwdmrighty) + "px; width:" + this.cwdmwidth + "px; height: " + this.cwdmheight + "px; z-index:500'>");
	str.append("<img id='"+ this.id +"_color_right' src='"+cwdmimage+"' style='position:relative; z-index:550'");
	str.append(" width='" + this.cwdmwidth + "' height='" + this.cwdmwidth + "' name='" + this.id +"_color_right' border='0' ");
	str.append(mouseOvr);
	str.append("</div>");
	if ( !this.redraw){
		str.append("</div>");
	}
	return str;
}

function rj45Compositeport(cType, portImages,rj45IsFirst, direction) {
	var p = new port(portImages);
	p.connType = cType;
	p.width = 21;
	p.height = 33;
	p.baseImage = preloadImage("/images/spacer.gif");
	if(cType.indexOf("-") != -1) {
		cType = cType.substring(0,cType.lastIndexOf("-"));
		p.connType = p.connType.substring(p.connType.lastIndexOf("-") + 1);
	} 
	else {
		if(cType.indexOf("unsupported") != -1) {
			cType = "Unsupported";
			p.connType = "10/100/1000BaseTX";
		}else if(cType.indexOf("unknown") != -1) {
			cType = "UnKnown";
			p.connType = "10/100/1000BaseTX";
		}else if(cType.indexOf("Not Present") != -1) {
			cType = "Empty";
			p.connType = "10/100/1000BaseTX";
		}else{
			cType = "Empty";
		}
	}
	if(rj45IsFirst)
		p.connType = p.connType + "-" + cType;
	else
		p.connType = cType + "-" + p.connType;
	if ( cType.indexOf("SFP") != -1 ) cType = cType.substring(0, cType.indexOf("SFP")).replace(/^\s+/,'').replace(/\s+$/,'');
	var sfpPort = new SFPport(cType,portImages);
	p.sfpPort = sfpPort;
	p.draw = _drawrj45CompositePort;
	p.refresh = _refreshrj45CompositePort;
	p.sfpx = 0; // default coordinates for 2950 LRE. other devices may override.
	p.sfpy = 0;
	p.rj45x = 1;
	p.rj45y = 17;
	p.rj45Width = 19;
	p.rj45Height = 15;
	p.sfpWidth = 21;
	p.sfpHeight = 16;
	if ( direction!= null && direction=="sideinverse" ){ 
		p.sfpPort = new SFPsideinverseport(cType,portImages);
		p.rj45Width = 15;
		p.rj45Height = 19;
		p.sfpWidth = 16;
		p.sfpHeight = 21;
	}
	p.pluggable = true;
	return p;
}

function _refreshrj45CompositePort(frame) {
	var rj45DivObject = frame.getElementById(this.id+"_div_id_rj45");	
	var sfpDivObject = frame.getElementById(this.id+"_div_id_sfp");	
	if(this.color.indexOf("-") != -1) {
		var colors = this.color.split("-");
		this.sfpColor = colors[0];
		this.rj45Color = colors[1];
	} 
	else {
		this.rj45Color = this.color;
		this.sfpColor = this.color;
	}
	if (this.rj45Color.indexOf("BLINK")!=-1 || this.rj45Color.indexOf("ALT_")!=-1 ){
		var bgimage = getBackgroundBlinkImage(this.rj45Color);
		rj45DivObject.style.backgroundImage=bgimage;
		rj45DivObject.style.backgroundRepeat="repeat";
	}
	else{
		rj45DivObject.style.backgroundImage="";
		var colcode=getHtmlColorCode(this.rj45Color);
		rj45DivObject.style.backgroundColor=colcode;
	}	
	if (this.sfpColor.indexOf("BLINK")!=-1 || this.sfpColor.indexOf("ALT_")!=-1 ){
		var bgimage = getBackgroundBlinkImage(this.sfpColor);
		sfpDivObject.style.backgroundImage=bgimage;
		sfpDivObject.style.backgroundRepeat="repeat";
	}
	else{
		sfpDivObject.style.backgroundImage="";
		var colcode=getHtmlColorCode(this.sfpColor);
		sfpDivObject.style.backgroundColor=colcode;
	}	
}

function _drawrj45CompositePort() {
	var baseImage = preloadImage("/images/spacer.gif").src;
	var rj45Image = this.images.src;
	var sfpImage = this.sfpPort.images.src;
	var mouseOverString =  new StringBuffer();
	var str =  new StringBuffer();
	if(this.sfpPort.cwdmImages){	
		mouseOverString.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.left="+(this.rj45x+1)+"; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.top="+(this.rj45y + 1) +";document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.left="+(this.sfpx+1)+"; document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.top="+(this.sfpy + 1) +";document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.left="+(this.sfpx + this.sfpPort.cwdmleftx +1)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.top="+(this.sfpy + this.sfpPort.cwdmlefty + 1) +";document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.left="+(this.sfpx + this.sfpPort.cwdmrightx+1)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.top="+(this.sfpy + this.sfpPort.cwdmrighty + 1) +";showTooltip(" + this.index + ");'");
		mouseOverString.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.left="+(this.rj45x)+"; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.top="+(this.rj45y ) +";document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.left="+(this.sfpx)+"; document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.top="+(this.sfpy) +";document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.left="+(this.sfpx + this.sfpPort.cwdmleftx)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm&quot;).style.top="+(this.sfpy + this.sfpPort.cwdmlefty) +";document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.left="+(this.sfpx + this.sfpPort.cwdmrightx)+"; document.getElementById(&quot;"+this.id+"_div_id_cwdm_right&quot;).style.top="+(this.sfpy + this.sfpPort.cwdmrighty) +";resetPort(); hideLayerWrapper(2000);'>");
	}
	else {
		mouseOverString.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.left="+(this.rj45x+1)+"; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.top="+(this.rj45y + 1) +";document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.left="+(this.sfpx+1)+"; document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.top="+(this.sfpy + 1) +";showTooltip(" + this.index + ");'");
		mouseOverString.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.left="+(this.rj45x)+"; document.getElementById(&quot;"+this.id+"_div_id_rj45&quot;).style.top="+(this.rj45y ) +";document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.left="+(this.sfpx)+"; document.getElementById(&quot;"+this.id+"_div_id_sfp&quot;).style.top="+(this.sfpy) +";resetPort(); hideLayerWrapper(2000);'>");
	}
	if ( !this.redraw){
		str.append("<div id='"+ this.id +"_div_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
	}
	str.append("<img id='"+ this.id +"' src = '"+baseImage+"' style='position:relative; z-index:400'");
	str.append(" width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' ");
	str.append(mouseOverString);
	str.append("<div id='"+ this.id +"_div_id_rj45' style='position:absolute; left:" + (this.rj45x) +"px; top:" + (this.rj45y) + "px; width:" + this.rj45Width + "px; height: " + this.rj45Height + "px; z-index:300'>");
	str.append("<img id='"+ this.id +"_rj45' src = '"+rj45Image+"' style='position:relative; z-index:500'");
	str.append(" width='" + this.rj45Width + "' height='" + this.rj45Height + "' name='" + this.id +"_rj45' border='0' ");
	str.append(mouseOverString);
	str.append("</div>");
	str.append("<div id='"+ this.id +"_div_id_sfp' style='position:absolute; left:" + (this.sfpx) +"px; top:" + (this.sfpy) + "px; width:" + this.sfpWidth + "px; height: " + this.sfpHeight + "px; z-index:300'>");
	str.append("<img id='"+ this.id +"_sfp' src = '"+sfpImage+"' style='position:relative;z-index:500'");
	str.append(" width='" + this.sfpWidth + "' height='" + this.sfpHeight + "' name='" + this.id +"_sfp' border='0' ");
	str.append(mouseOverString);
	str.append("</div>");
	if(this.sfpPort.cwdmImages) {
		var type = this.sfpPort.cwdmwavelength;
		var colcode;
		if(type.indexOf("SFP") != -1) {
			type = type.substring(0,type.indexOf("SFP")).replace(/^\s+/,'').replace(/\s+$/,'');
		}
		colcode=getHtmlColorCode(type);
		var cwdmimage = this.sfpPort.cwdmImages.src;
		str.append("<div id='"+ this.id +"_div_id_cwdm' style='background-color:"+colcode+"; position:absolute; left:" + (this.sfpx + this.sfpPort.cwdmleftx ) +"px; top:" + (this.sfpy + this.sfpPort.cwdmlefty) + "px; width:" + this.sfpPort.cwdmwidth + "px; height: " + this.sfpPort.cwdmheight + "px; z-index:500'>");
		str.append("<img id='"+ this.id +"_color' src='"+cwdmimage+"' style='position:relative; z-index:550'");
		str.append(" width='" + this.sfpPort.cwdmwidth + "' height='" + this.sfpPort.cwdmwidth + "' name='" + this.id +"_color' border='0' ");
		str.append(mouseOverString);
		str.append("</div>");
		str.append("<div id='"+ this.id +"_div_id_cwdm_right' style='background-color:"+colcode+"; position:absolute; left:" + (this.sfpx + this.sfpPort.cwdmrightx ) +"px; top:" + (this.sfpy + this.sfpPort.cwdmrighty) + "px; width:" + this.cwdmwidth + "px; height: " + this.sfpPort.cwdmheight + "px; z-index:500'>");
		str.append("<img id='"+ this.id +"_color_right' src='"+cwdmimage+"' style='position:relative; z-index:550'");
		str.append(" width='" + this.sfpPort.cwdmwidth + "' height='" + this.sfpPort.cwdmwidth + "' name='" + this.id +"_color_right' border='0' ");
		str.append(mouseOverString);
		str.append("</div>");
	}
	if ( !this.redraw){	
		str.append("</div>");
	}
	return str;
}

function tenGigport(cType, portImages) {
	var p = new port(portImages);
	if(cType.indexOf("10GBase-LR Xenpak") != -1) {
		p.baseImg = preloadImage("/images/10gig_base.gif");
		p.images = preloadImage("/images/10gig_gray.gif");
		p.draw = _draw10GigPort;
		p.baseWidth = 47;
		p.baseHeight = 26;
		p.connWidth = 31;
		p.connHeight = 14;
		p.width = 31;
		p.height = 14;
	} else {
		p.images = preloadImage("/images/10gig_empty.gif");
		p.width = 47;
		p.height = 26;
	}
	p.connType = cType;
	return p;
}

function _draw10GigPort() {
	var baseimg = this.baseImg.src;
	var connterimg = this.images.src;
	var mouseover =  new StringBuffer();
	var str =  new StringBuffer();
	mouseover.append(" onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");");
	mouseover.append("document.images[&quot;" + this.id + "_connector&quot;].style.top=1;document.images[&quot;" + this.id + "_connector&quot;].style.left=1;'");
	mouseover.append(" onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);");
	mouseover.append("document.images[&quot;" + this.id + "_connector&quot;].style.top=0;document.images[&quot;" + this.id + "_cnnector&quot;].style.left=0;'>");
	if ( !this.redraw){
		str.append("<div id='"+ this.id +"base_div_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:300'>");
		str.append("<img id='"+ this.id +"' src='"+baseimg+"' style='position:relative; z-index:400'");
		str.append(" width='" + this.baseWidth + "' height='" + this.baseHeight + "' name='" + this.id +"' border='0' ");
		str.append(mouseover);
		str.append("</div>");
		str.append("<div id='"+ this.id +"_div_id' style='position:absolute; left:" + (this.device.x + this.x  + 7) +"px; top:" + (this.device.y + this.y + 9) + "px; width:" + this.width + "px; height: " + this.height + "px; z-index:500'>");
	}
	str.append("<img id='"+ this.id +"_connector' src='"+connterimg+"' style='position:relative; z-index:600'");
	str.append(" width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_connector' border='0' ");
	str.append(mouseover);	
	if ( !this.redraw){
		str.append("</div>");
	}
	return str;
}

function ledImages() {
	return preloadImage("/images/led_gray.gif");
}

function hbportImages() {
	return preloadImage("/images/hb_gray.gif");
}

function rj45portImages() {
	return preloadImage("/images/gray.gif");
}

function rj45portInvImages() {
	return preloadImage("/images/inv_gray.gif");
}

function internalportImages(){
	return preloadImage("/images/internal_gray.gif");
}
function stackPortImages(){
	return preloadImage("/images/stack.gif");
}
function rj45portSideImages() {
	return preloadImage("/images/side_gray.gif");
}

function rj45portInvSideImages() {
	return preloadImage("/images/sideinverse_gray.gif");
}

function fxportImages() {
	return preloadImage("/images/fx_gray.gif");
}

function fxportSideImages() {
	return preloadImage("/images/fx_sidegray.gif");
}

function fxportInvSideImages() {
	return preloadImage("/images/fx_inverse_sidegray.gif");
}

function GBIC_EmptyImages() {
	return preloadImage("/images/gbic_empty.gif");
}

function GBIC_RazorImages() {
	return preloadImage("/images/gbic_base.gif");
}

function GBIC_RazorConnectorImages() {
	return preloadImage("/images/gbic_rzr_gray.gif");
}

function GBIC_TImages() {
	return preloadImage("/images/gbic_t_gray.gif");
}

function GBIC_FiberImages() {
	return preloadImage("/images/gbic_lx_gray.gif");
}

function GBIC_CWDMImages() {
	return GBIC_FiberImages();
}

function GBIC_DWDMImages() {
	return GBIC_FiberImages();
}

function SFP_TImages() {
	return preloadImage("/images/sfp_tx_gray.gif");
}

function SFP_side_TImages() {
	return preloadImage("/images/sfp_side_tx_gray.gif");
}

function SFP_SXImages() {
	return preloadImage("/images/sfp_gray.gif");
}

function SFP_side_SXImages() {
	return preloadImage("/images/sfp_side_gray.gif");
}

function SFP_LXImages() {
	return SFP_SXImages();
}

function SFP_ZXImages() {
	return SFP_SXImages();
}

function SFP_CXImages() {
        return SFP_SXImages();
}

function SFP_BXImages() {
        return SFP_SXImages();
}

function SFP_CWDMImages() {
	return SFP_SXImages();
}

function SFP_100FXImages() {
	return SFP_SXImages();
}

function SFP_side_LXImages() {
	return SFP_side_SXImages();
}

function SFP_side_ZXImages() {
	return SFP_side_SXImages();
}

function SFP_side_BXImages() {
        return SFP_side_SXImages();
}

function SFP_side_CWDMImages() {
	return SFP_side_SXImages();
}

function SFP_side_100FXImages() {
	return SFP_side_SXImages();
}

function tenGbSFP_EmptyImages() {
	return preloadImage("/images/10gb_sfp_empty_gray.gif");
}

function tenx2_type1Images() {
	return preloadImage("/images/10gb_sfp_type1_gray.gif");
}

function tenx2_type2Images() {
	return preloadImage("/images/10gb_sfp_type2_gray.gif");
}

function SFP_EmptyImages() {
	return preloadImage("/images/sfp_empty_gray.gif");
}

function SFP_side_EmptyImages() {
	return preloadImage("/images/sfp_side_empty_gray.gif");
}

function GBIC_10GImages() {
	return preloadImage("/images/10gig_gray.gif");
}

function GBIC_10GEmptyImages() {
	return preloadImage("/images/10gig_empty.gif");
}

function SFP_CWDMColorCodeImages() {
	return preloadImage("/images/cwdm_gray.gif");
}

function SFP_side_CWDMColorCodeImages() {
	return preloadImage("/images/cwdm_side_gray.gif");
}

function GBIC_CWDMColorCodeImages() {
	return preloadImage("/images/gbic_cwdm_gray.gif");
}

function getHtmlColorCode(color, src){
	var colcode="";
	switch (color){
		case "BLACK":
		case "CWDM-1470":
			colcode = "#CACACA";
			if (src != null && src.indexOf("/led_gray.gif") != -1 ) colcode = "#000000";
			break;
		case "GREEN":
		case "CWDM-1530":
			colcode = "#39FF31";
			break;
		case "AMBER":
			colcode = "#FFA221";
			break;
		case "CYAN":
			colcode = "#2FFFFF";
			break;
		case "BROWN":
		case "CWDM-1610":
			colcode = "#A08161";
			break;
		case "YELLOW":
		case "CWDM-1550":
			colcode = "#FFFF00";
			break;
		case "CWDM-1490"://violet
			colcode = "#8D1AFF";
			break;
		case "CWDM-1510"://blue
			colcode = "#0000FF";
			break;
		case "CWDM-1570"://orange
			colcode = "#FFA201";
			break;
		case "RED":
		case "CWDM-1590"://red
			colcode = "#FF0000";
			break;
		default:
			colcode = "#FFFFFF";
	}
	return colcode;
}

function getBackgroundBlinkImage(color, src){
	var bgimage="";
	switch (color){
		case "BLINKGREEN":
		case "ALT_GREEN_BLACK":
			bgimage = "blinkgreen1pix.gif";
			if (src != null && src.indexOf("/led_gray.gif") != -1 ) bgimage = "blackgreen1pix.gif";
			break;
		case "BLINKGREEN_AMBER":
		case "ALT_GREEN_AMBER":
			bgimage = "ambergreen1pix.gif";
			break;
		case "BLINKAMBER":
		case "ALT_AMBER_BLACK":
			bgimage = "blinkamber1pix.gif";
			if (src!= null && src.indexOf("/led_gray.gif") != -1 ) bgimage = "blackamber1pix.gif";
			break;
		case "BLINK_2_GREEN":
			bgimage = "blinkgreenfast1pix.gif";
			break;
		case "BLINKGREEN_RED":
		case "ALT_GREEN_RED":
			bgimage = "redgreen1pix.gif";
			break;
		case "BLINKRED":
		case "ALT_RED_BLACK":
			bgimage = "blinkred1pix.gif";
			break;
		default:
			bgimage = "blinkgreen1pix.gif";
	}
	var img = preloadImage(/images/+bgimage);
	return "url("+img.src+")";
}

function getSmartPortImage(role){
	var image = "";
	switch (role){
		case "Desktop":
		case "IE Desktop":
		case "Desktop for Automation":
			image = "/images/spDesktop.gif";
			break;
		case "IP Phone+Desktop":
        case "IE IP Phone":
		case "Phone for Automation":
			image = "/images/spIPPhone.gif";
			break;
		case "Switch":
		case "IE Switch":
		case "Switch for Automation":		
			image = "/images/spSwitch.gif";
			break;
		case  "Router":
		case "IE Router":
		case "Router for Automation":
			image = "/images/spRouter.gif";
			break;
		case "Wireless":
		case "Access Point":
		case "Wireless Access Point":
		case "IE Wireless":
		case "Wireless for Automation":
			image = "/images/spAccess.gif";
			break;
		case "Server":
			image = "/images/spServer.gif";
			break;
		case "Printer":
			image = "/images/spPrinter.gif";
			break;
		case "Guest":
			image = "/images/spGuest.gif";
			break;
		case "cisco-other":
		case "None":
		case "none":
			image = "/images/spNone.gif";
			break;
		case "Automation Device":
			image = "/images/AutomationDevice.gif";
			break;
		case "Automation Device with QoS":
			image = "/images/AutomationDevice-QoS.gif";
			break;
		case "Safety":
		case "Generic Ethernetip":
			image = "/images/spMultiple.gif";
			break;
		case "Diagnostics":
		case "Port Mirroring":
			image = "/images/spDiagnostics.gif";
			break;
		case "Cisco EtherNet/IP":
			image = "/images/spCiscoEthernetip.gif";
			break;
		default:
			image = "/images/spMultiple.gif";
	}
	return preloadImage(image);
}

function StringBuffer() { this.buffer = []; } 
	StringBuffer.prototype.append = function(string) { 
	this.buffer.push(string); 
	return this; 
} 

StringBuffer.prototype.toString = function(){ 
	return this.buffer.join(""); 
}

var imagesArray = new Array();
function preloadImage(imagename){
	if ( imagesArray[imagename] == null ) {
		var img = new Image();
		img.src = imagename;
		imagesArray[imagename] = img;
	}
	return imagesArray[imagename];
}

