<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js for c3560 devices.

// c3560 models.
// WS-C3560-24PS, WS-C3560-48PS, WS-C3560G-24TS, WS-C3560G-48TS, WS-C3560G-24PS, WS-C3560G-48PS
// WS-C3560-24TS, WS-C3560-48TS

function WSC356024P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 62;
	var xPortStartPos = 115;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 549;
	xPortGap = 22;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 38;		
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC356048P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 11;
	yPortCoord = 26;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G244TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G24_4TS.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}


function WSC3560G484TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G48_4TS.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}


function WSC3560G244PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024g_4p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}


function WSC3560G484PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560g48_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G242T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2T.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 37;
	for(i=24; i<26; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord = 37;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3560484T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4T.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function drawLeds_withPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 24;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 31;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 45;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 59;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withoutPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 56;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}


function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType == "WS-C3560-24PS") {
		device = new WSC356024P(int_status, media_type);
	} else if(deviceType == "WS-C3560-48PS") {
		device = new WSC356048P(int_status, media_type);
	} else if(deviceType == "WS-C3560G-24TS") {
		device = new WSC3560G244TS(int_status, media_type);
	} else if(deviceType == "WS-C3560G-48TS") {
		device = new WSC3560G484TS(int_status, media_type);
	} else if(deviceType == "WS-C3560G-48PS") {
		device = new WSC3560G484PS(int_status, media_type);
	} else if(deviceType == "WS-C3560G-24PS") {
		device = new WSC3560G244PS(int_status, media_type);
	} else if(deviceType == "WS-C3560-24TS") {
		device = new WSC3560G242T(int_status, media_type);
	} else if(deviceType == "WS-C3560-48TS") {
		device = new WSC3560484T(int_status, media_type);
	} 


	if(device != null) {
		device.type = deviceType;
		device.family = "3560";
	}
			
	return device;
}
