/*
 *------------------------------------------------------------------
 * sorttable.js
 *
 * Copyright (c) 2003-2005 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

/*

(NOTE: SCRIPT tags are broken into two pieces in these comments so the browser 
 doesn't interpret them)
  
This javascript creates a table with client-side data sorting. It works in 4.x or
higher browsers. In IE, it uses CSS and in Netscape it uses Layers.

Instructions for use in your HTML:

Include the js file inside your HTML source:
   <SCR IPT LANGUAGE="JAVASCRIPT" SRC="sorttable.js"></SCR IPT>
Due to a Netscape browser bug, if the page you are using this on is inside a frameset,
you may need to include an empty SCRIPT tag before the included file. Like this:
	<SCR IPT></SCR IPT>
   <SCR IPT LANGUAGE="JAVASCRIPT" SRC="sorttable.js"></SCR IPT>

Insert the style sheet types in your HTML source, inside <HEAD></HEAD>:
   <STYLE type=text/css>
   .rel {POSITION: relative; width:100%;}
   .abs {POSITION: absolute; width:100%;}
   .right { text-align:right; }
   .left { text-align:left; }
   .center { text-align:center; }
   </STYLE>

Define the table somewhere in your HTML file. Preferrably this will go in the 
<HEAD> of your document, but it may also be included in-line:
     var t = new SortTable("t");
This creates a new SortTable object. You must pass the function an argument of
the name of the object you are creating. For example,
     var mytable = new SortTable("mytable");

Now define the columns of your table:
     t.AddColumn("Name","","left","");
     t.AddColumn("ID","","center","numeric");
     t.AddColumn("Bonus","BGCOLOR=ffffcc","right","money");
The first argument is the name of the column, which you can use when sorting.
The second argument is the <TD> properties. Anything in this argument will be
  added to the <TD> for each element in this column.
The third argument is the alignment of this column. left, center, right. (default left)
The last argument is the data type of the column. This is used for sorting. More data
  types may be defined manually. The default data type for sorting is alphanumeric.
  Accepted types are:
     - numeric : float data
	  - form : If this columns contains form elements, you must use this type!
	           (this will cause the table to be non-sortable in Netscape)
     - date : Date data must be in a format understood by Date.parse()!
	  				  
Now populate the table:

     t.AddLine("John Doe",12345,"$500.00");

This adds a row of data to the table.
Sometimes, the table cell will contain text other than the actual data. For example, if
your cells contain a "Work Order Number" like '032097' that are inside of a link, your
table cell would contain:
     <a href="whatever">032097</a>
Sorting based on this text data does not give the correct results, however. Instead, you
want to sort based on just the number itself - 032097. For this, you need to define the
sort data separately from the cell contents. To continue with the above example, let's 
say that "John Doe" is actually a link to his home page. Your AddLine would look like this:

     t.AddLine("<a href='http://www.johndoe.com/'>Jone Doe</a>,12345,"$500.00");

To correctly sort the first column by only his name, you would then add this command
immediately after the AddLine() command:

     t.AddLineSortData("John Doe",'','');

When blank entries are left for the sort data, the text data entered with AddLine() is
used for the sorting.

You have one more option for the line of data you just entered. You may include a string
that will be included in the <TR> for this line of the table. You can then include a
background color for the row, for example. NOTE: This applies to the row number, and does
NOT move when the rows are sorted. For example, if you put a red background in a row,
and then re-sort the table, the red background will not move. The syntax for adding an
argument to the row's <TR> is:
     
	  t.AddLineProperties(text);
For example:
     t.AddLineProperties("align=center bgcolor=#F6F6F6");
This will center the whole row and give it a light gray background color. This option is
mostly useful for giving every other row a different background color to make reading
easier.
	  
You are now done defining the data of your table. To put the table into your HTML, you
must manually define the table itself. In order for Netscape to properly show cells of
different lengths, a width of the table MUST be specified!!
      
     <table border=1 width=600>
     <tr>
     	<th><a href="javascript:SortRows(t,0)">Name</a></th>
     	<th><a href="javascript:SortRows(t,1)">ID</a></th>
     	<th><a href="javascript:SortRows(t,2)">Bonus</a></th>

The links are to the SortRows() function. This will sort and re-populate the table. It
will be most common to call this function when a user clicks a table header, but you 
could actually call this function to sort from anywhere in the page. The sort function
requires the table name and column number (starting with index 0) as arguments.

Note: If SortRows() is called on the same row as the last sort, it will inverse the 
order of the last sort.

Now, as the body of your table, simply call the WriteRows() method of the table to
output the data in its original order. Do not wrap the WriteRows() call around <TR>
or <TD> tags - it creates them:
     </tr>
     <SCR IPT>t.WriteRows()</SCR IPT>
     </table>

*/
			
var use_css=false;
var use_layers=false;   
var use_dom=false;

if (document.all)    { use_css    = true; }
if (document.layers) { use_layers = true; }
 if (!document.all && document.getElementById) { use_dom=true; }  

var sort_object;
var reverse=0;

// Constructor for SortTable object
function SortTable(name) {
	// Properties
	this.name = name;
	this.sortcolumn="";
	this.dosort=true;
	this.width = 800;				// specifies the width of the table
	this.minwidth = 800;	// specifies the preferred width of the table
	this.height = 300;				// specifies the height of the table
	this.headerminheight = 25;		// specifies the minimum height of the table header
	this.tablecontainsforms=false;
	this.tablecontainsimages=false;
	
	this.noOfColumns = 0;			// these variables are used to change the image 
	this.alreadySortedColNo = -1;	// in the header to show whether ascending or descending
	this.headeralignleft = false;   // default header alignment is center...this should be set for left alignment
	this.sortOrder = "";			// uparrow or downarrow
	// Methods
	this.AddLine = AddLine;
	this.AddColumn = AddColumn;
	this.AddColumnData = AddColumnData; // to add columnwise data
	this.AddHeader = AddHeader; // to add all the column headers
	this.AddAdditionalHeader = AddAdditionalHeader; // to add column headers one by one or multiple number of times
	this.AddSecondaryHeader = AddSecondaryHeader; // to add all the columns Secondary Headers
	this.WriteHeader = WriteHeader; // to print the Header
	this.SetColumnWidth = SetColumnWidth; // to set the width of each and every column
	this.WriteRows = WriteRows;
	this.WritePrintableRows = WritePrintableRows;
	this.BuildTable = BuildTable; // to get the Header and Rows 
	this.PrintableTable = PrintableTable; // to get a table with all rows visible...useful for printing
	this.DontSortColumns = DontSortColumns; // to get the columns which need not be sorted
	this.ShowSortImage = ShowSortImage; // to show the sort image ... ascending / descending
	this.ClearAllImgs = ClearAllImgs; // to clear the sort images
	this.SortRows = SortRows;
	this.AddLineProperties = AddLineProperties;
	this.AddLineSortData = AddLineSortData;
	this.HighlightRow = HighlightRow; // highlights a row and scrolls it into view
	
	this.initialBuildDone = false; //flag to check if the table build is complete
	// Structure
	this.Columns = new Array();
	this.Header = new Array(); // to hold the column header names
	this.SecondaryHeader = new Array(); // to hold the column header names which doesn't need anchor
	this.Alignment = new Array(); // to hold the alignment of each column
	this.ColumnWidth = new Array(); // to hold the width of each and every column
	this.PreferredColumnWidth = new Array(); // to hold the default width
	this.NoSortColumns = new Array(); // to hold the list of columns which need not be sorted
	this.Lines = new Array();
	this.LineProperties = new Array();
	}
	
// Add a line to the grid
function AddLine() {
	var index = this.Lines.length;
	this.Lines[index] = new Array();
	for (var i=0; i<arguments.length; i++) {
		this.Lines[index][i] = new Object();
		this.Lines[index][i].lineIndex = index;
		this.Lines[index][i].text = arguments[i];
		this.Lines[index][i].data = arguments[i];
		if((""+arguments[i]).indexOf("<img ") >= 0 || (""+arguments[i]).indexOf("<image ") >= 0) {
			this.tablecontainsimages = true;
		}
	}
}

// Add columnwise data
function AddColumnData(_columnArray, _column) {
	for(var i=0; i<this.Lines.length; i++) {
		this.Lines[i][_column] = new Object();
		this.Lines[i][_column].text = _columnArray[i];
		this.Lines[i][_column].data= _columnArray[i];
		if((""+_columnArray[i]).indexOf("<img ") >= 0 || (""+_columnArray[i]).indexOf("<image ") >= 0) {
			this.tablecontainsimages = true;
		}
	}
}

// Define properties for the <TR> of the last line added
function AddLineProperties(prop) {
	var index = this.Lines.length-1;
	this.LineProperties[index] = prop;
	}
// Define sorting data for the last line added
function AddLineSortData() {
	var index = this.Lines.length-1;
	for (var i=0; i<arguments.length; i++) {
		if (arguments[i] != '') {
			this.Lines[index][i].data = arguments[i];
			}
		}
	}

// Add a column definition to the table
// Arguments:
//   name = name of the column
//   td   = any arguments to go into the <TD> tag for this column (ex: BGCOLOR="red")
//   align= Alignment of data in cells
//   type = type of data in this column (numeric, money, etc) - default alphanumeric
function AddColumn(name,td,align,type) {
	var index = this.Columns.length;
	this.Columns[index] = new Object;
	this.Columns[index].name = name;
	this.Columns[index].td   = td;
	this.Columns[index].align=align;
	this.Columns[index].type = type;
	if (type == "form" || type == "form-numeric") {
		 this.tablecontainsforms=true; 
		 if (use_layers) { 
		 	this.dosort=false;
			}
		}
	}
// Print out the original set of rows in the grid
function WriteRows() {
	var returnString = "";
	var open_div = "";
	var close_div = "";
	var rowClass = "";
	for (var i=0; i<this.Lines.length; i++) {
		if (i % 2 == 0)
			rowClass = "tableroweven";
		else 
			rowClass = "tablerowodd";
		returnString += "<TR>"; //"<TR "+this.LineProperties[i]+">"; 
		for (var j=0; j<this.Columns.length; j++) {
			var div_name = "d"+this.name+"-"+i+"-"+j;
			if (use_css || use_dom) {
				if (this.Columns[j].align != '') {
					var align = " ALIGN="+this.Columns[j].align;
					}
				else {
					var align = "";
					}
				open_div = "<DIV ID=\""+div_name+"\" "+align+">";
				close_div= "</DIV>";
				}
			else if (use_layers) {
				// If the table contains form elements, don't use <LAYER> tags or the
				// form will be forced closed.
				if (!this.dosort) {
					if (this.Columns[j].align != '') {
						open_div="<SPAN CLASS=\""+this.Columns[j].align+"\">";
						}
					}
				else {
					open_div = "<ILAYER NAME=\""+div_name+"\" WIDTH=100%>";
					open_div+= "<LAYER NAME=\""+div_name+"x\" WIDTH=100%>";
					if (this.Columns[j].align != '') {
						open_div+= "<SPAN CLASS=\""+this.Columns[j].align+"\">";
						}
					}
				if (this.Columns[j].align != '') {
	 				close_div = "</SPAN>";
					}
				if (this.dosort) {
					close_div += "</LAYER></ILAYER>";
					}
				}
			returnString += "<TD class=" + rowClass + ">"+open_div+this.Lines[i][j].text+close_div+"</TD>"; 
			}
		returnString += "</TR>"; 
		}
		return returnString;
	}
// Sort the table and re-write the results to the existing table
function SortRows(table,column) {
	sort_object = table;
	if (! ProceedWithSort(sort_object.dosort, column, sort_object.NoSortColumns)) { return; }
	//if (!sort_object.dosort) { return; }
	//if (sort_object.alreadySortedColNo == column) { reverse=1-reverse;alert('here');}
	//else { reverse=0; }
	//sort_object.alreadySortedColNo = column;
	var tempTable = this.ShowSortImage(table,column);
	sort_object.alreadySortedColNo = table.alreadySortedColNo;
	sort_object.sortOrder = table.sortOrder;
	if (sort_object.sortOrder == "descending") {
		reverse = 1;
	} else {
		reverse = 0;
	}
	
	// Save all form column contents into a temporary object
	// This is a nasty hack to keep the current values of form elements intact
	var tempcolumns = new Object();
	if (table.tablecontainsforms || table.tablecontainsimages) {
		var iname="1";
		//var tempcolumns = new Object();
		for (var i=0; i<table.Lines.length; i++) {
			for (var j=0; j<table.Columns.length; j++) {
				var cell_name = "d"+table.name+"-"+i+"-"+j;
				if(document.getElementById(cell_name).innerHTML.toLowerCase().indexOf("<img ") >= 0) {
					var images = document.getElementById(cell_name).getElementsByTagName("img");
					if(images[0].name == null ||  images[0].name == "") {
						table.Lines[i][j].data = images[0].src.substring(images[0].src.lastIndexOf("/")+1, images[0].src.length);
					}
					else
						table.Lines[i][j].data = images[0].name;
					//var _temp = document.getElementById(cell_name).innerHTML.match(/src="[^"]+"/g)[0].replace(/src="|"/g, "");
					//table.Lines[i][j].data = _temp.substring(_temp.lastIndexOf("/")+1, _temp.length);
				}
				else if(table.Columns[j].type == "form" || table.Columns[j].type == "form-numeric") {
					tempcolumns[iname] = document.getElementById(cell_name).innerHTML;
					var elementType = document.getElementById(cell_name).childNodes[0].type;
					
					if(elementType == "text") {
						if(document.getElementById(cell_name).childNodes[0].style.display == "none" || document.getElementById(cell_name).childNodes[0].style.visibility == "hidden")
							table.Lines[i][j].value = -2;
						else
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].value;
					}
					else if(elementType == "select-one")
					{
						if(document.getElementById(cell_name).childNodes[0].style.display == "none" || document.getElementById(cell_name).childNodes[0].style.visibility == "hidden")
							table.Lines[i][j].value = -2;
						else
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].options[document.getElementById(cell_name).childNodes[0].selectedIndex].text.toLowerCase();
						//for netscape the selectedindex of the combobox is stored to be set after sorting the rows
						//this is required to retain the values in the comboboxes after sorting
						table.Lines[i][j].selectedIndex = document.getElementById(cell_name).childNodes[0].selectedIndex;
					}
					else if(elementType == "checkbox")
					{
						table.Lines[i][j].checked = document.getElementById(cell_name).childNodes[0].checked;
						if(document.getElementById(cell_name).childNodes[0].style.display == "none" || document.getElementById(cell_name).childNodes[0].style.visibility == "hidden")
							table.Lines[i][j].value = -2;
						else if(document.getElementById(cell_name).childNodes[0].disabled)
							table.Lines[i][j].value = -1;
						else
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].checked;
					}
					else {
						table.Lines[i][j].value = document.getElementById(cell_name).innerHTML;
					}
					
					/*if (use_css) { 				//IE
						tempcolumns[iname] = document.all[cell_name].innerHTML;
						if(document.all[cell_name].childNodes[0].type == "text")
							table.Lines[i][j].value = document.all[cell_name].childNodes[0].value;
						//for combo boxes the text of the selected option is used for sorting
						else if(document.all[cell_name].childNodes[0].type == "select-one")
							table.Lines[i][j].value = document.all[cell_name].childNodes[0].options(document.all[cell_name].childNodes[0].selectedIndex).text;
						else if(document.all[cell_name].childNodes[0].type == "checkbox")
						{
							table.Lines[i][j].value = document.all[cell_name].childNodes[0].checked;
							table.Lines[i][j].checked = document.all[cell_name].childNodes[0].checked;
						}
						else if(document.all[cell_name].innerHTML.toLowerCase().indexOf("<img ") >= 0)
						{
							var _temp = document.all[cell_name].innerHTML.match(/src="[^"]+"/g)[0].replace(/src="|"/g, "");
							table.Lines[i][j].value = _temp.substring(_temp.lastIndexOf("/")+1, _temp.length);
						}
						else
							table.Lines[i][j].value = document.all[cell_name].innerHTML;
					}
					else {							//Netscape
						tempcolumns[iname] = document.getElementById(cell_name).innerHTML;
						if(document.getElementById(cell_name).childNodes[0].type == "text")
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].value;
						else if(document.getElementById(cell_name).childNodes[0].type == "select-one")
						{
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].options[document.getElementById(cell_name).childNodes[0].selectedIndex].text;
							//for netscape the selectedindex of the combobox is stored to be set after sorting the rows
							//this is required to retain the values in the comboboxes after sorting
							table.Lines[i][j].selectedIndex = document.getElementById(cell_name).childNodes[0].selectedIndex;
						}
						else if(document.getElementById(cell_name).childNodes[0].type == "checkbox")
						{
							table.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].checked;
							//for netscape the checked state of the checkbox is stored
							table.Lines[i][j].checked = document.getElementById(cell_name).childNodes[0].checked;
						}
						else if(document.getElementById(cell_name).innerHTML.toLowerCase().indexOf("<img ") >= 0)
						{
							var _temp = document.getElementById(cell_name).innerHTML.match(/src="[^"]+"/g)[0].replace(/src="|"/g, "");
							table.Lines[i][j].value = _temp.substring(_temp.lastIndexOf("/")+1, _temp.length);
						}
						else
							table.Lines[i][j].value = document.getElementById(cell_name).innerHTML;
					}*/
					table.Lines[i][j].text = iname;
					iname++;
					}
				}
			}
		}
		
	if (table.Columns[column].type == "numeric") {
		// Sort by Float
		table.Lines.sort(	function by_name(a,b) {
									if (parseFloatNumber(a[column].data) < parseFloatNumber(b[column].data) ) { return -1; }
									if (parseFloatNumber(a[column].data) > parseFloatNumber(b[column].data) ) { return 1; }
									if(parseFloatNumber(a[column].data) == parseFloatNumber(b[column].data) ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	else if (table.Columns[column].type == "form-numeric") {
		// Sort by Float
		table.Lines.sort(	function by_name(a,b) {
									if (parseFloatNumber(a[column].value) < parseFloatNumber(b[column].value) ) { return -1; }
									if (parseFloatNumber(a[column].value) > parseFloatNumber(b[column].value) ) { return 1; }
									if(parseFloatNumber(a[column].value) == parseFloatNumber(b[column].value) ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	else if (table.Columns[column].type == "money") {
		// Sort by Money
		table.Lines.sort(	function by_name(a,b) {
									if (parseFloat(a[column].data) < parseFloat(b[column].data) ) { return -1; }
									if (parseFloat(a[column].data) > parseFloat(b[column].data) ) { return 1; }
									if(parseFloat(a[column].data) == parseFloat(b[column].data) ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	else if (table.Columns[column].type == "date") {
		// Sort by Date
		table.Lines.sort(	function by_name(a,b) {
									if (Date.parse(a[column].data) < Date.parse(b[column].data) ) { return -1; }
									if (Date.parse(a[column].data) > Date.parse(b[column].data) ) { return 1; }
									if(Date.parse(a[column].data) == Date.parse(b[column].data) ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	else if (table.Columns[column].type == "form") {

		table.Lines.sort(	function by_name(a,b) {
									if (a[column].value+"" < b[column].value+"") { return -1; }
									if (a[column].value+"" > b[column].value+"") { return 1; }
									if(a[column].value+"" == b[column].value+"" ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	else if(table.Columns[column].type == "interface") {
			table.Lines.sort(function by_name(a,b) {
				 return compareIntName(a[column].data,b[column].data);
			} 		
		);
		}
	else if (table.Columns[column].type == "text") {
		table.Lines.sort(	function by_name(a,b) {
									if ((a[column].data+"").replace(/<[^>]+>/g, "") < (b[column].data+"").replace(/<[^>]+>/g, "")) { return -1; }
									if ((a[column].data+"").replace(/<[^>]+>/g, "") > (b[column].data+"").replace(/<[^>]+>/g, "")) { return 1; }
									if ((a[column].data+"").replace(/<[^>]+>/g, "") == (b[column].data+"").replace(/<[^>]+>/g, "")) { 
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
	}
	else {
		// Sort by alphanumeric
		table.Lines.sort(	function by_name(a,b) {
									if (a[column].data+"" < b[column].data+"") { return -1; }
									if (a[column].data+"" > b[column].data+"") { return 1; }
									if(a[column].data+"" == b[column].data+"" ) {
										if(a[column].lineIndex < b[column].lineIndex) { return -1; }
										if(a[column].lineIndex > b[column].lineIndex) { return 1; }
									}
									return 0;
									}
								);
		}
	
	var dataTable = document.getElementById("SortTableData");
	if(dataTable && dataTable.getAttribute("highlightedRow") != null && dataTable.getAttribute("highlightedRow") != "" && !isNaN(dataTable.getAttribute("highlightedRow"))) {
		var rowIndex = parseInt(dataTable.getAttribute("highlightedRow"));
		for(var i=0; i<dataTable.rows[rowIndex].cells.length; i++) {
			dataTable.rows[rowIndex].cells[i].style.backgroundColor = "";
		}
	}
	
	if (reverse) { table.Lines.reverse(); }
	for (var i=0; i<table.Lines.length; i++) {
		for (var j=0; j<table.Columns.length; j++) {
			var cell_name = "d"+table.name+"-"+i+"-"+j;
			if (use_dom) { //netscape
				if(table.Columns[j].type == "form" || table.Columns[j].type == "form-numeric") {
					var iname = table.Lines[i][j].text;
					document.getElementById(cell_name).innerHTML = tempcolumns[iname];
					//hack for netscape to retain the changed value in a combobox, textbox & checkbox
					if(document.getElementById(cell_name).childNodes[0].type == "text")
						document.getElementById(cell_name).childNodes[0].value = table.Lines[i][j].value;					
					if(document.getElementById(cell_name).childNodes[0].type == "select-one")
						document.getElementById(cell_name).childNodes[0].selectedIndex = table.Lines[i][j].selectedIndex;
					if(document.getElementById(cell_name).childNodes[0].type == "checkbox")
						document.getElementById(cell_name).childNodes[0].checked = table.Lines[i][j].checked;
					table.Lines[i][j].text = tempcolumns[iname];
					}
				else {
					document.getElementById(cell_name).innerHTML = table.Lines[i][j].text;
					}
				}
			else if (use_css) { //IE
				if(table.Columns[j].type == "form" || table.Columns[j].type == "form-numeric") {
					var iname = table.Lines[i][j].text;
					document.all[cell_name].innerHTML = tempcolumns[iname];
					//if(document.all[cell_name].childNodes[0].type == "checkbox")
					//	document.all[cell_name].childNodes[0].checked = table.Lines[i][j].checked;
					table.Lines[i][j].text = tempcolumns[iname];
					}
				else {
					document.all[cell_name].innerHTML = table.Lines[i][j].text;
					}
				}
			else if (use_layers) {
				var cell_namex= "d"+table.name+"-"+i+"-"+j+"x";
				if (table.Columns[j].align != '') {
					document.layers[cell_name].document.layers[cell_namex].document.write("<SPAN CLASS=\""+table.Columns[j].align+"\">");
					}
				document.layers[cell_name].document.layers[cell_namex].document.write(table.Lines[i][j].text);
				if (table.Columns[j].align != '') {
					document.layers[cell_name].document.layers[cell_namex].document.write("</SPAN>");
					}
				document.layers[cell_name].document.layers[cell_namex].document.close();
				}
			}
		}
	}

function parseFloatNumber(_number) {
	if(isNaN(parseFloat(_number)))
		return -10000;
	else
		return parseFloat(_number);
}

//////////// added for interface comparison

var LONGER = 1;
var SAME = 0;
var SHORTER = -1;

var BIGGER = 1;
var EQUAL = 0;
var SMALLER = -1;
var UNKNOWN = 1000;

var sizeFlag;

var str1 = null;
var str2 = null;

function compareIntName(a,b) {

  var result = UNKNOWN;

  result = validateComparatees(a, b);
  if (result != UNKNOWN)
  {
	 return result;
  }

  //divide the cellValue1 and cellValue2 into subgroups
  var group1 = new Array();
  var group2 = new Array();
  var types1 = new Array();
  var types2 = new Array();

  //divideStringByTypes((String)cellValue1, group1, types1);
  //divideStringByTypes((String)cellValue2, group2, types2);

  divideStringByTypes(str1, group1, types1);
  divideStringByTypes(str2, group2, types2);

  if (group1.length>group2.length)
  {
	 sizeFlag = LONGER;
  }
  else if (group1.length==group2.length)
  {
	 sizeFlag = SAME;
  }
  else
  {
	 sizeFlag = SHORTER;
  }

  var size = sizeFlag==LONGER?group2.length:group1.length;

  for (var i=0; i<size; ++i)
  {
	 var lType = types1[i];
	 var rType = types2[i];

	 if ((lType == rType)&&(lType == true))
	 {
		//check number
		var lInt = parseInt(group1[i]);
		var rInt = parseInt(group2[i]);
		if(lInt == rInt) result = 0;
		else if (lInt > rInt) result = 1;
		else result = -1;
	 }
	 else
	 {
		var lString = group1[i];
		var rString = group2[i];
		if(lString == rString) result = 0;
		else if (lString > rString) result = 1;
		else result = -1;
	 }

	 if (result != EQUAL)
	 {
		break;
	 }
  }

  if (result == EQUAL)
  {
	 if (sizeFlag == LONGER)
	 {
		result = BIGGER;
	 }
	 else if (sizeFlag == SHORTER)
	 {
		result = SMALLER;
	 }
  }

  return result;
}

function validateComparatees(a, b)
{
  str1 = a;
  str2 = b;

  if ((str1==null)&&(str2==null))
  {
	 return EQUAL;
  }

  if ((str1==null)&&(str2 !=null))
  {
	 return SMALLER;
  }

  if ((str1 !=null)&&(str2==null))
  {
	 return BIGGER;
  }

  var length1 = str1.length;
  var length2 = str2.length;

  if ((length1==0)&&(length2==0))
  {
	 return EQUAL;
  }
  else if (length1==0)
  {
	 return SMALLER;
  }
  else if (length2==0)
  {
	 return BIGGER;
  }

  return UNKNOWN;
}

function divideStringByTypes(target, dividedGroup, itemTypes) {
  var typeFlag = (!isNaN(target.charAt(0)));
  var index = 0;
  var buffer = "";

  for (var i=0; i<target.length; ++i)
  {
	 if (typeFlag==(!isNaN(target.charAt(i))))
	 {
		buffer += target.charAt(i);
	 }
	 else
	 {
		dividedGroup[dividedGroup.length] = buffer;
		itemTypes[itemTypes.length] = typeFlag;
		typeFlag = !typeFlag;
		buffer = "";
		buffer += target.charAt(i);
	 }
  }
  dividedGroup[dividedGroup.length] = buffer;
  itemTypes[itemTypes.length] = typeFlag;
}

// added till here for interface comparison


// check whether to sort or not 

function ProceedWithSort(sortthistable, columnNo, NoSortColumns) {
	if (sortthistable == false) {
		return false;
	} else {
		for(var i = 0; i < NoSortColumns.length; i++) {
			if (parseInt(NoSortColumns[i]) - 1 == columnNo)
				return false;		
		}
		return true;
	}
}

function DontSortColumns(arrayDontSortColumns) {
	this.NoSortColumns = arrayDontSortColumns;	
}

// Add Header to the table

function AddHeader(arrayHeader, arrayHeaderDataType, arrayAlignment) {
	this.noOfColumns = arrayHeader.length;
	this.Header = arrayHeader;
	this.Alignment = arrayAlignment;
	var headerName = "";
	var headerDataType = "";
	var alignment = "";
	for(var i = 0; i < arrayHeader.length; i++) {
		headerName = arrayHeader[i];
		headerDataType = arrayHeaderDataType[i];
		//if the third parameter is not supplied getAlignmentFromType function is used
		//to get the default alignment for the column based on the column type
		alignment = (!arrayAlignment || arrayAlignment[i]=="") ? getAlignmentFromType(arrayHeaderDataType[i]) : arrayAlignment[i];
		this.AddColumn(headerName,"",alignment,headerDataType);
	}
}

// this function enables to add additional header multiple number of times or one by one
// if it doesn't affect any feature, AddHeader and AddAdditionalHeader can be merged into one
function AddAdditionalHeader(arrayHeader, arrayHeaderDataType, arrayAlignment) {
	this.noOfColumns = this.noOfColumns + arrayHeader.length;
	this.Header = this.Header.concat(arrayHeader);
	this.Alignment = arrayAlignment;
	var headerName = "";
	var headerDataType = "";
	var alignment = "";
	for(var i = 0; i < arrayHeader.length; i++) {
		headerName = arrayHeader[i];
		headerDataType = arrayHeaderDataType[i];
		//if the third parameter is not supplied getAlignmentFromType function is used
		//to get the default alignment for the column based on the column type
		alignment = (!arrayAlignment || arrayAlignment[i]=="") ? getAlignmentFromType(arrayHeaderDataType[i]) : arrayAlignment[i];
		this.AddColumn(headerName,"",alignment,headerDataType);
	}
}

//returns the default alignment for a column based on the column type
//_columnType - specifies the column type for which the default alignment is required
function getAlignmentFromType(_columnType) {
	var _columnAlignment = "left";
	switch(_columnType)
	{
		case "interface":
			_columnAlignment = "left";
			break;
		case "numeric":
			_columnAlignment = "right";
			break;
		case "form":
			_columnAlignment = "center";
			break;
		case "form-numeric":
			_columnAlignment = "center";
			break;
		default:
			_columnAlignment = "left";
			break;
	}
	return _columnAlignment;
}

// Add secondary header to the table... header that doesn't have sort anchor

function AddSecondaryHeader(arraySecondaryHeader) {
	this.SecondaryHeader = arraySecondaryHeader;
}

// set the column width 

function SetColumnWidth(arrayColWidth) {
	for (var i = 0; i < arrayColWidth.length; i++) {
		var n = 0;
		if(this.Header[i].toLowerCase().indexOf("<input") >= 0 && this.Header[i].toLowerCase().indexOf("checkbox") >= 0) n = 13;
		this.ColumnWidth[i] = arrayColWidth[i] + n;
		this.PreferredColumnWidth[i] = arrayColWidth[i] + n;
	}
}

// Print out the table header
function WriteHeader() {
	var alignment = "";
	var returnString = "";
	returnString +="<tr class='tableheader'>"; 
	for (var i=0; i<this.Header.length; i++) {
		//alignment = this.Alignment[i];
		if (this.headeralignleft) 
			alignment = 'left'
		else 
			alignment = 'center';
		
		var strForCheckBox = "";
		if(this.Header[i].toLowerCase().indexOf("<input") >= 0 && this.Header[i].toLowerCase().indexOf("checkbox") >= 0)
			strForCheckBox = "<td><image src='images/spacer.gif' width='13'></td>";
					
		if (i != this.alreadySortedColNo) {
			if (this.SecondaryHeader.length == 0) 
				returnString += "<td id='col" + i + this.name + "' class='tablecol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableheader'>" + this.Header[i] + "</td><td><image name='image" + i + this.name + "' src='images/spacer.gif' width='13'></td></tr></table></td>"; 
			else 
				returnString += "<td id='col" + i + this.name + "' class='tablecol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableheader'>" + this.Header[i] + "</td><td>" + this.SecondaryHeader[i] + "</td><td><image name='image" + i + this.name + "' src='images/spacer.gif' width='13'></td></tr></table></td>"; 
		} else {
			if (this.sortOrder == "descending") {
				if (this.SecondaryHeader.length == 0) 
					returnString += "<td id='col" + i + this.name + "' class='tableselectedcol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableselectedheader'>" + this.Header[i] + "</td><td><image name='image" + i + this.name + "' src='images/down_arrow.gif'></td></tr></table></td>"; 
				else 
					returnString += "<td id='col" + i + this.name + "' class='tableselectedcol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableselectedheader'>" + this.Header[i] + "</td><td>" + this.SecondaryHeader[i] + "</td><td><image name='image" + i + this.name + "' src='images/down_arrow.gif'></td></tr></table></td>"; 
			} else {
				if (this.SecondaryHeader.length == 0) 
					returnString += "<td id='col" + i + this.name + "' class='tableselectedcol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableselectedheader'>" + this.Header[i] + "</td><td><image name='image" + i + this.name + "' src='images/up_arrow.gif'></td></tr></table></td>"; 
				else 
					returnString += "<td id='col" + i + this.name + "' class='tableselectedcol' align='" + alignment + "' height='" + this.headerminheight + "' onclick='SortRows(" + this.name + ", " + i + ")'><table><tr>" + strForCheckBox + "<td id='head" + i + this.name + "' class='tableselectedheader'>" + this.Header[i] + "/td><td>" + this.SecondaryHeader[i] + "</td><td><image name='image" + i + this.name + "' src='images/up_arrow.gif'></td></tr></table></td>"; 
			}
		}
	}
	returnString += "</tr>"; 
	return returnString;
}

// Print the header and data

function BuildTable() {
				
	var returnString = "";
	var strColumnWidth = "<colgroup>";
	var colWidth = 0;
	if (this.ColumnWidth.length == 0) {
		colWidth = (this.width - 15) / this.noOfColumns;
		for(var i = 0; i < this.noOfColumns - 1; i++) {
			this.ColumnWidth[i] = colWidth;
			strColumnWidth += "<col width='" + colWidth + "'>";
		}
	} else {
		var diff = 15 / this.noOfColumns;
		for(var i = 0; i < this.noOfColumns-1; i++) {
			strColumnWidth += "<col width='" + (this.ColumnWidth[i] - diff)+ "'>";
		}
	}
	
	returnString += "<div id='SortTable'>";
	returnString += "<div id='TableHeader' style='position:relative;width:" + this.width + ";border: 1px #81868C solid;border-bottom 0px #000000'>"; 
	returnString += "<table width='100%' border='0' cellspacing='0' cellpadding='0' bgcolor='#ffffff'>"; 
	returnString += "<tr>"; 
	returnString += "<td>"; 
	returnString += "<table width='100%' border='0' cellspacing='1' cellpadding='2'>"; 
	returnString += strColumnWidth; 
	returnString += this.WriteHeader();
	returnString += "</table>";
	returnString += "</td>"; 
	returnString += "</tr>"; 
	returnString += "</table>"; 
	returnString += "</div>"; 
	
	returnString += "<div id='TableData' style='position:relative;top:-2;overflow:auto;height:" + this.height + ";width:" + this.width + ";border: 1px #81868C solid;'>"; 
	returnString += "<table width='100%' border='0' cellspacing='0' cellpadding='0' bgcolor='#ffffff'>"; 
	returnString += "<tr>"; 
	returnString += "<td>"; 
	returnString += "<table width='100%' border='0' cellspacing='1' cellpadding='2' id='SortTableData'>"; 
	returnString += strColumnWidth; 
	returnString += this.WriteRows();
	returnString += "</table>"; 
	returnString += "</td>"; 
	returnString += "</tr>"; 
	returnString += "</table>"; 
	returnString += "</div>"; 
	
	returnString += "</div>";
	this.initialBuildDone = true;
	return returnString;
}

// to show the sort image

function ShowSortImage(table, sortColNo) {
	var tableName = table.name;
	var noOfColumns = table.noOfColumns;
	this.ClearAllImgs(tableName, noOfColumns);
	if (sortColNo == table.alreadySortedColNo) {
		if (table.sortOrder == "ascending") {
			document.images["image" + sortColNo + tableName].src = "images/down_arrow.gif";
			table.sortOrder = "descending";
		} else if (table.sortOrder == "descending") {
			document.images["image" + sortColNo + tableName].src = "images/up_arrow.gif";
			table.sortOrder = "ascending";
		} else {
			document.images["image" + sortColNo + tableName].src = "images/up_arrow.gif";
			table.sortOrder = "ascending";
		}		
	} else {
		document.images["image" + sortColNo + tableName].src = "images/up_arrow.gif";	
		table.alreadySortedColNo = sortColNo;
		table.sortOrder = "ascending";
	}
	getLayerByName("col" + sortColNo + tableName).className = "tableselectedcol";
	getLayerByName("head" + sortColNo + tableName).className = "tableselectedheader";
	return table;
}

function ClearAllImgs(tableName, noOfColumns) {
	for (var i=0; i<noOfColumns; i++) {
		document.images["image" + i + tableName].src = "images/spacer.gif";
		getLayerByName("col" + i + tableName).className = "tablecol";
		getLayerByName("head" + i + tableName).className = "tableheader";
	}
}


/* Function getDesiredHeight() calculates the optimum height for a table when the page
 * is resized. If the page is resized below a minimum size, a size of 200 is returned.
 */
function getDesiredHeight(offsetVal, widthOffset) {

	var width = 0, height = 0;
	if( typeof( window.innerWidth ) == 'number' ) {
	//Non-IE
	width = window.innerWidth;
	height = window.innerHeight;
	} else {
	  if( document.body && ( document.body.clientWidth || document.body.clientHeight )) {
		//IE 4 compatible
	//	alert(" CW :" + document.body.clientWidth + ", OW :" + document.documentElement.offsetWidth + ", CH :" + document.body.clientHeight + ", OH :" + document.documentElement.offsetHeight );
				width = document.body.clientWidth;
				height = document.body.clientHeight;
	//	width = document.documentElement.offsetWidth;
	//	height = document.documentElement.offsetHeight;
	  } else if( document.documentElement &&
			(document.documentElement.clientWidth || document.documentElement.clientHeight )) {
	  //IE 6+ in 'standards compliant mode'
		  width = document.documentElement.clientWidth;
		  height = document.documentElement.clientHeight;
	  }		
	}

	if(height < (offsetVal + 100)) {
		document.body.style.overflowY = "auto";
	}
	else {
		document.body.style.overflowY = "hidden";
	}

	width -= widthOffset;
	
	if (width > 700) {
		width = width * (90/100);
	}
	else {
		width = 630;
	}

	//if (width <= 630) {
		document.getElementById("outerTable").style.height = "90%";
	//} else {
	//	document.getElementById("outerTable").style.height = "100%";
	//}

	var factor = (height / 100) - 2.1;

	//if( (height - offsetVal) > 235) height = (height - offsetVal) * (70/100) - (20/factor);
	//else height = 85;	
	if( height > offsetVal + 100 ) {
		height = height - offsetVal;
	}
	else {
		height = 100;
	}
	//alert(width + " : " + height);
	//height = height - 20;
	return new Array(width,height);
}

function setDesiredSize(t, offsetVal, widthOffset) {
	//the form values are stored to repopulate the values after the table is resized and rebuilt
	if (t.initialBuildDone && t.tablecontainsforms) //condition to check if table has been built and if the table contains form elements
	{
		for (var i=0; i<t.Lines.length; i++)
		{
			for (var j=0; j<t.Columns.length; j++)
			{
				if(t.Columns[j].type == "form" || t.Columns[j].type == "form-numeric")
				{
					var cell_name = "d"+t.name+"-"+i+"-"+j;
					if (use_css)
					{
						if(document.all[cell_name].childNodes[0].type == "text")
							t.Lines[i][j].value = document.all[cell_name].childNodes[0].value;
						else if(document.all[cell_name].childNodes[0].type == "select-one")
							t.Lines[i][j].value = document.all[cell_name].childNodes[0].selectedIndex;
						else if(document.all[cell_name].childNodes[0].type == "checkbox")
							t.Lines[i][j].value = document.all[cell_name].childNodes[0].checked;
					}
					else
					{
						if(document.getElementById(cell_name).childNodes[0].type == "text")
							t.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].value;
						else if(document.getElementById(cell_name).childNodes[0].type == "select-one")
							t.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].selectedIndex;
						else if(document.getElementById(cell_name).childNodes[0].type == "checkbox")
							t.Lines[i][j].value = document.getElementById(cell_name).childNodes[0].checked;
					}
				}
			}
		}
	}
	
	var htOffset = offsetVal != undefined ? offsetVal : 0;
	var wtOffset = widthOffset != undefined ? widthOffset : 0;
	var dimension = getDesiredHeight(htOffset, wtOffset);
	t.height = dimension[1];
	if (dimension[0] > t.minwidth) {
		t.width = dimension[0];
		var diff = parseInt((dimension[0] - t.minwidth) / t.noOfColumns);
		if (t.PreferredColumnWidth.length > 0) {
			for (var i = 0; i < t.ColumnWidth.length; i++) {
				t.ColumnWidth[i] = t.PreferredColumnWidth[i] + diff;
			}
		} else {
			var equalWidth = parseInt((t.width - 15) / t.noOfColumns);
			for (var i = 0; i < t.ColumnWidth.length; i++) {
				t.ColumnWidth[i] = equalWidth;
			}
		}
	} else {
		t.width = t.minwidth;
		if (t.PreferredColumnWidth.length > 0) {
			for(var i = 0; i < t.PreferredColumnWidth.length; i++) {
				t.ColumnWidth[i] = t.PreferredColumnWidth[i];
			}
		} else {
			var equalWidth = parseInt((t.width - 15) / t.noOfColumns);
			for (var i = 0; i < t.ColumnWidth.length; i++) {
				t.ColumnWidth[i] = equalWidth;
			}
		}
	}
}

//repopulate stored form values after the table is resized and rebuilt
function updateTableValues(_table) {
	if (_table.tablecontainsforms)
	{
		for (var i=0; i<_table.Lines.length; i++)
		{
			for (var j=0; j<_table.Columns.length; j++)
			{
				if(_table.Columns[j].type == "form" || _table.Columns[j].type == "form-numeric")
				{
					var cell_name = "d"+_table.name+"-"+i+"-"+j;
					if (use_css)
					{
						if(document.all[cell_name].childNodes[0].type == "text")
							document.all[cell_name].childNodes[0].value = _table.Lines[i][j].value;
						else if(document.all[cell_name].childNodes[0].type == "select-one")
							document.all[cell_name].childNodes[0].selectedIndex = _table.Lines[i][j].value;
						else if(document.all[cell_name].childNodes[0].type == "checkbox")
							document.all[cell_name].childNodes[0].checked = _table.Lines[i][j].value;
					}
					else
					{
						if(document.getElementById(cell_name).childNodes[0].type == "text")
							document.getElementById(cell_name).childNodes[0].value = _table.Lines[i][j].value;
						else if(document.getElementById(cell_name).childNodes[0].type == "select-one")
							document.getElementById(cell_name).childNodes[0].selectedIndex = _table.Lines[i][j].value;
						else if(document.getElementById(cell_name).childNodes[0].type == "checkbox")
							document.getElementById(cell_name).childNodes[0].checked = _table.Lines[i][j].value;
					}
				}
			}
		}
	}
}

function PrintableTable() {
	var returnString = "";
	var strColumnWidth = "<colgroup>";
	var colWidth = 0;
	if (this.ColumnWidth.length == 0) {
		colWidth = this.width / this.noOfColumns;
		for(var i = 0; i < this.noOfColumns; i++) {
			this.ColumnWidth[i] = colWidth;
			strColumnWidth += "<col width='" + colWidth + "'>";
		}
	} else {
		for(var i = 0; i < this.noOfColumns; i++) {
			strColumnWidth += "<col width='" + this.ColumnWidth[i] + "'>";
		}
	}
	
	returnString += "<div id='SortTable'>";
	returnString += "<div id='TableHeader' style='position:relative;'>"; 
	returnString += "<table align=center width=95% border='1' cellspacing='0' cellpadding='0' bgcolor='#ffffff' bordercolor='#000000' style='border-collapse:collapse;'>"; 
	returnString += strColumnWidth; 
	returnString += this.WriteHeader();
	returnString += this.WritePrintableRows();
	returnString += "</table>"; 
	returnString += "</div>"; 
	
	returnString += "</div>";
	return returnString;
}

// Print out the original set of rows in the grid
function WritePrintableRows() {
	var returnString = "";
	var open_div = "";
	var close_div = "";
	var rowClass = "";
	for (var i=0; i<this.Lines.length; i++) {
		if (i % 2 == 0)
			rowClass = "tableroweven";
		else 
			rowClass = "tablerowodd";
		returnString += "<TR>"; //"<TR "+this.LineProperties[i]+">"; 
		for (var j=0; j<this.Columns.length; j++) {
			var div_name = "d"+this.name+"-"+i+"-"+j;
			if (use_css || use_dom) {
				if (this.Columns[j].align != '') {
					var align = " ALIGN="+this.Columns[j].align;
					}
				else {
					var align = "";
					}
				open_div = "<DIV ID=\""+div_name+"\" "+align+">";
				close_div= "</DIV>";
				}
			else if (use_layers) {
				// If the table contains form elements, don't use <LAYER> tags or the
				// form will be forced closed.
				if (!this.dosort) {
					if (this.Columns[j].align != '') {
						open_div="<SPAN CLASS=\""+this.Columns[j].align+"\">";
						}
					}
				else {
					open_div = "<ILAYER NAME=\""+div_name+"\" WIDTH=100%>";
					open_div+= "<LAYER NAME=\""+div_name+"x\" WIDTH=100%>";
					if (this.Columns[j].align != '') {
						open_div+= "<SPAN CLASS=\""+this.Columns[j].align+"\">";
						}
					}
				if (this.Columns[j].align != '') {
	 				close_div = "</SPAN>";
					}
				if (this.dosort) {
					close_div += "</LAYER></ILAYER>";
					}
				}
				
				cellText = ""+this.Lines[i][j].text;
				if(cellText.indexOf("<image ") >= 0) {
					cellText = cellText.match(/ title[ ]*=[ ]*'[^']+'| title[ ]*=[ ]*"[^"]+"/i)[0].replace(/ title=['"]/i, "");
					cellText = cellText.substring(0, cellText.length-1);
				}
			returnString += "<TD class=" + rowClass + ">"+open_div+cellText+close_div+"</TD>";
			}
		returnString += "</TR>"; 
		}
		return returnString;
}
	
function set_printlayercontent(layerName, layerContent){
	
	if(document.all){
	// the browser is "ie"
		layerObj = top.printFrame.document.all[layerName];
		layerObj.innerHTML=layerContent;
	}
		
	if(!document.all && document.getElementById){
	// the browser is "NN6";
		layerObj = top.printFrame.document.getElementById(layerName);
		layerObj.innerHTML =layerContent;
	}
}

// method to highlight a row and scroll it into view
function HighlightRow(rowIndex, scrollToView) {
	var table = document.getElementById("SortTableData");
	table.setAttribute("highlightedRow", rowIndex);
	rowIndex = parseInt(rowIndex);
	
	if(table && !isNaN(rowIndex)) {
		for(var i=0; i<table.rows[rowIndex].cells.length; i++) {
			table.rows[rowIndex].cells[i].style.backgroundColor = "lightblue";
		}
		if(scrollToView) {
			table.rows[rowIndex].cells[0].scrollIntoView();
		}
	}
}
