<!-- Copyright (c) 2004, 2006 by Cisco Systems, Inc. -->
// discover.js for c3560 devices.

// c3560 models.
// WS-C3560-24PS, WS-C3560-48PS, WS-C3560G-24TS, WS-C3560G-48TS, WS-C3560G-24PS, WS-C3560G-48PS
// WS-C3560-24TS, WS-C3560-48TS

function WSC356024P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 62;
	var xPortStartPos = 115;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 549;
	xPortGap = 22;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 38;		
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC356048P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 11;
	yPortCoord = 26;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G244TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G24_4TS.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}


function WSC3560G484TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G48_4TS.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}


function WSC3560G244PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024g_4p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}


function WSC3560G484PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560g48_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G242T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2T.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 37;
	for(i=24; i<26; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord = 37;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3560484T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4T.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC35608PC(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560_8_1.gif";

	drawLeds_pilsner2_PoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports. 
	for(i=0; i<8; i++) {       
		yPortCoord = 57;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }
	//Add one composite port
	xPortCoord = 397;
	yPortCoord = 55;
	portWidth = 21;
	for(i=8; i<9; i++) {
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX"; 
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
		port.width = 44;
		port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}	
	
	return dev;
}

function drawLeds_pilsner2_PoE(dev) 
{
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	modeBtn.x = 37;
	modeBtn.y = 50;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 32;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 39;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 46;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 53;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 24;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 31;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 45;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 59;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withoutPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 56;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}

// For Pixar Buzz devices.

function WSC3580G24TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_24.gif";

	drawLeds_withoutPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9; 
	var xPortStartPos = 325;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18; 
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/25") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
			

	if (interfaces.indexOf("0/27") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}

  	  if (interfaces.indexOf("0/25") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;

	}

	if (interfaces.indexOf("0/27") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599; 
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3580G24PD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_24_PoE.gif";

	drawLeds_withPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 326;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];

	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/25") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
			
	if (interfaces.indexOf("0/27") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}

	if (interfaces.indexOf("0/25") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/27") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC3580G48TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_48.gif";

	drawLeds_withoutPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/49") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}

	if (interfaces.indexOf("0/51") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}

	if (interfaces.indexOf("0/49") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/51") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3580G48PD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_48_PoE.gif";

	drawLeds_withPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/49") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}

	if (interfaces.indexOf("0/51") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;		// need to be modified
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}

	if (interfaces.indexOf("0/49") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/51") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(617, 8, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(617, 57, 7, 5, image1);
        	portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;

		case 25:
		case 49:
			// Adding the top port label1
				var portlbl = new top.portLabel(607, 8, 7, 5, image1);
				portlbl.id = "portlbl1";
				dev.addPortLabel(portlbl);

			 // Adding the top port label2
				var portlbl2 = new top.portLabel(629, 8, 7, 5, image2);
				portlbl2.id = "portlbl2";
				dev.addPortLabel(portlbl2);
			break;
		case 27:
		case 51:
		        // Adding the bottom port label1 
				var portlbl3 = new top.portLabel(607, 57, 7, 5, image1);
				portlbl3.id = "portlbl3";
				dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2 
				var portlbl4 = new top.portLabel(629, 57, 7, 5, image2);
				portlbl4.id = "portlbl4";
				dev.addPortLabel(portlbl4);
	}
}

function drawLeds_withPoE_pixar(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 29;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 58;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withoutPoE_pixar(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 29;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}

function drawACOK_DCOKLEDs(dev){
	// Create AC OK LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 69;
	tempLed.y = 67;
	tempLed.id = "ac_ok";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["ACOK"] = tempLed;

	// Create DC OK LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 104;
	tempLed.y = 67;
	tempLed.id = "dc_ok";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["DCOK"] = tempLed;

	// Create Fa0 LED
	tempLed = new top.led(ledImages);
	tempLed.x = 141;
	tempLed.y = 67;
	tempLed.id = "fa_0";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

}

function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;

	switch(deviceType){

		case "WS-C3560-24PS":
			device = new WSC356024P(int_status, media_type);
			break;	
		case "WS-C3560-48PS":
			device = new WSC356048P(int_status, media_type);
			break;
		case "WS-C3560G-24TS":
			device = new WSC3560G244TS(int_status, media_type);
			break;
		case "WS-C3560G-48TS":
			device = new WSC3560G484TS(int_status, media_type);
			break;
		case "WS-C3560G-48PS":
			device = new WSC3560G484PS(int_status, media_type);
			break;
		case "WS-C3560G-24PS":
			device = new WSC3560G244PS(int_status, media_type);
			break;
		case "WS-C3560-24TS":
			device = new WSC3560G242T(int_status, media_type);
			break;
		case "WS-C3560-48TS":
			device = new WSC3560484T(int_status, media_type);
			break;
		case "WS-C3560-8PC":
			device = new WSC35608PC(int_status, media_type);
			break;
		case "WS-C3560E-24TD":
			device = new WSC3580G24TD(int_status, media_type);
			break;
		case "WS-C3560E-24PD":
			device = new WSC3580G24PD(int_status, media_type);
			break;
		case "WS-C3560E-48TD":
			device = new WSC3580G48TD(int_status, media_type);
			break;
		case "WS-C3560E-48PD":
			device = new WSC3580G48PD(int_status, media_type);
			break;
	} 

	if(device != null) {
		device.type = deviceType;
		if(deviceType.indexOf("C3560E")!=-1)
			device.family = "3560-E";	
		else
			device.family = "3560";
	}
			
	return device;
}
