<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// Parsing code for 3550.

/* 
 * Used to determine the software upgrade stages. Stages will be 
 * displayed below the 'instructions' table. Appropriate error message   
 * will be displayed if there is any error message. 
 */
var contents = "";
function getStreamedOutput()
{
//	var str 	= "";
	str 		= parent.result.document.body.innerHTML;			// Get the result frame content.
	contents	= parent.result.document.body.innerHTML;		
	currContent = str.substring(5,str.length-6);					// extract the text without <pre> </pre> tags
	if(currContent.indexOf("BODY") != -1)
		currContent = "";
		
	diff		= getDifference(prevContent, currContent);  		// Get the difference (or) Get the new output. 
	// if there is no content. Make it as loading stage.
	if(currContent.length == 0 || currContent.indexOf("BODY") != -1)		// For nn7
	{
		currStage = 1;												// Still Loading stage.
		prevStage = 1;
		//displayStage(currStage);					
	}
	// New updated content has come from the device.
	if(diff.length != 0)
	{
		currStage	  = getStage(diff);								// Get the stage.
		if(currStage == 2 && totalSize == 0)						// If it is loading stage, parse the total file size.	
		{
			var parStr = "Total Image Size:";						// differs from 3750
			startInd = diff.indexOf(parStr); 
			if(startInd != -1)
			{
				stopInd = diff.indexOf("\n",startInd);					
				tot_size = diff.substring(startInd + parStr.length,stopInd);		// Parsing the total file size.				
				if(tot_size.indexOf("0x") != -1)
					totalSize = parseInt(tot_size,16);								// Store total file size.	
				else 
					totalSize = parseInt(tot_size,10);			
			}
		}
				
		if(currStage != prevStage)									// If there is any change of stage, activate the stage.
		{
			displayStage(currStage);			
		}
		
		if(currStage == 3)											// For extracting stage, show the progress bar.
		{	
			size  = getTotalFileSize(diff);							// Get the total file size extracted.
			var date = new Date();
			var currTime = date.getTime();
			currPercentage = (totalExtractedBytes/totalSize) * 100;
			currPercentage = Math.round(currPercentage);
			var elapsedTime = currTime - startTime;
			if(currPercentage > 0) {
				timerInterval = (elapsedTime / currPercentage);
				timerInterval = Math.round(timerInterval);
			}

			totalExtractedBytes  += size;
			currPercentage = (totalExtractedBytes/totalSize) * 100;
			currPercentage = Math.round(currPercentage);
			if(currPercentage >= 100)		
					currPercentage = 100;
			if(currPercentage > prevPercentage)	
			{			
			//window.status = "Devices : " + totalDevices + " , Pre % : " + prevPercentage + " , curr % : " + currPercentage + " , Timer : " + timerInterval;
				startProgress(prevPercentage, currPercentage, timerInterval);	// Show the progress bar.
			}	
			prevPercentage = currPercentage; 
		}
		
		//  If it is reloading state, stop polling and activate the checkReload function after 1 min.
		else if (currStage == 4 && isReloadMsgArrived)    					 			
		{
			//isReloadMsgArrived = true;
			startProgress(currPercentage,100, timerInterval);									// Complete the progress
		}
		
		if(anyErrorHappened(diff))									// Check for Any errors.
		{
			stopPolling();
			isUpgrading = false;
			enableMenu();
			errMsg = getErrorMessage(diff);							// Get the corresponding error message.
			if(currStage == 1)
				unHighlight("load","1. Loading the tar file to the switch", true);			
			else if(currStage == 2)
				unHighlight("verify","2. Verifying the tar file", true);
			else if(currStage == 3)
			{
				set_layercontent("extractDivSymbol","&nbsp;");
				set_layercontent("extractDivStage","<span class=content>3. Extracting the software files from the tar file</span>");					
				stopProgress();
//				document.getElementById("progressBarDiv").style.border = "0px";
				document.getElementById("progressBarDiv").style.display = 'none';
				document.getElementById("progressBarDiv_ok").style.display = 'none';
				document.getElementById("progressBarDiv_err").style.display = 'block';
			}
			showMsgBottomTable(errMsg,"contentred");								// Show the error message.			
			return;
		}
		prevStage = currStage;
	}	
	prevContent	 = currContent;
  	id = setTimeout("getStreamedOutput()",2000);		
}

/* 
 * Used to get the current stage. Stages are represented using
 * numbers. Reloading=4;Extracting=3;verifying=2;loading=1;
 */

function getStage(diff)
{
	var state = -1;
	if(diff.indexOf("reload in progress") != -1)								// Search for Reload stage string.		
	{
		state = 4;
	}
	else if(currStage == 4 && diff.indexOf("done") != -1)
	{
		state = 4;
		isUpgradeOver = true;
		isReloadMsgArrived = true;
	}
	else if(diff.indexOf("Configuring system to use new image") != -1)	// differs from 3750
	{
		state = 4;
		if(diff.indexOf("done") != -1) {
			isUpgradeOver = true;
			isReloadMsgArrived = true;
		}			
	}
	else if(diff.indexOf("examining image") != -1 || diff.indexOf("Total Image Size:") != -1)		
	{
		state = 2;
		var parStr = "Total Image Size:";					// differs from 3750
		startIndex = diff.indexOf(parStr); 
		if(startIndex != -1)
		{
			stopInd = diff.indexOf("\n",startIndex );
			tot_size = diff.substring(startIndex + parStr.length,stopInd);
			if(tot_size.indexOf("0x") != -1)
				totalSize = parseInt(tot_size,16);
			else 
				totalSize = parseInt(tot_size,10);
		}
		if(diff.indexOf("Extracting files") != -1)				// differs from 3750 // Check for intersection of two stages.
		{
			state = 3;			
			setStartTime();
		}
	}
	else if(diff.indexOf("Extracting files") != -1)				// differs from 3750
	{
		state = 3;
		setStartTime();
	}
	if(state == -1)				
		state = currStage;		
	return state;
}

