<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for 3550 devices.
// Supported WS-C3550-12T, WS-C3550-24, WS-C3550-48, WS-C3550-24-DC
// WS-C3550-24-PWR, WS-C3550-12G, WS-C355024-FX

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType == "WS-C3550-12T") {
		device = new WSC355012T(uiPortDataArr);		
	} else if(deviceType == "WS-C3550-12G") {
		device = new WSC355012G(uiPortDataArr);		
	} else if(deviceType == "WS-C3550-24" || deviceType.indexOf("WS-C3550-24-DC") !=-1  ) {
      device = new WSC355024(uiPortDataArr);		
	} else if(deviceType == "WS-C3550-24-PWR") {
		device = new WSC355024PWR(uiPortDataArr);		
	} else if(deviceType == "WS-C3550-48") {
		device = new WSC355048(uiPortDataArr);		
	} else if(deviceType == "WS-C3550-24-FX") {
		device = new WSC355024FX(uiPortDataArr);		
	}
}



function WSC355048(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "32" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "32" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount - 2; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();                                          
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "32" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}

/*
 *  This is unit tested.
 */
function WSC355012T(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "18" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  					<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 10 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
	}
		
	document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
					  
	for (var portId = portCount - 2; portId < portCount; portId++) {
  		// This is extra space between port 15 and 17
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
	}
	document.writeln('\
				  <td nowrap width="18" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('\
		  </tr>')
	document.writeln('\
		<tr><td colspan= "27" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
		</td></tr>')					
}

/*
 *  This is unit tested.
 */
function WSC355024(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
			}
		}
		document.writeln('\
			<td colspan= "20" height="5" bgcolor="#f4f4f4"></td>')
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000);"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="30" bgcolor="#f4f4f4">&nbsp;</td>') 
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="30" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000);"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}                       
		document.writeln('\
				  <td nowrap width="18" bgcolor="#f4f4f4">&nbsp;</td>')                             
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "23" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}


function WSC355024PWR(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "23" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
			}
		}
		document.writeln('\
				  <td nowrap width="30" bgcolor="#f4f4f4">&nbsp;</td>') 
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			if ( portId % 2 == 0) {				  				   
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
			}				
		}                       
		document.writeln('\
				  <td nowrap width="15" bgcolor="#f4f4f4">&nbsp;</td>')		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "23" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')
	   	document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000);"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="30" bgcolor="#f4f4f4">&nbsp;</td>') 
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {				  				   
			document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000);"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a><br>\
					<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}                       
		document.writeln('\
				  <td nowrap width="15" bgcolor="#f4f4f4">&nbsp;</td>')                             
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "23" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

/*
 *  This is unit tested.
 */
function WSC355012G(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "18" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
	for (var portId = 0; portId < portCount -2 ; portId++) {
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="22" height="22" name="cell', '_', portId, '"></a></td>')
			document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		}
	}
	document.writeln('\
				<td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')
	for (var portId = portCount - 2; portId < portCount ; portId++) {
		if ( portId % 2 == 0) {				  				   
			document.writeln('\
				<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="22" height="22" name="cell', '_', portId, '"></a></td>')
		}
	}    
	document.writeln('\
			  <td nowrap width="15" bgcolor="#f4f4f4">&nbsp;</td>')							
	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "18" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')
	document.writeln('\
			  <tr>')
	writeSpaceCell();
	document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')								  
	for (var portId = 0; portId < portCount - 2 ; portId++) {
		if ( portId % 2 != 0) {
			document.writeln('\
				<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000);"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="22" height="22" name="cell', '_', portId, '"></a><br>\
				<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
			document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		}
	}
	
	document.writeln('\
				<td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')
	for (var portId = portCount - 2; portId < portCount ; portId++) {
		if ( portId % 2 != 0) {				  				   				  				   
			document.writeln('\
				<td align="center" width="22" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000);"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="22" height="22" name="cell', '_', portId, '"></a><br>\
				<font size="1" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</td>')
		}
	}                       
	document.writeln('\
			  <td nowrap width="15" bgcolor="#f4f4f4">&nbsp;</td>')                             
	document.writeln('\
			  </tr>')
	document.writeln('\
			  <tr><td colspan= "20" height="5" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')		
}

/*
 * This has been unit tested
 */
function WSC355024FX(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "35" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')
		}
		
		for (var portId = portCount - 2; portId < portCount ; portId++) {
		 	document.writeln('\
					<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="22" bgcolor="#f4f4f4"><font size="1"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="22" height="22" name="cell', '_', portId, '"></a></td>')								  
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "35" height="9" bgcolor="#f4f4f4">')
	   	document.writeln('\
				  </td></tr>')					
}


function getPortLabel(intName) {
	var intNumber = intName.substring(intName.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}
