/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.xmllite;

import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class TestParser
implements Handler {
    private Writer output;

    public static void main(String[] args) {
        System.out.println("Test started...");
        FileReader in = null;
        PrintWriter out = null;
        try {
            in = new FileReader("D:/CompArch/classes/version.xml");
            out = new PrintWriter(new BufferedWriter(new FileWriter("D:/CompArch/classes/version-out.txt")));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        Parser parser = new Parser();
        parser.setSource(in);
        parser.pushHandler(new TestParser(out));
        try {
            parser.startParsing();
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
        out.close();
        System.out.println("\nTest ended.");
    }

    public TestParser(Writer output) {
        this.output = output;
    }

    public void startDocument(Parser parser) {
        try {
            this.output.write("<!-- Document Start -->");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public CharString startElement(Parser parser, CharString element) {
        try {
            this.output.write("<" + element + ">");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return new CharString(element);
    }

    public void elementData(Parser parser, CharString data) {
        try {
            this.output.write(data.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void ignoredData(Parser parser, CharString data) throws ParseException {
        throw new ParseException(parser, "Unexpected ignored data");
    }

    public void endElement(Parser parser, CharString element) {
        try {
            this.output.write("</" + element + ">");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void endDocument(Parser parser) {
        try {
            this.output.write("<!-- Document end -->");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

