/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.xmllite;

import com.cisco.cpnm.boot.internal.xmllite.CharString;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

class Buffer {
    private static final int LOAD_SUCCESS = 0;
    private static final int LOAD_BUFFER_FULL = 1;
    private static final int LOAD_SOURCE_END = 2;
    private Reader source;
    private char[] buffer;
    private int bufferSize;
    private int bufferStart = 0;
    private int bufferEnd = 0;
    private int bufferLength = 0;
    private boolean collectIgnore = false;
    private StringBuffer collectBuffer;

    Buffer(int bufferSize) {
        this.buffer = new char[bufferSize];
        this.bufferSize = bufferSize;
    }

    void setSource(Reader source) {
        this.source = source;
        this.bufferStart = 0;
        this.bufferEnd = 0;
        this.bufferLength = 0;
    }

    public boolean isCollectIgnore() {
        return this.collectIgnore;
    }

    public void setCollectIgnore(boolean v) {
        this.collectIgnore = v;
        if (this.collectIgnore) {
            this.collectBuffer = new StringBuffer();
        }
    }

    public StringBuffer getCollectBuffer() {
        this.setCollectIgnore(false);
        return this.collectBuffer;
    }

    char peek() throws IOException {
        if (this.bufferLength == 0) {
            this.loadBuffer();
        }
        if (this.bufferLength == 0) {
            throw new EOFException();
        }
        char character = this.buffer[this.bufferStart];
        return character;
    }

    char readCharacter() throws IOException {
        char character = this.peek();
        this.charactersRemoved(1);
        if (this.collectIgnore) {
            this.collectBuffer.append(character);
        }
        return character;
    }

    CharString readCharacters() throws IOException {
        return this.readCharacters(this.bufferLength);
    }

    CharString readCharacters(int numChars) throws IOException {
        if (this.bufferLength < numChars) {
            this.loadBuffer();
        }
        if (this.bufferLength == 0) {
            throw new EOFException();
        }
        int returnLength = this.bufferLength < numChars ? this.bufferLength : numChars;
        CharString str = new CharString(this.buffer, this.bufferStart, returnLength);
        this.charactersRemoved(returnLength);
        if (this.collectIgnore) {
            this.collectBuffer.append(str);
        }
        return str;
    }

    int find(char findChar) throws IOException {
        int result;
        int searchLength;
        boolean found = false;
        int searchIndex = this.bufferStart;
        for (searchLength = 0; searchLength != this.bufferLength || (result = this.loadBuffer()) != 1 && result != 2; ++searchLength) {
            if (this.buffer[searchIndex] != findChar) continue;
            found = true;
            break;
        }
        return found ? searchLength : -1;
    }

    int findNonWhiteSpace() throws IOException {
        int result;
        int searchLength;
        boolean found = false;
        int searchIndex = this.bufferStart;
        for (searchLength = 0; searchLength != this.bufferLength || (result = this.loadBuffer()) != 1 && result != 2; ++searchLength) {
            if (Character.isWhitespace(this.buffer[searchIndex])) continue;
            found = true;
            break;
        }
        return found ? searchLength : -1;
    }

    private int loadBuffer() throws IOException {
        int secondChunk;
        if (this.bufferLength == this.bufferSize) {
            return 1;
        }
        int firstChunk = this.bufferSize - this.bufferEnd;
        int freeSpace = this.bufferSize - this.bufferLength;
        if (firstChunk < freeSpace) {
            secondChunk = freeSpace - firstChunk;
        } else {
            firstChunk = freeSpace;
            secondChunk = 0;
        }
        int numRead = this.source.read(this.buffer, this.bufferEnd, firstChunk);
        if (numRead == -1) {
            return 2;
        }
        this.charactersAdded(numRead);
        if (numRead == firstChunk && secondChunk != 0 && (numRead = this.source.read(this.buffer, this.bufferEnd, secondChunk)) != -1) {
            this.charactersAdded(numRead);
        }
        return 0;
    }

    private void charactersAdded(int numChars) {
        this.bufferEnd += numChars;
        if (this.bufferEnd >= this.bufferSize) {
            this.bufferEnd -= this.bufferSize;
        }
        this.bufferLength += numChars;
    }

    private void charactersRemoved(int numChars) {
        this.bufferStart += numChars;
        if (this.bufferStart >= this.bufferSize) {
            this.bufferStart -= this.bufferSize;
        }
        this.bufferLength -= numChars;
    }
}

