/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.Component;
import com.cisco.cpnm.boot.internal.Distribution;
import com.cisco.cpnm.boot.internal.SgzReader;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.compression.decoder.Decoder1_7;
import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Package
implements Handler,
VersionXml,
BootDebug {
    private static final byte NOT_LOADED = 0;
    private static final byte LOADING = 1;
    private static final byte LOADED = 2;
    private Distribution container;
    private String name;
    private String extension;
    private int size;
    private List components;
    private CharString currElem;
    private byte loadState;
    private int numLatest;
    private long loadTime = 0L;

    Package(Distribution container) {
        this.container = container;
        this.loadState = 0;
    }

    public Distribution getDistribution() {
        return this.container;
    }

    URL getFilesystem() {
        return this.container.getFilesystem();
    }

    String getName() {
        return this.name;
    }

    public int getMajorVersion() {
        return this.container.getMajorVersion();
    }

    public boolean isLocal() {
        return this.container.isLocal();
    }

    public boolean hasSavedComponents() {
        boolean hasSaved = false;
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!comp.isStored()) continue;
            hasSaved = true;
            break;
        }
        return hasSaved;
    }

    public String toString() {
        return this.name + "." + this.extension;
    }

    List getComponents() {
        return this.components;
    }

    void updateNumLatest(boolean isLatest) {
        this.numLatest = isLatest ? ++this.numLatest : --this.numLatest;
        this.container.updateNumLatest(isLatest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Package package_ = this;
        synchronized (package_) {
            if (this.loadState != 0) {
                return;
            }
            this.loadState = 1;
        }
        this.loadPackage();
        Package package_2 = this;
        synchronized (package_2) {
            this.loadState = (byte)2;
        }
    }

    private void loadPackage() {
        if (this.isLocal()) {
            this.loadCSIPackage();
        } else if (this.extension == null || this.extension.equals("")) {
            this.loadUnpackaged();
        } else if (this.extension.equals("sgz")) {
            this.loadSgzPackage();
        } else if (this.extension.equals("pfj")) {
            this.loadPfjPackage();
        } else {
            System.out.println("Unknown extension; ignoring " + this.name + '.' + this.extension);
        }
    }

    private void getContents(InputStream stream, byte[] inputBuff) throws IOException {
        int dst = 0;
        while (stream.available() > 0) {
            try {
                int n = stream.read(inputBuff, dst, inputBuff.length - dst);
                if (n <= 0) break;
                dst += n;
            }
            catch (EOFException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadUnpackaged() {
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!comp.isLatest()) continue;
            InputStream compStream = null;
            URL compFile = new URL(this.getFilesystem(), comp.getName());
            compStream = compFile.openStream();
            byte[] contents = new byte[comp.getSize()];
            this.getContents(compStream, contents);
            comp.setSigned(true);
            comp.setContents(contents);
            Object var7_8 = null;
            try {
                if (compStream == null) continue;
                compStream.close();
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
            continue;
            {
                catch (MalformedURLException mue) {
                    comp.setContentsNotFound();
                    mue.printStackTrace();
                    var7_8 = null;
                    try {
                        if (compStream == null) continue;
                        compStream.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException ioe) {
                    comp.setContentsNotFound();
                    ioe.printStackTrace();
                    var7_8 = null;
                    try {
                        if (compStream == null) continue;
                        compStream.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    if (compStream != null) {
                        compStream.close();
                    }
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadCSIPackage() {
        boolean signed = false;
        StringBuffer nameSb = new StringBuffer();
        String compName = null;
        Object fullName = null;
        URL fs = this.getFilesystem();
        nameSb.append(fs.getPath());
        nameSb.append("/v");
        nameSb.append(this.container.getMajorVersion());
        nameSb.append("/signed/");
        File signedPath = new File(nameSb.toString());
        nameSb.setLength(0);
        nameSb.append(fs.getPath());
        nameSb.append("/v");
        nameSb.append(this.container.getMajorVersion());
        nameSb.append("/unsigned/");
        File unsignedPath = new File(nameSb.toString());
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!comp.isLatest()) continue;
            InputStream compStream = null;
            compName = comp.getName();
            File compFile = new File(signedPath, compName);
            signed = true;
            if (!compFile.exists()) {
                compFile = new File(unsignedPath, compName);
                signed = false;
            }
            compStream = new FileInputStream(compFile);
            byte[] contents = new byte[comp.getSize()];
            this.getContents(compStream, contents);
            comp.setSigned(signed);
            comp.setContents(contents);
            comp.setStored(true);
            Object var14_14 = null;
            try {
                if (compStream == null) continue;
                compStream.close();
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
            continue;
            {
                catch (IOException ioe) {
                    comp.setContentsNotFound();
                    ioe.printStackTrace();
                    var14_14 = null;
                    try {
                        if (compStream == null) continue;
                        compStream.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                try {
                    if (compStream != null) {
                        compStream.close();
                    }
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSgzPackage() {
        URL pkgFile;
        try {
            pkgFile = new URL(this.getFilesystem(), this.name + "." + this.extension);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return;
        }
        InputStream pkgStream = null;
        SgzReader pkgReader = null;
        try {
            pkgStream = pkgFile.openStream();
            pkgReader = new SgzReader(pkgStream);
            Iterator iter = this.components.iterator();
            while (iter.hasNext()) {
                String nameInPkgFile;
                Component comp = (Component)iter.next();
                if (!comp.isLatest()) continue;
                String nameInVerFile = comp.getName();
                do {
                    if ((nameInPkgFile = pkgReader.getNextElement()) != null) continue;
                    this.markContentsNotFound(comp, iter);
                    return;
                } while (!nameInPkgFile.equals(nameInVerFile));
                int status = pkgReader.getElementStatus();
                if (status == 2) {
                    comp.setContentsNotFound();
                    continue;
                }
                comp.setSigned(status == 1);
                byte[] contents = pkgReader.getElementData();
                comp.setContents(contents);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (pkgReader != null) {
                    pkgReader.close();
                } else if (pkgStream != null) {
                    pkgStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPfjPackage() {
        URL pkgFile;
        try {
            pkgFile = new URL(this.getFilesystem(), this.name + "." + this.extension);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return;
        }
        InputStream pkgStream = null;
        Decoder1_7 pkgReader = null;
        try {
            pkgStream = pkgFile.openStream();
            pkgReader = new Decoder1_7(pkgStream);
            Iterator iter = this.components.iterator();
            while (iter.hasNext()) {
                String nameInPkgFile;
                Component comp = (Component)iter.next();
                if (!comp.isLatest()) continue;
                String nameInVerFile = comp.getName();
                do {
                    if ((nameInPkgFile = pkgReader.getNextElement()) != null) continue;
                    this.markContentsNotFound(comp, iter);
                    return;
                } while (!nameInPkgFile.equals(nameInVerFile));
                int status = pkgReader.getElementStatus();
                if (status == 2) {
                    comp.setContentsNotFound();
                    continue;
                }
                comp.setSigned(status == 1);
                byte[] contents = pkgReader.getElementData();
                comp.setContents(contents);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (pkgReader != null) {
                    pkgReader.close();
                } else if (pkgStream != null) {
                    pkgStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void markContentsNotFound(Component current, Iterator remaining) {
        current.setContentsNotFound();
        while (remaining.hasNext()) {
            Component comp = (Component)remaining.next();
            comp.setContentsNotFound();
        }
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString element) throws ParseException {
        this.currElem = null;
        if (element.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (element.equals(VersionXml.EXTENSION)) {
            this.currElem = VersionXml.EXTENSION;
        } else if (element.equals(VersionXml.SIZE)) {
            this.currElem = VersionXml.SIZE;
        } else if (element.equals(VersionXml.NUM_COMP)) {
            this.currElem = VersionXml.NUM_COMP;
        } else if (element.equals(VersionXml.COMPONENT)) {
            this.currElem = VersionXml.COMPONENT;
            Component comp = new Component(this);
            this.components.add(comp);
            parser.pushHandler(comp);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString data) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = data.toString();
        } else if (this.currElem == VersionXml.EXTENSION) {
            this.extension = data.toString();
        } else if (this.currElem == VersionXml.SIZE) {
            this.size = data.toInt();
        } else if (this.currElem == VersionXml.NUM_COMP) {
            this.components = new ArrayList(data.toInt());
        }
    }

    public void ignoredData(Parser parser, CharString data) throws ParseException {
        throw new ParseException(parser, "Unexpected ignored data");
    }

    public void endElement(Parser parser, CharString element) throws ParseException {
        if (element.equals(VersionXml.PACKAGE)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }

    public void outputVersionFile(PrintWriter out) {
        this.outputPrologue(out);
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!comp.isLatest()) continue;
            comp.outputVersionFile(out);
        }
        this.outputEpilogue(out);
    }

    private void outputPrologue(PrintWriter out) {
        out.print("  <");
        out.print(VersionXml.PACKAGE);
        out.println(">");
        out.print("   <");
        out.print(VersionXml.NAME);
        out.print(">");
        out.print(this.name);
        out.print("</");
        out.print(VersionXml.NAME);
        out.println(">");
        if (this.extension != null) {
            out.print("   <");
            out.print(VersionXml.EXTENSION);
            out.print(">");
            out.print(this.extension);
            out.print("</");
            out.print(VersionXml.EXTENSION);
            out.println(">");
        }
        out.print("   <");
        out.print(VersionXml.SIZE);
        out.print(">");
        out.print(this.size);
        out.print("</");
        out.print(VersionXml.SIZE);
        out.println(">");
        out.print("   <");
        out.print(VersionXml.NUM_COMP);
        out.print(">");
        out.print(this.components.size());
        out.print("</");
        out.print(VersionXml.NUM_COMP);
        out.println(">");
    }

    private void outputEpilogue(PrintWriter out) {
        out.print("  </");
        out.print(VersionXml.PACKAGE);
        out.println(">");
    }
}

