/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.external.DynamicDiscoveryListener;
import com.cisco.cpnm.boot.external.DynamicDiscoverySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DynamicDiscoveryDb
implements DynamicDiscoverySystem {
    private Map implementationMap = new HashMap();
    private Map listenerMap = new HashMap();

    synchronized void addDiscovered(String intfName, String implName) {
        ArrayList<String> implementations = (ArrayList<String>)this.implementationMap.get(intfName);
        if (implementations == null) {
            implementations = new ArrayList<String>();
            this.implementationMap.put(intfName, implementations);
        }
        if (!implementations.contains(implName)) {
            implementations.add(implName);
            this.notify(intfName, implementations, implementations.size() - 1);
        }
    }

    synchronized void removeDiscovered(String intfName, String implName) {
        List implementations = (List)this.implementationMap.get(intfName);
        if (implementations != null) {
            implementations.remove(implName);
        }
    }

    private synchronized void notify(String intfName, List implementations, int start) {
        List listeners = (List)this.listenerMap.get(intfName);
        if (listeners == null) {
            return;
        }
        List subList = implementations.subList(start, implementations.size());
        List unModList = Collections.unmodifiableList(subList);
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            DynamicDiscoveryListener listener = (DynamicDiscoveryListener)iter.next();
            listener.discovered(intfName, unModList);
        }
    }

    private synchronized void notify(DynamicDiscoveryListener listener, String interfaceName) {
        List implementations = (List)this.implementationMap.get(interfaceName);
        if (implementations == null) {
            return;
        }
        List unModList = Collections.unmodifiableList(implementations);
        listener.discovered(interfaceName, unModList);
    }

    public List getDiscovered(Class interfaceClass) {
        if (interfaceClass == null) {
            return null;
        }
        String interfaceName = interfaceClass.getName();
        return (List)this.implementationMap.get(interfaceName);
    }

    public synchronized void addListener(DynamicDiscoveryListener listener, Class interfaceClass) {
        if (interfaceClass == null || listener == null) {
            return;
        }
        String interfaceName = interfaceClass.getName();
        LinkedList<DynamicDiscoveryListener> listeners = (LinkedList<DynamicDiscoveryListener>)this.listenerMap.get(interfaceName);
        if (listeners == null) {
            listeners = new LinkedList<DynamicDiscoveryListener>();
            this.listenerMap.put(interfaceName, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            this.notify(listener, interfaceName);
        }
    }

    public synchronized void removeListener(DynamicDiscoveryListener listener, Class interfaceClass) {
        if (interfaceClass == null || listener == null) {
            return;
        }
        String interfaceName = interfaceClass.getName();
        List listeners = (List)this.listenerMap.get(interfaceName);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }
}

