/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.Component;
import com.cisco.cpnm.boot.internal.Distribution;
import com.cisco.cpnm.boot.internal.DynamicDiscoveryDb;
import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.PackageLoadHandler;
import com.cisco.cpnm.boot.internal.VersionFile;
import com.cisco.cpnm.boot.internal.VersionIntegrator;
import com.cisco.cpnm.boot.internal.VersionIntgHandler;
import com.cisco.cpnm.boot.internal.VersionReadHandler;
import com.cisco.cpnm.boot.internal.ccl.ClassData;
import com.cisco.cpnm.boot.internal.jobq.JobHandler;
import com.cisco.cpnm.boot.internal.jobq.JobOwner;
import com.cisco.cpnm.boot.internal.jobq.JobQueue;
import com.cisco.cpnm.boot.internal.util.JreVersion;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ComponentDb
implements JobOwner {
    private static final JreVersion CURR_JRE_VER = new JreVersion(System.getProperty("java.version"));
    private Map compMap = new HashMap();
    private DynamicDiscoveryDb dynDiscDb;
    private List versionFiles = new ArrayList(20);
    private boolean parsedFileSeen;
    private boolean majorCompatibleFileSeen;
    private boolean jreCompatibleFileSeen;
    private JreVersion minJre;
    private VersionIntegrator integrator;
    private JobQueue verReadQ = new JobQueue(this, 0);
    private JobQueue verIntgQ = new JobQueue(this, 1);
    private JobQueue pkgLoadQ = new JobQueue(this, 0);

    ComponentDb(DynamicDiscoveryDb dynDiscDb, VersionIntegrator integrator) {
        this.dynDiscDb = dynDiscDb;
        this.integrator = integrator;
        integrator.setComponentDb(this);
    }

    void integrateFile(URL filesystem, InputStream versionFile) {
        VersionFile file = new VersionFile(filesystem, versionFile);
        this.verReadQ.submit(file, false);
    }

    void waitForCompletion() {
        this.verReadQ.waitForCompletion();
        this.verIntgQ.waitForCompletion();
    }

    boolean addVersionFile(VersionFile verFile) {
        this.versionFiles.add(verFile);
        if (verFile.getParseException() != null) {
            return false;
        }
        this.parsedFileSeen = true;
        if (verFile.getMajorVersion() != 1) {
            return false;
        }
        this.majorCompatibleFileSeen = true;
        JreVersion verFileJre = verFile.getJreVersion();
        if (this.minJre == null || verFileJre.compareTo(this.minJre) < 0) {
            this.minJre = verFileJre;
        }
        if (verFileJre.compareTo(CURR_JRE_VER) > 0) {
            return false;
        }
        this.jreCompatibleFileSeen = true;
        return true;
    }

    int getStartupError() {
        if (!this.parsedFileSeen) {
            return 1;
        }
        if (!this.majorCompatibleFileSeen) {
            return 2;
        }
        if (!this.jreCompatibleFileSeen) {
            return 3;
        }
        return 0;
    }

    List getContribDists() {
        ArrayList<String> contrib = new ArrayList<String>();
        Iterator verFiles = this.versionFiles.iterator();
        while (verFiles.hasNext()) {
            VersionFile verFile = (VersionFile)verFiles.next();
            if (!verFile.isContributing()) continue;
            Iterator dists = verFile.getDistributions().iterator();
            while (dists.hasNext()) {
                Distribution dist = (Distribution)dists.next();
                if (!dist.isContributing()) continue;
                contrib.add(dist.getName());
            }
        }
        return contrib;
    }

    void integrateWithoutChecking(Package intgPkg) {
        List components = intgPkg.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            String compName = component.getName();
            this.compMap.put(compName, component);
            this.replaceComponent(null, component);
        }
    }

    void integrateWithChecking(Package intgPkg) {
        List components = intgPkg.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            String compName = component.getName();
            Component existing = (Component)this.compMap.get(compName);
            if (existing == null) {
                this.compMap.put(compName, component);
                this.replaceComponent(null, component);
                continue;
            }
            if (!component.isNewerThan(existing)) continue;
            this.compMap.put(compName, component);
            this.replaceComponent(existing, component);
        }
    }

    private void replaceComponent(Component oldComp, Component newComp) {
        String oldSuper = null;
        String newSuper = null;
        if (oldComp != null) {
            oldComp.setLatest(false);
            oldSuper = oldComp.getMarkedSuper();
        }
        newComp.setLatest(true);
        newSuper = newComp.getMarkedSuper();
        if (oldSuper != null) {
            if (oldSuper.equals(newSuper)) {
                return;
            }
            this.dynDiscDb.removeDiscovered(oldSuper, oldComp.getClassName());
        }
        if (newSuper != null) {
            this.dynDiscDb.addDiscovered(newSuper, newComp.getClassName());
        }
    }

    ClassData getClassData(String name) {
        String classFilename = name.replace('.', '/') + ".class";
        Component component = (Component)this.compMap.get(classFilename);
        if (component == null) {
            return null;
        }
        byte[] bytecode = this.getContents(component);
        if (bytecode == null) {
            return null;
        }
        return component;
    }

    InputStream getStream(String name) {
        Component component = (Component)this.compMap.get(name);
        if (component == null) {
            return null;
        }
        byte[] bytes = this.getContents(component);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        return stream;
    }

    protected boolean contains(String name) {
        return this.compMap.get(name) != null;
    }

    private byte[] getContents(Component component) {
        Component component2 = component;
        synchronized (component2) {
            if (component.isContentsLoaded()) {
                byte[] byArray = component.getContents();
                return byArray;
            }
            if (component.isContentsNotFound()) {
                byte[] byArray = null;
                return byArray;
            }
            Package pkg = component.getPackage();
            this.pkgLoadQ.submit(pkg, false);
            do {
                try {
                    component.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (!component.isContentsLoaded() && !component.isContentsNotFound());
            byte[] byArray = component.getContents();
            return byArray;
        }
    }

    public JobHandler createHandler(JobQueue queue) {
        JobHandler handler = null;
        if (queue == this.verReadQ) {
            handler = new VersionReadHandler(this.verIntgQ);
        } else if (queue == this.verIntgQ) {
            handler = new VersionIntgHandler(this, this.integrator);
        } else if (queue == this.pkgLoadQ) {
            handler = new PackageLoadHandler();
        }
        return handler;
    }
}

