/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.RootPaneContainer;

public class ModalDialog {
    private static Listener listener = new Listener();
    private static Hashtable parents = new Hashtable();
    private static Hashtable delegates = new Hashtable();

    public static void setParentBlocked(Dialog dialog, boolean bl) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)parents.get(dialog);
        if (rootPaneContainer == null) {
            return;
        }
        Component component = rootPaneContainer.getGlassPane();
        if (bl) {
            component.setVisible(true);
            component.addMouseListener(listener);
            component.addKeyListener(listener);
        } else {
            component.setVisible(false);
            component.removeMouseListener(listener);
            component.removeKeyListener(listener);
        }
    }

    public static void show(RootPaneContainer rootPaneContainer, Dialog dialog, ParentDelegate parentDelegate) {
        parents.put(dialog, rootPaneContainer);
        if (parentDelegate != null) {
            delegates.put(dialog, parentDelegate);
        }
        dialog.setModal(false);
        dialog.addWindowListener(listener);
        dialog.show();
    }

    public static interface ParentDelegate {
        public void modalDialogClosed(Dialog var1);
    }

    private static class Listener
    implements MouseListener,
    KeyListener,
    WindowListener {
        Listener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            Toolkit.getDefaultToolkit().beep();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Toolkit.getDefaultToolkit().beep();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)windowEvent.getSource();
            ModalDialog.setParentBlocked(dialog, false);
            ParentDelegate parentDelegate = (ParentDelegate)delegates.get(dialog);
            if (parentDelegate != null) {
                parentDelegate.modalDialogClosed(dialog);
            }
            parents.remove(dialog);
            delegates.remove(dialog);
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)windowEvent.getSource();
            ModalDialog.setParentBlocked(dialog, true);
        }
    }
}

