/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LinkGraph
extends Graph {
    private static String[] dataTypeStrings = new String[]{"% Utilization", "Total Bytes", "Total Packets", "Total Errors"};
    private JComboBox deviceSelectionCombo;
    private JComboBox portSelectionCombo;
    private JComboBox dataSelectionCombo;
    private JPanel topRightPanel;

    public LinkGraph(JApplet jApplet, CommonSwitch commonSwitch, String string, String string2) {
        this(jApplet, null, commonSwitch, string);
        this.setTitle("Link Graph: " + string2);
    }

    public LinkGraph(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch, String string) {
        super(jApplet, commonSwitchArray, commonSwitch, string);
        this.setTitle("Link Graph");
    }

    public void helpClicked() {
        HelpDialog.Factory.showHelp(this.theApplet, "lnkbdwin");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.deviceSelectionCombo) {
            int n = this.deviceSelectionCombo.getSelectedIndex();
            if (this.switches[n].statusCode.equals("Down")) {
                JOptionPane.showMessageDialog(this, "The selected switch is down.", "Link Graph", 0);
                this.deviceSelectionCombo.setSelectedItem(this.switches[this.switchIndex].switchName);
                return;
            }
            this.switchIndex = n;
            this.theSwitch = this.switches[this.switchIndex];
            this.populatePortSelectionPanel(null, this.portSelectionCombo);
            if (this.portSelectionCombo.getComponentCount() == 0) {
                this.mapper.setPort(null);
            }
        } else if (object == this.portSelectionCombo) {
            this.mapper.setPort((String)this.portSelectionCombo.getSelectedItem());
        } else {
            super.itemStateChanged(itemEvent);
        }
    }

    public void layoutTopPanel() {
        super.layoutTopPanel();
        if (!this.theApplet.getClass().getName().equalsIgnoreCase("Cluster")) {
            JPanel jPanel = new JPanel();
            if (this.theApplet.getClass().getName().equalsIgnoreCase("ClusterManager")) {
                this.deviceSelectionCombo = new JComboBox();
                this.populateDeviceSelectionPanel(jPanel, this.deviceSelectionCombo);
            }
            this.portSelectionCombo = new JComboBox();
            this.populatePortSelectionPanel(this.initialPortName, this.portSelectionCombo);
            this.portSelectionCombo.addItemListener(this);
            jPanel.add(new JLabel("Port:"));
            jPanel.add(this.portSelectionCombo);
            this.topPanel.add((Component)jPanel, "North");
        }
        this.topRightPanel = new JPanel();
        this.dataSelectionCombo = new JComboBox();
        this.populateDataTypePanel(this.topRightPanel, this.dataSelectionCombo, dataTypeStrings);
        this.dataSelectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LinkGraph.this.mapper.setDataType(LinkGraph.this.dataSelectionCombo.getSelectedIndex());
            }
        });
        this.topPanel.add((Component)this.topRightPanel, "East");
    }

    public void startGraphMapper() {
        super.startGraphMapper(0, this.initialPortName);
    }
}

