/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BandwidthGraph
extends Graph {
    private JComboBox deviceSelectionCombo;

    public BandwidthGraph(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(jApplet, commonSwitchArray, commonSwitch);
        if (commonSwitchArray != null) {
            this.setTitle("Device Bandwidth Graph");
        } else {
            this.setTitle("Device Bandwidth Graph: " + commonSwitch.switchName);
        }
    }

    public void helpClicked() {
        HelpDialog.Factory.showHelp(this.theApplet, "bandwdth");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.deviceSelectionCombo) {
            int n = 0;
            String string = (String)this.deviceSelectionCombo.getSelectedItem();
            n = 0;
            while (n < this.switches.length) {
                if (this.switches[n].switchName.equals(string)) break;
                ++n;
            }
            if (this.switches[n].statusCode.equals("Down")) {
                JOptionPane.showMessageDialog(this, "The selected switch is down.", "Bandwidth Graph", 0);
                this.deviceSelectionCombo.setSelectedItem(this.switches[this.switchIndex].switchName);
                return;
            }
            this.switchIndex = n;
            this.theSwitch = this.switches[this.switchIndex];
            this.mapper.setDevice(this.theSwitch);
        } else {
            super.itemStateChanged(itemEvent);
        }
    }

    public void layoutTopPanel() {
        super.layoutTopPanel();
        if (this.theApplet.getClass().getName().equalsIgnoreCase("ClusterManager")) {
            JPanel jPanel = new JPanel();
            this.deviceSelectionCombo = new JComboBox();
            this.populateDeviceSelectionPanel(jPanel, this.deviceSelectionCombo);
            this.topPanel.add((Component)jPanel, "North");
        }
    }

    public void startGraphMapper() {
        this.startGraphMapper(4, null);
    }
}

