/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class SuggCandDialog
extends JFrame
implements ActionListener,
ItemListener,
WindowListener {
    JTable candidates;
    Hashtable infoTable = new Hashtable(15);
    JLabel enablePasswordLabel;
    JPasswordField passwordField;
    JLabel okMessage;
    JLabel cancelMessage;
    JLabel labelLine1;
    JLabel labelLine2;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    JCheckBox showWindow;
    Cluster sTopo;
    String sTopoHost;
    ClusterCLI clusterCLI;
    Preferences prefs = null;
    int maxSelectable;

    public SuggCandDialog(Cluster cluster) {
        Container container = this.getContentPane();
        this.sTopo = cluster;
        this.sTopoHost = cluster.clusterPanel.sTopoHost;
        this.clusterCLI = cluster.clusterPanel.clusterCLI;
        boolean bl = false;
        CandidateTableModel candidateTableModel = this.getCandidates();
        this.prefs = new Preferences(this.clusterCLI);
        boolean bl2 = this.prefs.getSuggested_candidate_window();
        if (bl2 && candidateTableModel != null) {
            EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
            container.setLayout(new BorderLayout());
            this.setTitle("Suggested Candidate Window");
            ((Component)this).setBounds(1, 1, 513, 305);
            this.setResizable(false);
            container.setBackground(new Color(-3355444));
            JPanel jPanel = new JPanel();
            this.candidates = new JTable(candidateTableModel);
            this.candidates.setPreferredScrollableViewportSize(new Dimension(400, 150));
            this.candidates.setSelectionMode(2);
            JScrollPane jScrollPane = new JScrollPane(this.candidates);
            jPanel.setBorder(emptyBorder);
            jPanel.add(jScrollPane);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.labelLine1 = new JLabel("Highlighted switches are qualified cluster candidates.");
            jPanel2.add((Component)this.labelLine1, "North");
            this.enablePasswordLabel = new JLabel("Current password of highlighted candidates ");
            jPanel2.add((Component)this.enablePasswordLabel, "West");
            this.passwordField = new JPasswordField();
            this.passwordField.setEchoChar('*');
            ((JTextComponent)this.passwordField).setText("");
            this.passwordField.setColumns(15);
            jPanel2.add((Component)this.passwordField, "East");
            this.passwordField.addActionListener(this);
            jPanel2.setBorder(emptyBorder);
            container.add((Component)jPanel2, "North");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(1, 5, 5));
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this);
            jPanel3.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(this);
            jPanel3.add(this.cancelButton);
            this.helpButton = new JButton();
            this.helpButton.setText("Help");
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SuggCandDialog.this.invokeHelp();
                }
            });
            jPanel3.add(this.helpButton);
            ListSelectionModel listSelectionModel = this.candidates.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        SuggCandDialog.this.okButton.setEnabled(false);
                    } else {
                        SuggCandDialog.this.okButton.setEnabled(true);
                    }
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)new JLabel("Add all qualified candidates to cluster"), "North");
            jPanel4.add((Component)jPanel3, "Center");
            jPanel4.setBorder(emptyBorder);
            this.showWindow = new JCheckBox("Show suggested candidates every time Cluster Builder starts", bl2);
            this.showWindow.addItemListener(this);
            jPanel4.add((Component)this.showWindow, "South");
            container.add((Component)jPanel4, "South");
            this.selectCandidates(this.candidates);
            this.addWindowListener(this);
            container.doLayout();
            this.pack();
            this.show();
            this.passwordField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton || object == this.passwordField) {
            this.okButton.requestFocus();
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.okButtonPressed();
        } else if (object == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.dispose();
    }

    private void checkBoxAction(ItemEvent itemEvent) {
        boolean bl = false;
        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
        boolean bl2 = false;
        boolean bl3 = this.prefs.getSuggested_candidate_window();
        ((Component)this).setCursor(new Cursor(3));
        if (jCheckBox.isSelected()) {
            if (bl3) {
                bl2 = true;
            } else {
                bl = true;
            }
        } else if (!bl3) {
            bl2 = true;
        } else {
            bl = false;
        }
        if (!bl2) {
            this.prefs.setSuggested_candidate_window(bl);
            this.prefs.savePreferences();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private void displayErrors(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("These errors were detected : \n");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            String string2 = (String)objectArray[0];
            String string3 = (String)objectArray[1];
            int n = string3.indexOf("%ERROR");
            int n2 = string3.indexOf("</DL><HR><PRE>");
            string3 = string3.substring(n, n2);
            stringBuffer.append(string2);
            stringBuffer.append(" : ");
            stringBuffer.append(string3);
            stringBuffer.append("\n");
        }
        JOptionPane.showMessageDialog(null, stringBuffer.toString(), string, 0);
    }

    private CandidateTableModel getCandidates() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        CandidateTableModel candidateTableModel = new CandidateTableModel();
        ClusterPanel cfr_ignored_0 = this.sTopo.clusterPanel;
        if (this.sTopo.clusterPanel.numClusterNodes < 16 && (string = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster candidates html", "exec")) != null) {
            CLIResponse cLIResponse = new CLIResponse(string);
            this.infoTable.clear();
            if (string.indexOf("Operation timed out") == -1 && string.indexOf("this[i++] = ") != -1 && cLIResponse.getLineCount() > 0) {
                while (cLIResponse.hasMoreLines()) {
                    CLILine cLILine = cLIResponse.nextLine();
                    string5 = cLILine.getFieldAt(7);
                    if (string5.compareTo("E") == 0) continue;
                    string2 = cLILine.getFieldAt(0);
                    string3 = cLILine.getFieldAt(1);
                    string4 = cLILine.getFieldAt(4);
                    string5 = "es" + cLILine.getFieldAt(8);
                    string6 = cLILine.getFieldAt(12);
                    String string11 = cLILine.getFieldAt(14);
                    int n = string11 != null && string11.compareTo("") != 0 ? Integer.parseInt(string11) : 0;
                    string7 = string4;
                    if (this.infoTable.get(string7) != null) continue;
                    if (string6.compareTo("") != 0) {
                        this.infoTable.put(string7, new Integer(string6));
                    } else {
                        this.infoTable.put(string7, new Integer(-1));
                    }
                    candidateTableModel.addEntry(string2, string3, string4, string5, n);
                }
            }
        }
        if (candidateTableModel.getRowCount() > 0) {
            return candidateTableModel;
        }
        return null;
    }

    private void invokeHelp() {
        HelpDialog.Factory.showHelp((JApplet)((Object)this.sTopo), (String)"suggcand");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox) {
            this.checkBoxAction(itemEvent);
        }
    }

    private void okButtonPressed() {
        Thread thread = new Thread(){

            public void run() {
                Vector<Object[]> vector = new Vector<Object[]>();
                String string = new String(SuggCandDialog.this.passwordField.getPassword());
                ClusterCLI clusterCLI = SuggCandDialog.this.sTopo.clusterPanel.clusterCLI;
                String string2 = "";
                int n = -1;
                String string3 = "";
                int[] nArray = SuggCandDialog.this.candidates.getSelectedRows();
                CandidateTableModel candidateTableModel = (CandidateTableModel)SuggCandDialog.this.candidates.getModel();
                if (SuggCandDialog.this.candidates.getSelectedRowCount() <= SuggCandDialog.this.maxSelectable) {
                    Object[] objectArray;
                    ((Component)SuggCandDialog.this).setCursor(new Cursor(3));
                    SuggCandDialog.this.sTopo.setAllowUpdates(false);
                    Vector<Object[]> vector2 = new Vector<Object[]>();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        objectArray = new Object[2];
                        n = nArray[n2];
                        objectArray[0] = (String)candidateTableModel.getValueAt(n, 0);
                        objectArray[1] = (String)candidateTableModel.getValueAt(n, 2);
                        vector2.addElement(objectArray);
                        ++n2;
                    }
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        int n3;
                        objectArray = (Object[])enumeration.nextElement();
                        String string4 = (String)objectArray[0];
                        String string5 = (String)objectArray[1];
                        int n4 = (Integer)SuggCandDialog.this.infoTable.get(string5);
                        if (n4 == -1) {
                            n4 = clusterCLI.getUnusedClusterMemberNumber((Applet)((Object)SuggCandDialog.this.sTopo));
                        }
                        string2 = "cluster member mac " + string5;
                        if (string.compareTo("") != 0) {
                            string2 = String.valueOf(string2) + " password " + string;
                        }
                        if ((n3 = (string3 = clusterCLI.runCLICommand(SuggCandDialog.this.sTopo.clusterPanel.sTopoHost, string2, "configure")).indexOf("%ERROR")) == -1) continue;
                        Object[] objectArray2 = new Object[]{string4, string3};
                        vector.addElement(objectArray2);
                    }
                    if (vector.size() > 0) {
                        SuggCandDialog.this.displayErrors(vector, "Error: Failure Adding Candidates");
                        candidateTableModel = SuggCandDialog.this.getCandidates();
                        SuggCandDialog.this.candidates.setModel(candidateTableModel);
                        SuggCandDialog.this.candidates.sizeColumnsToFit(-1);
                        SuggCandDialog.this.selectCandidates(SuggCandDialog.this.candidates);
                        if (SuggCandDialog.this.maxSelectable > 0) {
                            SuggCandDialog.this.okButton.setEnabled(true);
                            SuggCandDialog.this.cancelButton.setEnabled(true);
                            SuggCandDialog.this.passwordField.setEnabled(true);
                        } else {
                            SuggCandDialog.this.dispose();
                        }
                    } else {
                        SuggCandDialog.this.sTopo.clusterPanel.waitForSwitchAndUpdateView(false, 1000);
                        SuggCandDialog.this.dispose();
                    }
                    ((Component)SuggCandDialog.this).setCursor(new Cursor(0));
                    SuggCandDialog.this.sTopo.setAllowUpdates(true);
                } else {
                    String string6 = "Too many devices selected.\n\n";
                    string6 = String.valueOf(string6) + "The maximum number of 16 members would be exceeded.\n";
                    string6 = String.valueOf(string6) + "Change your selection and resubmit your request.";
                    JOptionPane.showMessageDialog(null, string6, "Error : Cluster Member Limit Exceeded", 0);
                }
            }
        };
        thread.start();
    }

    private void selectCandidates(JTable jTable) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        ClusterPanel cfr_ignored_0 = this.sTopo.clusterPanel;
        this.maxSelectable = Math.min(16 - this.sTopo.clusterPanel.getMemberCount(), jTable.getRowCount());
        if (this.maxSelectable > 0) {
            listSelectionModel.setSelectionInterval(0, this.maxSelectable - 1);
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

