/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;

public class LinkPanel
extends JPanel
implements ActionListener {
    protected JPanel portPanel;
    protected JComboBox portComboBox;
    protected JPanel portInfoPanel;
    protected JPanel buttonPanel;
    protected JLabel portGroupLabel;
    protected JLabel portGroup;
    protected JLabel portSpeedLabel;
    protected JLabel portSpeed;
    protected JLabel duplexTypeLabel;
    protected JLabel duplexType;
    protected JPanel addressPanel;
    protected JComboBox addressComboBox;
    protected JLabel vlanLabel;
    protected JComboBox vlanComboBox;
    protected JLabel addresstypeLabel;
    protected JScrollPane addresslistScrollPane;
    protected JViewport JViewport3;
    protected JList addressList;
    protected JScrollBar scrollBar5;
    protected JScrollBar scrollBar6;
    protected JLabel macAddrLabel;
    protected JLabel STPLabel;
    protected JLabel STPValue;
    protected JPanel devicePanel;
    protected JLabel deviceNameLabel;
    protected JLabel deviceName;
    protected CommonIOSCLIs commonIOSCLIs;
    protected CommandCLIs commandCLIs;
    protected c2900CLIs c2900CLIs;
    protected String esn;
    protected String hostName;
    protected String portName;
    protected String resn;
    protected int groupNumber;
    protected String interfaceType;
    protected int slotNumber;
    protected int portNumber;
    protected String portSpeedValue;
    protected String portDuplexValue;
    protected String addressType;
    protected String vlanId;
    protected String stpStateValue;
    protected LinkFrame parent;
    protected JPanel otherPanel;
    protected String loc;
    String[] macAddresses;
    String[] allPortNames;
    Vector portPairs;
    protected DefaultListModel addressListModel;

    public LinkPanel(JFrame jFrame, String string, String string2, String string3, String string4, String string5) {
        String string6 = Cluster.getCodeBaseHost();
        this.commonIOSCLIs = new CommonIOSCLIs(string6);
        this.commandCLIs = new CommandCLIs(string6);
        this.c2900CLIs = new c2900CLIs(string6);
        this.addressType = "dynamic";
        this.vlanId = "1";
        this.addressListModel = new DefaultListModel();
        this.vlanComboBox = new JComboBox();
        this.portPairs = new Vector();
        this.otherPanel = new JPanel();
        this.parent = (LinkFrame)jFrame;
        this.hostName = string.trim();
        this.esn = string2.trim();
        this.portName = string3.trim();
        this.resn = string5 != null ? string5.trim() : null;
        this.parsePortName(string3);
        this.loc = string4.trim();
        this.getInitialPopulateInfo();
        this.setLayout(new BorderLayout());
        this.portPanel = new JPanel();
        this.portPanel.setBorder(new TitledBorder(null, "Link Ports", 1, 2, new Font("Dialog", 1, 12)));
        this.portPanel.setLayout(new GridBagLayout());
        this.portComboBox = new JComboBox<String>(this.allPortNames);
        this.portComboBox.setMaximumRowCount(4);
        if (this.portComboBox.getItemCount() > 0) {
            int n = 0;
            while (n < this.portComboBox.getItemCount()) {
                if (((String)this.portComboBox.getItemAt(n)).trim().equals(this.portName)) {
                    this.portComboBox.setSelectedIndex(n);
                }
                ++n;
            }
        }
        this.portComboBox.addActionListener(this);
        this.portInfoPanel = new JPanel();
        this.portInfoPanel.setBorder(new TitledBorder(null, "Port Information", 1, 2, new Font("Dialog", 1, 12)));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        this.portInfoPanel.setLayout(flowLayout);
        this.buttonPanel = new JPanel();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(2);
        gridLayout.setRows(3);
        gridLayout.setVgap(6);
        gridLayout.setHgap(6);
        this.buttonPanel.setLayout(gridLayout);
        this.portGroupLabel = new JLabel();
        this.portGroupLabel.setText("Port Group :");
        this.portGroup = new JLabel();
        this.portGroup.setForeground(new Color(0, 0, 0));
        if (this.groupNumber > 0) {
            this.portGroup.setText(Integer.toString(this.groupNumber));
        } else {
            this.portGroup.setText("");
        }
        this.portSpeedLabel = new JLabel();
        this.portSpeedLabel.setText("Speed :");
        this.portSpeed = new JLabel();
        this.portSpeed.setForeground(new Color(0, 0, 0));
        this.portSpeed.setText(this.portSpeedValue.trim());
        this.duplexTypeLabel = new JLabel();
        this.duplexTypeLabel.setText("Duplex :");
        this.duplexType = new JLabel();
        this.duplexType.setForeground(new Color(0, 0, 0));
        this.duplexType.setText(this.portDuplexValue.trim());
        this.buttonPanel.add(this.portGroupLabel, null, -1);
        this.buttonPanel.add(this.portGroup, null, -1);
        this.buttonPanel.add(this.portSpeedLabel, null, -1);
        this.buttonPanel.add(this.portSpeed, null, -1);
        this.buttonPanel.add(this.duplexTypeLabel, null, -1);
        this.buttonPanel.add(this.duplexType, null, -1);
        this.portInfoPanel.add(this.buttonPanel, null, -1);
        this.addressPanel = new JPanel();
        this.addressPanel.setBorder(new TitledBorder(null, "Address", 1, 2, new Font("Dialog", 1, 12)));
        this.addressPanel.setLayout(new GridBagLayout());
        this.addressComboBox = new JComboBox();
        this.vlanLabel = new JLabel();
        this.vlanLabel.setText("VLAN Id :");
        this.vlanComboBox.addActionListener(this);
        this.vlanComboBox.setMaximumRowCount(4);
        String[] stringArray = new String[]{"Dynamic", "Static", "Secure"};
        this.addressComboBox = new JComboBox<String>(stringArray);
        this.addressComboBox.addActionListener(this);
        this.addressComboBox.setMaximumRowCount(4);
        this.addresstypeLabel = new JLabel();
        this.addresstypeLabel.setText("Address Type :");
        this.addresslistScrollPane = new JScrollPane();
        this.JViewport3 = this.addresslistScrollPane.getViewport();
        this.addressList = new JList(this.addressListModel);
        this.JViewport3.add(this.addressList, null, -1);
        this.scrollBar5 = this.addresslistScrollPane.getHorizontalScrollBar();
        this.scrollBar6 = this.addresslistScrollPane.getVerticalScrollBar();
        this.macAddrLabel = new JLabel();
        this.macAddrLabel.setText("MAC Addresses:");
        this.STPLabel = new JLabel();
        this.STPLabel.setText("STP:");
        this.STPValue = new JLabel();
        this.STPValue.setForeground(new Color(0, 0, 0));
        this.STPValue.setText(this.stpStateValue);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.addressPanel.add(this.addressComboBox, gridBagConstraints, -1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.addressPanel.add(this.vlanLabel, gridBagConstraints, -1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.addressPanel.add(this.vlanComboBox, gridBagConstraints, -1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.addressPanel.add(this.addresstypeLabel, gridBagConstraints, -1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addressPanel.add(this.addresslistScrollPane, gridBagConstraints, -1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addressPanel.add(this.macAddrLabel, gridBagConstraints, -1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        this.addressPanel.add(this.STPLabel, gridBagConstraints, -1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.addressPanel.add(this.STPValue, gridBagConstraints, -1);
        this.portPanel.add(this.portComboBox, null, -1);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints2.weightx = 1.0;
        this.portPanel.add(this.portInfoPanel, gridBagConstraints2, -1);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(0, 6, 6, 6);
        gridBagConstraints2.weighty = 1.0;
        this.portPanel.add(this.addressPanel, gridBagConstraints2, -1);
        this.devicePanel = new JPanel();
        this.devicePanel.setLayout(new GridBagLayout());
        this.deviceNameLabel = new JLabel();
        this.deviceNameLabel.setText("Host Name :");
        this.deviceName = new JLabel();
        this.deviceName.setForeground(new Color(0, 0, 0));
        if (this.hostName != null) {
            this.deviceName.setText(this.hostName);
        }
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(6, 0, 6, 6);
        this.devicePanel.add(this.deviceNameLabel, gridBagConstraints3, -1);
        gridBagConstraints3.gridx = 1;
        this.devicePanel.add(this.deviceName, gridBagConstraints3, -1);
        String string7 = "Center";
        this.add(this.portPanel, string7, -1);
        string7 = "North";
        this.add(this.devicePanel, string7, -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        if (actionEvent.getSource().equals(this.addressComboBox)) {
            this.addressType = ((String)jComboBox.getSelectedItem()).toLowerCase().trim();
            this.getMacAddress();
        } else if (actionEvent.getSource().equals(this.vlanComboBox)) {
            this.vlanId = ((String)jComboBox.getSelectedItem()).toLowerCase().trim();
            this.getMacAddress();
            this.getSTPState();
            this.STPValue.setText(this.stpStateValue);
            this.repaint();
        } else if (actionEvent.getSource().equals(this.portComboBox)) {
            this.updatePortInfo(((String)((JComboBox)actionEvent.getSource()).getSelectedItem()).trim());
        }
    }

    protected void getGroupMembers() {
        if (this.groupNumber > 0) {
            this.allPortNames = this.c2900CLIs.getAllPorts(this.esn, this.groupNumber);
        } else if (this.portName != null) {
            this.allPortNames = new String[1];
            this.allPortNames[0] = this.portName;
        }
    }

    protected void getInitialPopulateInfo() {
        this.groupNumber = this.c2900CLIs.getMyGroup(this.esn, this.portName);
        if (this.groupNumber != 0) {
            this.getGroupMembers();
        } else if (this.portName != null) {
            this.allPortNames = new String[1];
            this.allPortNames[0] = this.portName;
        }
        if (this.resn != null) {
            this.makePortPairs();
        }
        if (this.interfaceType != "GigabitEthernet") {
            this.portSpeedValue = this.commonIOSCLIs.getPortSpeedActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber);
            if (this.portSpeedValue == null) {
                this.portSpeedValue = "";
            }
        } else {
            this.portSpeedValue = "1000";
        }
        if ((this.portDuplexValue = this.commonIOSCLIs.getPortDuplexActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber)) == null) {
            this.portDuplexValue = "";
        }
        this.getVlans();
        this.getMacAddress();
        this.getSTPState();
    }

    protected void getMacAddress() {
        block4: {
            this.addressListModel.removeAllElements();
            this.macAddresses = this.c2900CLIs.getMacAddress(this.esn, this.addressType, this.interfaceType, this.slotNumber, this.portNumber, this.vlanId);
            if (this.macAddresses == null) break block4;
            if (this.addressType.equals("static")) {
                int n = this.macAddresses[0].indexOf(" ");
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(this.macAddresses[0], " ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addressListModel.addElement(stringTokenizer.nextToken());
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                }
            } else {
                int n = 0;
                while (n < this.macAddresses.length) {
                    int n2 = this.macAddresses[n].indexOf(" ");
                    this.addressListModel.addElement(this.macAddresses[n].substring(0, n2));
                    ++n;
                }
            }
        }
    }

    void getOtherPanel() {
        this.otherPanel = this.loc == "leftPanel" ? this.parent.getRightPanel() : this.parent.getLeftPanel();
        if (this.portPairs.size() == 0 && this.otherPanel != null) {
            this.portPairs = ((LinkPanel)this.otherPanel).getPortPairs();
        }
    }

    public Vector getPortPairs() {
        return this.portPairs;
    }

    protected void getSTPState() {
        this.stpStateValue = this.c2900CLIs.getSTPState(this.esn, this.vlanId, this.interfaceType, this.slotNumber, this.portNumber);
        if (this.stpStateValue == null) {
            this.stpStateValue = null;
        }
    }

    protected void getVlans() {
        String string;
        boolean bl = false;
        if (this.vlanComboBox.getItemCount() > 0) {
            this.vlanComboBox.removeAllItems();
        }
        if ((string = this.commonIOSCLIs.getVlanMembership(this.esn, this.interfaceType, this.slotNumber, this.portNumber)) != null) {
            string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.indexOf("-") >= 0) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                    String string3 = stringTokenizer2.nextToken();
                    String string4 = stringTokenizer2.nextToken();
                    int n = Integer.parseInt(string3);
                    while (n <= Integer.parseInt(string4)) {
                        this.vlanComboBox.addItem(Integer.toString(n));
                        ++n;
                    }
                    continue;
                }
                this.vlanComboBox.addItem(string2);
            }
        }
        if (string != null) {
            this.vlanId = (String)this.vlanComboBox.getItemAt(0);
        }
    }

    protected String makePortName(String string) {
        int n = string.indexOf(47);
        String string2 = null;
        switch (string.charAt(0)) {
            case 'F': 
            case 'f': {
                string2 = "FastEthernet";
                break;
            }
            case 'G': 
            case 'g': {
                string2 = "GigabitEthernet";
                break;
            }
            case 'A': 
            case 'a': {
                string2 = "ATM";
                break;
            }
        }
        return String.valueOf(string2) + string.substring(n - 1, n) + "/" + string.substring(n + 1, string.length());
    }

    protected void makePortPairs() {
        String[] stringArray = this.c2900CLIs.getClusterPortNeighbor(null, Integer.parseInt(this.esn.trim().substring(2, this.esn.length())));
        if (stringArray[0] != null && stringArray[0].trim().length() > 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n].trim();
                String string = null;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ",");
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[n], ",");
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n2;
                }
                int n3 = Integer.parseInt(stringTokenizer2.nextToken());
                String string2 = stringTokenizer2.nextToken();
                if (n2 > 7) {
                    stringTokenizer2.nextToken();
                }
                int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                int n5 = Integer.parseInt(stringTokenizer2.nextToken());
                String string3 = stringTokenizer2.nextToken();
                if (n2 > 7) {
                    stringTokenizer2.nextToken();
                }
                int n6 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n4 == this.groupNumber && n5 == Integer.parseInt(this.resn.substring(2, this.resn.length()))) {
                    string = String.valueOf(this.makePortName(string2)) + "," + this.makePortName(string3);
                    this.portPairs.addElement(string);
                } else if (n6 == this.groupNumber && n3 == Integer.parseInt(this.resn.substring(2, this.resn.length()))) {
                    string = String.valueOf(this.makePortName(string3)) + "," + this.makePortName(string2);
                    this.portPairs.addElement(string);
                }
                ++n;
            }
        }
        this.portPairs.trimToSize();
    }

    protected void parsePortName(String string) {
        int n = string.indexOf(47);
        switch (string.charAt(0)) {
            case 'F': 
            case 'f': {
                this.interfaceType = "FastEthernet";
                break;
            }
            case 'G': 
            case 'g': {
                this.interfaceType = "GigabitEthernet";
                break;
            }
            case 'A': 
            case 'a': {
                this.interfaceType = "ATM";
                break;
            }
        }
        this.slotNumber = Integer.parseInt(string.substring(n - 1, n));
        this.portNumber = Integer.parseInt(string.substring(n + 1, string.length()));
        if (n <= string.length()) {
            this.portName = String.valueOf(this.interfaceType) + this.slotNumber + "/" + this.portNumber;
        }
    }

    protected void parsePortString(String string) {
        int n = string.indexOf(45);
        switch (string.charAt(0)) {
            case 'F': 
            case 'f': {
                this.interfaceType = "FastEthernet";
                break;
            }
            case 'G': 
            case 'g': {
                this.interfaceType = "GigabitEthernet";
                break;
            }
            case 'A': 
            case 'a': {
                this.interfaceType = "ATM";
                break;
            }
        }
        this.slotNumber = Integer.parseInt(string.substring(n - 1, n));
        this.portNumber = Integer.parseInt(string.substring(n + 1, string.length()));
        if (n <= string.length()) {
            this.portName = String.valueOf(this.interfaceType) + this.slotNumber + "/" + this.portNumber;
        }
    }

    protected void updatePortInfo(String string) {
        int n;
        int n2 = 0;
        this.getOtherPanel();
        this.portPairs.trimToSize();
        this.portComboBox.removeActionListener(this);
        if (this.portComboBox.getItemCount() > 0) {
            n = 0;
            while (n < this.portComboBox.getItemCount()) {
                if (((String)this.portComboBox.getItemAt(n)).trim().equals(string.trim())) {
                    this.portComboBox.setSelectedIndex(n);
                }
                ++n;
            }
        }
        this.portComboBox.addActionListener(this);
        n = 0;
        while (n < this.portPairs.size()) {
            if (((String)this.portPairs.elementAt(n)).indexOf(string) >= 0) {
                n2 = ((String)this.portPairs.elementAt(n)).indexOf(44);
                String string2 = ((String)this.portPairs.elementAt(n)).indexOf(string) < n2 ? ((String)this.portPairs.elementAt(n)).substring(n2 + 1, ((String)this.portPairs.elementAt(n)).length()) : ((String)this.portPairs.elementAt(n)).substring(0, n2);
                if (this.otherPanel != null) {
                    ((LinkPanel)this.otherPanel).updateRemotePortInfo(string2);
                }
            }
            this.parsePortName(string);
            this.portSpeedValue = this.commonIOSCLIs.getPortSpeedActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber);
            this.portSpeed.setText(this.portSpeedValue);
            this.portDuplexValue = this.commonIOSCLIs.getPortDuplexActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber);
            this.duplexType.setText(this.portDuplexValue);
            this.getMacAddress();
            this.getSTPState();
            this.STPValue.setText(this.stpStateValue);
            this.repaint();
            ++n;
        }
    }

    protected void updateRemotePortInfo(String string) {
        if (string != null) {
            this.parsePortName(string);
            this.portComboBox.removeActionListener(this);
            if (this.portComboBox.getItemCount() > 0) {
                int n = 0;
                while (n < this.portComboBox.getItemCount()) {
                    if (((String)this.portComboBox.getItemAt(n)).trim().equals(string.trim())) {
                        this.portComboBox.setSelectedIndex(n);
                    }
                    ++n;
                }
            }
            this.portComboBox.addActionListener(this);
            this.portSpeedValue = this.commonIOSCLIs.getPortSpeedActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber);
            this.portSpeed.setText(this.portSpeedValue);
            this.portDuplexValue = this.commonIOSCLIs.getPortDuplexActual(this.esn, this.interfaceType, this.slotNumber, this.portNumber);
            this.duplexType.setText(this.portDuplexValue);
            this.getMacAddress();
            this.getSTPState();
            this.STPValue.setText(this.stpStateValue);
            this.repaint();
        }
    }
}

