/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ClusterPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Runnable,
DynamicUpdate {
    private boolean allowed_to_run = true;
    public Node centerNode;
    public String clusterName = null;
    public boolean bLabel = false;
    public boolean bIsBrowserIE;
    private final int MAX_EDGES = 60;
    private final int MAX_NODES = 40;
    public final int MAX_CLUSTER_NODES = 16;
    private Dimension mySize;
    private JFrame myFrame;
    private JApplet myApplet;
    public Cluster sTopo;
    private int nStackNodes = 0;
    public String sTopoHost;
    private Hashtable nodes = new Hashtable(20);
    private Hashtable commanders = new Hashtable(5);
    public Hashtable mac2vbnMap = new Hashtable(20);
    private Integer nodeLayer = new Integer(100);
    private Integer edgeLayer = new Integer(200);
    private Hashtable gifTable = new Hashtable(5);
    private Hashtable islandsToBePlaced = new Hashtable(5);
    private Vector edges = new Vector(20);
    private Node curNode = null;
    private Edge curEdge = null;
    private Node currSelNode;
    private Node movedNode = null;
    private boolean multiSelectionOccured = false;
    private Node endNode = null;
    private Point curPoint = new Point(0, 0);
    private boolean bCurrSelNodeFixed;
    private String selectedInterface;
    private String endNodeInterface;
    private Thread initialDrawThread;
    private UpdateNotify updateNotifyThread = null;
    private boolean bDeviceClicked = false;
    private boolean bLinkClicked = false;
    private boolean layoutCompleted = false;
    private Graphics offgraphics;
    private Image offscreen;
    private Dimension offscreensize;
    private final Color medGray = new Color(204, 204, 204);
    private boolean nodeCapacityReached = false;
    private boolean edgeCapacityReached = false;
    private final int EDGE_LEN = 200;
    private final int ABOVE = 0;
    private final int BELOW = 1;
    private final int LEFT = 2;
    private final int RIGHT = 3;
    public boolean bClusterBuilder = true;
    private final String SWITCH_MANAGER_MENU = new String("Switch Manager");
    private final String BW_GRAPH_MENU = new String("Bandwidth Graph");
    private final String ADD_TO_CLUSTER_MENU = new String("Add to Cluster");
    private final String REMOVE_FROM_CLUSTER_MENU = new String("Remove from Cluster");
    private final String HIDE_CANDIDATES_MENU = new String("Hide Candidates");
    private final String SHOW_CANDIDATES_MENU = new String("Show Candidates");
    private final String DEVICE_WEB_PAGE_MENU = new String("Device Web Page...");
    private final String LINK_REPORT_MENU = new String("Link Report...");
    private final String LINK_GRAPH_MENU = new String("Link Graph");
    private final String DISQUALIFICATION_CODE_MENU = new String("Disqualification Code");
    private final String HOSTNAME_CONFIG_MENU = new String("Host Name Config...");
    private final String CLEAR_STATE = new String("Clear State");
    private String commanderIP;
    private String commanderVbnLbl;
    private String oldClusterMembersList = "";
    private String oldCDPNeighborsList = "";
    private String oldCandidatesList = "";
    private String oldPortList = "";
    private final String PLACEMENT_FILE = "flash:placement.txt";
    private boolean forceNextUpdate = false;
    public ClusterCLI clusterCLI;
    public long updateInterval;
    private int cursorPosX;
    private int cursorPosY;
    private final int MIN_X = 25;
    private final int MIN_Y = 10;
    private static final int MENU_TYPE_RESET = -2;
    private static final int MENU_TYPE_NONE = -1;
    private static final int MENU_TYPE_SNODE = 0;
    private static final int MENU_TYPE_LINK = 1;
    private static final int MENU_TYPE_ENODE = 2;
    private static final int MENU_TYPE_GLOBAL = 3;
    private static final int MENU_TYPE_MULTIEDGE = 4;
    private static final int MAX_MENUS = 6;
    private static final int SUBMENU_TYPE_REPORT = 0;
    private static final int SUBMENU_TYPE_CONSOLE = 1;
    private String[][] SubMenu;
    private String[][] SubMenuURL;
    private int[] MenuAreaX = new int[6];
    private int[] MenuAreaY = new int[6];
    private int[] MAWidth = new int[6];
    private int[] MAHeight = new int[6];
    private int curMenu = -1;
    private int curSubMenu;
    private int[] numItems = new int[]{4, 5, 2, 1, 2, 1, 2};
    private Font f;
    private FontMetrics fm;
    private int currOldX = -1;
    private int currOldY = -1;
    private JPopupMenu popUpMenu = new JPopupMenu();
    private JPopupMenu mouseOverBox = new JPopupMenu();
    private Hashtable designationTable = new Hashtable(10);
    private boolean isStable = false;
    int stable_topology_count = 0;
    private Thread doSaveLayout = null;
    private String[] disqualificationStrings = new String[]{"Device can be added to the cluster", "Device is not capable of clustering", "Mismatch between versions of cluster management software on this device and this cluster", "One end or the other of a link between two devices is blocked by Spanning Tree", "Device belongs to another cluster", "Unknown disqualification code", "Candidate switch in different management VLAN than the cluster"};
    private String stackDesignationStrings = new String("CC,CM,CA,NQ,N,XC,XM");
    public int numClusterEdges = 0;
    public int numClusterNodes = 0;
    private int multiMembers;
    private int multiCandidates;
    HostNameDialog hostNameDialog;
    private Cursor WAIT_CURSOR = new Cursor(3);
    private Cursor DEFAULT_CURSOR = new Cursor(0);
    private Cursor MOVE_CURSOR = new Cursor(13);

    public ClusterPanel(Cluster cluster) {
        int n;
        this.setLayout(null);
        this.sTopo = cluster;
        this.sTopoHost = Cluster.getCodeBaseHost();
        this.setSize(this.getPreferredSize());
        this.clusterCLI = new ClusterCLI();
        Object object = cluster;
        while (object != null) {
            if (this.myApplet == null && object instanceof JApplet) {
                this.myApplet = (JApplet)object;
            }
            if (this.myFrame == null && object instanceof JFrame) {
                this.myFrame = (JFrame)object;
            }
            object = ((Component)object).getParent();
        }
        if (this.bClusterBuilder) {
            this.myApplet.getAppletContext().showStatus("Cisco Cluster Builder");
        } else {
            this.myApplet.getAppletContext().showStatus("Cisco Cluster View");
        }
        this.setBackground(Color.lightGray);
        StringTokenizer stringTokenizer = new StringTokenizer(this.stackDesignationStrings, ",");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.designationTable.put(stringTokenizer.nextToken().trim(), new Integer(n2));
            ++n2;
        }
        int n3 = n = 15;
        while (n3 > 6) {
            this.f = new Font("Dialog", 0, n3);
            this.fm = ((Component)this).getFontMetrics(this.f);
            if (this.fm.getHeight() <= n) break;
            --n3;
        }
        this.bClusterBuilder = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        SymAncestor symAncestor = new SymAncestor();
        this.addAncestorListener(symAncestor);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
        SymFocus symFocus = new SymFocus();
        this.addFocusListener(symFocus);
        SymContainer symContainer = new SymContainer();
        this.addContainerListener(symContainer);
    }

    void ClusterPanel_ancestorAdded(AncestorEvent ancestorEvent) {
    }

    void ClusterPanel_ancestorMoved(AncestorEvent ancestorEvent) {
    }

    void ClusterPanel_componentMoved(ComponentEvent componentEvent) {
    }

    void ClusterPanel_componentRemoved(ContainerEvent containerEvent) {
    }

    void ClusterPanel_componentShown(ComponentEvent componentEvent) {
    }

    void ClusterPanel_focusGained(FocusEvent focusEvent) {
    }

    void ClusterPanel_focusLost(FocusEvent focusEvent) {
    }

    void LinkIsSelected(Edge edge, int n, int n2) {
        Node node = null;
        Node node2 = null;
        this.curEdge = edge;
        if (this.curMenu > 0 || edge.isSecondary()) {
            this.curMenu = -1;
            this.curEdge = null;
            this.curNode = null;
        } else {
            this.bLinkClicked = true;
            this.curSubMenu = 0;
            this.curMenu = 1;
            this.curPoint.x = n;
            this.curPoint.y = n2;
            this.curEdge = edge;
            node = edge.fromPort.getDevice();
            node2 = edge.toPort.getDevice();
            if (node.bStack) {
                if (node == this.centerNode && node2.bStack) {
                    this.curNode = node2;
                    this.endNode = node;
                    this.selectedInterface = edge.toDevicePortLbl;
                    this.endNodeInterface = edge.fromDevicePortLbl;
                } else {
                    this.curNode = node;
                    this.endNode = node2;
                    this.selectedInterface = edge.fromDevicePortLbl;
                    this.endNodeInterface = edge.toDevicePortLbl;
                }
            } else {
                this.curNode = node;
                this.endNode = node2;
                this.selectedInterface = edge.fromDevicePortLbl;
                this.endNodeInterface = edge.toDevicePortLbl;
            }
        }
    }

    static /* synthetic */ boolean access$0(ClusterPanel clusterPanel) {
        return clusterPanel.multiSelectionOccured;
    }

    static /* synthetic */ Thread access$13(ClusterPanel clusterPanel) {
        return clusterPanel.doSaveLayout;
    }

    static /* synthetic */ int access$4(ClusterPanel clusterPanel) {
        return clusterPanel.multiMembers;
    }

    static /* synthetic */ void access$5(ClusterPanel clusterPanel, Node node) {
        clusterPanel.removeFromCluster(node);
    }

    static /* synthetic */ int access$6(ClusterPanel clusterPanel) {
        return clusterPanel.multiCandidates;
    }

    static /* synthetic */ void access$7(ClusterPanel clusterPanel, Node node) {
        clusterPanel.addToCluster(node);
    }

    public Edge addEdge(String string, String string2, int n, String string3, String string4, String string5, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.edges.size() == 60) {
            if (!this.edgeCapacityReached) {
                this.edgeCapacityReached = true;
                String string6 = "Maximum device limit reached\n\n";
                string6 = String.valueOf(string6) + "Some devices in your network may not appear properly in the Network View!";
                JOptionPane.showMessageDialog(null, string6, "Warning : Edge Limit Reached", 2);
            }
            return null;
        }
        Node node = this.getNode(string);
        Node node2 = this.getNode(string2);
        if (node == null || node2 == null) {
            if (node == null && node2 != null && this.islandsToBePlaced.get(node2.vbnLbl) == null) {
                this.islandsToBePlaced.put(node2.vbnLbl, node2);
            }
            if (node2 == null && node != null && this.islandsToBePlaced.get(node.vbnLbl) == null) {
                this.islandsToBePlaced.put(node.vbnLbl, node);
            }
            return null;
        }
        int n2 = this.findNode(node);
        int n3 = this.findNode(node2);
        if (n2 == -1 || n3 == -1 || n2 == n3) {
            return null;
        }
        Edge edge = this.getEdge(string, string3, string2, string4);
        if (edge != null) {
            bl4 = true;
            if (edge.fromDevicePortLbl.compareTo(string3) == 0) {
                return null;
            }
        } else {
            edge = this.getEdge(string2, string4, string, string3);
            if (edge != null) {
                bl4 = true;
                if (edge.fromDevicePortLbl.compareTo(string4) == 0) {
                    return null;
                }
            }
        }
        Edge edge2 = new Edge(this);
        edge2.from = edge2.fromDeviceNode = n2;
        edge2.to = edge2.toDeviceNode = n3;
        edge2.len = n;
        edge2.fromLbl = edge2.fromDeviceLbl = string;
        edge2.toLbl = edge2.toDeviceLbl = string2;
        edge2.fromDevicePortLbl = string3;
        edge2.toDevicePortLbl = string4;
        edge2.setBlocked(bl2);
        edge2.setFromNode(node);
        edge2.setToNode(node2);
        edge2.isGBIC = bl;
        if (!string5.equals("0") && !string5.equals("")) {
            edge2.bFastEthChannel = true;
            edge2.bDontLabelMe = true;
        } else if (edge2.fromDevicePortLbl.startsWith("Gi") || edge2.toDevicePortLbl.startsWith("Gi")) {
            edge2.bFastEthChannel = true;
        }
        String string7 = "";
        this.determineNeighbors(node, node2);
        this.determineNeighbors(node2, node);
        switch (node.designation) {
            case 1: 
            case 6: {
                edge2.fromClusterLbl = this.getNodeCommanderName(node);
                edge2.fromClusterNode = this.findNode(edge2.fromClusterLbl);
                break;
            }
            case 0: 
            case 5: {
                edge2.fromClusterLbl = node.vbnLbl;
                edge2.fromClusterNode = this.findNode(edge2.fromClusterLbl);
                break;
            }
            default: {
                edge2.fromClusterLbl = "";
            }
        }
        switch (node2.designation) {
            case 1: 
            case 6: {
                int n4 = node2.vbnLbl.indexOf("_");
                if (n4 != -1) {
                    edge2.toClusterLbl = this.getNodeCommanderName(node2);
                    edge2.toClusterNode = this.findNode(edge2.toClusterLbl);
                    break;
                }
                edge2.toClusterLbl = "";
                break;
            }
            case 0: 
            case 5: {
                edge2.toClusterLbl = node2.vbnLbl;
                edge2.toClusterNode = this.findNode(edge2.toClusterLbl);
                break;
            }
        }
        if (!(node.designation != 1 && node.designation != 0 || node2.designation != 1 && node2.designation != 0)) {
            ++this.numClusterEdges;
        }
        this.edges.addElement(edge2);
        return edge2;
    }

    public Node addNode(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, URL uRL, URL uRL2, boolean bl) {
        Node node = null;
        if (this.getNode(string) == null) {
            node = bl ? new CommandNode(this) : new SwitchNode(this);
            node.x = 25.0;
            node.y = 10.0;
            node.vbn = n;
            node.vbnLbl = string;
            node.hostLbl = string3;
            node.hopCount = n2;
            int n3 = string.indexOf("_");
            node.clusterID = string.substring(0, n3);
            node.switchStr = string.substring(n3 + 1);
            node.deviceLbl = string2;
            node.devUrl = uRL;
            node.consoleUrl = uRL2.getHost().compareTo("0.0.0.0") == 0 ? null : uRL2;
            node.bFixed = false;
            node.macAddr = string4;
            node.upStreamMacAddr = string5;
            node.candidateNeighborsShown = true;
            node.designation = (Integer)this.designationTable.get(string6);
            String string8 = node.disqualificationCode = string7.compareTo("") == 0 ? "0" : string7;
            if (node.disqualificationCode.compareTo("0") != 0) {
                node.designation = node.disqualificationCode.compareTo("4") != 0 ? 3 : 6;
            }
            node.bPlaced = false;
            node.bNeighborsPlaced = false;
            node.isVisible = node.designation == 2 || node.designation == 1 || node.designation == 0;
            node.nodeNum = this.nodes.size();
            if (node.designation == 1 || node.designation == 0) {
                node.bStack = true;
            }
            this.nodes.put(node.vbnLbl, node);
            this.mac2vbnMap.put(node.macAddr, node.vbnLbl);
        }
        return node;
    }

    public RelayNode addNode(RelayNode relayNode) {
        relayNode.nodeNum = this.nodes.size();
        this.nodes.put(relayNode.vbnLbl, relayNode);
        this.mac2vbnMap.put(relayNode.macAddr, relayNode.vbnLbl);
        return relayNode;
    }

    public void addRelayWithEdges(Node node, Port port) {
        Edge edge = null;
        RelayNode relayNode = new RelayNode(this, node, port.getName());
        relayNode = this.addNode(relayNode);
        Vector vector = (Vector)port.getEdges().clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            edge = (Edge)enumeration.nextElement();
            edge.replaceNode(node, relayNode);
        }
        Edge edge2 = this.addEdge(relayNode.vbnLbl, node.vbnLbl, 50, "", port.getName(), "0", false, false);
        Node node2 = edge2.toPort.getDevice();
    }

    public void addSelectedToCluster() {
        Thread thread = new Thread(){

            public void run() {
                String string = null;
                String string2 = "";
                Vector<Object[]> vector = new Vector<Object[]>();
                Vector vector2 = ClusterPanel.this.getSelectedCandidates();
                if (vector2.size() == 0) {
                    vector2.addElement(ClusterPanel.this.currSelNode);
                }
                Enumeration enumeration = vector2.elements();
                ClusterPanel.this.changeCursor(3);
                ClusterPanel.this.sTopo.setAllowUpdates(false);
                ClusterPanel.this.sTopo.addOrRemoveInProgress(true);
                while (enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    Object[] objectArray = string == null ? ClusterPanel.this.addSingleNode(node) : ClusterPanel.this.addSingleNode(node, string);
                    if (objectArray != null && string == null && (string2 = (String)objectArray[1]).indexOf("%ERROR: password mismatch") != -1) {
                        PasswordDialog passwordDialog = new PasswordDialog();
                        passwordDialog.setTitle("Device : " + node.hostLbl);
                        ((Component)passwordDialog).setLocation(new Point(200, 200));
                        ((Component)passwordDialog).setVisible(true);
                        ClusterPanel.this.sTopo.makeDialogModal(passwordDialog);
                        string = passwordDialog.getPassword();
                        if (string != null) {
                            objectArray = ClusterPanel.this.addSingleNode(node, string);
                        }
                    }
                    if (objectArray == null) continue;
                    vector.addElement(objectArray);
                }
                ClusterPanel.this.deselectAllNodes();
                if (vector.size() > 0) {
                    ClusterPanel.this.displayErrors(vector, "Error : Failure Adding Members");
                }
                if (vector2.size() != vector.size()) {
                    ClusterPanel.this.waitForSwitchAndUpdateView(false, 5000);
                }
                ClusterPanel.this.sTopo.setAllowUpdates(true);
                ClusterPanel.this.sTopo.addOrRemoveInProgress(false);
                ClusterPanel.this.changeCursor(0);
            }
        };
        thread.start();
    }

    private Object[] addSingleNode(Node node) {
        Object[] objectArray = null;
        int n = -1;
        String string = this.clusterCLI.runCLICommand(this.sTopoHost, "cluster member mac " + node.macAddr, "configure");
        if (string.indexOf("%ERROR") != -1) {
            objectArray = new Object[]{node, string};
        }
        return objectArray;
    }

    private Object[] addSingleNode(Node node, String string) {
        Object[] objectArray = null;
        int n = -1;
        String string2 = this.clusterCLI.runCLICommand(this.sTopoHost, "cluster member mac " + node.macAddr + " password " + string, "configure");
        if (string2.indexOf("%ERROR") != -1) {
            objectArray = new Object[]{node, string2};
        }
        return objectArray;
    }

    private void addToCluster(Node node) {
        String string;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Vector<Object[]> vector = new Vector<Object[]>();
        this.changeCursor(3);
        this.sTopo.setAllowUpdates(false);
        this.sTopo.addOrRemoveInProgress(true);
        Object[] objectArray = this.addSingleNode(node);
        if (objectArray != null && (string = (String)objectArray[1]).indexOf("%ERROR: password mismatch") != -1) {
            PasswordDialog passwordDialog = new PasswordDialog();
            passwordDialog.setTitle("Device : " + node.hostLbl);
            ((Component)passwordDialog).setLocation(new Point(200, 200));
            ((Component)passwordDialog).setVisible(true);
            this.sTopo.makeDialogModal(passwordDialog);
            string2 = passwordDialog.getPassword();
            if (string2 != null) {
                objectArray = this.addSingleNode(node, string2);
            }
        }
        if (objectArray != null) {
            vector.addElement(objectArray);
        }
        if (vector.size() > 0) {
            this.displayErrors(vector, "Error : Failure Adding Members");
        } else {
            this.waitForSwitchAndUpdateView(false, 1000);
        }
        this.sTopo.setAllowUpdates(true);
        this.sTopo.addOrRemoveInProgress(false);
        this.changeCursor(0);
    }

    void buildNodesAndEdges(String string, String string2, String string3, String string4, String string5) {
        Object object;
        Object object2;
        boolean bl;
        Edge edge;
        Vector<Edge> vector = new Vector<Edge>(5);
        String string6 = new String("");
        boolean bl2 = false;
        boolean bl3 = false;
        Node node = null;
        Vector vector2 = new Vector(20);
        int n = 1;
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        String string17 = "";
        String string18 = "";
        String string19 = "";
        String string20 = "";
        String string21 = "";
        String string22 = "";
        String string23 = "";
        String string24 = "";
        String string25 = "";
        String string26 = "";
        String string27 = "";
        String string28 = "";
        String string29 = "";
        String string30 = "";
        this.clearModel();
        CLIResponse cLIResponse = new CLIResponse(string);
        CLIResponse cLIResponse2 = new CLIResponse(string2);
        CLIResponse cLIResponse3 = new CLIResponse(string3);
        CLIResponse cLIResponse4 = new CLIResponse(string4);
        CLIResponse cLIResponse5 = new CLIResponse(string5);
        CLILine cLILine = cLIResponse.nextLine();
        this.clusterName = cLILine.getFieldAt(0);
        while (cLIResponse2.hasMoreLines()) {
            edge = new Edge(this);
            cLILine = cLIResponse2.nextLine();
            int n2 = Integer.parseInt(cLILine.getFieldAt(0));
            string11 = cLILine.getFieldAt(1);
            edge.fromDeviceLbl = string7 = String.valueOf(this.commanderIP) + "_" + string11;
            string12 = cLILine.getFieldAt(2);
            string8 = cLILine.getFieldAt(3);
            string9 = cLILine.getFieldAt(4);
            string21 = cLILine.getFieldAt(5);
            string13 = cLILine.getFieldAt(6);
            string10 = cLILine.getFieldAt(7);
            edge.fromDevicePortLbl = cLILine.getFieldAt(8);
            string26 = cLILine.getFieldAt(9);
            string28 = cLILine.getFieldAt(10);
            n = string28.compareTo("") != 0 ? new Integer(string28) : 0;
            string14 = cLILine.getFieldAt(11);
            string16 = cLILine.getFieldAt(12);
            edge.toDevicePortLbl = cLILine.getFieldAt(13);
            string25 = cLILine.getFieldAt(14);
            edge.isGBIC = string25.equals("CXR") && string26.equals("CXR");
            string18 = cLILine.getFieldAt(15);
            string19 = cLILine.getFieldAt(16);
            string20 = cLILine.getFieldAt(17);
            bl = string9.indexOf("1900") != -1 || string9.indexOf("2820") != -1;
            if (cLILine.getFieldAt(18).compareTo("CC") == 0 || cLILine.getFieldAt(18).compareTo("AC") == 0) {
                string17 = "CC";
                string30 = bl ? "http://" + this.commanderIP + "/homepage.htm" : "http://" + this.commanderIP + "/basiccfg.html";
            } else {
                string17 = "CM";
                string30 = bl ? "http://" + this.commanderIP + "/" + string11 + "/homepage.htm" : "http://" + this.commanderIP + "/" + string11 + "/basiccfg.html";
            }
            if (string16.compareTo("") == 0 && string17.compareTo("CC") == 0) {
                string16 = string10;
                string14 = "0";
            }
            edge.toDeviceLbl = String.valueOf(this.commanderIP) + "_es" + string14;
            edge.FECNum = string13;
            boolean bl4 = cLILine.getFieldAt(18).compareTo("CC") == 0 || cLILine.getFieldAt(18).compareTo("AC") == 0 || cLILine.getFieldAt(18).compareTo("SC") == 0;
            try {
                node = this.addNode(n2, string7, string9, string8, string10, string16, n, string17, string23, new URL("http://" + this.commanderIP + "/" + string11 + "/snmp.html"), new URL(string30), bl4);
                ++this.numClusterNodes;
            }
            catch (Exception exception) {}
            if (bl4) {
                if (node != null && cLILine.getFieldAt(18).compareTo("SC") == 0) {
                    ((CommandNode)node).setStandby(true);
                } else {
                    this.commanderVbnLbl = string7;
                }
            }
            if (node != null) {
                node.setStatusCode(string12);
                node.setOldDevice(bl);
                if (string13.compareTo("") != 0 && string13.compareTo("0") != 0) {
                    node.addPortGroup(string13);
                }
            }
            if (!edge.isValid()) continue;
            vector.addElement(edge);
        }
        while (cLIResponse3.hasMoreLines()) {
            cLILine = cLIResponse3.nextLine();
            string17 = cLILine.getFieldAt(0);
            string8 = cLILine.getFieldAt(1);
            string9 = cLILine.getFieldAt(2);
            string21 = cLILine.getFieldAt(3);
            if (string21.indexOf("H") != -1) continue;
            edge = new Edge(this);
            string13 = cLILine.getFieldAt(4);
            string10 = cLILine.getFieldAt(5);
            edge.fromDevicePortLbl = cLILine.getFieldAt(6);
            string26 = cLILine.getFieldAt(7);
            string14 = cLILine.getFieldAt(8);
            string14.compareTo("");
            edge.toDeviceLbl = String.valueOf(this.commanderIP) + "_es" + string14;
            string16 = cLILine.getFieldAt(9);
            string29 = (String)this.mac2vbnMap.get(string16);
            n = string29 != null ? this.getNode((String)string29).hopCount + 1 : 1;
            edge.toDevicePortLbl = cLILine.getFieldAt(10);
            string25 = cLILine.getFieldAt(11);
            edge.isGBIC = string25.equals("CXR") && string26.equals("CXR");
            string23 = cLILine.getFieldAt(12);
            if (string23.compareTo("") == 0) {
                string23 = "0";
            }
            string22 = cLILine.getFieldAt(13);
            string7 = string17.equals("XC") ? String.valueOf(string22) + "_" + "es0" : String.valueOf(string22) + "_" + string8;
            edge.fromDeviceLbl = string7;
            edge.FECNum = string13;
            bl = string9.indexOf("1900") != -1 || string9.indexOf("2820") != -1;
            if (string23.compareTo("0") != 0) {
                string30 = "http://" + string22 + "/";
            } else {
                string30 = bl ? "http://" + string22 + "/homepage.htm" : "http://" + string22 + "/basiccfg.html";
                string23 = "-1";
            }
            try {
                node = this.addNode(-1, string7, string9, string8, string10, string16, n, string17, string23, new URL("http://" + string22 + "/snmp.html"), new URL(string30), false);
            }
            catch (Exception exception) {
                System.out.println("Exception : " + exception);
            }
            if (node != null) {
                node.setOldDevice(bl);
                if (string13.compareTo("") != 0 && string13.compareTo("0") != 0) {
                    node.addPortGroup(string13);
                }
            }
            vector.addElement(edge);
        }
        while (cLIResponse4.hasMoreLines()) {
            cLILine = cLIResponse4.nextLine();
            if (cLILine.getFieldAt(8).compareTo("E") == 0) {
                edge = new Edge(this);
                string17 = "CA";
                string8 = cLILine.getFieldAt(0);
                string9 = cLILine.getFieldAt(1);
                string21 = cLILine.getFieldAt(2);
                string13 = cLILine.getFieldAt(3);
                string10 = cLILine.getFieldAt(4);
                edge.fromDevicePortLbl = cLILine.getFieldAt(5);
                string26 = cLILine.getFieldAt(6);
                string14 = cLILine.getFieldAt(8);
                string16 = cLILine.getFieldAt(9);
                object2 = this.getNodeByMac(string16);
                if (object2 != null) {
                    edge.toDeviceLbl = ((Node)object2).vbnLbl;
                    n = ((Node)object2).hopCount + 1;
                } else {
                    edge.toDeviceLbl = "";
                    n = -1;
                }
                edge.toDevicePortLbl = cLILine.getFieldAt(10);
                string25 = cLILine.getFieldAt(11);
                edge.isGBIC = string25.equals("CXR") && string26.equals("CXR");
                String string31 = cLILine.getFieldAt(12);
                string22 = cLILine.getFieldAt(13);
                object = cLILine.getFieldAt(14);
                bl = string9.indexOf("1900") != -1 || string9.indexOf("2820") != -1;
                string30 = bl ? "http://" + string22 + "/homepage.htm" : "http://" + string22 + "/basiccfg.html";
                string7 = string22.length() == 0 ? "0.0.0.0_" + string8 : String.valueOf(string22) + "_" + string8;
                edge.fromDeviceLbl = string7;
                edge.FECNum = string13;
                try {
                    node = this.addNode(-1, string7, string9, string8, string10, string16, n, string17, "", new URL("http://" + string22 + "/snmp.html"), new URL(string30), false);
                    node.setOldDevice(bl);
                }
                catch (Exception exception) {}
                if (node != null && string13.compareTo("") != 0 && string13.compareTo("0") != 0) {
                    node.addPortGroup(string13);
                }
                vector.addElement(edge);
                continue;
            }
            string10 = cLILine.getFieldAt(4);
            node = this.getNodeByMac(string10);
            if (node == null) continue;
            node.disqualificationCode = "0";
            node.designation = 2;
        }
        this.checkForExternalClusterDevices();
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            edge = (Edge)object2.nextElement();
            this.addEdge(edge.fromDeviceLbl, edge.toDeviceLbl, 50, edge.fromDevicePortLbl, edge.toDevicePortLbl, edge.FECNum, edge.isGBIC, false);
        }
        vector = null;
        while (cLIResponse5.hasMoreLines()) {
            cLILine = cLIResponse5.nextLine();
            int n3 = Integer.parseInt(cLILine.getFieldAt(0));
            int n4 = Integer.parseInt(cLILine.getFieldAt(4));
            Node node2 = this.getNodeByVbn(n3);
            Node node3 = this.getNodeByVbn(n4);
            if (node2 == null || node3 == null) continue;
            String string32 = cLILine.getFieldAt(1);
            String string33 = cLILine.getFieldAt(5);
            Port port = node2.getPortByName(cLILine.getFieldAt(1));
            object = port != null ? port.getEdgeTo(node3) : null;
            boolean bl5 = cLILine.getFieldAt(8).compareTo("") == 0;
            boolean bl6 = cLILine.getFieldAt(2).compareTo("CXR") == 0;
            int n5 = Integer.parseInt(cLILine.getFieldAt(3));
            int n6 = Integer.parseInt(cLILine.getFieldAt(7));
            boolean bl7 = n5 != 0 && n6 != 0;
            if (object == null) {
                if (node2.portGroupExists(n5) || node3.portGroupExists(n6)) continue;
                object = this.addEdge(node2.vbnLbl, node3.vbnLbl, 50, string32, string33, cLILine.getFieldAt(3), bl6, bl5);
                continue;
            }
            if (bl7) {
                node2.addPortGroup(n5);
                node3.addPortGroup(n6);
            }
            ((Edge)object).setBlocked(bl5);
            ((Edge)object).setRazor(bl6);
        }
        this.detectAndAddRelays();
        this.setMultiLinkPrimaryEdges();
    }

    public void changeCursor(int n) {
        this.setCursor(new Cursor(n));
        this.getCursor();
    }

    public void changeView(boolean bl) {
        if (this.nodes.size() > 0) {
            this.setUpNodesAccordingToView();
            this.drawInitialNodes(bl);
        }
    }

    public void checkForExternalClusterDevices() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.designation != 6 || this.isNodeCommanderSeen(node)) continue;
            node.designation = 4;
        }
    }

    public void clearModel() {
        this.nodes = new Hashtable(20);
        this.edges = new Vector(20);
        this.numClusterEdges = 0;
        this.numClusterNodes = 0;
        RelayNode.reset();
    }

    private void computeCoordinates(Node node, Node node2, int n, double d) {
        node.x = node2.x + (double)n * Math.cos(d * Math.PI / 180.0);
        node.y = node2.y - (double)n * Math.sin(d * Math.PI / 180.0);
        node.posWRTPrimaryNeighbor = d;
    }

    private int computePositionRelToCaptain(Node node) {
        int n = node.primaryEdgeLen;
        double d = (node.y - this.centerNode.y) / (double)n;
        int n2 = 4;
        if (node != this.centerNode) {
            n2 = d > -0.707 && d < 0.707 ? (node.x < this.centerNode.x ? 2 : 3) : (node.y < this.centerNode.y ? 0 : 1);
        }
        return n2;
    }

    public void configureHostName(Node node) {
        this.hostNameDialog = new HostNameDialog(this, this.currSelNode);
        ((Component)this.hostNameDialog).setLocation(new Point(400, 400));
        ((Component)this.hostNameDialog).setVisible(true);
        this.sTopo.makeDialogModal(this.hostNameDialog);
    }

    public void deselectAllCandidates() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isCandidate()) continue;
            node.setSelected(false);
        }
        this.sTopo.updateDeviceMenu(0);
    }

    public void deselectAllEdges() {
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            ((Edge)enumeration.nextElement()).setSelected(false);
        }
        this.sTopo.updateLinkMenu(0);
    }

    public void deselectAllMembers() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isMember()) continue;
            node.setSelected(false);
        }
        this.sTopo.updateDeviceMenu(0);
    }

    public void deselectAllNodes() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).setSelected(false);
        }
        this.sTopo.updateDeviceMenu(0);
    }

    public void detectAndAddRelays() {
        Node node;
        Vector<Node> vector = new Vector<Node>();
        Enumeration<Object> enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            if (!node.hasDuplicatePorts()) continue;
            vector.addElement(node);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            Vector vector2 = node.duplicatePorts();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Port port = (Port)enumeration2.nextElement();
                if (port.isRazor()) continue;
                this.addRelayWithEdges(node, port);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void determineNeighbors(Node node, Node node2) {
        String string = this.getNodeCommanderName(node);
        Node node3 = this.getNode(string);
        String string2 = this.getNodeCommanderName(node2);
        Node node4 = this.getNode(string2);
        switch (node.designation) {
            case 0: {
                switch (node2.designation) {
                    case 1: {
                        node.addClusterNeighbor(node2);
                        return;
                    }
                    case 2: {
                        node.addClusterNeighbor(node2);
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 5: {
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 6: {
                        node3.addNetworkNeighbor(node4);
                        return;
                    }
                    default: {
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 0: 
                }
                return;
            }
            case 1: {
                switch (node2.designation) {
                    case 0: {
                        node.addClusterNeighbor(node2);
                        return;
                    }
                    case 1: {
                        node.addClusterNeighbor(node2);
                        return;
                    }
                    case 2: {
                        node.addClusterNeighbor(node2);
                        node3.addNetworkNeighbor(node2);
                        return;
                    }
                    case 5: {
                        node3.addNetworkNeighbor(node2);
                        return;
                    }
                    case 6: {
                        node3.addNetworkNeighbor(node4);
                        return;
                    }
                }
                node3.addNetworkNeighbor(node2);
                return;
            }
            case 2: {
                switch (node2.designation) {
                    case 0: {
                        node.addClusterNeighbor(node2);
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 2: {
                        node.addClusterNeighbor(node2);
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 1: {
                        node.addClusterNeighbor(node2);
                        node.addNetworkNeighbor(node4);
                        return;
                    }
                }
                return;
            }
            case 5: {
                switch (node2.designation) {
                    case 0: {
                        node.addNetworkNeighbor(node2);
                        return;
                    }
                    case 1: {
                        node.addNetworkNeighbor(node4);
                        return;
                    }
                }
                return;
            }
            case 6: {
                switch (node2.designation) {
                    case 0: 
                    case 1: {
                        node3.addNetworkNeighbor(node4);
                        return;
                    }
                }
                return;
            }
        }
        switch (node2.designation) {
            case 0: {
                node.addNetworkNeighbor(node2);
                return;
            }
            case 1: {
                node.addNetworkNeighbor(node4);
                return;
            }
        }
    }

    private Node deviceClicked(int n, int n2) {
        Node node = null;
        boolean bl = false;
        Image image = null;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.isVisible) continue;
            String string = this.bLabel ? node2.deviceLbl : node2.switchStr;
            image = node2.currentImage(this.bClusterBuilder);
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            int n5 = this.fm.stringWidth(string) + 10;
            int n6 = this.fm.getHeight() + 4;
            if (!((double)n > node2.x - (double)(n3 / 2) && (double)n < node2.x + (double)(n3 / 2) && (double)n2 > node2.y - (double)(n4 / 2) && (double)n2 < node2.y + (double)(n4 / 2)) && (!((double)n > node2.x - (double)(n5 / 2)) || !((double)n < node2.x + (double)(n5 / 2)) || !((double)n2 > node2.y - (double)(n6 / 2) + 25.0) || !((double)n2 < node2.y + (double)(n6 / 2) + 25.0))) continue;
            bl = true;
            node = node2;
        }
        return node;
    }

    private void displayErrors(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("These errors were detected : \n");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            Node node = (Node)objectArray[0];
            String string2 = (String)objectArray[1];
            int n = string2.indexOf("%ERROR");
            int n2 = string2.indexOf("</DL><HR><PRE>");
            string2 = string2.substring(n, n2);
            stringBuffer.append(node.hostLbl);
            stringBuffer.append(" : ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        JOptionPane.showMessageDialog(null, stringBuffer.toString(), string, 0);
    }

    private synchronized void drawInitialNodes(boolean bl) {
        String string = "";
        String string2 = "";
        Node node = null;
        boolean bl2 = true;
        boolean bl3 = false;
        string = this.clusterCLI.runCLICommand(this.sTopoHost, "cluster preferences file flash:placement.txt", "exec");
        try {
            String string3;
            int n;
            if (string != null && !string.equals("") && string.indexOf("%ERROR") == -1 && (n = string.indexOf(string3 = "Command was")) != -1) {
                string = string.substring(n);
                string3 = "<PRE><HR>";
                n = string.indexOf(string3);
                int n2 = string.indexOf("</DL><HR><PRE>");
                string = string.substring(n + string3.length(), n2);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n3 = 0;
                bl3 = true;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    node = this.getNodebyMacOrName(string4);
                    if (node != null) {
                        String string5 = stringTokenizer.nextToken();
                        if (string5.compareTo("NONE") != 0 && node.upStreamMacAddr.compareTo(string5) != 0) {
                            bl3 = false;
                        } else {
                            node.x = new Integer(stringTokenizer.nextToken()).intValue();
                            node.y = new Integer(stringTokenizer.nextToken()).intValue();
                            node.bPlaced = true;
                        }
                    } else {
                        bl3 = false;
                    }
                    ++n3;
                }
                if (n3 == this.getRealDeviceCount() && bl3) {
                    bl2 = false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = true;
        }
        if (bl2) {
            this.centerNode.x = this.getPreferredSize().width / 2;
            this.centerNode.y = this.getPreferredSize().height / 2;
            this.centerNode.bPlaced = true;
            this.centerNode.posWRTPrimaryNeighbor = -1.0;
            this.placeNeighbors(this.centerNode);
        }
        this.placeRelays();
        if (!bl) {
            this.layoutCompleted = true;
            this.repaint();
        }
    }

    private void drawMenu(Graphics graphics) {
        this.MenuAreaX[this.curMenu] = this.curPoint.x - 2;
        this.MenuAreaY[this.curMenu] = this.curPoint.y - 2;
        int n = this.MAWidth[this.curMenu] + this.MenuAreaX[this.curMenu];
        int n2 = this.MAHeight[this.curMenu] + this.MenuAreaY[this.curMenu];
        boolean bl = false;
        graphics.setFont(this.f);
        graphics.setColor(this.medGray);
        graphics.fillRect(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], this.MAWidth[this.curMenu], this.MAHeight[this.curMenu]);
        graphics.setColor(Color.white);
        graphics.drawLine(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], n, this.MenuAreaY[this.curMenu]);
        graphics.drawLine(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], this.MenuAreaX[this.curMenu], n2);
        graphics.setColor(Color.black);
        graphics.drawLine(n, this.MenuAreaY[this.curMenu], n, n2);
        graphics.drawLine(this.MenuAreaX[this.curMenu], n2, n, n2);
        if (this.curSubMenu >= 0) {
            int n3 = 0;
            while (n3 < this.numItems[this.curMenu]) {
                if (this.curSubMenu == n3) {
                    graphics.setColor(Color.blue);
                } else if (this.curSubMenu == n3 - 1) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawString(this.SubMenu[this.curMenu][n3], this.MenuAreaX[this.curMenu] + 4, this.MenuAreaY[this.curMenu] + (n3 + 1) * (this.fm.getAscent() + 2));
                ++n3;
            }
        }
    }

    public void dynamicUpdate(boolean bl) {
        if (this.updateNotifyThread != null && this.updateNotifyThread.getUpdatePeriod() != (double)this.updateInterval) {
            this.updateNotifyThread.setUpdatePeriod(this.updateInterval);
        }
        this.updateView(bl);
    }

    private Edge edgeClicked(int n, int n2) {
        Edge edge = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge2 = (Edge)enumeration.nextElement();
            Node node = edge2.fromPort.getDevice();
            Node node2 = edge2.toPort.getDevice();
            if (!edge2.isVisible) continue;
            bl = false;
            n3 = (int)node.x;
            n5 = (int)node.y;
            n4 = (int)node2.x;
            n6 = (int)node2.y;
            if (n3 == n4) {
                if (n < n3 - 3 || n > n3 + 3) continue;
                if (n6 > n5) {
                    if (n2 < n5 || n2 > n6) continue;
                    this.LinkIsSelected(edge2, n, n2);
                    edge = edge2;
                    continue;
                }
                if (n5 <= n6 || n2 > n5 || n2 < n6) continue;
                this.LinkIsSelected(edge2, n, n2);
                edge = edge2;
                continue;
            }
            double d = (double)(n6 - n5) / (double)(n4 - n3);
            int n7 = (int)((double)n6 - d * (double)n4);
            if (d >= -1.0 && d <= 1.0) {
                int n8 = (int)(d * (double)n + (double)n7);
                if (n2 >= n8 - 3 && n2 <= n8 + 3) {
                    bl = true;
                }
            } else {
                int n9 = (int)((double)(n2 - n7) / d);
                if (n >= n9 - 3 && n <= n9 + 3) {
                    bl = true;
                }
            }
            if (!bl) continue;
            if (n4 > n3 && n >= n3 - 3 && n <= n4 + 3) {
                if (n5 > n6 && n2 >= n6 - 3 && n2 <= n5 + 3) {
                    edge = edge2;
                    continue;
                }
                if (n2 < n5 - 3 || n2 > n6 + 3) continue;
                edge = edge2;
                continue;
            }
            if (n > n3 + 3 || n < n4 - 3) continue;
            if (n5 > n6 && n2 >= n6 - 3 && n2 <= n5 + 3) {
                edge = edge2;
                continue;
            }
            if (n2 < n5 - 3 || n2 > n6 + 3) continue;
            edge = edge2;
        }
        return edge;
    }

    private boolean equivelent(String string, String string2) {
        int n = string.indexOf("</H5>");
        int n2 = string.indexOf("</DL><HR><PRE>");
        if (n == -1 || n2 == -1) {
            return false;
        }
        string = string.substring(n + 5, n2);
        n = string2.indexOf("</H5>");
        n2 = string2.indexOf("</DL><HR><PRE>");
        if (n == -1 || n2 == -1) {
            return false;
        }
        return string.compareTo(string2 = string2.substring(n + 5, n2)) == 0;
    }

    public int findNode(Node node) {
        return node.nodeNum;
    }

    public int findNode(String string) {
        Node node = this.getNode(string);
        int n = node != null ? this.findNode(node) : -1;
        return n;
    }

    public Node getCommander() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isCommand() || !((CommandNode)node).isActiveCommand()) continue;
            return node;
        }
        return null;
    }

    Node getDeviceUnderCursor(int n, int n2) {
        Node node = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        Node node2 = null;
        String string = "";
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Image image = null;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            node2 = (Node)enumeration.nextElement();
            image = node2.currentImage(this.bClusterBuilder);
            n3 = image.getWidth(this);
            n4 = image.getHeight(this);
            if (n3 == -1) {
                n3 = 32;
            }
            if (n4 == -1) {
                n4 = 21;
            }
            string = this.bLabel ? node2.deviceLbl : node2.switchStr;
            n5 = this.fm.stringWidth(string) + 10;
            n6 = this.fm.getHeight() + 4;
            rectangle.x = (int)node2.x;
            rectangle.y = (int)node2.y - n4 / 2;
            rectangle.width = n3;
            rectangle.height = n4;
            rectangle2.x = (int)(node2.x - (double)(n5 / 2));
            rectangle2.y = (int)(node2.y + (double)(n4 / 2) + 10.0);
            rectangle2.width = n5;
            rectangle2.height = n6;
            if (rectangle.contains(n, n2) || rectangle2.contains(n, n2)) {
                node = node2;
                continue;
            }
            if (rectangle.x == n && rectangle.y == n2) {
                node = node2;
                continue;
            }
            if (!rectangle2.contains(n, n2)) continue;
            node = node2;
        }
        return node;
    }

    public Edge getEdge(String string, String string2, String string3, String string4) {
        Edge edge = null;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            edge = (Edge)enumeration.nextElement();
            if (edge.fromDeviceLbl.compareTo(string) != 0 || edge.fromDevicePortLbl.compareTo(string2) != 0 || edge.toDeviceLbl.compareTo(string3) != 0 || edge.toDevicePortLbl.compareTo(string4) != 0) continue;
            return edge;
        }
        return null;
    }

    public Dimension getMaximumSize() {
        return new Dimension(1000, 1000);
    }

    public int getMemberCount() {
        int n = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.isRelay() || !node.isMember()) continue;
            ++n;
        }
        return n;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    String getNextToken(StringTokenizer stringTokenizer, boolean bl) {
        String string = "";
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.compareTo(",") != 0) {
                if (!bl) {
                    stringTokenizer.nextToken();
                }
            } else {
                string = "";
            }
        }
        return string.trim();
    }

    public Node getNode(int n) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.getNodeNum() != n) continue;
            return node;
        }
        return null;
    }

    public Node getNode(String string) {
        Node node = (Node)this.nodes.get(string);
        return node;
    }

    public Node getNodeByMac(String string) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.macAddr.compareTo(string) != 0) continue;
            return node;
        }
        return null;
    }

    public Node getNodeByVbn(int n) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.vbn != n) continue;
            return node;
        }
        return null;
    }

    public String getNodeCommanderName(Node node) {
        String string;
        String string2 = "";
        String string3 = node.vbnLbl.substring(0, node.vbnLbl.indexOf("_"));
        if (string3.compareTo(string = this.commanderVbnLbl.substring(0, this.commanderVbnLbl.indexOf("_"))) == 0) {
            string2 = this.commanderVbnLbl;
        } else if (string3.compareTo("") != 0) {
            string2 = String.valueOf(string3) + "_es0";
        }
        return string2;
    }

    private Node getNodebyMacOrName(String string) {
        Node node = null;
        if (string.startsWith("Unknown")) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)enumeration.nextElement();
                if (node2.hostLbl.compareTo(string) != 0) continue;
                node = node2;
                break;
            }
        } else {
            node = this.getNodeByMac(string);
        }
        return node;
    }

    private int getNumNeighbors(Node node) {
        return node.neighbors.size();
    }

    private int getNumStackNeighbors(Node node) {
        int n = this.getNumNeighbors(node);
        int n2 = 0;
        Node node2 = null;
        Enumeration enumeration = node.neighbors.elements();
        while (enumeration.hasMoreElements()) {
            node2 = (Node)enumeration.nextElement();
            if (node2 == null || !node2.bStack) continue;
            ++n2;
        }
        return n2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(1000, 1000);
    }

    private int getRealDeviceCount() {
        int n = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.isRelay()) continue;
            ++n;
        }
        return n;
    }

    public Vector getSelectedCandidates() {
        Vector<Node> vector = new Vector<Node>();
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isSelected() || node.designation != 2) continue;
            vector.addElement(node);
        }
        return vector;
    }

    public int getSelectedDeviceCount() {
        int n = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public int getSelectedEdgeCount() {
        int n = 0;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public Vector getSelectedMembers() {
        Vector<Node> vector = new Vector<Node>();
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isSelected() || !node.isMember()) continue;
            vector.addElement(node);
        }
        return vector;
    }

    public Node getSingleSelectedDevice() {
        Node node = null;
        int n = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.isSelected()) continue;
            if (node == null) {
                node = node2;
            }
            ++n;
        }
        if (n != 1) {
            return null;
        }
        return node;
    }

    public Edge getSingleSelectedEdge() {
        Edge edge = null;
        int n = 0;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge2 = (Edge)enumeration.nextElement();
            if (!edge2.isSelected()) continue;
            if (edge == null) {
                edge = edge2;
            }
            ++n;
        }
        if (n != 1) {
            return null;
        }
        return edge;
    }

    public void hideCandidateNeighbors(Node node) {
        if (node.candidateNeighborsShown) {
            Enumeration enumeration = node.neighbors.elements();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)enumeration.nextElement();
                if (node2.designation != 2) continue;
                if (node.candidateNeighborsShown) {
                    node.candidateNeighborsShown = false;
                }
                node2.isHiddenCandidate = true;
                if (!node2.candidateNeighborsShown) continue;
                this.hideCandidateNeighbors(node2);
                this.updateMembersCandidateShownStatus(node2, false);
            }
            node.candidateNeighborsShown = false;
        }
        this.repaint();
    }

    private boolean isDeviceOutOfBounds(Node node) {
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (node.x > (double)dimension.width || (int)node.x < 25 || node.y > (double)dimension.height || (int)node.y < 10) {
            bl = true;
        }
        return bl;
    }

    private boolean isDeviceUnderCursor(Node node) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Image image = node.currentImage(this.bClusterBuilder);
        if (image == null) {
            return false;
        }
        n = image.getWidth(this);
        n2 = image.getHeight(this);
        if (n == -1) {
            n = 32;
        }
        if (n2 == -1) {
            n2 = 21;
        }
        String string = this.bLabel ? node.deviceLbl : node.switchStr;
        int n3 = this.fm.stringWidth(string) + 10;
        int n4 = this.fm.getHeight() + 4;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        rectangle.x = (int)node.x;
        rectangle.y = (int)node.y - n2 / 2;
        rectangle.height = n2;
        rectangle.width = n;
        rectangle2.x = (int)(node.x - (double)(n3 / 2));
        rectangle2.y = (int)(node.y + (double)(n2 / 2) + 10.0);
        rectangle2.width = n3;
        rectangle2.height = n4;
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Node node2 = null;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            node2 = (Node)enumeration.nextElement();
            if (node2 == node || !node2.isVisible) continue;
            image = node2.currentImage(this.bClusterBuilder);
            if (image == null) {
                n = 32;
                n2 = 32;
            } else {
                n = image.getWidth(this);
                n2 = image.getHeight(this);
            }
            if (n == -1) {
                n = 32;
            }
            if (n2 == -1) {
                n2 = 21;
            }
            string = this.bLabel ? node2.deviceLbl : node2.switchStr;
            n3 = this.fm.stringWidth(string) + 10;
            n4 = this.fm.getHeight() + 4;
            rectangle3.x = (int)node2.x;
            rectangle3.y = (int)node2.y - n2 / 2;
            rectangle3.width = n;
            rectangle3.height = n2;
            rectangle4.x = (int)(node2.x - (double)(n3 / 2));
            rectangle4.y = (int)(node2.y + (double)(n2 / 2) + 10.0);
            rectangle4.width = n3;
            rectangle4.height = n4;
            if (rectangle3.intersects(rectangle) || rectangle3.intersects(rectangle2) || rectangle4.intersects(rectangle)) {
                bl = true;
                continue;
            }
            if ((double)rectangle3.x == node.x && (double)rectangle3.y == node.y) {
                bl = true;
                continue;
            }
            rectangle4.intersects(rectangle2);
        }
        return bl;
    }

    private boolean isLinkOnAnotherLink(Node node, Node node2, double d) {
        boolean bl = false;
        int n = this.getNumNeighbors(node2);
        double d2 = 360.0;
        if (-1.0 * (180.0 - node2.posWRTPrimaryNeighbor) == d) {
            bl = true;
        } else {
            Enumeration enumeration = node2.neighbors.elements();
            while (enumeration.hasMoreElements()) {
                Node node3 = (Node)enumeration.nextElement();
                if (node3 == node || !node3.bPlaced || node.posWRTPrimaryNeighbor % d2 != node3.posWRTPrimaryNeighbor % d2) continue;
                bl = true;
            }
        }
        return bl;
    }

    boolean isNodeCommanderSeen(Node node) {
        boolean bl = false;
        String string = this.getNodeCommanderName(node);
        if (this.getNode(string) != null) {
            bl = true;
        }
        return bl;
    }

    boolean isPointOnLink(int n, int n2) {
        this.bLinkClicked = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            Node node = edge.fromPort.getDevice();
            Node node2 = edge.toPort.getDevice();
            if (!edge.isVisible) continue;
            bl = false;
            n3 = (int)node.x;
            n5 = (int)node.y;
            n4 = (int)node2.x;
            n6 = (int)node2.y;
            if (n3 == n4) {
                if (n < n3 - 3 || n > n3 + 3) continue;
                if (n6 > n5) {
                    if (n2 < n5 || n2 > n6) continue;
                    this.LinkIsSelected(edge, n, n2);
                    continue;
                }
                if (n5 <= n6 || n2 > n5 || n2 < n6) continue;
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            double d = (double)(n6 - n5) / (double)(n4 - n3);
            int n7 = (int)((double)n6 - d * (double)n4);
            if (d >= -1.0 && d <= 1.0) {
                int n8 = (int)(d * (double)n + (double)n7);
                if (n2 >= n8 - 3 && n2 <= n8 + 3) {
                    bl = true;
                }
            } else {
                int n9 = (int)((double)(n2 - n7) / d);
                if (n >= n9 - 3 && n <= n9 + 3) {
                    bl = true;
                }
            }
            if (!bl) continue;
            if (n4 > n3 && n >= n3 - 3 && n <= n4 + 3) {
                if (n5 > n6 && n2 >= n6 - 3 && n2 <= n5 + 3) {
                    this.LinkIsSelected(edge, n, n2);
                    continue;
                }
                if (n2 < n5 - 3 || n2 > n6 + 3) continue;
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            if (n > n3 + 3 || n < n4 - 3) continue;
            if (n5 > n6 && n2 >= n6 - 3 && n2 <= n5 + 3) {
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            if (n2 < n5 - 3 || n2 > n6 + 3) continue;
            this.LinkIsSelected(edge, n, n2);
        }
        return this.bLinkClicked;
    }

    public void launchDeviceBandwidthGraph(Node node) {
        ClusterBuilderSwitch clusterBuilderSwitch = new ClusterBuilderSwitch(node);
        clusterBuilderSwitch.imageName = clusterBuilderSwitch.Cli.getSwVersion(clusterBuilderSwitch.esn);
        BandwidthGraph bandwidthGraph = new BandwidthGraph(this.myApplet, null, (CommonSwitch)clusterBuilderSwitch);
        bandwidthGraph.setVisible(true);
    }

    public void launchLinkGraph(Edge edge) {
        Node node = null;
        String string = null;
        String string2 = null;
        if (edge != null) {
            Node node2 = edge.fromPort.getDevice();
            Node node3 = edge.toPort.getDevice();
            string2 = String.valueOf(node2.hostLbl) + " <-> " + node3.hostLbl;
            boolean bl = false;
            if (!node2.isOldDevice() && !node2.isRelay() && (node2.isMember() || node2.isCommand())) {
                node = node2;
                string = edge.fromDevicePortLbl;
            } else if (!node3.isOldDevice() && !node3.isRelay() && (node3.isMember() || node3.isCommand())) {
                node = node3;
                string = edge.toDevicePortLbl;
            }
            if (node != null) {
                ClusterBuilderSwitch clusterBuilderSwitch = new ClusterBuilderSwitch(node);
                LinkGraph linkGraph = new LinkGraph(this.myApplet, (CommonSwitch)clusterBuilderSwitch, string, string2);
                linkGraph.setVisible(true);
            }
        }
    }

    public void launchLinkReport(final Edge edge) {
        if (edge != null) {
            Thread thread = new Thread(){

                public void run() {
                    String[] stringArray = new String[2];
                    String[] stringArray2 = new String[2];
                    String[] stringArray3 = new String[2];
                    Node node = edge.fromPort.getDevice();
                    Node node2 = edge.toPort.getDevice();
                    int n = 0;
                    if (!node.isOldDevice() && !node.isRelay() && (node.isMember() || node.isCommand())) {
                        stringArray[n] = node.hostLbl;
                        stringArray2[n] = edge.fromDevicePortLbl;
                        stringArray3[n] = node.switchStr;
                        ++n;
                    }
                    if (!node2.isOldDevice() && !node2.isRelay() && (node2.isMember() || node2.isCommand())) {
                        stringArray[n] = node2.hostLbl;
                        stringArray2[n] = edge.toDevicePortLbl;
                        stringArray3[n] = node2.switchStr;
                    } else {
                        stringArray[n] = null;
                        stringArray3[n] = null;
                        stringArray2[n] = null;
                    }
                    if (stringArray[0] != null) {
                        this.changeCursor(3);
                        LinkFrame linkFrame = new LinkFrame((JApplet)((Object)sTopo), stringArray[0], stringArray3[0], stringArray2[0], stringArray[1], stringArray3[1], stringArray2[1]);
                        ((Component)linkFrame).setVisible(true);
                        this.changeCursor(0);
                    }
                }
            };
            thread.start();
        }
    }

    public void launchSuggCandDialog() {
        SuggCandDialog suggCandDialog = new SuggCandDialog(this.sTopo);
    }

    public void launchVisualSwitchMgr(Node node) {
        block2: {
            if (!node.canLaunchVisualSwitchManager()) break block2;
            try {
                ((Applet)((Object)this.sTopo)).getAppletContext().showDocument(node.consoleUrl, "CVSM");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Edge lookupEdge(String string, String string2, String string3, String string4) {
        Edge edge = this.getEdge(string, string3, string2, string4);
        if (edge != null ? edge.fromDevicePortLbl.compareTo(string3) == 0 : (edge = this.getEdge(string2, string4, string, string3)) != null && edge.toDevicePortLbl.compareTo(string4) == 0) {
            return edge;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        block7: {
            if (mouseEvent.isAltDown()) break block7;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Dimension dimension = this.getSize();
            if (n < 0) {
                n = 0;
            }
            if (n >= dimension.width) {
                n = dimension.width;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= dimension.height) {
                n2 = dimension.height;
            }
            if (this.curMenu < 0 && this.currSelNode != null) {
                try {
                    this.currSelNode.x = n;
                    this.currSelNode.y = n2;
                    this.movedNode = this.currSelNode;
                    this.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block10: {
            if (mouseEvent == null || this.fm == null) break block10;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.cursorPosX = n;
            this.cursorPosY = n2;
            try {
                if (this.curMenu >= 0) {
                    if (n > this.MenuAreaX[this.curMenu] && n < this.MenuAreaX[this.curMenu] + this.MAWidth[this.curMenu] && n2 > this.MenuAreaY[this.curMenu] && n2 < this.MenuAreaY[this.curMenu] + this.MAHeight[this.curMenu] || this.curMenu == n2 / 23) {
                        this.curSubMenu = (n2 - this.MenuAreaY[this.curMenu]) / (this.fm.getAscent() + 4);
                        if (this.curSubMenu > this.numItems[this.curMenu] - 1) {
                            this.curSubMenu = 0;
                        }
                    } else {
                        this.curMenu = -2;
                        this.curEdge = null;
                    }
                }
                if (this.bClusterBuilder && this.myApplet != null) {
                    this.myApplet.getAppletContext().showStatus("Cisco Cluster Builder");
                } else {
                    this.myApplet.getAppletContext().showStatus("Cisco Cluster View");
                }
                if (this.curMenu >= 0 || this.curMenu == -2) {
                    if (this.curMenu == -2) {
                        this.curMenu = -1;
                    }
                    this.repaint();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in ClusterPanel::mouseMoved() " + exception);
                exception.printStackTrace();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.multiSelectionOccured = false;
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.movedNode = null;
            if (mouseEvent.isAltDown() && mouseEvent.isControlDown()) {
                this.clusterCLI.toggleResponeReporting();
            }
            this.curPoint.x = n;
            this.curPoint.y = n2;
            this.currSelNode = null;
            Node node = this.deviceClicked(n, n2);
            if (node != null) {
                this.currSelNode = node;
                this.currOldX = (int)node.x;
                this.currOldY = (int)node.y;
                this.bCurrSelNodeFixed = this.currSelNode.bFixed;
                this.currSelNode.bFixed = true;
                this.setCursor(new Cursor(13));
                if (mouseEvent.getClickCount() == 2 && this.currSelNode.isUp() && !this.currSelNode.isRelay()) {
                    URL uRL = null;
                    this.setCursor(new Cursor(3));
                    try {
                        if (this.currSelNode.designation == 5) {
                            String string = this.currSelNode.vbnLbl.replace('.', '_');
                            uRL = new URL("http://" + this.currSelNode.clusterID + "/cluster.html");
                            ((Applet)((Object)this.sTopo)).getAppletContext().showDocument(uRL, string);
                        } else if (this.currSelNode.canLaunchVisualSwitchManager()) {
                            this.launchVisualSwitchMgr(this.currSelNode);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else if (this.isPointOnLink(n, n2) && this.bClusterBuilder) {
                Node node2;
                Node node3 = this.curEdge.fromPort.getDevice();
                Vector vector = node3.getEdgesToNode(node2 = this.curEdge.toPort.getDevice());
                if (vector.size() > 1) {
                    this.curMenu = 4;
                    this.setItemsAndDisplayEdgeSelectionMenu(this.curEdge, n, n2);
                    this.multiSelectionOccured = true;
                } else {
                    this.multiSelectionOccured = false;
                }
            }
        } else if ((mouseEvent.getModifiers() & 4) != 0) {
            this.bDeviceClicked = false;
            this.currSelNode = null;
            this.curNode = null;
            if (mouseEvent.isAltDown() && mouseEvent.isControlDown()) {
                this.forceNextUpdate = true;
                this.updateView(false);
            } else if (mouseEvent.isAltDown()) {
                ClusterCLI.stepScenario();
                this.forceNextUpdate = true;
                this.updateView(false);
            }
            Node node = this.deviceClicked(n, n2);
            if (node != null) {
                this.currSelNode = node;
                this.curMenu = node.designation >= 6 ? 3 : node.designation;
                this.curPoint.x = n;
                this.curPoint.y = n2;
                this.curNode = node;
                this.endNode = null;
                this.bDeviceClicked = true;
                this.setItemsAndDisplayDeviceMenu(node, n, n2);
            } else if (this.bClusterBuilder && this.isPointOnLink(n, n2)) {
                this.curMenu = 1;
                this.setItemsAndDisplayLinkMenu(this.curEdge, n, n2);
            } else {
                this.curMenu = -1;
                this.curEdge = null;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (!mouseEvent.isAltDown()) {
                Edge edge;
                Node node;
                if (this.bClusterBuilder && (node = this.deviceClicked(n, n2)) != null) {
                    if (node.isSelectable() && node != this.movedNode) {
                        this.curMenu = -1;
                        this.curEdge = null;
                        this.deselectAllEdges();
                        boolean bl = node.isSelected();
                        if (node.isMember()) {
                            this.deselectAllCandidates();
                        } else if (node.isCandidate()) {
                            this.deselectAllMembers();
                        }
                        if (!mouseEvent.isControlDown()) {
                            this.deselectAllNodes();
                        }
                        node.setSelected(!bl);
                        this.sTopo.updateDeviceMenu(this.getSelectedDeviceCount());
                    }
                } else if (this.bClusterBuilder && (edge = this.edgeClicked(n, n2)) != null && !this.multiSelectionOccured) {
                    this.curMenu = -1;
                    this.curEdge = null;
                    this.deselectAllNodes();
                    boolean bl = edge.isSelected();
                    this.deselectAllEdges();
                    edge.setSelected(!bl);
                    this.sTopo.updateLinkMenu(this.getSelectedEdgeCount());
                }
            }
        } else if (this.currSelNode != null) {
            if (this.currSelNode.x < 25.0) {
                this.currSelNode.x = 40.0;
            }
            if (this.currSelNode.x > (double)this.mySize.width) {
                this.currSelNode.x = this.mySize.width - 40;
            }
            if (this.currSelNode.y < 10.0) {
                this.currSelNode.y = 40.0;
            }
            if (this.currSelNode.y > (double)this.mySize.height) {
                this.currSelNode.y = this.mySize.height - 40;
            }
            if (this.isDeviceUnderCursor(this.currSelNode)) {
                this.currSelNode.x = this.currOldX;
                this.currSelNode.y = this.currOldY;
            }
            this.currSelNode.bFixed = this.bCurrSelNodeFixed;
            this.repaint();
        }
        this.setCursor(new Cursor(0));
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension;
        Node node = null;
        if (!this.layoutCompleted) {
            return;
        }
        this.mySize = dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        int n = 0;
        this.offgraphics.setColor(Color.black);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(Color.white);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(Color.black);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        FontMetrics fontMetrics = this.offgraphics.getFontMetrics();
        Node node2 = null;
        Node node3 = null;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            node2 = this.getNode(edge.fromLbl);
            node3 = this.getNode(edge.toLbl);
            if (node2 == null || node3 == null || node2 == node3) continue;
            edge.paintEdge(this.offgraphics, this, fontMetrics);
        }
        Enumeration enumeration2 = this.nodes.elements();
        while (enumeration2.hasMoreElements()) {
            node = (Node)enumeration2.nextElement();
            if (!node.isVisible) continue;
            node.paintNode(this.offgraphics, this, fontMetrics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private synchronized void placeNeighbors(Node node) {
        int n = this.getNumNeighbors(node);
        int n2 = this.getNumStackNeighbors(node);
        double d = 0.0;
        double d2 = 0.0;
        Node node2 = null;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = n - n2;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 1;
        int n6 = 1;
        int n7 = n > 6 ? (int)(160.0 * (double)n / 6.0) : 160;
        int n8 = 0;
        if (node == this.centerNode) {
            n7 = n > 12 ? (int)((double)(200 * n) / 12.0) : 200;
        }
        n3 = this.computePositionRelToCaptain(node);
        d5 = 180.0;
        double d6 = n2 > 1 ? d5 / (double)(n2 - 1) : 45.0;
        double d7 = n4 > 1 ? d5 / (double)(n4 - 1) : 45.0;
        switch (n3) {
            case 0: {
                d = 180.0;
                n5 = -1;
                n6 = -1;
                break;
            }
            case 1: {
                d = -180.0;
                break;
            }
            case 3: {
                d = 90.0;
                n5 = -1;
                n6 = -1;
                break;
            }
            case 2: {
                d = 90.0;
                break;
            }
            default: {
                d5 = 360.0;
                d = 90.0;
                d6 = n2 > 1 ? d5 / (double)n2 : 45.0;
                d7 = n4 > 1 ? d5 / (double)n4 : 45.0;
            }
        }
        d2 = d;
        d3 = d6 *= (double)n6;
        d4 = d7 *= (double)n5;
        Enumeration enumeration = node.neighbors.elements();
        while (enumeration.hasMoreElements()) {
            node2 = (Node)enumeration.nextElement();
            if (node2.bPlaced || !node2.bStack) continue;
            n8 = node2.neighbors.size() > 6 ? n7 * node2.neighbors.size() / 6 : n7;
            this.setCoordinates(node2, node, n8, d2, d3);
            d2 += d6;
        }
        d2 = d;
        Enumeration enumeration2 = node.neighbors.elements();
        while (enumeration2.hasMoreElements()) {
            node2 = (Node)enumeration2.nextElement();
            if (node2.bPlaced || node2.bStack) continue;
            n8 = node2.neighbors.size() > 6 ? n7 * node2.neighbors.size() / 6 : n7;
            this.setCoordinates(node2, node, n8, d2, d4);
            d2 += d7;
        }
        node.bNeighborsPlaced = true;
        Enumeration enumeration3 = node.neighbors.elements();
        while (enumeration3.hasMoreElements()) {
            node2 = (Node)enumeration3.nextElement();
            if (node2.bNeighborsPlaced) continue;
            this.placeNeighbors(node2);
        }
    }

    private void placeRelays() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isRelay() || node.bPlaced) continue;
            ((RelayNode)node).placeYourself();
        }
    }

    private String portNameToURLCompatibleForm(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '/') {
                cArray[n] = 45;
            }
            ++n;
        }
        return new String(cArray);
    }

    private void removeFromCluster(Node node) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        this.changeCursor(3);
        this.sTopo.setAllowUpdates(false);
        this.sTopo.addOrRemoveInProgress(true);
        String string = node.switchStr;
        String string2 = string.substring(2);
        n = new Integer(string2);
        String string3 = this.clusterCLI.runCLICommand(this.sTopoHost, "no cluster member " + n + " mac " + node.macAddr, "configure");
        n2 = string3.indexOf("%ERROR");
        if (n2 == -1) {
            this.waitForSwitchAndUpdateView(false, 5000);
            if (this.getNode(node.vbnLbl) != null) {
                this.updateNotifyThread.setUpdatePeriod(11000.0);
                this.forceNextUpdate = true;
            }
        } else {
            n3 = string3.indexOf("</DL><HR><PRE>");
            string3 = string3.substring(n2, n3);
            JOptionPane.showMessageDialog(null, string3, "Error : Failure Removing Member", 0);
        }
        this.sTopo.setAllowUpdates(true);
        this.sTopo.addOrRemoveInProgress(false);
        this.changeCursor(0);
    }

    public void removeSelectedFromCluster() {
        Thread thread = new Thread(){

            public void run() {
                String string = "";
                StringBuffer stringBuffer = new StringBuffer(1024);
                Vector<Object[]> vector = new Vector<Object[]>();
                Vector vector2 = ClusterPanel.this.getSelectedMembers();
                if (vector2.size() == 0) {
                    vector2.addElement(ClusterPanel.this.currSelNode);
                }
                Enumeration enumeration = vector2.elements();
                ClusterPanel.this.changeCursor(3);
                ClusterPanel.this.sTopo.setAllowUpdates(false);
                ClusterPanel.this.sTopo.addOrRemoveInProgress(true);
                while (enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    String string2 = node.switchStr;
                    String string3 = string2.substring(2);
                    int n = Integer.parseInt(string3);
                    string = ClusterPanel.this.clusterCLI.runCLICommand(ClusterPanel.this.sTopoHost, "no cluster member " + n + " mac " + node.macAddr, "configure");
                    int n2 = string.indexOf("%ERROR");
                    if (n2 == -1) continue;
                    Object[] objectArray = new Object[]{node, string};
                    vector.addElement(objectArray);
                }
                ClusterPanel.this.deselectAllNodes();
                if (vector.size() > 0) {
                    ClusterPanel.this.displayErrors(vector, "Error : Failure Removing Members");
                }
                if (vector2.size() != vector.size()) {
                    ClusterPanel.this.waitForSwitchAndUpdateView(false, 5000);
                }
                ClusterPanel.this.sTopo.setAllowUpdates(true);
                ClusterPanel.this.sTopo.addOrRemoveInProgress(false);
                ClusterPanel.this.changeCursor(0);
            }
        };
        thread.start();
    }

    private String replaceChars(String string, String string2, String string3) {
        String string4 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            string4 = String.valueOf(string4) + string3;
            string4 = String.valueOf(string4) + stringTokenizer.nextToken();
        }
        return string4;
    }

    public void run() {
        this.commanderIP = Cluster.getCodeBaseHost();
        this.dynamicUpdate(true);
        this.bClusterBuilder ^= true;
        this.changeView(true);
        this.bClusterBuilder ^= true;
        this.changeView(false);
        this.clusterCLI = new ClusterCLI();
        this.launchSuggCandDialog();
        this.sTopo.initializationComplete();
    }

    public void saveConfiguration() {
        Thread thread = new Thread(){

            public void run() {
                ClusterPanel.this.changeCursor(3);
                String string = Cluster.getCodeBaseHost();
                ClusterCLI clusterCLI = new ClusterCLI();
                String string2 = clusterCLI.runCLICommand(string, "show cluster members html", "exec");
                string2 = clusterCLI.runCLICommand(string, "write memory", "exec");
                ClusterPanel.this.changeCursor(0);
                String string3 = "Configuration was saved successfully.";
                String string4 = "Info: Save Configuration";
                int n = 1;
                if (string2.indexOf("Error") != -1) {
                    int n2 = string2.indexOf("Error");
                    int n3 = string2.indexOf("<", n2);
                    string3 = string2.substring(n2, n3);
                    string4 = "Error: Save Configuration";
                    n = 0;
                } else if (string2.indexOf("Building configuration") < 0) {
                    string3 = "Error in  Saving Configuration.";
                    string4 = "Error: Save Configuration";
                    n = 0;
                }
                JOptionPane.showMessageDialog((Component)((Object)ClusterPanel.this.sTopo), string3, string4, n);
            }
        };
        thread.start();
    }

    public synchronized void saveLayout() {
        if (this.doSaveLayout == null) {
            this.doSaveLayout = new Thread(){

                public void run() {
                    Object object;
                    String string = new String("");
                    Vector<String> vector = new Vector<String>();
                    int n = 1;
                    Enumeration enumeration = ClusterPanel.this.nodes.elements();
                    while (enumeration.hasMoreElements()) {
                        Node node = (Node)enumeration.nextElement();
                        object = node.upStreamMacAddr;
                        if (((String)object).length() == 0) {
                            object = "NONE";
                        }
                        string = node.isRelay() ? String.valueOf(string) + node.hostLbl + ",NONE," + (int)node.x + "," + (int)node.y : String.valueOf(string) + node.macAddr + "," + (String)object + "," + (int)node.x + "," + (int)node.y;
                        if (enumeration.hasMoreElements()) {
                            string = String.valueOf(string) + ",";
                        }
                        if (n % 5 == 0 || !enumeration.hasMoreElements()) {
                            vector.addElement(string);
                            string = "";
                        }
                        ++n;
                    }
                    ClusterPanel.this.sTopo.setAppletBlocked(true);
                    ClusterPanel.this.setCursor(new Cursor(3));
                    n = 0;
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        String string2 = n == 0 ? ClusterPanel.this.clusterCLI.runCLICommand(ClusterPanel.this.sTopoHost, "cluster preferences file flash:placement.txt " + string, "exec") : ClusterPanel.this.clusterCLI.runCLICommand(ClusterPanel.this.sTopoHost, "cluster preferences file append flash:placement.txt " + string, "exec");
                        ++n;
                    }
                    ClusterPanel.this.setCursor(new Cursor(0));
                    ClusterPanel.this.sTopo.setAppletBlocked(false);
                    ClusterPanel.this.doSaveLayout = null;
                }
            };
            this.doSaveLayout.start();
        }
    }

    public void setAllowUpdates(boolean bl) {
        this.updateNotifyThread.setAllowUpdates(bl);
    }

    public void setCoordinates(Node node, Node node2, int n, double d, double d2) {
        double d3 = 1.0;
        double d4 = 0.15;
        double d5 = d;
        double d6 = d2;
        boolean bl = false;
        int n2 = 0;
        double d7 = n;
        if (!node.bPlaced || node.bStack && node2.bStack) {
            this.computeCoordinates(node, node2, (int)d7, d5);
            while (this.isLinkOnAnotherLink(node, node2, d5) || this.isDeviceOutOfBounds(node) || this.isDeviceUnderCursor(node)) {
                if (Math.abs((double)(++n2) * d6) >= 360.0) {
                    d6 = d2 * (d3 -= d4);
                    n2 = 0;
                    if (Math.abs(d6) < 10.0) {
                        Dimension dimension = this.getSize();
                        if (node.x > (double)dimension.width) {
                            node.x = dimension.width - 10;
                        } else if (node.x < 25.0) {
                            node.x = 35.0;
                        }
                        if (node.y > (double)dimension.height) {
                            node.y = dimension.height - 10;
                            break;
                        }
                        if (!(node.y < 10.0)) break;
                        node.y = 20.0;
                        break;
                    }
                }
                this.computeCoordinates(node, node2, (int)d7, d5 += d6);
            }
            d = d5;
            node.bPlaced = true;
            node.primaryEdgeLen = (int)d7;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void setItemsAndDisplayDeviceMenu(Node var1_1, int var2_2, int var3_3) {
        var5_4 = var1_1.designation;
        this.popUpMenu.removeAll();
        if (!this.bClusterBuilder) ** GOTO lbl77
        if (this.currSelNode.isRelay()) {
            return;
        }
        this.multiMembers = this.getSelectedMembers().size();
        this.multiCandidates = this.getSelectedCandidates().size();
        switch (var5_4) {
            case 0: 
            case 1: {
                if (this.multiMembers > 0 && !this.currSelNode.isSelected()) {
                    this.deselectAllNodes();
                    this.multiMembers = 0;
                }
                if (this.multiCandidates > 0) {
                    this.deselectAllCandidates();
                }
                var4_5 = new JMenuItem(this.SWITCH_MANAGER_MENU);
                var4_5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClusterPanel.this.launchVisualSwitchMgr(ClusterPanel.this.currSelNode);
                    }
                });
                if (this.multiMembers > 1 || !this.currSelNode.isUp()) {
                    var4_5.setEnabled(false);
                }
                this.popUpMenu.add(var4_5);
                if (!var1_1.isOldDevice()) {
                    var4_5 = new JMenuItem(this.BW_GRAPH_MENU);
                    var4_5.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ClusterPanel.this.launchDeviceBandwidthGraph(ClusterPanel.this.currSelNode);
                        }
                    });
                    this.popUpMenu.add(var4_5);
                    if (this.multiMembers > 1 || !this.currSelNode.isUp()) {
                        var4_5.setEnabled(false);
                    }
                }
                var4_5 = new JMenuItem(this.HOSTNAME_CONFIG_MENU);
                var4_5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClusterPanel.this.configureHostName(ClusterPanel.this.currSelNode);
                    }
                });
                if (this.multiMembers > 1 || !this.currSelNode.isUp()) {
                    var4_5.setEnabled(false);
                }
                this.popUpMenu.add(var4_5);
                if (this.currSelNode.isMember()) {
                    var4_5 = new JMenuItem(this.REMOVE_FROM_CLUSTER_MENU);
                    var4_5.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Thread thread = new Thread(ClusterPanel.this){
                                private final /* synthetic */ ClusterPanel this$0;
                                {
                                    this.this$0 = clusterPanel;
                                }

                                public void run() {
                                    if (ClusterPanel.access$4(this.this$0) > 0) {
                                        this.this$0.removeSelectedFromCluster();
                                    } else {
                                        ClusterPanel.access$5(this.this$0, ClusterPanel.access$3(this.this$0));
                                    }
                                }
                            };
                            thread.start();
                        }
                    });
                    if (!this.currSelNode.isUp() || this.sTopo.isAddOrRemoveInProgress()) {
                        var4_5.setEnabled(false);
                    }
                    this.popUpMenu.add(var4_5);
                }
                if (var1_1.candidateNeighborsShown) {
                    var4_5 = new JMenuItem(this.HIDE_CANDIDATES_MENU);
                    var4_5.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ClusterPanel.this.hideCandidateNeighbors(ClusterPanel.this.currSelNode);
                        }
                    });
                } else {
                    var4_5 = new JMenuItem(this.SHOW_CANDIDATES_MENU);
                    var4_5.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ClusterPanel.this.showCandidateNeighbors(ClusterPanel.this.currSelNode);
                        }
                    });
                }
                if (!var1_1.hasCandidateNeighbors()) {
                    var4_5.setEnabled(false);
                }
                this.popUpMenu.add(var4_5);
                var4_5 = new JMenuItem(this.CLEAR_STATE);
                var4_5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClusterPanel.this.currSelNode.setFault(false);
                    }
                });
                if (!this.currSelNode.isFault() || this.multiMembers > 1) {
                    var4_5.setEnabled(false);
                }
                this.popUpMenu.add(var4_5);
                break;
            }
            case 2: {
                if (this.multiCandidates > 0 && !this.currSelNode.isSelected()) {
                    this.deselectAllNodes();
                    this.multiCandidates = 0;
                }
                if (this.multiMembers > 0) {
                    this.deselectAllMembers();
                }
                var4_6 = new JMenuItem(this.DEVICE_WEB_PAGE_MENU);
                var4_6.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClusterPanel.this.launchVisualSwitchMgr(ClusterPanel.this.currSelNode);
                    }
                });
                if (!var1_1.canLaunchVisualSwitchManager() || this.multiCandidates > 1) {
                    var4_6.setEnabled(false);
                }
                this.popUpMenu.add(var4_6);
                var4_6 = new JMenuItem(this.ADD_TO_CLUSTER_MENU);
                var4_6.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Thread thread = new Thread(ClusterPanel.this){
                            private final /* synthetic */ ClusterPanel this$0;
                            {
                                this.this$0 = clusterPanel;
                            }

                            public void run() {
                                if (ClusterPanel.access$6(this.this$0) > 0) {
                                    this.this$0.addSelectedToCluster();
                                } else {
                                    ClusterPanel.access$7(this.this$0, ClusterPanel.access$3(this.this$0));
                                }
                            }
                        };
                        thread.start();
                    }
                });
                if (this.numClusterNodes >= 16 || this.sTopo.isAddOrRemoveInProgress() || !this.currSelNode.isUp()) {
                    var4_6.setEnabled(false);
                }
                this.popUpMenu.add(var4_6);
                break;
            }
lbl77:
            // 1 sources

            var4_7 = new JMenuItem(this.DEVICE_WEB_PAGE_MENU);
            var4_7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusterPanel.this.changeCursor(3);
                    ((Applet)((Object)ClusterPanel.this.sTopo)).getAppletContext().showDocument(((ClusterPanel)ClusterPanel.this).currSelNode.consoleUrl, "CVSM");
                    ClusterPanel.this.changeCursor(0);
                }
            });
            if (var1_1.vbnLbl.indexOf("0.0.0.0") != -1 || !this.currSelNode.isUp()) {
                var4_7.setEnabled(false);
            }
            this.popUpMenu.add(var4_7);
            var4_7 = new JMenuItem(this.DISQUALIFICATION_CODE_MENU);
            var4_7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(null, ClusterPanel.this.translateCode(((ClusterPanel)ClusterPanel.this).currSelNode.disqualificationCode), "Info : Device Not Qualified", 1);
                }
            });
            if (var1_1.disqualificationCode.compareTo("0") == 0) {
                var4_7.setEnabled(false);
            }
            this.popUpMenu.add(var4_7);
            break;
        }
        this.add(this.popUpMenu);
        this.popUpMenu.show(this, var2_2, var3_3);
    }

    void setItemsAndDisplayEdgeSelectionMenu(Edge edge, int n, int n2) {
        this.popUpMenu.removeAll();
        Node node = edge.fromPort.getDevice();
        Node node2 = edge.toPort.getDevice();
        Vector vector = node.getEdgesToNode(node2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge2 = (Edge)enumeration.nextElement();
            JMenuItem jMenuItem = new JMenuItem(String.valueOf(edge2.fromDevicePortLbl) + "  ::  " + edge2.toDevicePortLbl);
            if (edge2.isPrimary()) {
                jMenuItem.setIcon(ImageFactory.getEntry(ImageFactory.MULTI_LINK).getIcon());
            } else {
                jMenuItem.setIcon(ImageFactory.getEntry(ImageFactory.BLANK).getIcon());
            }
            jMenuItem.putClientProperty("selection", edge2);
            jMenuItem.putClientProperty("list", vector);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusterPanel.this.multiSelectionOccured = true;
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    Edge edge = (Edge)jMenuItem.getClientProperty("selection");
                    Vector vector = (Vector)jMenuItem.getClientProperty("list");
                    if (edge.isPrimary()) {
                        ClusterPanel.this.deselectAllNodes();
                        boolean bl = edge.isSelected();
                        ClusterPanel.this.deselectAllEdges();
                        edge.setSelected(!bl);
                        ClusterPanel.this.sTopo.updateLinkMenu(ClusterPanel.this.getSelectedEdgeCount());
                    } else {
                        ClusterPanel.this.deselectAllNodes();
                        ClusterPanel.this.deselectAllEdges();
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Edge edge2 = (Edge)enumeration.nextElement();
                            if (edge2 == edge) {
                                edge2.setPrimary();
                                continue;
                            }
                            edge2.setSecondary();
                        }
                        edge.setSelected(true);
                        ClusterPanel.this.sTopo.updateLinkMenu(ClusterPanel.this.getSelectedEdgeCount());
                        ClusterPanel.this.repaint();
                    }
                }
            });
            this.popUpMenu.add(jMenuItem);
        }
        this.add(this.popUpMenu);
        this.popUpMenu.show(this, n, n2);
    }

    void setItemsAndDisplayLinkMenu(Edge edge, int n, int n2) {
        JMenuItem jMenuItem;
        this.popUpMenu.removeAll();
        Node node = edge.fromPort.getDevice();
        Node node2 = edge.toPort.getDevice();
        Edge edge2 = this.getSingleSelectedEdge();
        if (edge2 != null && edge2 != this.curEdge) {
            edge2.setSelected(false);
        }
        if (node.designation == 0 || node.designation == 1) {
            jMenuItem = new JMenuItem(this.LINK_GRAPH_MENU);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusterPanel.this.launchLinkGraph(ClusterPanel.this.curEdge);
                }
            });
            if (!edge.canLaunchLinkGraph()) {
                jMenuItem.setEnabled(false);
            }
            this.popUpMenu.add(jMenuItem);
        } else if (node2.designation == 0 || node2.designation == 1) {
            jMenuItem = new JMenuItem(this.LINK_GRAPH_MENU);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusterPanel.this.launchLinkGraph(ClusterPanel.this.curEdge);
                }
            });
            if (!edge.canLaunchLinkGraph()) {
                jMenuItem.setEnabled(false);
            }
            this.popUpMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(this.LINK_REPORT_MENU);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusterPanel.this.launchLinkReport(ClusterPanel.this.curEdge);
            }
        });
        if (!edge.canLaunchLinkReport()) {
            jMenuItem.setEnabled(false);
        }
        this.popUpMenu.add(jMenuItem);
        this.add(this.popUpMenu);
        this.popUpMenu.show(this, n, n2);
    }

    private void setMultiLinkPrimaryEdges() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Enumeration enumeration2 = this.nodes.elements();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                Vector vector = node.getEdgesToNode(node2);
                int n = vector.size();
                if (n <= 1) continue;
                Edge edge = null;
                Edge edge2 = null;
                Edge edge3 = null;
                Enumeration enumeration3 = vector.elements();
                while (enumeration3.hasMoreElements()) {
                    Edge edge4 = (Edge)enumeration3.nextElement();
                    if (edge == null) {
                        edge = edge4;
                    }
                    edge4.setSecondary();
                    edge3 = edge.isBetter(edge4) ? edge : edge4;
                    if (edge2 == null) {
                        edge2 = edge3;
                        continue;
                    }
                    if (!edge4.isBetter(edge2)) continue;
                    edge2 = edge4;
                }
                if (edge2 == null) continue;
                edge2.setPrimary();
            }
        }
    }

    public void setNodeHostName(String string, Node node) {
        String string2 = this.clusterCLI.runCLICommand(this.sTopoHost, String.valueOf(node.switchStr) + " hostname \"" + string + "\"", "configure");
        this.repaint();
    }

    private void setTopologyStable(boolean bl) {
        if (bl != this.isStable) {
            this.isStable = bl;
            this.repaint();
        }
    }

    private void setUpNodesAccordingToView() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.bNeighborsPlaced = false;
            node.bPlaced = false;
            switch (node.designation) {
                case 1: {
                    node.isVisible = this.bClusterBuilder;
                    break;
                }
                case 0: {
                    node.isVisible = true;
                    break;
                }
                case 2: {
                    node.isVisible = true;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    node.isVisible = this.bClusterBuilder ^ true;
                    break;
                }
                case 6: {
                    node.isVisible = this.bClusterBuilder ^ true;
                    break;
                }
                default: {
                    node.isVisible = false;
                }
            }
            Hashtable hashtable = node.neighbors = this.bClusterBuilder ? node.getClusterNeighbors() : node.getNetworkNeighbors();
        }
    }

    public void showCandidateNeighbors(Node node) {
        boolean bl = false;
        if (!node.candidateNeighborsShown) {
            Enumeration enumeration = node.neighbors.elements();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)enumeration.nextElement();
                if (node2.designation != 2) continue;
                if (!node.candidateNeighborsShown) {
                    node.candidateNeighborsShown = true;
                }
                node2.isHiddenCandidate = false;
                if (node2.candidateNeighborsShown) continue;
                this.showCandidateNeighbors(node2);
                this.updateMembersCandidateShownStatus(node2, true);
            }
            node.candidateNeighborsShown = true;
        }
        this.repaint();
    }

    public void shutdown() {
        this.allowed_to_run = false;
    }

    public void start() {
        this.initialDrawThread = new Thread((Runnable)this, "ClusterPanel initialDrawThread");
        this.initialDrawThread.start();
        this.updateNotifyThread = new UpdateNotify(this, this.updateInterval);
        this.updateNotifyThread.start();
    }

    public void stop() {
        if (this.updateNotifyThread != null) {
            this.updateNotifyThread.shutdown();
            UpdateNotify updateNotify = this.updateNotifyThread;
            synchronized (updateNotify) {
                this.updateNotifyThread.notify();
            }
        }
        this.updateNotifyThread = null;
        this.sTopo = null;
        this.myFrame = null;
        this.myApplet = null;
        this.nodes.clear();
        this.nodes = null;
        this.commanders.clear();
        this.commanders = null;
        this.mac2vbnMap.clear();
        this.mac2vbnMap = null;
        this.gifTable.clear();
        this.gifTable = null;
        this.islandsToBePlaced.clear();
        this.islandsToBePlaced = null;
        this.edges.removeAllElements();
        this.edges = null;
        this.curNode = null;
        this.curEdge = null;
        this.currSelNode = null;
        this.movedNode = null;
    }

    public void toggleCandidateVisible(Node node) {
        if (node.isMember()) {
            if (node.candidateNeighborsShown) {
                this.hideCandidateNeighbors(node);
                this.repaint();
            } else {
                this.showCandidateNeighbors(node);
                this.repaint();
            }
        }
    }

    public void toggleLabels() {
        this.bLabel ^= true;
        this.repaint();
    }

    public void toggleSelectedCandidateVisible() {
        Enumeration enumeration = this.getSelectedMembers().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isMember()) continue;
            if (node.candidateNeighborsShown) {
                this.hideCandidateNeighbors(node);
                this.repaint();
                continue;
            }
            this.showCandidateNeighbors(node);
            this.repaint();
        }
    }

    public void toggleViews() {
        Thread thread = new Thread(){

            public void run() {
                ClusterPanel.this.deselectAllNodes();
                ClusterPanel.this.deselectAllEdges();
                ClusterPanel.this.changeCursor(3);
                ClusterPanel.this.bClusterBuilder ^= true;
                ClusterPanel.this.changeView(false);
                ClusterPanel.this.sTopo.setTitle(ClusterPanel.this.bClusterBuilder);
                ClusterPanel.this.changeCursor(0);
                ClusterPanel.this.repaint();
            }
        };
        thread.start();
    }

    private String translateCode(String string) {
        int n = -1;
        String string2 = null;
        try {
            n = Integer.parseInt(string);
            string2 = this.disqualificationStrings[n];
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "Unknown disqualification code";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string2 = "Unknown disqualification code";
        }
        return string2;
    }

    private void updateFaultIndications(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Node node2 = (Node)hashtable.get(node.vbnLbl);
            if (node2 == null || !node.isMember() || node2.macAddr.compareTo(node.macAddr) != 0) continue;
            node.setFault(false);
            if (node2.isFault() && node.isUp()) {
                node.setFault(true);
                continue;
            }
            if (node2.isUp() || !node.isUp()) continue;
            node.setFault(true);
        }
    }

    public void updateMembersCandidateShownStatus(Node node, boolean bl) {
        Enumeration enumeration = node.neighbors.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (node2.designation != 1 && node2.designation != 0) continue;
            node2.candidateNeighborsShown = bl;
        }
        this.repaint();
    }

    private void updateStability(boolean bl) {
        if (!bl) {
            this.updateNotifyThread.setUpdatePeriod(15000.0);
        }
        this.sTopo.updateStability(bl);
    }

    void updateView(boolean bl) {
        boolean bl2 = true;
        String string = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster html", "exec");
        String string2 = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster members html", "exec");
        String string3 = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster cdp-neighbors html", "exec");
        String string4 = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster candidates html", "exec");
        String string5 = this.clusterCLI.runCLICommand(this.sTopoHost, "show cluster port neighbor html", "exec");
        if (string == null || string2 == null || string3 == null || string4 == null || string5 == null) {
            JOptionPane.showMessageDialog(null, "Error : The switches are not returning responses!", "Switch Communication Failure", 0);
        } else {
            Hashtable hashtable = this.nodes;
            Vector vector = this.edges;
            this.updateNotifyThread.setLastUpdateTime(System.currentTimeMillis());
            bl2 = this.bClusterBuilder ? this.equivelent(this.oldClusterMembersList, string2) && this.equivelent(this.oldCandidatesList, string4) && this.equivelent(this.oldPortList, string5) : this.equivelent(this.oldCDPNeighborsList, string3);
            if (bl2) {
                if (this.stable_topology_count < 1) {
                    this.updateStability(false);
                    ++this.stable_topology_count;
                } else {
                    this.updateStability(true);
                }
            } else {
                this.updateStability(false);
                this.stable_topology_count = 0;
            }
            if (this.forceNextUpdate || !bl2) {
                if (this.forceNextUpdate) {
                    this.forceNextUpdate = false;
                }
                this.setCursor(new Cursor(3));
                this.oldClusterMembersList = string2;
                this.oldCDPNeighborsList = string3;
                this.oldCandidatesList = string4;
                this.oldPortList = string5;
                this.buildNodesAndEdges(string, string2, string3, string4, string5);
                this.updateFaultIndications(hashtable, this.nodes);
                hashtable.clear();
                hashtable = null;
                vector = null;
                this.centerNode = this.getCommander();
                this.setUpNodesAccordingToView();
                this.drawInitialNodes(bl);
                this.setCursor(new Cursor(0));
                this.sTopo.updateDeviceMenu(this.getSelectedDeviceCount());
                this.sTopo.updateLinkMenu(this.getSelectedEdgeCount());
            }
        }
    }

    private String vbnLblToURLCompatibleForm(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '_') {
                cArray[n] = 45;
            }
            ++n;
        }
        return new String(cArray);
    }

    public void waitForSwitchAndUpdateView(boolean bl, int n) {
        try {
            Thread.sleep(n);
            Thread.sleep(n);
            this.changeCursor(3);
            this.updateView(bl);
            this.changeCursor(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class SymAncestor
    implements AncestorListener {
        SymAncestor() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Object object = ancestorEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_ancestorAdded(ancestorEvent);
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
            Object object = ancestorEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_ancestorMoved(ancestorEvent);
            }
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_componentMoved(componentEvent);
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_componentShown(componentEvent);
            }
        }
    }

    class SymFocus
    extends FocusAdapter {
        SymFocus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_focusLost(focusEvent);
            }
        }
    }

    class SymContainer
    extends ContainerAdapter {
        SymContainer() {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Object object = containerEvent.getSource();
            if (object == ClusterPanel.this) {
                ClusterPanel.this.ClusterPanel_componentRemoved(containerEvent);
            }
        }
    }
}

