/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;

public class RotateString
implements Serializable {
    private Component parent;
    private Color c;
    private Font f;
    private transient Image tmp;

    public RotateString(Component component) {
        this.parent = component;
        this.c = null;
        this.f = null;
    }

    private void drawString(String string, int n, int n2, int n3, int n4, int n5, Image image) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (string == null) {
            return;
        }
        double d = -Math.PI * (double)n5 / 180.0;
        Graphics graphics = image.getGraphics();
        if (this.f == null) {
            this.f = graphics.getFont();
        }
        if (this.c == null) {
            this.c = graphics.getColor();
        }
        if (this.c == null) {
            this.c = Color.black;
        }
        Rectangle rectangle = this.getExtent(string, n, n2, 0, this.f);
        int n11 = rectangle.x;
        int n12 = rectangle.y;
        int n13 = rectangle.width;
        int n14 = rectangle.height;
        if (n5 == 0) {
            n10 = n11;
            n9 = n12;
            n8 = n13;
            n7 = n14;
        } else {
            rectangle = this.rotateRectangle(rectangle, n3, n4, d);
            n10 = rectangle.x;
            n9 = rectangle.y;
            n8 = rectangle.width;
            n7 = rectangle.height;
        }
        this.tmp = this.parent.createImage(n13, n14);
        Graphics graphics2 = this.tmp.getGraphics();
        int n15 = n6 = this.c.getRGB();
        n6 = Color.black.getRGB();
        graphics2.setColor(Color.black);
        graphics2.setFont(this.f);
        graphics2.drawString(string, n - n11, n2 - n12);
        int[] nArray = new int[n13 * n14];
        PixelGrabber pixelGrabber = new PixelGrabber(this.tmp, 0, 0, n13, n14, nArray, 0, n13);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        int[] nArray2 = new int[n8 * n7];
        int n16 = n9;
        int n17 = 0;
        while (n16 < n7 + n9) {
            int n18 = n10;
            while (n18 < n8 + n10) {
                int n19;
                int n20 = (int)(0.5 + (double)(n18 - n3) * Math.cos(-d) - (double)(n16 - n4) * Math.sin(-d) + (double)n3);
                int n21 = (int)(0.5 + (double)(n18 - n3) * Math.sin(-d) + (double)(n16 - n4) * Math.cos(-d) + (double)n4);
                if ((n20 -= n11) >= 0 && (n21 -= n12) >= 0 && n20 < n13 && n21 < n14 && nArray[n19 = n21 * n13 + n20] == n6) {
                    nArray2[n17] = n15;
                }
                ++n17;
                ++n18;
            }
            ++n16;
        }
        this.tmp = this.parent.createImage(new MemoryImageSource(n8, n7, ColorModel.getRGBdefault(), nArray2, 0, n8));
        graphics.drawImage(this.tmp, n10, n9, null);
        graphics2.dispose();
    }

    public void drawString(String string, int n, int n2, int n3, Image image) {
        this.drawString(string, n, n2, n, n2, n3, image);
    }

    private void drawString(String string, int n, int n2, Image image) {
        this.drawString(string, n, n2, n, n2, 0, image);
    }

    private Rectangle getExtent(String string, int n, int n2, int n3) {
        return this.getExtent(string, n, n2, n, n2, n3, this.f);
    }

    private Rectangle getExtent(String string, int n, int n2, int n3, int n4, int n5) {
        return this.getExtent(string, n, n2, n3, n4, n5, this.f);
    }

    private Rectangle getExtent(String string, int n, int n2, int n3, int n4, int n5, Font font) {
        Rectangle rectangle = new Rectangle();
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        int n6 = fontMetrics.getMaxDescent();
        int n7 = fontMetrics.getMaxAscent();
        rectangle.x = n;
        rectangle.y = n2 - n7 + n6;
        rectangle.width = fontMetrics.stringWidth(string);
        rectangle.height = n7;
        if (n5 != 0) {
            rectangle = this.rotateRectangle(rectangle, n3, n4, -Math.PI * (double)n5 / 180.0);
        }
        return rectangle;
    }

    private Rectangle getExtent(String string, int n, int n2, int n3, int n4, int n5, FontMetrics fontMetrics) {
        Rectangle rectangle = new Rectangle();
        int n6 = fontMetrics.getMaxDescent();
        int n7 = fontMetrics.getMaxAscent();
        rectangle.x = n;
        rectangle.y = n2 - n7 + n6;
        rectangle.width = fontMetrics.stringWidth(string);
        rectangle.height = n7;
        if (n5 != 0) {
            rectangle = this.rotateRectangle(rectangle, n3, n4, -Math.PI * (double)n5 / 180.0);
        }
        return rectangle;
    }

    private Rectangle getExtent(String string, int n, int n2, int n3, Font font) {
        return this.getExtent(string, n, n2, n, n2, n3, font);
    }

    protected Rectangle getExtent(String string, int n, int n2, int n3, FontMetrics fontMetrics) {
        return this.getExtent(string, n, n2, n, n2, n3, fontMetrics);
    }

    private Rectangle rotateRectangle(Rectangle rectangle, int n, int n2, double d) {
        double d2;
        double d3;
        double d4 = d3 = (double)(rectangle.x - n) * Math.cos(d) - (double)(rectangle.y - n2) * Math.sin(d);
        double d5 = d2 = (double)(rectangle.x - n) * Math.sin(d) + (double)(rectangle.y - n2) * Math.cos(d);
        double d6 = (double)(rectangle.x + rectangle.width - 1 - n) * Math.cos(d) - (double)(rectangle.y - n2) * Math.sin(d);
        double d7 = (double)(rectangle.x + rectangle.width - 1 - n) * Math.sin(d) + (double)(rectangle.y - n2) * Math.cos(d);
        if (d6 < d4) {
            d4 = d6;
        }
        if (d6 > d3) {
            d3 = d6;
        }
        if (d7 < d5) {
            d5 = d7;
        }
        if (d7 > d2) {
            d2 = d7;
        }
        d6 = (double)(rectangle.x - n) * Math.cos(d) - (double)(rectangle.y + rectangle.height - 1 - n2) * Math.sin(d);
        d7 = (double)(rectangle.x - n) * Math.sin(d) + (double)(rectangle.y + rectangle.height - 1 - n2) * Math.cos(d);
        if (d6 < d4) {
            d4 = d6;
        }
        if (d6 > d3) {
            d3 = d6;
        }
        if (d7 < d5) {
            d5 = d7;
        }
        if (d7 > d2) {
            d2 = d7;
        }
        d6 = (double)(rectangle.x + rectangle.width - 1 - n) * Math.cos(d) - (double)(rectangle.y + rectangle.height - 1 - n2) * Math.sin(d);
        d7 = (double)(rectangle.x + rectangle.width - 1 - n) * Math.sin(d) + (double)(rectangle.y + rectangle.height - 1 - n2) * Math.cos(d);
        if (d6 < d4) {
            d4 = d6;
        }
        if (d6 > d3) {
            d3 = d6;
        }
        if (d7 < d5) {
            d5 = d7;
        }
        if (d7 > d2) {
            d2 = d7;
        }
        rectangle.x = (int)d4 + n;
        rectangle.y = (int)d5 + n2;
        rectangle.width = (int)(d3 - d4 + 1.0);
        rectangle.height = (int)(d2 - d5 + 1.0);
        return rectangle;
    }

    void setColor(Color color) {
        this.c = color;
    }

    void setFont(Font font) {
        this.f = font;
    }
}

