/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.util.Vector;
import javachart.chart.Area;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;

public class DiscontinuousArea
extends Area {
    private Vector saveBuffer = new Vector();

    public DiscontinuousArea(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        super(datasetArray, axisInterface, axisInterface2, plotarea);
    }

    public void draw(Graphics graphics) {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] != null) {
                Dataset dataset = this.datasets[n];
                int n2 = 0;
                while (n2 < dataset.getData().size()) {
                    if (dataset.getDataElementAt((int)n2).label == "D") {
                        this.setDiscontinuity(n, n2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        super.draw(graphics);
        this.resetValuesFromSaveBuffer();
    }

    private void resetValuesFromSaveBuffer() {
        int n = 0;
        while (n < this.saveBuffer.size()) {
            int n2 = (Integer)this.saveBuffer.elementAt(n);
            int n3 = (Integer)this.saveBuffer.elementAt(++n);
            this.datasets[n2].getDataElementAt((int)n3).y = (Double)this.saveBuffer.elementAt(++n);
            ++n;
        }
        this.saveBuffer.removeAllElements();
    }

    private void setDiscontinuity(int n, int n2) {
        this.saveBuffer.addElement(new Integer(n));
        this.saveBuffer.addElement(new Integer(n2));
        this.saveBuffer.addElement(new Double(this.datasets[n].getDataElementAt((int)n2).y));
        try {
            double d = this.datasets[n].getDataElementAt((int)(n2 - 1)).y;
            double d2 = this.datasets[n].getDataElementAt((int)(n2 + 1)).y;
            this.datasets[n].getDataElementAt((int)n2).y = (d2 + d) / 2.0;
        }
        catch (Exception exception) {}
    }
}

