/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.ChartInterface;
import javachart.chart.DataRepresentation;
import javachart.chart.Dataset;
import javachart.chart.DisplayList;
import javachart.chart.Globals;
import javachart.chart.Legend;
import javachart.chart.LegendInterface;
import javachart.chart.Plotarea;
import javachart.chart.RotateString;

public abstract class Chart
implements ChartInterface,
Serializable {
    String name = "New Chart";
    protected Graphics canvas;
    protected boolean legendVisible = false;
    protected int width = 640;
    protected int height = 480;
    protected boolean xAxisVisible = true;
    protected boolean yAxisVisible = true;
    protected Globals globals;
    protected Dataset[] datasets;
    protected Plotarea plotarea;
    protected Background background;
    protected LegendInterface legend;
    protected AxisInterface xAxis;
    protected AxisInterface yAxis;
    protected DataRepresentation dataRepresentation;
    protected int numberOfDatasets = 0;
    public static final int MAX_DATASETS = 40;

    public Chart() {
        this.initChart();
    }

    public Chart(String string) {
        this.name = string;
        this.initChart();
    }

    public void addDataset(String string, double[] dArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray) {
        this.addDataset(string, dArray);
    }

    public void addDataset(String string, double[] dArray, double[] dArray2) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2) {
        this.addDataset(string, dArray, dArray2);
    }

    public void addDataset(String string, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, dArray3, dArray4, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("maximum number of datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.addDataset(string, dArray, dArray2, dArray3, dArray4);
    }

    public void addDataset(String string, double[] dArray, double[] dArray2, String[] stringArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, stringArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2, String[] stringArray) {
        this.addDataset(string, dArray, dArray2, stringArray);
    }

    public void addDataset(String string, double[] dArray, String[] stringArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, stringArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("maximum number of datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, String[] stringArray) {
        this.addDataset(string, dArray, stringArray);
    }

    public void addDataset(Dataset dataset) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = dataset;
            dataset.setGlobals(this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(Dataset dataset) {
        this.addDataset(dataset);
    }

    public void deleteDataset(String string) {
        int n = 0;
        while (n < this.numberOfDatasets) {
            if (this.datasets[n].setName.equals(string)) {
                this.deleteDataset(this.datasets[n]);
                return;
            }
            ++n;
        }
    }

    public void deleteDataSet(String string) {
        this.deleteDataset(string);
    }

    public void deleteDataset(Dataset dataset) {
        int n = 0;
        while (n < this.numberOfDatasets) {
            if (this.datasets[n] == dataset) {
                this.datasets[n] = null;
                int n2 = n + 1;
                while (n2 < this.datasets.length) {
                    this.datasets[n2 - 1] = this.datasets[n2];
                    ++n2;
                }
            }
            ++n;
        }
        --this.numberOfDatasets;
    }

    public void deleteDataSet(Dataset dataset) {
        this.deleteDataset(dataset);
    }

    public void drawGraph() {
        if (this.globals.useDisplayList) {
            this.globals.displayList.clear();
        }
    }

    public void drawGraph(Graphics graphics) {
        if (this.globals.useDisplayList) {
            this.globals.displayList.clear();
        }
    }

    public Background getBackground() {
        return this.background;
    }

    public Graphics getCanvas() {
        return this.canvas;
    }

    public DataRepresentation getDataRepresentation() {
        return this.dataRepresentation;
    }

    public Dataset getDataset(String string) {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] != null && this.datasets[n].setName.equals(string)) {
                return this.datasets[n];
            }
            ++n;
        }
        return null;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public DisplayList getDisplayList() {
        return this.globals.getDisplayList();
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public int getHeight() {
        return this.globals.maxY;
    }

    public Image getImage() {
        return this.globals.getImage();
    }

    public LegendInterface getLegend() {
        return this.legend;
    }

    public String getName() {
        return this.name;
    }

    public int getNumDatasets() {
        return this.numberOfDatasets;
    }

    public Plotarea getPlotarea() {
        return this.plotarea;
    }

    public RotateString getStringRotator() {
        return this.globals.stringRotator;
    }

    public boolean getUseDisplayList() {
        return this.globals.getUseDisplayList();
    }

    public int getWidth() {
        return this.globals.maxX;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public int getXOffset() {
        return this.globals.xOffset;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    public int getYOffset() {
        return this.globals.yOffset;
    }

    public boolean includesDataset(Dataset dataset) {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == dataset) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void initChart() {
    }

    protected void initDatasets() {
        this.datasets = new Dataset[40];
    }

    protected void initGlobals() {
        this.globals = new Globals();
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public boolean isThreeD() {
        return this.globals.threeD;
    }

    public boolean isXAxisVisible() {
        return this.xAxisVisible;
    }

    public boolean isYAxisVisible() {
        return this.yAxisVisible;
    }

    public void paint() {
        this.drawGraph();
    }

    public void paint(Component component, Graphics graphics) {
        Dimension dimension = component.getSize();
        if (this.globals.image == null || dimension.width != this.globals.image.getWidth(null) || dimension.height != this.globals.image.getHeight(null)) {
            this.globals.image = component.createImage(dimension.width, dimension.height);
            this.setStringRotator(new RotateString(component));
            this.resize(dimension.width, dimension.height);
        }
        this.drawGraph(this.globals.image.getGraphics());
        graphics.drawImage(this.globals.image, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.drawGraph(graphics);
    }

    public void resize(int n, int n2) {
        this.globals.maxY = n2;
        if (this.plotarea != null) {
            this.plotarea.resize(n, n2);
        }
        if (this.background != null) {
            this.background.resize(n, n2);
        }
        if (this.legend != null) {
            this.legend.resize(n, n2);
        }
        this.globals.maxX = n;
        this.globals.maxY = n2;
        this.width = n;
        this.height = n2;
    }

    public void setBackground(Background background) {
        this.background = background;
        this.background.globals = this.globals;
    }

    public void setCanvas(Graphics graphics) {
        this.canvas = graphics;
    }

    public void setDataRepresentation(DataRepresentation dataRepresentation) {
        dataRepresentation.plotarea = this.plotarea;
        dataRepresentation.xAxis = this.xAxis;
        dataRepresentation.yAxis = this.yAxis;
        dataRepresentation.datasets = this.datasets;
        dataRepresentation.globals = this.globals;
        this.dataRepresentation = dataRepresentation;
    }

    public void setDisplayList(DisplayList displayList) {
        this.globals.setDisplayList(displayList);
    }

    public void setGlobals(Globals globals) {
        this.globals = globals;
        try {
            this.dataRepresentation.globals = globals;
            this.plotarea.globals = globals;
            this.plotarea.gc.globals = globals;
            this.background.globals = globals;
            this.background.gc.globals = globals;
            if (this.legend != null && this.legend instanceof Legend) {
                ((Legend)this.legend).globals = globals;
                ((Legend)this.legend).backgroundGc.globals = globals;
            }
            int n = 0;
            while (n < this.datasets.length) {
                if (this.datasets[n] != null) {
                    this.datasets[n].setGlobals(globals);
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public void setHeight(int n) {
        this.height = n;
        this.resize(this.width, this.height);
    }

    public void setImage(Image image) {
        this.globals.setImage(image);
    }

    public void setLegend(LegendInterface legendInterface) {
        this.legend = legendInterface;
        if (this.legend instanceof Legend) {
            ((Legend)this.legend).datasets = this.datasets;
            ((Legend)this.legend).globals = this.globals;
            ((Legend)this.legend).backgroundGc.globals = this.globals;
        }
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPlotarea(Plotarea plotarea) {
        this.plotarea = plotarea;
        this.plotarea.globals = this.globals;
        this.plotarea.gc.globals = this.globals;
    }

    public void setStringRotator(RotateString rotateString) {
        this.globals.stringRotator = rotateString;
    }

    public void setThreeD(boolean bl) {
        this.globals.threeD = bl;
    }

    public void setUseDisplayList(boolean bl) {
        this.globals.setUseDisplayList(bl);
    }

    public void setWidth(int n) {
        this.width = n;
        this.resize(this.width, this.height);
    }

    public void setXAxis(AxisInterface axisInterface) {
        this.xAxis = axisInterface;
        try {
            Axis axis = (Axis)axisInterface;
            axis.globals = this.globals;
            axis.lineGc.globals = this.globals;
            axis.tickGc.globals = this.globals;
            axis.gridGc.globals = this.globals;
            axis.plotarea = this.plotarea;
            axis.datasets = this.datasets;
            axis.isXAxis = true;
            if (this.dataRepresentation != null) {
                this.dataRepresentation.xAxis = axisInterface;
            }
        }
        catch (Exception exception) {}
    }

    public void setXAxisVisible(boolean bl) {
        this.xAxisVisible = bl;
    }

    public void setXOffset(int n) {
        this.globals.xOffset = n;
    }

    public void setYAxis(AxisInterface axisInterface) {
        this.yAxis = axisInterface;
        try {
            Axis axis = (Axis)axisInterface;
            axis.globals = this.globals;
            axis.lineGc.globals = this.globals;
            axis.tickGc.globals = this.globals;
            axis.gridGc.globals = this.globals;
            axis.plotarea = this.plotarea;
            axis.datasets = this.datasets;
            axis.isXAxis = false;
            if (this.dataRepresentation != null) {
                this.dataRepresentation.yAxis = axisInterface;
            }
        }
        catch (Exception exception) {}
    }

    public void setYAxisVisible(boolean bl) {
        this.yAxisVisible = bl;
    }

    public void setYOffset(int n) {
        this.globals.yOffset = n;
    }
}

