/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class VTPMgmtNew_JDialog
extends CustomMinimumSize_JDialog
implements ActionListener,
ItemListener,
KeyListener,
FocusListener {
    private int currentVLANIndex = 0;
    private boolean vlanIdKeyTyped = false;
    private boolean saidKeyTyped = false;
    boolean frameSizeAdjusted = false;
    JLabel vlanId_JLabel = new JLabel();
    JLabel vlanName_JLabel = new JLabel();
    JLabel vlanType_JLabel = new JLabel();
    JLabel vlanSAID_JLabel = new JLabel();
    JLabel mtuSize_JLabel = new JLabel("1500");
    JLabel bridge1_JLabel = new JLabel("0");
    JLabel bridge2_JLabel = new JLabel("0");
    JLabel vlanStatus_JLabel = new JLabel();
    JLabel ringNumber_JLabel = new JLabel();
    JLabel parentVlan_JLabel = new JLabel();
    JLabel bridgeNumber_JLabel = new JLabel();
    JLabel stpType_JLabel = new JLabel();
    JLabel bridgeMode_JLabel = new JLabel();
    JLabel ARE_JLabel = new JLabel();
    JLabel STE_JLabel = new JLabel();
    JLabel backupCRF_JLabel = new JLabel();
    NumericTextField vlanId_JTextField = new NumericTextField("");
    JTextField vlanName_JTextField = new JTextField("");
    NumericTextField vlanSAID_JTextField = new NumericTextField("100000");
    static final int ETHERNET = 0;
    static final int FDDI = 1;
    static final int TOKENRING = 2;
    static final int FDDINET = 3;
    static final int TOKENNET = 4;
    Object[] mediaType = new Object[]{"Ethernet", "FDDI", "Token Ring/TRCRF", "FDDI-Net", "Token-Ring-Net/TRBRF"};
    JComboBox vlanType_JCombo = new JComboBox<Object>(this.mediaType);
    NumericTextField mtuSize_JTextField = new NumericTextField("1500");
    NumericTextField bridge1_JTextField = new NumericTextField("0");
    NumericTextField bridge2_JTextField = new NumericTextField("0");
    Object[] stateType = new Object[]{"Active", "Suspended"};
    JComboBox vlanStatus_JCombo = new JComboBox<Object>(this.stateType);
    NumericTextField ringNumber_JTextField = new NumericTextField("1");
    NumericTextField parentVlan_JTextField = new NumericTextField("0");
    NumericTextField bridgeNumber_JTextField = new NumericTextField("0");
    Object[] stpTypeItem = new Object[]{"IEEE", "IBM", "AUTO"};
    JComboBox stpType_JCombo = new JComboBox<Object>(this.stpTypeItem);
    Object[] bridgeModeItem = new Object[]{"SRB", "SRT"};
    JComboBox bridgeMode_JCombo = new JComboBox<Object>(this.bridgeModeItem);
    NumericTextField ARE_JTextField = new NumericTextField("7");
    NumericTextField STE_JTextField = new NumericTextField("7");
    Object[] backupCRFItem = new Object[]{"Off", "On"};
    JComboBox backupCRF_JCombo = new JComboBox<Object>(this.backupCRFItem);
    JButton ok_JButton = new JButton();
    JButton cancel_JButton = new JButton();
    JButton help_JButton = new JButton();
    JPanel main_JPanel;
    JPanel param_JPanel;
    JPanel buttons_JPanel;
    VTPMgmt_JDialog parent;
    String action;
    String vlanId;
    String vlanName;
    String vlanSAID;
    String mtuSize;
    String bridge1;
    String bridge2;
    String vlanStatus;
    String vlanType;
    String ringNumber;
    String parentVlan;
    String bridgeNumber;
    String stpType;
    String bridgeMode;
    String ARE;
    String STE;
    String backupCRF;
    CommonSwitch[] switches;

    public VTPMgmtNew_JDialog(Frame frame) {
        super(frame);
        this.setTitle("VLAN Configuration - New VLAN");
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(405, 505);
        this.setMinimumWidth(this.getSize().width);
        this.setMinimumHeight(this.getSize().height);
        this.setVisible(false);
        this.vlanId_JLabel.setText("VLAN ID:");
        this.vlanName_JLabel.setText("VLAN Name:");
        this.vlanType_JLabel.setText("VLAN Media Type:");
        this.vlanSAID_JLabel.setText("802.10 SAID: [0 - 4294967294]");
        this.mtuSize_JLabel.setText("MTU Size: [1500 - 18190]");
        this.bridge1_JLabel.setText("Translational Bridge 1: [0 - 1005]");
        this.bridge2_JLabel.setText("Translational Bridge 2: [0 - 1005]");
        this.vlanStatus_JLabel.setText("VLAN Status:");
        this.ringNumber_JLabel.setText("Ring Number:");
        this.ringNumber_JLabel.setVisible(false);
        this.parentVlan_JLabel.setText("Parent VLAN:");
        this.parentVlan_JLabel.setVisible(false);
        this.bridgeNumber_JLabel.setText("Bridge Number:");
        this.bridgeNumber_JLabel.setVisible(false);
        this.stpType_JLabel.setText("STP Type:");
        this.stpType_JLabel.setVisible(false);
        this.bridgeMode_JLabel.setText("Bridge Mode:");
        this.bridgeMode_JLabel.setVisible(false);
        this.ARE_JLabel.setText("ARE Max hops:");
        this.ARE_JLabel.setVisible(false);
        this.STE_JLabel.setText("STE Max hops:");
        this.STE_JLabel.setVisible(false);
        this.backupCRF_JLabel.setText("Backup CRF:");
        this.backupCRF_JLabel.setVisible(false);
        this.vlanId_JTextField.setBounds(196, 12, 168, 24);
        this.vlanName_JTextField.setBounds(196, 40, 168, 24);
        this.vlanSAID_JTextField.setBounds(196, 98, 168, 24);
        this.vlanType_JCombo.setBounds(196, 68, 168, 24);
        this.mtuSize_JTextField.setBounds(196, 130, 168, 24);
        this.bridge1_JTextField.setBounds(196, 160, 168, 24);
        this.bridge2_JTextField.setBounds(198, 190, 168, 24);
        this.vlanStatus_JCombo.setBounds(198, 220, 168, 24);
        this.ringNumber_JTextField.setVisible(false);
        this.parentVlan_JTextField.setVisible(false);
        this.bridgeNumber_JTextField.setVisible(false);
        this.stpType_JCombo.setVisible(false);
        this.bridgeMode_JCombo.setVisible(false);
        this.ARE_JTextField.setVisible(false);
        this.STE_JTextField.setVisible(false);
        this.backupCRF_JCombo.setVisible(false);
        this.ok_JButton.setText("OK");
        this.cancel_JButton.setText("Cancel");
        this.help_JButton.setText("Help");
        this.main_JPanel = new JPanel(new BorderLayout(5, 5));
        this.param_JPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.param_JPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.param_JPanel.add((Component)this.vlanId_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.param_JPanel.add((Component)this.vlanName_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.param_JPanel.add((Component)this.vlanType_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.param_JPanel.add((Component)this.vlanSAID_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.param_JPanel.add((Component)this.mtuSize_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.param_JPanel.add((Component)this.bridge1_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.param_JPanel.add((Component)this.bridge2_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.param_JPanel.add((Component)this.vlanStatus_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.param_JPanel.add((Component)this.vlanId_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.param_JPanel.add((Component)this.vlanName_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.param_JPanel.add((Component)this.vlanType_JCombo, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.param_JPanel.add((Component)this.vlanSAID_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.param_JPanel.add((Component)this.mtuSize_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.param_JPanel.add((Component)this.bridge1_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.param_JPanel.add((Component)this.bridge2_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.param_JPanel.add((Component)this.vlanStatus_JCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.param_JPanel.add((Component)this.ringNumber_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.param_JPanel.add((Component)this.parentVlan_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.param_JPanel.add((Component)this.bridgeNumber_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        this.param_JPanel.add((Component)this.stpType_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        this.param_JPanel.add((Component)this.bridgeMode_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 13;
        this.param_JPanel.add((Component)this.ARE_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 14;
        this.param_JPanel.add((Component)this.STE_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 15;
        this.param_JPanel.add((Component)this.backupCRF_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.param_JPanel.add((Component)this.ringNumber_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.param_JPanel.add((Component)this.parentVlan_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.param_JPanel.add((Component)this.bridgeNumber_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        this.param_JPanel.add((Component)this.stpType_JCombo, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        this.param_JPanel.add((Component)this.bridgeMode_JCombo, gridBagConstraints);
        gridBagConstraints.gridy = 13;
        this.param_JPanel.add((Component)this.ARE_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 14;
        this.param_JPanel.add((Component)this.STE_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 15;
        this.param_JPanel.add((Component)this.backupCRF_JCombo, gridBagConstraints);
        this.param_JPanel.setBorder(BorderFactory.createTitledBorder("VLAN Parameters"));
        this.getContentPane().add((Component)this.param_JPanel, "Center");
        this.buttons_JPanel = new JPanel();
        this.buttons_JPanel.add(this.ok_JButton);
        this.buttons_JPanel.add(this.cancel_JButton);
        this.buttons_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.buttons_JPanel, "South");
        this.vlanType_JCombo.setSelectedItem("Ethernet");
        this.vlanStatus_JCombo.setSelectedItem("Active");
        this.stpType_JCombo.setSelectedItem("IEEE");
        this.bridgeMode_JCombo.setSelectedItem("SRB");
        this.backupCRF_JCombo.setSelectedItem("Off");
        this.vlanType_JCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VTPMgmtNew_JDialog.this.ok_JButton.setEnabled(true);
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals(VTPMgmtNew_JDialog.this.mediaType[0])) {
                    VTPMgmtNew_JDialog.this.ringNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ringNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.param_JPanel.revalidate();
                } else if (string.equals(VTPMgmtNew_JDialog.this.mediaType[1])) {
                    VTPMgmtNew_JDialog.this.ringNumber_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.parentVlan_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ringNumber_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.parentVlan_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.param_JPanel.revalidate();
                } else if (string.equals(VTPMgmtNew_JDialog.this.mediaType[2])) {
                    VTPMgmtNew_JDialog.this.ringNumber_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.parentVlan_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ringNumber_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.parentVlan_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.stpType_JCombo.setVisible(false);
                    if (VTPMgmtNew_JDialog.this.parent.vtpV2.equals("Enabled")) {
                        VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(true);
                        VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(true);
                        VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(true);
                        VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(true);
                        VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(true);
                        VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(true);
                        VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(true);
                        VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(true);
                    } else {
                        VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(false);
                        VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(false);
                        VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(false);
                        VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(false);
                        VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(false);
                        VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(false);
                        VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(false);
                        VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(false);
                    }
                    VTPMgmtNew_JDialog.this.param_JPanel.revalidate();
                } else if (string.equals(VTPMgmtNew_JDialog.this.mediaType[3])) {
                    VTPMgmtNew_JDialog.this.ringNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.stpType_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.ringNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.stpType_JCombo.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.param_JPanel.revalidate();
                } else if (string.equals(VTPMgmtNew_JDialog.this.mediaType[4])) {
                    VTPMgmtNew_JDialog.this.ringNumber_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.stpType_JLabel.setVisible(true);
                    VTPMgmtNew_JDialog.this.ringNumber_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.parentVlan_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeNumber_JTextField.setVisible(true);
                    VTPMgmtNew_JDialog.this.stpType_JCombo.setVisible(true);
                    VTPMgmtNew_JDialog.this.bridgeMode_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JLabel.setVisible(false);
                    VTPMgmtNew_JDialog.this.bridgeMode_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.ARE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.STE_JTextField.setVisible(false);
                    VTPMgmtNew_JDialog.this.backupCRF_JCombo.setVisible(false);
                    VTPMgmtNew_JDialog.this.param_JPanel.revalidate();
                }
            }
        });
        this.vlanId_JTextField.addKeyListener(this);
        this.vlanId_JTextField.addFocusListener(this);
        this.vlanSAID_JTextField.addKeyListener(this);
        this.vlanId_JTextField.addActionListener(this);
        this.vlanName_JTextField.addActionListener(this);
        this.vlanSAID_JTextField.addActionListener(this);
        this.mtuSize_JTextField.addActionListener(this);
        this.bridge1_JTextField.addActionListener(this);
        this.bridge2_JTextField.addActionListener(this);
        this.ringNumber_JTextField.addActionListener(this);
        this.parentVlan_JTextField.addActionListener(this);
        this.bridgeNumber_JTextField.addActionListener(this);
        this.ARE_JTextField.addActionListener(this);
        this.STE_JTextField.addActionListener(this);
        this.vlanType_JCombo.addItemListener(this);
        this.vlanStatus_JCombo.addItemListener(this);
        this.stpType_JCombo.addItemListener(this);
        this.bridgeMode_JCombo.addItemListener(this);
        this.backupCRF_JCombo.addItemListener(this);
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
    }

    public VTPMgmtNew_JDialog(CommonSwitch[] commonSwitchArray, VTPMgmt_JDialog vTPMgmt_JDialog) {
        this((Frame)null);
        this.switches = commonSwitchArray;
        this.parent = vTPMgmt_JDialog;
        this.action = "NEW";
    }

    public VTPMgmtNew_JDialog(CommonSwitch[] commonSwitchArray, VTPMgmt_JDialog vTPMgmt_JDialog, int n) {
        this((Frame)null);
        Object object;
        this.switches = commonSwitchArray;
        this.parent = vTPMgmt_JDialog;
        this.currentVLANIndex = n;
        this.action = "MODIFY";
        this.setTitle("VLAN Configuration - Modify");
        this.vlanId = (String)vTPMgmt_JDialog.vtpVlanTableModel.getValueAt(n, 0);
        this.vlanId_JTextField.setText(this.vlanId);
        this.vlanId_JTextField.setEnabled(false);
        String string = commonSwitchArray[vTPMgmt_JDialog.switchIndex].esn;
        String[] stringArray = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanEntries(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = new StringTokenizer(stringArray[n2], " ");
            String string2 = ((StringTokenizer)object).nextToken();
            String string3 = ((StringTokenizer)object).nextToken();
            String string4 = ((StringTokenizer)object).nextToken();
            if (string2.equals(this.vlanId)) {
                this.vlanName = string3;
                this.vlanName_JTextField.setText(this.vlanName);
                this.vlanStatus = string4;
                this.vlanStatus_JCombo.setSelectedItem(this.vlanStatus);
                String string5 = stringArray[n2 + 1];
                if (string5.equals("ethernet")) {
                    this.vlanType = (String)this.mediaType[0];
                }
                if (string5.equals("fddi")) {
                    this.vlanType = (String)this.mediaType[1];
                }
                if (string5.equals("fddinet")) {
                    this.vlanType = (String)this.mediaType[3];
                }
                if (string5.equals("token-ring")) {
                    this.vlanType = (String)this.mediaType[2];
                }
                if (string5.equals("trnet")) {
                    this.vlanType = (String)this.mediaType[4];
                }
                this.vlanType_JCombo.setSelectedItem(this.vlanType);
                this.vlanType_JCombo.setEnabled(false);
                break;
            }
            n2 += 2;
        }
        this.vlanSAID = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanSAID(string, this.vlanId);
        this.vlanSAID_JTextField.setText(this.vlanSAID);
        this.mtuSize = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanMTU(string, this.vlanId);
        this.mtuSize_JTextField.setText(this.mtuSize);
        this.bridge1 = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanBridge1(string, this.vlanId);
        this.bridge1_JTextField.setText(this.bridge1);
        this.bridge2 = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanBridge2(string, this.vlanId);
        this.bridge2_JTextField.setText(this.bridge2);
        if (this.vlanType.equals(this.mediaType[2]) || this.vlanType.equals(this.mediaType[1])) {
            this.ringNumber = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanRingNumber(string, this.vlanId);
            this.ringNumber_JTextField.setText(this.ringNumber);
            this.parentVlan = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanParentVlan(string, this.vlanId);
            this.parentVlan_JTextField.setText(this.parentVlan);
            if (this.vlanType.equals(this.mediaType[2]) && vTPMgmt_JDialog.vtpV2.equals("Enabled")) {
                this.ARE = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanARE(string, this.vlanId);
                this.ARE_JTextField.setText(this.ARE);
                this.STE = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanSTE(string, this.vlanId);
                this.STE_JTextField.setText(this.STE);
                this.bridgeMode = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanBridgeMode(string, this.vlanId);
                this.bridgeMode_JCombo.setSelectedItem(this.bridgeMode);
                this.backupCRF = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanBackupCRF(string, this.vlanId);
                if (this.backupCRF.trim().equalsIgnoreCase("Enabled")) {
                    this.backupCRF_JCombo.setSelectedItem("On");
                } else {
                    this.backupCRF_JCombo.setSelectedItem("Off");
                }
            }
        } else if (this.vlanType.equals(this.mediaType[4]) || this.vlanType.equals(this.mediaType[3])) {
            this.bridgeNumber = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanBridgeNumber(string, this.vlanId);
            this.bridgeNumber_JTextField.setText(this.bridgeNumber);
            object = commonSwitchArray[vTPMgmt_JDialog.switchIndex].Cli.getVtpVlanSTP(string, this.vlanId);
            this.stpType_JCombo.setSelectedItem(object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        } else if (object == this.vlanName_JTextField || object == this.vlanName_JTextField || object == this.vlanSAID_JTextField || object == this.mtuSize_JTextField || object == this.bridge1_JTextField || object == this.bridge2_JTextField || object == this.ringNumber_JTextField || object == this.parentVlan_JTextField || object == this.bridgeNumber_JTextField || object == this.ARE_JTextField || object == this.STE_JTextField) {
            this.ok_JButton.setEnabled(true);
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickCancel() {
        this.dispose();
    }

    void clickHelp() {
        String string = (String)this.vlanType_JCombo.getSelectedItem();
        if (this.action.equals("MODIFY")) {
            HelpDialog.Factory.showHelp((JApplet)this.parent.theApplet, (String)"vtpmoddg");
        } else {
            HelpDialog.Factory.showHelp((JApplet)this.parent.theApplet, (String)"vtpnewdg");
        }
    }

    void clickOK() {
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        this.vlanId = this.vlanId_JTextField.getText();
        if (this.action.equals("NEW")) {
            if (this.vlanId.equals("")) {
                JOptionPane.showMessageDialog(this, "Please specify a VLAN ID between 2 - 1001.", "VTP VLAN Configuration", 0);
                return;
            }
            n3 = new Integer(this.vlanId);
            if (n3 < 2 || n3 > 1001) {
                JOptionPane.showMessageDialog(this, "Please specify a VLAN ID between 2 - 1001.", "VTP VLAN Configuration", 0);
                return;
            }
            n2 = 0;
            while (n2 < this.parent.vtpVlan_JTable.getRowCount()) {
                objectArray = (Object[])this.parent.vtpVlan_JTable.getValueAt(n2, 0);
                if (this.vlanId.equals(objectArray)) {
                    JOptionPane.showMessageDialog(this, "Duplicated VLAN ID! please specify another VLAN ID.", "VTP VLAN Configuration", 0);
                    return;
                }
                ++n2;
            }
        }
        this.vlanName = this.vlanName_JTextField.getText();
        if (this.vlanName.equals("")) {
            this.setVlanName();
        }
        this.vlanSAID = this.vlanSAID_JTextField.getText();
        n3 = new Integer(this.vlanSAID);
        if (n3 < 1) {
            JOptionPane.showMessageDialog(this, "Please specify a 802.10 SAID between 1 - 4294967294.", "VTP VLAN Configuration", 0);
            return;
        }
        this.mtuSize = this.mtuSize_JTextField.getText();
        n3 = new Integer(this.mtuSize);
        if (n3 < 1500 || n3 > 18190) {
            JOptionPane.showMessageDialog(this, "Please specify a MTU Size between 1500 - 18190.", "VTP VLAN Configuration", 0);
            return;
        }
        this.vlanStatus = (String)this.vlanStatus_JCombo.getSelectedItem();
        this.vlanStatus.trim();
        if (this.vlanStatus.equalsIgnoreCase("Suspended")) {
            this.vlanStatus = "Suspend";
        }
        this.vlanType = (String)this.vlanType_JCombo.getSelectedItem();
        n2 = 0;
        if (this.vlanType.equals(this.mediaType[0])) {
            n2 = this.okEthernet() ? 1 : 0;
        }
        if (this.vlanType.equals(this.mediaType[2])) {
            n2 = this.okTokenring() ? 1 : 0;
        }
        if (this.vlanType.equals(this.mediaType[4])) {
            n2 = this.okTokenringNet() ? 1 : 0;
        }
        if (this.vlanType.equals(this.mediaType[1])) {
            n2 = this.okFddi() ? 1 : 0;
        }
        if (this.vlanType.equals(this.mediaType[3])) {
            n2 = this.okFddiNet() ? 1 : 0;
        }
        if (n2 == 0) {
            return;
        }
        objectArray = new String[]{this.vlanId, this.vlanName, this.vlanStatus};
        if (this.action.equals("NEW")) {
            this.parent.vtpVlanTableModel.addRow(objectArray);
        } else {
            n = 0;
            while (n < 3) {
                this.parent.vtpVlanTableModel.setValueAt(objectArray[n], this.currentVLANIndex, n);
                ++n;
            }
        }
        n = this.parent.vtpVlanTableModel.getRowCount();
        this.dispose();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.vlanId_JTextField) {
            this.vlanIdKeyTyped = false;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.vlanId_JTextField && this.vlanIdKeyTyped && this.action.equalsIgnoreCase("NEW") && !this.saidKeyTyped) {
            try {
                long l = Long.parseLong(this.vlanId_JTextField.getText().trim()) + 100000L;
                this.vlanSAID_JTextField.setText(String.valueOf(l));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.setVlanName();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.ok_JButton.setEnabled(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.vlanId_JTextField) {
            this.vlanIdKeyTyped = true;
        } else if (keyEvent.getSource() == this.vlanSAID_JTextField) {
            this.saidKeyTyped = true;
        }
    }

    boolean okEthernet() {
        String string = this.switches[this.parent.switchIndex].esn;
        this.bridge1 = this.bridge1_JTextField.getText();
        int n = new Integer(this.bridge1);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridge2 = this.bridge2_JTextField.getText();
        n = new Integer(this.bridge2);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        String string2 = this.switches[this.parent.switchIndex].Cli.vtpAddEtherVlan(string, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.bridge1, this.bridge2, this.vlanStatus);
        if (string2.indexOf("Unknown TLB") != -1) {
            JOptionPane.showMessageDialog(this, "Unknown Translational bridge value", "VTP VLAN Configuration", 0);
            return false;
        }
        if (string2.indexOf("Error") != -1) {
            JOptionPane.showMessageDialog(this, string2, "VTP VLAN Configuration", 0);
            return false;
        }
        return true;
    }

    boolean okFddi() {
        String string = this.switches[this.parent.switchIndex].esn;
        this.bridge1 = this.bridge1_JTextField.getText();
        int n = new Integer(this.bridge1);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridge2 = this.bridge2_JTextField.getText();
        n = new Integer(this.bridge2);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.ringNumber = this.ringNumber_JTextField.getText();
        n = new Integer(this.ringNumber);
        if (n < 1 || n > 4095) {
            JOptionPane.showMessageDialog(this, "Please specify a Ring Number between 1 - 4095.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.parentVlan = this.parentVlan_JTextField.getText();
        n = new Integer(this.parentVlan);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify a Parent VLAN between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        String string2 = this.switches[this.parent.switchIndex].Cli.vtpAddFddiVlan(string, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.ringNumber, this.parentVlan, this.bridge1, this.bridge2, this.vlanStatus);
        if (string2.indexOf("Unknown TLB") != -1) {
            JOptionPane.showMessageDialog(this, "Unknown Translational bridge value", "VTP VLAN Configuration", 0);
            return false;
        }
        if (string2.indexOf("Error") != -1) {
            JOptionPane.showMessageDialog(this, string2, "VTP VLAN Configuration", 0);
            return false;
        }
        return true;
    }

    boolean okFddiNet() {
        String string = this.switches[this.parent.switchIndex].esn;
        this.bridge1 = this.bridge1_JTextField.getText();
        int n = new Integer(this.bridge1);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridge2 = this.bridge2_JTextField.getText();
        n = new Integer(this.bridge2);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridgeNumber = this.bridgeNumber_JTextField.getText();
        n = new Integer(this.bridgeNumber);
        if (n < 0 || n > 15) {
            JOptionPane.showMessageDialog(this, "Please specify a Bridge Number between 0 - 15.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.stpType = (String)this.stpType_JCombo.getSelectedItem();
        String string2 = this.switches[this.parent.switchIndex].Cli.vtpAddFddiNetVlan(string, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.bridge1, this.bridge2, this.vlanStatus, this.bridgeNumber, this.stpType);
        if (string2.indexOf("Unknown TLB") != -1) {
            JOptionPane.showMessageDialog(this, "Unknown Translational bridge value", "VTP VLAN Configuration", 0);
            return false;
        }
        if (string2.indexOf("Error") != -1) {
            JOptionPane.showMessageDialog(this, string2, "VTP VLAN Configuration", 0);
            return false;
        }
        return true;
    }

    boolean okTokenring() {
        String string;
        String string2 = this.switches[this.parent.switchIndex].esn;
        this.bridge1 = this.bridge1_JTextField.getText();
        int n = new Integer(this.bridge1);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridge2 = this.bridge2_JTextField.getText();
        n = new Integer(this.bridge2);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.ringNumber = this.ringNumber_JTextField.getText();
        n = new Integer(this.ringNumber);
        if (this.parent.vtpV2.equals("Enabled")) {
            if (n < 1 || n > 4095) {
                JOptionPane.showMessageDialog(this, "Please specify a Ring Number between 1 - 4095.", "VTP VLAN Configuration", 0);
                return false;
            }
        } else if (n < 0 || n > 4095) {
            JOptionPane.showMessageDialog(this, "Please specify a Ring Number between 0 - 4095.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.parentVlan = this.parentVlan_JTextField.getText();
        n = new Integer(this.parentVlan);
        if (this.parent.vtpV2.equals("Enabled")) {
            if (n < 1 || n > 1005) {
                JOptionPane.showMessageDialog(this, "Please specify a Parent VLAN between 1 - 1005.", "VTP VLAN Configuration", 0);
                return false;
            }
        } else if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify a Parent VLAN between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        if (this.parent.vtpV2.equals("Disabled")) {
            string = this.switches[this.parent.switchIndex].Cli.vtpAddTokenVlan1(string2, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.ringNumber, this.parentVlan, this.bridge1, this.bridge2, this.vlanStatus);
        } else {
            this.bridgeMode = (String)this.bridgeMode_JCombo.getSelectedItem();
            this.ARE = this.ARE_JTextField.getText();
            n = Integer.parseInt(this.ARE);
            if (n < 0 || n > 13) {
                JOptionPane.showMessageDialog(this, "Please enter the ARE Max hops in the range of 0 - 13", "VTP VLAN Configuration", 0);
                return false;
            }
            this.STE = this.STE_JTextField.getText();
            n = Integer.parseInt(this.STE);
            if (n < 0 || n > 13) {
                JOptionPane.showMessageDialog(this, "Please enter the STE Max hops in the range of 0 - 13", "VTP VLAN Configuration", 0);
                return false;
            }
            this.backupCRF = (String)this.backupCRF_JCombo.getSelectedItem();
            this.backupCRF = this.backupCRF.trim().equalsIgnoreCase("On") ? "Enable" : "Disable";
            string = this.switches[this.parent.switchIndex].Cli.vtpAddTokenVlan2(string2, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.ringNumber, this.parentVlan, this.bridge1, this.bridge2, this.vlanStatus, this.bridgeMode, this.ARE, this.STE, this.backupCRF);
        }
        if (string.indexOf("Unknown TLB") != -1) {
            JOptionPane.showMessageDialog(this, "Unknown Translational bridge value", "VTP VLAN Configuration", 0);
            return false;
        }
        if (string.indexOf("Error") != -1) {
            JOptionPane.showMessageDialog(this, string, "VTP VLAN Configuration", 0);
            return false;
        }
        return true;
    }

    boolean okTokenringNet() {
        String string = this.switches[this.parent.switchIndex].esn;
        this.bridge1 = this.bridge1_JTextField.getText();
        int n = new Integer(this.bridge1);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridge2 = this.bridge2_JTextField.getText();
        n = new Integer(this.bridge2);
        if (n < 0 || n > 1005) {
            JOptionPane.showMessageDialog(this, "Please specify Translational Bridge value between 0 - 1005.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.bridgeNumber = this.bridgeNumber_JTextField.getText();
        n = new Integer(this.bridgeNumber);
        if (this.parent.vtpV2.equals("Disabled")) {
            if (n < 0 || n > 15) {
                JOptionPane.showMessageDialog(this, "Please specify a Bridge Number between 0 - 15.", "VTP VLAN Configuration", 0);
                return false;
            }
        } else if (n < 1 || n > 15) {
            JOptionPane.showMessageDialog(this, "Please specify a Bridge Number between 1 - 15.", "VTP VLAN Configuration", 0);
            return false;
        }
        this.stpType = (String)this.stpType_JCombo.getSelectedItem();
        String string2 = this.switches[this.parent.switchIndex].Cli.vtpAddTokenNetVlan(string, this.vlanId, this.vlanName, this.vlanSAID, this.mtuSize, this.bridge1, this.bridge2, this.vlanStatus, this.bridgeNumber, this.stpType);
        if (string2.indexOf("Unknown TLB") != -1) {
            JOptionPane.showMessageDialog(this, "Unknown Translational bridge value", "VTP VLAN Configuration", 0);
            return false;
        }
        if (string2.indexOf("Error") != -1) {
            JOptionPane.showMessageDialog(this, string2, "VTP VLAN Configuration", 0);
            return false;
        }
        return true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void setVlanName() {
        String string = this.vlanId_JTextField.getText();
        if (string.length() != 0 && this.vlanName_JTextField.getText().length() == 0) {
            String string2 = "";
            int n = string.length();
            while (n < 4) {
                string2 = String.valueOf(string2) + "0";
                ++n;
            }
            string2 = String.valueOf(string2) + string;
            this.vlanName_JTextField.setText("VLAN" + string2);
        }
    }
}

