/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VLANGroupConfig_JDialog
extends JDialog
implements ActionListener,
Runnable {
    VLANConfig_JDialog vlanConfig_JDialog;
    boolean frameSizeAdjusted = false;
    JPanel center_JPanel;
    JPanel vlanId_JPanel;
    JPanel vlanMode_JPanel;
    JPanel button_JPanel;
    JPanel allowedVLAN_JPanel;
    JPanel pruning_JPanel;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JLabel assignedVLANs_JLabel;
    JLabel vlanMode_JLabel;
    JLabel allowedVLAN_JLabel;
    JLabel pruning_JLabel;
    JComboBox vlanMode_JComboBox;
    JTextField assignedVLANs_JTextField;
    JTextField allowedVLAN_JTextField;
    JTextField pruning_JTextField;
    String[] portSettings = null;
    boolean errorFound = false;
    Thread vlanConfigThread;
    Hashtable settingInfo;
    Hashtable modeInfo;
    Hashtable spanInfo;
    Vector selectedPorts;
    Vector selectedDevices;
    CommonSwitch selectedSwitch;
    CommonSwitch[] Switches;
    String[] spanSettings = null;
    int index = 0;
    boolean calledFromPortPopup = false;
    String[] modeSettings;
    boolean updateIsNeeded = false;
    boolean closeDialog = true;
    JApplet theApplet;
    private boolean DynamicAndTrunkIsNotSupported = false;

    public VLANGroupConfig_JDialog(JApplet jApplet, VLANConfig_JDialog vLANConfig_JDialog, CommonSwitch commonSwitch, Vector vector) {
        this(jApplet, null);
        this.selectedPorts = vector;
        this.selectedSwitch = commonSwitch;
        this.center_JPanel.add(this.allowedVLAN_JPanel);
        if (commonSwitch.Cli.getDeviceType(commonSwitch.esn).indexOf("WS-C2950") == -1) {
            this.center_JPanel.add(this.pruning_JPanel);
        }
        this.vlanConfig_JDialog = vLANConfig_JDialog;
        String string = commonSwitch.Cli.getSwVersion(commonSwitch.esn);
        if (commonSwitch.deviceType.indexOf("WS-C2950") != -1 && (string.indexOf("XU") == -1 || string.indexOf("WC") == -1 || string.indexOf("XW") == -1)) {
            JOptionPane.showMessageDialog(this, "Device '" + commonSwitch.switchName + "',  is running\n" + string + " image, which does not allow \n" + "modification of the pruning eligibility list", "Information: VLAN Membership", 1);
            this.pruning_JTextField.setEnabled(false);
        }
        if (commonSwitch.deviceType.indexOf("WS-C2950") != -1) {
            this.vlanMode_JComboBox.removeItem("Multi-VLAN");
            this.vlanMode_JComboBox.removeItem("ISL Trunk");
            this.vlanMode_JComboBox.removeItem("Dynamic Access");
        }
    }

    public VLANGroupConfig_JDialog(JApplet jApplet, VLANConfig_JDialog vLANConfig_JDialog, Vector vector, Vector vector2) {
        this(jApplet, null);
        this.center_JPanel.add(this.vlanMode_JPanel);
        this.center_JPanel.add(this.vlanId_JPanel);
        this.allowedVLAN_JPanel.setVisible(false);
        this.vlanConfig_JDialog = vLANConfig_JDialog;
        this.selectedPorts = vector;
        this.selectedDevices = vector2;
        this.calledFromPortPopup = false;
        this.vlanConfigThread = new Thread((Runnable)this, "device");
        this.vlanConfigThread.start();
        Object[] objectArray = new CommonSwitch[vector2.size()];
        Object[] objectArray2 = new String[vector.size()];
        vector2.copyInto(objectArray);
        vector.copyInto(objectArray2);
        if (this.areAllC2950((CommonSwitch[])objectArray)) {
            this.vlanMode_JComboBox.removeItem("Multi-VLAN");
            this.vlanMode_JComboBox.removeItem("ISL Trunk");
            this.vlanMode_JComboBox.removeItem("Dynamic Access");
        }
    }

    public VLANGroupConfig_JDialog(JApplet jApplet, Frame frame) {
        super(frame);
        this.theApplet = jApplet;
        this.setDefaultCloseOperation(2);
        this.setTitle("Group VLAN Assignment");
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(450, 200);
        this.setVisible(false);
        this.center_JPanel = new JPanel();
        this.center_JPanel.setLayout(new GridLayout(2, 0));
        this.vlanMode_JPanel = new JPanel();
        this.vlanMode_JLabel = new JLabel("Mode:");
        this.vlanMode_JPanel.add(this.vlanMode_JLabel);
        Object[] objectArray = new Object[]{"Static Access", "Multi-VLAN", "Dynamic Access", "ISL Trunk", "802.1Q Trunk"};
        this.vlanMode_JComboBox = new JComboBox<Object>(objectArray);
        this.vlanMode_JComboBox.addActionListener(this);
        this.vlanMode_JPanel.add(this.vlanMode_JComboBox);
        this.vlanMode_JPanel.setBorder(BorderFactory.createTitledBorder("VLAN Mode"));
        this.vlanId_JPanel = new JPanel();
        this.vlanId_JPanel.setBorder(BorderFactory.createTitledBorder("Assigned VLANs"));
        this.assignedVLANs_JLabel = new JLabel("VLAN ID (1-1001):");
        this.vlanId_JPanel.add(this.assignedVLANs_JLabel);
        this.assignedVLANs_JTextField = new JTextField(15);
        this.vlanId_JPanel.add(this.assignedVLANs_JTextField);
        this.allowedVLAN_JPanel = new JPanel();
        this.allowedVLAN_JPanel.setBorder(BorderFactory.createTitledBorder("Allowed VLAN List"));
        this.allowedVLAN_JLabel = new JLabel("VLAN ID (1-1005):");
        this.allowedVLAN_JPanel.add(this.allowedVLAN_JLabel);
        this.allowedVLAN_JTextField = new JTextField(15);
        this.allowedVLAN_JPanel.add(this.allowedVLAN_JTextField);
        this.pruning_JPanel = new JPanel();
        this.pruning_JPanel.setBorder(BorderFactory.createTitledBorder("VLAN Pruning Eligibility"));
        this.pruning_JLabel = new JLabel("VLAN ID (none,2-1001):");
        this.pruning_JPanel.add(this.pruning_JLabel);
        this.pruning_JTextField = new JTextField(15);
        this.pruning_JPanel.add(this.pruning_JTextField);
        this.button_JPanel = new JPanel();
        this.ok_JButton = new JButton("OK");
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton = new JButton("Cancel");
        this.cancel_JButton.addActionListener(this);
        this.help_JButton = new JButton("Help");
        this.help_JButton.addActionListener(this);
        this.button_JPanel.add(this.ok_JButton);
        this.button_JPanel.add(this.cancel_JButton);
        this.button_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.center_JPanel, "Center");
        this.getContentPane().add((Component)this.button_JPanel, "South");
    }

    public VLANGroupConfig_JDialog(JApplet jApplet, Vector vector, Vector vector2) {
        this(jApplet, null);
        this.center_JPanel.add(this.vlanMode_JPanel);
        this.center_JPanel.add(this.vlanId_JPanel);
        this.allowedVLAN_JPanel.setVisible(false);
        this.selectedPorts = vector;
        this.selectedDevices = vector2;
        this.calledFromPortPopup = true;
        this.vlanConfigThread = new Thread((Runnable)this, "port");
        this.vlanConfigThread.start();
        Object[] objectArray = new CommonSwitch[vector2.size()];
        Object[] objectArray2 = new String[vector.size()];
        vector2.copyInto(objectArray);
        vector.copyInto(objectArray2);
        if (this.areAllC2950((CommonSwitch[])objectArray)) {
            this.vlanMode_JComboBox.removeItem("Multi-VLAN");
            this.vlanMode_JComboBox.removeItem("ISL Trunk");
            this.vlanMode_JComboBox.removeItem("Dynamic Access");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        if (object == this.vlanMode_JComboBox) {
            if (((String)this.vlanMode_JComboBox.getSelectedItem()).indexOf("Trunk") != -1 || ((String)this.vlanMode_JComboBox.getSelectedItem()).indexOf("Dynamic") != -1) {
                this.assignedVLANs_JTextField.setEnabled(false);
                this.ok_JButton.setEnabled(true);
            } else {
                this.assignedVLANs_JTextField.setEnabled(true);
            }
        } else if (object == this.ok_JButton) {
            if (this.allowedVLAN_JPanel.isVisible()) {
                String string;
                int n;
                ((Component)this).setCursor(new Cursor(3));
                String string2 = this.allowedVLAN_JTextField.getText().trim();
                if (string2.length() > 0) {
                    if (this.validateMultiVlanId(string2, 1, 1005)) {
                        n = 0;
                        while (n < this.selectedPorts.size()) {
                            this.selectedSwitch.Cli.setTrunkAllowedVLANList(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), string2);
                            ++n;
                        }
                        this.updateIsNeeded = true;
                    } else {
                        this.closeDialog = false;
                    }
                }
                if ((string = this.pruning_JTextField.getText().trim()).length() > 0) {
                    if (string.trim().toLowerCase().equals("none")) {
                        n = 0;
                        while (n < this.selectedPorts.size()) {
                            this.selectedSwitch.Cli.setTrunkPruningList(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), string);
                            ++n;
                        }
                        this.updateIsNeeded = true;
                    } else if (this.validateMultiVlanId(string, 2, 1001)) {
                        n = 0;
                        while (n < this.selectedPorts.size()) {
                            this.selectedSwitch.Cli.setTrunkPruningList(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "none");
                            this.selectedSwitch.Cli.setTrunkPruningList(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), string);
                            ++n;
                        }
                        this.updateIsNeeded = true;
                    } else {
                        this.closeDialog = false;
                    }
                }
                if (this.updateIsNeeded && !this.calledFromPortPopup) {
                    this.updateTableModel();
                    this.updateIsNeeded = false;
                }
                ((Component)this).setCursor(new Cursor(0));
                if (this.closeDialog) {
                    this.cancelAction();
                } else {
                    this.closeDialog = true;
                }
            } else {
                ((Component)this).setCursor(new Cursor(3));
                String string = this.assignedVLANs_JTextField.getText();
                this.settingInfo = new Hashtable();
                this.modeInfo = new Hashtable();
                this.spanInfo = new Hashtable();
                if (((String)this.vlanMode_JComboBox.getSelectedItem()).indexOf("Trunk") != -1) {
                    int n = 0;
                    while (n < this.selectedPorts.size()) {
                        this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
                        if (!this.checkForATM(n) && this.checkForEnterpriseEdition(n)) {
                            this.getSettings();
                            if (!(this.isPortMultiVlan(n) || this.isThereAnyMultiVlan(n) || this.checkForSecuredPort(n) || this.checkForPortMonitor(n) || this.checkForMonitoredPort(n) || this.checkFor100BTXorBFX(n, true))) {
                                if (((String)this.vlanMode_JComboBox.getSelectedItem()).equals("ISL Trunk")) {
                                    this.selectedSwitch.Cli.setVLANMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "trunk");
                                    this.selectedSwitch.Cli.setVLANTrunkMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "ISL Trunk");
                                } else {
                                    this.selectedSwitch.Cli.setVLANMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "trunk");
                                    this.selectedSwitch.Cli.setVLANTrunkMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "802.1Q Trunk");
                                }
                                this.updateIsNeeded = true;
                            }
                        }
                        ++n;
                    }
                } else if (((String)this.vlanMode_JComboBox.getSelectedItem()).equals("Static Access")) {
                    if (this.validateSingleVlanId(string, 1, 1001)) {
                        int n = 0;
                        while (n < this.selectedPorts.size()) {
                            if (!this.checkForATM(n)) {
                                this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
                                this.selectedSwitch.Cli.setVLANMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "access");
                                String string3 = this.selectedSwitch.Cli.setVLANIdforMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), string, "access");
                                if (string3 == null || string3.equals("")) {
                                    this.updateIsNeeded = true;
                                } else {
                                    Object object2;
                                    String[] stringArray = this.selectedSwitch.Cli.showPortSPAN(this.selectedSwitch.esn);
                                    String[] stringArray2 = this.selectedSwitch.Cli.showHtmlPortNames(this.selectedSwitch.esn);
                                    String string4 = (String)this.selectedPorts.elementAt(n);
                                    int n2 = 0;
                                    int n3 = 0;
                                    while (n3 < stringArray2.length) {
                                        if (stringArray2[n3].equals(string4)) {
                                            n2 = n3;
                                            break;
                                        }
                                        ++n3;
                                    }
                                    String string5 = "";
                                    int n4 = 1;
                                    while (n4 < stringArray.length) {
                                        object2 = stringArray[n4].toCharArray();
                                        if (object2[n2 + 1] == '1') {
                                            string5 = stringArray2[n4 - 1];
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (!string5.equals("")) {
                                        object2 = this.selectedSwitch.Cli.getVlanId(this.selectedSwitch.esn, string5);
                                        JOptionPane.showMessageDialog(this, "Couldn't change VLAN for the port " + string4 + "\n" + " because its already being monitored in VLAN " + (String)object2 + ".", "Error: VLAN Membership", 0);
                                    }
                                    this.updateIsNeeded = false;
                                }
                            }
                            ++n;
                        }
                    } else {
                        this.closeDialog = false;
                    }
                } else if (((String)this.vlanMode_JComboBox.getSelectedItem()).equals("Multi-VLAN")) {
                    if (this.validateMultiVlanId(string, 1, 1001)) {
                        int n = 0;
                        while (n < this.selectedPorts.size()) {
                            this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
                            if (!this.checkForATM(n)) {
                                this.getSettings();
                                if (!(this.isPortTrunk(n) || this.isThereAnyTrunk(n) || this.checkForSecuredPort(n) || this.checkForPortMonitor(n) || this.checkForMonitoredPort(n))) {
                                    this.selectedSwitch.Cli.setVLANMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "multi");
                                    this.selectedSwitch.Cli.setVLANIdforMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), string, "multi");
                                    this.updateIsNeeded = true;
                                }
                            }
                            ++n;
                        }
                    } else {
                        this.closeDialog = false;
                    }
                } else if (((String)this.vlanMode_JComboBox.getSelectedItem()).equals("Dynamic Access")) {
                    int n = 0;
                    while (n < this.selectedPorts.size()) {
                        this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
                        if (!this.checkForATM(n) && this.checkForEnterpriseEdition(n)) {
                            this.getSettings();
                            if (!(this.checkForNetworkPort(n) || this.checkForGroupPort(n) || this.checkForSecuredPort(n) || this.checkForPortMonitor(n) || this.checkForMonitoredPort(n))) {
                                this.selectedSwitch.Cli.setVLANMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "access");
                                this.selectedSwitch.Cli.setVLANTrunkMode(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n), "Dynamic Access");
                                this.updateIsNeeded = true;
                            }
                        }
                        ++n;
                    }
                }
                if (this.updateIsNeeded && !this.calledFromPortPopup) {
                    this.updateTableModel();
                    this.updateIsNeeded = false;
                }
                ((Component)this).setCursor(new Cursor(0));
                if (this.closeDialog) {
                    this.cancelAction();
                } else {
                    this.closeDialog = true;
                }
            }
        } else if (object == this.cancel_JButton) {
            this.cancelAction();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"vmemwin");
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    boolean areAllC2950(CommonSwitch[] commonSwitchArray) {
        boolean bl = true;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n].deviceType.indexOf("WS-C2950") == -1) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void cancelAction() {
        this.dispose();
    }

    boolean checkFor100BTXorBFX(int n, boolean bl) {
        if ((this.selectedSwitch.Slot1Type.equals("WS-2914-XL") || this.selectedSwitch.Slot1Type.equals("100BTX")) && ((String)this.selectedPorts.elementAt(n)).indexOf("1/") != -1) {
            if (bl) {
                JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is located \n" + "on a 100BTX module, which can not support trunk mode.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
            }
            return true;
        }
        if ((this.selectedSwitch.Slot2Type.equals("WS-2914-XL") || this.selectedSwitch.Slot2Type.equals("100BTX")) && ((String)this.selectedPorts.elementAt(n)).indexOf("2/") != -1) {
            if (bl) {
                JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is located\n" + "on a 100BTX module, which can not support trunk mode.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
            }
            return true;
        }
        if ((this.selectedSwitch.Slot1Type.equals("WS-X2922-XL") || this.selectedSwitch.Slot1Type.equals("100BFX")) && ((String)this.selectedPorts.elementAt(n)).indexOf("1/") != -1) {
            if (bl) {
                JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is located.\n" + "on 100BFX module, which can not support trunk mode.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
            }
            return true;
        }
        if ((this.selectedSwitch.Slot2Type.equals("WS-X2922-XL") || this.selectedSwitch.Slot2Type.equals("100BFX")) && ((String)this.selectedPorts.elementAt(n)).indexOf("2/") != -1) {
            if (bl) {
                JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is located.\n" + "on 100BFX module, which can not support trunk mode.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
            }
            return true;
        }
        return false;
    }

    boolean checkForATM(int n) {
        if (((String)this.selectedPorts.elementAt(n)).toLowerCase().indexOf("atm") != -1) {
            JOptionPane.showMessageDialog(this, "VLAN mode for the ATM port, " + (String)this.selectedPorts.elementAt(n) + "\n" + "on '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "' device can not be modified.\n", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    public boolean checkForEnterpriseEdition(int n) {
        this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
        if (!this.selectedSwitch.enterpriseEdition || this.selectedSwitch.enterpriseEdition && this.selectedSwitch.DRAMSize == 4) {
            JOptionPane.showMessageDialog(this, (String)this.selectedPorts.elementAt(n) + " is on a Device(" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + ") \n" + "that does not support Dynamic or Trunk mode.", "Error: VLAN Membership", 0);
            return false;
        }
        return true;
    }

    boolean checkForGroupPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("g")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a group port.\n" + "Group Port can not be a dynamic access port.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean checkForMonitoredPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.spanSettings = (String[])this.spanInfo.get(this.selectedSwitch);
        int n2 = 0;
        while (n2 < this.spanSettings.length) {
            if (this.spanSettings[n2].substring(this.index, this.index + 1).equals("1")) {
                JOptionPane.showMessageDialog(this, "Selected port, " + (String)this.selectedPorts.elementAt(n) + " on '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "' device\n" + "is being monitored. VLAN for a monitored port can not be modified.\n", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean checkForNetworkPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("n") || this.portSettings[this.index - 1].equals("ng")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a network port.\n" + "Network Port can not be a dynamic access port.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean checkForPortMonitor(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("m")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a monitor port.\n" + "VLAN mode can not be changed for monitor ports.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean checkForSecuredPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("s")) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a secured port.\n" + "It can only be a static access port.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    void getSettings() {
        if (!this.settingInfo.isEmpty()) {
            if (!this.settingInfo.containsKey(this.selectedSwitch)) {
                this.settingInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllPortsSetting(this.selectedSwitch.esn));
                this.modeInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllVLANsMode(this.selectedSwitch.esn));
                this.spanInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getSPAN(this.selectedSwitch.esn));
            }
        } else {
            this.settingInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllPortsSetting(this.selectedSwitch.esn));
            this.modeInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllVLANsMode(this.selectedSwitch.esn));
            this.spanInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getSPAN(this.selectedSwitch.esn));
        }
    }

    public int getTruePortIndex(int n) {
        int n2 = 0;
        this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
        if (((String)this.selectedPorts.elementAt(n)).indexOf("0/") != -1) {
            if (((String)this.selectedPorts.elementAt(n)).indexOf("gig") != -1) {
                if (this.selectedSwitch.getName().indexOf("3508") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
                } else if (this.selectedSwitch.getName().indexOf("3512") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 12;
                } else if (this.selectedSwitch.getName().indexOf("3524") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 24;
                } else if (this.selectedSwitch.getName().indexOf("3548") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 48;
                }
            } else {
                n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
            }
        } else if (((String)this.selectedPorts.elementAt(n)).indexOf("1/") != -1) {
            n2 = this.selectedSwitch.slot0PortNumbers + new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
        } else if (((String)this.selectedPorts.elementAt(n)).indexOf("2/") != -1) {
            n2 = this.selectedSwitch.slot0PortNumbers + this.selectedSwitch.slot1PortNumbers + new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
        }
        return n2;
    }

    boolean isPortMultiVlan(int n) {
        this.index = this.getTruePortIndex(n);
        this.modeSettings = (String[])this.modeInfo.get(this.selectedSwitch);
        if (this.modeSettings[this.index - 1].equals("Multi-VLAN")) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  has Multi-VLAN mode.\n" + "Can not change a port from Mutli-VLAN mode to Trunk mode.\n" + "Change the port to access mode first and then\n" + "change it to Trunk mode.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean isPortTrunk(int n) {
        this.index = this.getTruePortIndex(n);
        this.modeSettings = (String[])this.modeInfo.get(this.selectedSwitch);
        if (this.modeSettings[this.index - 1].indexOf("Trunk") != -1) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a Trunk.\n" + "Can not change a port from Trunk mode to Multi-VLAN mode.\n" + "Change the port to access mode first and then\n" + "change it to Trunk mode.", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean isThereAnyMultiVlan(int n) {
        int n2 = 0;
        while (n2 < this.modeSettings.length) {
            if (this.modeSettings[n2].indexOf("Multi") != -1) {
                JOptionPane.showMessageDialog(this, "One or more ports on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "', are\n" + "configured as multi-VLAN.\n" + "There can not be concurrent Multi-VLAN and Trunks configured\n" + "on the same device.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isThereAnyTrunk(int n) {
        int n2 = 0;
        while (n2 < this.modeSettings.length) {
            if (this.modeSettings[n2].indexOf("Trunk") != -1) {
                JOptionPane.showMessageDialog(this, "One or more ports on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "', are\n" + "configured as Trunk.\n" + "There can not be concurrent Multi-VLAN and Trunks configured\n" + "on the same device.", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run() {
        int n;
        ((Component)this).setCursor(new Cursor(3));
        if (this.calledFromPortPopup) {
            this.DynamicAndTrunkIsNotSupported = true;
            n = 0;
            while (n < this.selectedDevices.size()) {
                this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
                if (this.selectedSwitch.enterpriseEdition && this.selectedSwitch.DRAMSize != 4 && !this.checkFor100BTXorBFX(n, false) || this.selectedSwitch.enterpriseEdition && this.selectedSwitch.DRAMSize == 4 && !this.checkFor100BTXorBFX(n, false) && ((String)this.selectedPorts.elementAt(n)).indexOf("0/") == -1) {
                    this.DynamicAndTrunkIsNotSupported = false;
                    break;
                }
                ++n;
            }
        } else {
            this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(0);
            if (!this.selectedSwitch.enterpriseEdition) {
                this.DynamicAndTrunkIsNotSupported = true;
            } else {
                this.DynamicAndTrunkIsNotSupported = true;
                n = 0;
                while (n < this.selectedPorts.size()) {
                    if (this.selectedSwitch.DRAMSize == 8 && ((String)this.selectedPorts.elementAt(n)).indexOf("0/") != -1 || this.selectedSwitch.DRAMSize == 4 && ((String)this.selectedPorts.elementAt(n)).indexOf("0/") == -1 && !this.checkFor100BTXorBFX(n, false) || ((String)this.selectedPorts.elementAt(n)).indexOf("0/") == -1 && !this.checkFor100BTXorBFX(n, false)) {
                        this.DynamicAndTrunkIsNotSupported = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        if (this.DynamicAndTrunkIsNotSupported) {
            JOptionPane.showMessageDialog(this, "Selected ports belong to device(s) that can not\nsupport Dynamic and Trunk modes.", "Information: VLAN Membership", 1);
            this.vlanMode_JComboBox.removeItem("Dynamic Access");
            this.vlanMode_JComboBox.removeItem("ISL Trunk");
            this.vlanMode_JComboBox.removeItem("802.1Q Trunk");
        }
        if (this.selectedPorts.size() == 1) {
            this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(0);
            String string = (String)this.selectedPorts.elementAt(0);
            String string2 = this.selectedSwitch.Cli.getVlanMode(this.selectedSwitch.esn, string.substring(0, string.indexOf("/") - 1), new Integer(string.substring(string.indexOf("/") - 1, string.indexOf("/"))).intValue(), new Integer(string.substring(string.indexOf("/") + 1)).intValue());
            int n2 = 0;
            while (n2 < this.vlanMode_JComboBox.getItemCount()) {
                if (string2.equals("1Q Trunk")) {
                    this.vlanMode_JComboBox.setSelectedItem("802.1Q Trunk");
                    break;
                }
                if (this.vlanMode_JComboBox.getItemAt(n2).equals(string2)) {
                    this.vlanMode_JComboBox.setSelectedItem(string2);
                    break;
                }
                ++n2;
            }
            String string3 = this.selectedSwitch.Cli.getVlanMembership(this.selectedSwitch.esn, string.substring(0, string.indexOf("/") - 1), new Integer(string.substring(string.indexOf("/") - 1, string.indexOf("/"))).intValue(), new Integer(string.substring(string.indexOf("/") + 1)).intValue());
            this.assignedVLANs_JTextField.setText(string3);
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void updateTableModel() {
        this.vlanConfig_JDialog.vlanConfigAssign_CustomModel.getDataFromDevice(this.selectedSwitch);
        this.vlanConfig_JDialog.assign_JTable.sizeColumnsToFit(-1);
        this.vlanConfig_JDialog.vlanConfigTrunk_CustomModel.getDataFromDevice(this.selectedSwitch);
        this.vlanConfig_JDialog.trunkConfig_JTable.sizeColumnsToFit(-1);
    }

    private boolean validateMultiVlanId(String string, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",-", true);
        if (stringTokenizer.countTokens() == 1) {
            return this.validateSingleVlanId(string, n, n2);
        }
        try {
            while (stringTokenizer.hasMoreTokens()) {
                int n3 = new Integer(stringTokenizer.nextToken());
                if (n3 < 1 || n3 > n2) {
                    JOptionPane.showMessageDialog(this, "Invalid VLAN ID. Enter an integer from " + n + " to " + n2 + ".", "Error: VLAN Membership", 0);
                    ((Component)this).setCursor(new Cursor(3));
                    return false;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringTokenizer.nextToken();
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid VLAN range.\nExample: 2,3,6-10\nVLAN ID must be an integer from " + n + " to " + n2 + ".", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return false;
        }
        return true;
    }

    private boolean validateSingleVlanId(String string, int n, int n2) {
        try {
            int n3 = new Integer(string);
            if (n3 < 1 || n3 > n2) {
                JOptionPane.showMessageDialog(this, "Invalid VLAN ID. Enter an integer from " + n + " to " + n2 + ".", "Error: VLAN Membership", 0);
                ((Component)this).setCursor(new Cursor(3));
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid VLAN ID. Enter an integer from " + n + " to " + n2 + ".", "Error: VLAN Membership", 0);
            ((Component)this).setCursor(new Cursor(3));
            return false;
        }
    }
}

