/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class PortStatisticsTableModel
extends AbstractTableModel {
    private boolean isTableCleared = true;
    private String VDSL_INTERFACE = "Long";
    private String NO_APP = "NA";
    private Vector modelData = null;
    private int retrievalNumber = 3;
    private CommonSwitch device = null;
    private String IPAddress = null;
    private String esn = null;
    private CommonIOSCLIs clis = null;
    private String deviceType = null;
    private boolean supportVDSL = false;
    public static String[] columnNames = new String[]{"Interface", "Port Description", "Transmit Rate (Mbps)", "Receive Rate (Mbps)", "Transmit Bandwidth Usage %", "Receive Bandwidth Usage %", "Transmit Packet Rate (per Second)", "Receive Packet Rate (per Second)", "Transmit Mcast/Bcast Packet Rate (per Second)", "Receive Mcast/Bcast Packet Rate (per Second)", "Total Discarded Packets", "Total Packets With Errors", "Unicast Packets", "Multicast Packets", "Broadcast Packets", "Total Collision Packets", "Excessive Collisions", "Late Collisions", "Unicast Packets", "Multicast Packets", "Broadcast Packets", "Discarded Packets", "Alignment Errors (Packets)", "FCS Errors (Packets)", "Collision Fragments", "Undersize Packets", "Oversize Packets", "Upstream Bandwidth Usage %", "Downstream Bandwidth Usage %", "Signal to Noise Ratio", "Upstream Reed-Solomon Errors", "Downstream Reed-Solomon Errors"};
    public static final int INTERFACE = 0;
    public static final int PORT_NAME = 1;
    public static final int T_RATE = 2;
    public static final int R_RATE = 3;
    public static final int T_UTILIZATION = 4;
    public static final int R_UTILIZATION = 5;
    public static final int T_PACKETS_RATE = 6;
    public static final int R_PACKETS_RATE = 7;
    public static final int T_MB_RATE = 8;
    public static final int R_MB_RATE = 9;
    public static final int TOTAL_DROPS = 10;
    public static final int TOTAL_ERRORS = 11;
    public static final int T_UNICAST = 12;
    public static final int T_MULTICAST = 13;
    public static final int T_BROADCAST = 14;
    public static final int T_COLLISIONS = 15;
    public static final int T_EXCES_COLLISIONS = 16;
    public static final int T_LATE_COLLISIONS = 17;
    public static final int R_UNICAST = 18;
    public static final int R_MULTICAST = 19;
    public static final int R_BROADCAST = 20;
    public static final int R_DROPPED = 21;
    public static final int R_ALIGNMENT_ERRORS = 22;
    public static final int R_FCS_ERRORS = 23;
    public static final int R_FRAGMENT = 24;
    public static final int R_UNDERSIZE = 25;
    public static final int R_OVERSIZE = 26;
    public static final int US_UTILIZATION = 27;
    public static final int DS_UTILIZATION = 28;
    public static final int VDSL_SNR = 29;
    public static final int VDSL_US_ERRORS = 30;
    public static final int VDSL_DS_ERRORS = 31;
    public static final int colNumber = 32;

    public PortStatisticsTableModel(CommonSwitch commonSwitch) {
        this.device = commonSwitch;
        if (commonSwitch != null) {
            this.esn = commonSwitch.esn;
            this.deviceType = commonSwitch.deviceType;
            this.IPAddress = commonSwitch.IPAddress;
            this.clis = commonSwitch.Cli;
            this.supportVDSL = commonSwitch.supportVDSL();
        }
        this.setModelData();
    }

    public void clearCounter() {
        this.isTableCleared = true;
        this.fireTableChanged(new TableModelEvent(this));
        this.clis.clearAllEthernetControllers(this.esn);
        this.setModelData();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= columnNames.length) {
            return "";
        }
        return columnNames[n];
    }

    public StatisticsParser getParser() {
        if (this.deviceType.indexOf("2950") != -1) {
            return new C2950_StatisticsParser();
        }
        return new GenericStatisticsParser();
    }

    public int getRowCount() {
        if (this.modelData == null) {
            return 0;
        }
        return this.modelData.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.modelData.size() || n2 >= 32) {
            return "";
        }
        if (this.isTableCleared) {
            return null;
        }
        PortStatistics portStatistics = (PortStatistics)this.modelData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = portStatistics.getInterfaceName();
                break;
            }
            case 1: {
                string = portStatistics.getPortDesc();
                break;
            }
            case 2: {
                string = portStatistics.getTransmitRate();
                break;
            }
            case 3: {
                string = portStatistics.getReceiveRate();
                break;
            }
            case 4: {
                string = portStatistics.getTransmitBandwidthUsage();
                break;
            }
            case 5: {
                string = portStatistics.getReceiveBandwidthUsage();
                break;
            }
            case 6: {
                string = portStatistics.getTransmitPacketRate();
                break;
            }
            case 7: {
                string = portStatistics.getReceivePacketRate();
                break;
            }
            case 8: {
                string = portStatistics.getMBTransmitPacketRate();
                break;
            }
            case 9: {
                string = portStatistics.getMBReceivePacketRate();
                break;
            }
            case 10: {
                string = portStatistics.getTotalDiscardedPackets();
                break;
            }
            case 11: {
                string = portStatistics.getTotalReceiveErrors();
                break;
            }
            case 12: {
                string = portStatistics.getTransmitUnicastPackets();
                break;
            }
            case 13: {
                string = portStatistics.getTransmitMulticastPackets();
                break;
            }
            case 14: {
                string = portStatistics.getTransmitBroadcastPackets();
                break;
            }
            case 15: {
                string = portStatistics.getTotalCollisionPackets();
                break;
            }
            case 16: {
                string = portStatistics.getExcessiveCollisions();
                break;
            }
            case 17: {
                string = portStatistics.getLateCollisions();
                break;
            }
            case 18: {
                string = portStatistics.getReceiveUnicastPackets();
                break;
            }
            case 19: {
                string = portStatistics.getReceiveMulticastPackets();
                break;
            }
            case 20: {
                string = portStatistics.getReceiveBroadcastPackets();
                break;
            }
            case 21: {
                string = portStatistics.getReceiveDiscardedPackets();
                break;
            }
            case 22: {
                string = portStatistics.getAlignmentErrors();
                break;
            }
            case 23: {
                string = portStatistics.getFCSErrors();
                break;
            }
            case 24: {
                string = portStatistics.getCollisionFragments();
                break;
            }
            case 25: {
                string = portStatistics.getUnderSizedPackets();
                break;
            }
            case 26: {
                string = portStatistics.getOverSizedPackets();
                break;
            }
            case 27: {
                string = portStatistics.getVdslUsUsage();
                break;
            }
            case 28: {
                string = portStatistics.getVdslDsUsage();
                break;
            }
            case 29: {
                string = portStatistics.getVdslSnr();
                break;
            }
            case 30: {
                string = portStatistics.getVdslUsRSErrs();
                break;
            }
            case 31: {
                string = portStatistics.getVdslDsRSErrs();
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public boolean isTableFilled() {
        return this.isTableCleared ^ true;
    }

    private void modelDataRetrieved(Vector vector) {
        this.modelData = vector;
        this.isTableCleared = false;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void refresh() {
        this.isTableCleared = true;
        this.fireTableChanged(new TableModelEvent(this));
        this.setModelData();
    }

    private void setModelData() {
        AllPortStatisticPoller allPortStatisticPoller = new AllPortStatisticPoller();
        allPortStatisticPoller.start();
    }

    class PortStatistics {
        protected NumberFormat rateFormat = null;
        protected NumberFormat defaultFormat = null;
        private long pollingTime = 0L;
        protected Map transmitMap = null;
        protected Map receiveMap = null;
        private Map vdslMap = null;
        private double transRate = 0.0;
        private double receiveRate = 0.0;
        private double transPacketRate = 0.0;
        private double receivePacketRate = 0.0;
        private double transMBPacketRate = 0.0;
        private double receiveMBPacketRate = 0.0;
        private String interfaceName = null;
        private String portSpeed = null;
        private String portDesc = null;
        private String vdslSnr = null;
        private String vdslUsrate = null;
        private String vdslDsrate = null;
        private String vdslUsRSErrs = null;
        private String vdslDsRSErrs = null;
        private boolean isVdslLinkUp = false;

        public PortStatistics(long l) {
            this.pollingTime = l;
            this.transmitMap = new HashMap();
            this.receiveMap = new HashMap();
            this.rateFormat = new DecimalFormat("0.#####");
            this.defaultFormat = new DecimalFormat("0.#");
        }

        public void addValue(Object object, Object object2, boolean bl) {
            if (bl) {
                this.transmitMap.put(object, object2);
            } else {
                this.receiveMap.put(object, object2);
            }
        }

        public void calculateRates(PortStatistics portStatistics) {
            if (this.pollingTime == portStatistics.pollingTime) {
                return;
            }
            double d = (portStatistics.pollingTime - this.pollingTime) / 1000L;
            double d2 = (portStatistics.pollingTime - this.pollingTime) * 1000L;
            long l = Long.parseLong(this.getTotalTransmitBytes());
            long l2 = Long.parseLong(portStatistics.getTotalTransmitBytes());
            long l3 = Long.parseLong(this.getTotalReceiveBytes());
            long l4 = Long.parseLong(portStatistics.getTotalReceiveBytes());
            long l5 = Long.parseLong(this.getTransmitMulticastPackets()) + Long.parseLong(this.getTransmitBroadcastPackets());
            long l6 = l5 + Long.parseLong(this.getTransmitUnicastPackets());
            long l7 = Long.parseLong(this.getReceiveMulticastPackets()) + Long.parseLong(this.getReceiveBroadcastPackets());
            long l8 = Long.parseLong(this.getReceiveUnicastPackets()) + l7;
            long l9 = Long.parseLong(portStatistics.getTransmitMulticastPackets()) + Long.parseLong(portStatistics.getTransmitBroadcastPackets());
            long l10 = Long.parseLong(portStatistics.getTransmitUnicastPackets()) + l9;
            long l11 = Long.parseLong(portStatistics.getReceiveMulticastPackets()) + Long.parseLong(portStatistics.getReceiveBroadcastPackets());
            long l12 = Long.parseLong(portStatistics.getReceiveUnicastPackets()) + l11;
            this.transPacketRate = (double)(l10 - l6) / d;
            this.receivePacketRate = (double)(l12 - l8) / d;
            this.transMBPacketRate = (double)(l9 - l5) / d;
            this.receiveMBPacketRate = (double)(l11 - l7) / d;
            this.transRate = (double)((l2 - l) * 8L + 160L * (l10 - l6)) / d2;
            this.receiveRate = (double)((l4 - l3) * 8L + 160L * (l12 - l8)) / d2;
        }

        public String getAlignmentErrors() {
            return (String)this.receiveMap.get("Alignment errors");
        }

        public String getCollisionFragments() {
            return (String)this.receiveMap.get("Collision fragments");
        }

        public String getExcessiveCollisions() {
            return (String)this.transmitMap.get("Excessive collisions");
        }

        public String getFCSErrors() {
            return (String)this.receiveMap.get("FCS errors");
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getLateCollisions() {
            return (String)this.transmitMap.get("Late collisions");
        }

        public String getMBReceivePacketRate() {
            return this.defaultFormat.format(this.receiveMBPacketRate);
        }

        public String getMBTransmitPacketRate() {
            return this.defaultFormat.format(this.transMBPacketRate);
        }

        public String getOverSizedPackets() {
            return (String)this.receiveMap.get("Oversize frames");
        }

        public String getPortDesc() {
            return this.portDesc;
        }

        public String getReceiveBandwidthUsage() {
            try {
                long l = Long.parseLong(this.portSpeed);
                double d = this.receiveRate / (double)Long.parseLong(this.portSpeed) * 100.0;
                return this.rateFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                return PortStatisticsTableModel.this.NO_APP;
            }
        }

        public String getReceiveBroadcastPackets() {
            return (String)this.receiveMap.get("Broadcast frames");
        }

        public String getReceiveDiscardedPackets() {
            return Long.toString(this.getTotalReceiveDiscardedPacketsByNumber());
        }

        public String getReceiveMulticastPackets() {
            return (String)this.receiveMap.get("Multicast frames");
        }

        public String getReceivePacketRate() {
            return this.defaultFormat.format(this.receivePacketRate);
        }

        public String getReceiveRate() {
            return this.rateFormat.format(this.receiveRate);
        }

        public String getReceiveUnicastPackets() {
            return (String)this.receiveMap.get("Unicast frames");
        }

        public String getTotalCollisionPackets() {
            return Long.toString(this.getTotalCollisionPacketsByNumber());
        }

        public long getTotalCollisionPacketsByNumber() {
            long l = 0L;
            l += Long.parseLong((String)this.transmitMap.get("1 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("2 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("3 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("4 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("5 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("6 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("7 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("8 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("9 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("10 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("11 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("12 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("13 collision frames"));
            l += Long.parseLong((String)this.transmitMap.get("14 collision frames"));
            return l += Long.parseLong((String)this.transmitMap.get("15 collision frames"));
        }

        public String getTotalDiscardedPackets() {
            long l = 0L;
            l += this.getTotalTransmitDroppedPacketsByNumber();
            return Long.toString(l += this.getTotalReceiveDiscardedPacketsByNumber());
        }

        public String getTotalReceiveBytes() {
            return (String)this.receiveMap.get("Bytes");
        }

        public long getTotalReceiveDiscardedPacketsByNumber() {
            long l = 0L;
            l += Long.parseLong((String)this.receiveMap.get("No bandwidth frames"));
            l += Long.parseLong((String)this.receiveMap.get("No buffers frames"));
            l += Long.parseLong((String)this.receiveMap.get("No dest, unicast"));
            l += Long.parseLong((String)this.receiveMap.get("No dest, multicast"));
            return l += Long.parseLong((String)this.receiveMap.get("No dest, broadcast"));
        }

        public String getTotalReceiveErrors() {
            long l = 0L;
            l += Long.parseLong(this.getAlignmentErrors());
            l += Long.parseLong(this.getFCSErrors());
            l += Long.parseLong(this.getCollisionFragments());
            l += Long.parseLong(this.getUnderSizedPackets());
            return Long.toString(l += Long.parseLong(this.getOverSizedPackets()));
        }

        public String getTotalTransmitBytes() {
            return (String)this.transmitMap.get("Bytes");
        }

        public long getTotalTransmitBytesByNumber() {
            return Long.parseLong((String)this.transmitMap.get("Bytes"));
        }

        public long getTotalTransmitDroppedPacketsByNumber() {
            long l = 0L;
            l += Long.parseLong((String)this.transmitMap.get("Too old frames"));
            l += Long.parseLong((String)this.transmitMap.get("Discarded frames"));
            l += Long.parseLong((String)this.transmitMap.get("Excessive collisions"));
            return l += Long.parseLong((String)this.transmitMap.get("Late collisions"));
        }

        public String getTransmitBandwidthUsage() {
            try {
                long l = Long.parseLong(this.portSpeed);
                double d = this.transRate / (double)Long.parseLong(this.portSpeed) * 100.0;
                return this.rateFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                return PortStatisticsTableModel.this.NO_APP;
            }
        }

        public String getTransmitBroadcastPackets() {
            return (String)this.transmitMap.get("Broadcast frames");
        }

        public long getTransmitBroadcastPacketsByNumber() {
            return Long.parseLong((String)this.transmitMap.get("Broadcast frames"));
        }

        public String getTransmitDiscardedPackets() {
            return (String)this.transmitMap.get("Discarded frames");
        }

        public String getTransmitMulticastPackets() {
            return (String)this.transmitMap.get("Multicast frames");
        }

        public long getTransmitMulticastPacketsByNumber() {
            return Long.parseLong((String)this.transmitMap.get("Multicast frames"));
        }

        public String getTransmitPacketRate() {
            return this.defaultFormat.format(this.transPacketRate);
        }

        public String getTransmitRate() {
            return this.rateFormat.format(this.transRate);
        }

        public String getTransmitUnicastPackets() {
            return (String)this.transmitMap.get("Unicast frames");
        }

        public long getTransmitUnicastPacketsByNumber() {
            return Long.parseLong((String)this.transmitMap.get("Unicast frames"));
        }

        public String getUnderSizedPackets() {
            return (String)this.receiveMap.get("Undersize frames");
        }

        public String getVdslDsRSErrs() {
            return this.vdslDsRSErrs;
        }

        public String getVdslDsUsage() {
            if (!this.isVdslLinkUp) {
                return PortStatisticsTableModel.this.NO_APP;
            }
            try {
                double d = this.transRate / (double)Long.parseLong(this.vdslDsrate) * 100.0;
                return this.rateFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                return PortStatisticsTableModel.this.NO_APP;
            }
        }

        public String getVdslSnr() {
            return this.vdslSnr;
        }

        public String getVdslUsRSErrs() {
            return this.vdslUsRSErrs;
        }

        public String getVdslUsUsage() {
            if (!this.isVdslLinkUp) {
                return PortStatisticsTableModel.this.NO_APP;
            }
            try {
                double d = this.receiveRate / (double)Long.parseLong(this.vdslUsrate) * 100.0;
                return this.rateFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                return PortStatisticsTableModel.this.NO_APP;
            }
        }

        public void setInterfaceName(String string) {
            this.interfaceName = string;
        }

        public void setPortDesc(String string) {
            this.portDesc = string;
        }

        public void setPortSpeed(String string) {
            this.portSpeed = string;
        }

        public void setVdslDsRSErrs(String string) {
            this.vdslDsRSErrs = string;
        }

        public void setVdslDsrate(String string) {
            this.vdslDsrate = string;
        }

        public void setVdslLinkState(String string) {
            this.isVdslLinkUp = string.equals("UP");
        }

        public void setVdslSnr(String string) {
            this.vdslSnr = string;
        }

        public void setVdslUsRSErrs(String string) {
            this.vdslUsRSErrs = string;
        }

        public void setVdslUsrate(String string) {
            this.vdslUsrate = string;
        }
    }

    class C2950_PortStatistics
    extends PortStatistics {
        public C2950_PortStatistics(long l) {
            super(l);
        }

        public void addValue(Object object, Object object2, boolean bl) {
            if (bl) {
                this.transmitMap.put(object, object2);
            } else {
                this.receiveMap.put(object, object2);
            }
        }

        public long getTotalCollisionPacketsByNumber() {
            long l = 0L;
            return l += Long.parseLong((String)this.transmitMap.get("Single collision frames"));
        }

        public long getTotalReceiveDiscardedPacketsByNumber() {
            long l = 0L;
            return l += Long.parseLong((String)this.receiveMap.get("Discarded Frames"));
        }

        public long getTotalTransmitDroppedPacketsByNumber() {
            long l = 0L;
            l += Long.parseLong((String)this.transmitMap.get("Aborted Frames"));
            l += Long.parseLong((String)this.transmitMap.get("Excessive collisions"));
            return l += Long.parseLong((String)this.transmitMap.get("Late collisions"));
        }
    }

    static interface StatisticsParser {
        public static final String TRANSMIT = "Transmit";
        public static final String RECEIVE = "Receive";
        public static final String BYTES = "Bytes";
        public static final String UNICAST_FRAMES = "Unicast frames";
        public static final String MULTICAST_FRAMES = "Multicast frames";
        public static final String BROADCAST_FRAMES = "Broadcast frames";
        public static final String DISCARDED_FRAMES = "Discarded frames";
        public static final String TOO_OLD_FRAMES = "Too old frames";
        public static final String DEFERRED_FRAMES = "Deferred frames";
        public static final String T1_COLLISION_FRAMES = "1 collision frames";
        public static final String T2_COLLISION_FRAMES = "2 collision frames";
        public static final String T3_COLLISION_FRAMES = "3 collision frames";
        public static final String T4_COLLISION_FRAMES = "4 collision frames";
        public static final String T5_COLLISION_FRAMES = "5 collision frames";
        public static final String T6_COLLISION_FRAMES = "6 collision frames";
        public static final String T7_COLLISION_FRAMES = "7 collision frames";
        public static final String T8_COLLISION_FRAMES = "8 collision frames";
        public static final String T9_COLLISION_FRAMES = "9 collision frames";
        public static final String T10_COLLISION_FRAMES = "10 collision frames";
        public static final String T11_COLLISION_FRAMES = "11 collision frames";
        public static final String T12_COLLISION_FRAMES = "12 collision frames";
        public static final String T13_COLLISION_FRAMES = "13 collision frames";
        public static final String T14_COLLISION_FRAMES = "14 collision frames";
        public static final String T15_COLLISION_FRAMES = "15 collision frames";
        public static final String EXCESSIVE_COLLISIONS = "Excessive collisions";
        public static final String LATE_COLLISIONS = "Late collisions";
        public static final String NO_BW_FRAMES = "No bandwidth frames";
        public static final String NO_BUFFERS_FRAMES = "No buffers frames";
        public static final String NO_DEST_UNICAST = "No dest, unicast";
        public static final String NO_DEST_MULTICAST = "No dest, multicast";
        public static final String NO_DEST_BROADCAST = "No dest, broadcast";
        public static final String ALIGNMENT_ERRORS = "Alignment errors";
        public static final String FCS_ERRORS = "FCS errors";
        public static final String COLLISION_FRAGMENTS = "Collision fragments";
        public static final String UNDERSIZE_FRAMES = "Undersize frames";
        public static final String MINIMUM_SIZE_FRAMES = "Minimum size frames";
        public static final String R65_127_FRAMES = "65 to 127 byte frames";
        public static final String R128_255_FRAMES = "128 to 255 byte frames";
        public static final String R256_511_FRAMES = "256 to 511 byte frames";
        public static final String R512_1023_FRAMES = "512 to 1023 byte frames";
        public static final String R1024_1518_FRAMES = "1024 to 1518 byte frames";
        public static final String OVERSIZE_FRAMES = "Oversize frames";
        public static final String FLOODED_FRAMES = "Flooded frames";
        public static final String OVERRUN_FRAMES = "Overrun frames";
        public static final String VLAN_FILTERED_FRAMES = "VLAN filtered frames";
        public static final String SINGLE_COLLISION_FRAMES = "Single collision frames";
        public static final String T_ABORTED_FRAMES = "Aborted Frames";
        public static final String T_PAUSE_FRAMES = "Pause frames";
        public static final String R_DISCARDED_FRAMES = "Discarded Frames";
        public static final String DEFAULT_ZERO = "0";

        public Vector parse(String[] var1, long var2);
    }

    class GenericStatisticsParser
    implements StatisticsParser {
        private PortStatistics currentPortStats = null;
        private String dataStr = null;

        GenericStatisticsParser() {
        }

        protected PortStatistics getNewPortStatistics(long l) {
            return new PortStatistics(l);
        }

        protected int getToken(int n, String string, boolean bl) {
            int n2 = 0;
            int n3 = 0;
            String string2 = null;
            n2 = this.dataStr.indexOf(string, n);
            if (n2 == -1) {
                string2 = "0";
                n3 = n;
            } else {
                string2 = this.dataStr.substring(n, n2);
                n3 = n2 + string.length();
            }
            if (bl) {
                this.currentPortStats.addValue(string, string2.trim(), true);
            } else {
                this.currentPortStats.addValue(string, string2.trim(), false);
            }
            return n3;
        }

        public Vector parse(String[] stringArray, long l) {
            Vector<PortStatistics> vector = new Vector<PortStatistics>();
            int n = 0;
            while (n < stringArray.length) {
                this.dataStr = stringArray[n];
                this.currentPortStats = this.getNewPortStatistics(l);
                this.parse4Port();
                vector.add(this.currentPortStats);
                ++n;
            }
            return vector;
        }

        protected void parse4Port() {
            int n = 0;
            n = this.getToken(n, "Receive", true);
            n = this.getToken(n, "Bytes", true);
            n = this.getToken(n, "Bytes", false);
            n = this.getToken(n, "Unicast frames", true);
            n = this.getToken(n, "Unicast frames", false);
            n = this.getToken(n, "Multicast frames", true);
            n = this.getToken(n, "Multicast frames", false);
            n = this.getToken(n, "Broadcast frames", true);
            n = this.getToken(n, "Broadcast frames", false);
            n = this.getToken(n, "Discarded frames", true);
            n = this.getToken(n, "No bandwidth frames", false);
            n = this.getToken(n, "Too old frames", true);
            n = this.getToken(n, "No buffers frames", false);
            n = this.getToken(n, "Deferred frames", true);
            n = this.getToken(n, "No dest, unicast", false);
            n = this.getToken(n, "1 collision frames", true);
            n = this.getToken(n, "No dest, multicast", false);
            n = this.getToken(n, "2 collision frames", true);
            n = this.getToken(n, "No dest, broadcast", false);
            n = this.getToken(n, "3 collision frames", true);
            n = this.getToken(n, "Alignment errors", false);
            n = this.getToken(n, "4 collision frames", true);
            n = this.getToken(n, "FCS errors", false);
            n = this.getToken(n, "5 collision frames", true);
            n = this.getToken(n, "Collision fragments", false);
            n = this.getToken(n, "6 collision frames", true);
            n = this.getToken(n, "7 collision frames", true);
            n = this.getToken(n, "Undersize frames", false);
            n = this.getToken(n, "8 collision frames", true);
            n = this.getToken(n, "Minimum size frames", false);
            n = this.getToken(n, "9 collision frames", true);
            n = this.getToken(n, "65 to 127 byte frames", false);
            n = this.getToken(n, "10 collision frames", true);
            n = this.getToken(n, "128 to 255 byte frames", false);
            n = this.getToken(n, "11 collision frames", true);
            n = this.getToken(n, "256 to 511 byte frames", false);
            n = this.getToken(n, "12 collision frames", true);
            n = this.getToken(n, "512 to 1023 byte frames", false);
            n = this.getToken(n, "13 collision frames", true);
            n = this.getToken(n, "1024 to 1518 byte frames", false);
            n = this.getToken(n, "14 collision frames", true);
            n = this.getToken(n, "Oversize frames", false);
            n = this.getToken(n, "15 collision frames", true);
            n = this.getToken(n, "Flooded frames", false);
            n = this.getToken(n, "Excessive collisions", true);
            n = this.getToken(n, "Overrun frames", false);
            n = this.getToken(n, "Late collisions", true);
        }
    }

    class C2950_StatisticsParser
    extends GenericStatisticsParser {
        protected PortStatistics getNewPortStatistics(long l) {
            return new C2950_PortStatistics(l);
        }

        protected void parse4Port() {
            int n = 0;
            n = this.getToken(n, "Receive", true);
            n = this.getToken(n, "Bytes", true);
            n = this.getToken(n, "Bytes", false);
            n = this.getToken(n, "Unicast frames", true);
            n = this.getToken(n, "Unicast frames", false);
            n = this.getToken(n, "Multicast frames", true);
            n = this.getToken(n, "Multicast frames", false);
            n = this.getToken(n, "Broadcast frames", true);
            n = this.getToken(n, "Broadcast frames", false);
            n = this.getToken(n, "Deferred frames", true);
            n = this.getToken(n, "Alignment errors", false);
            n = this.getToken(n, "Single collision frames", true);
            n = this.getToken(n, "FCS errors", false);
            n = this.getToken(n, "Excessive collisions", true);
            n = this.getToken(n, "Collision fragments", false);
            n = this.getToken(n, "Late collisions", true);
            n = this.getToken(n, "Undersize frames", false);
            n = this.getToken(n, "Aborted Frames", true);
            n = this.getToken(n, "Oversize frames", false);
            n = this.getToken(n, "Pause frames", true);
            n = this.getToken(n, "Discarded Frames", false);
        }
    }

    class AllPortStatisticPoller
    extends Thread {
        private int pollingInterval = 0;
        Vector modelData = null;

        public AllPortStatisticPoller() {
            this.pollingInterval = 2000;
        }

        public AllPortStatisticPoller(int n) {
            this.pollingInterval = n;
        }

        private void adjustPortSpeeds(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("Gig")) {
                    stringArray3[n] = stringArray2[n].equals("UP") ? "1000" : "NA";
                }
                ++n;
            }
        }

        private void completeModelData(Vector vector) {
            String[] stringArray;
            String[] stringArray2 = PortStatisticsTableModel.this.clis.getPortName(PortStatisticsTableModel.this.esn);
            String[] stringArray3 = PortStatisticsTableModel.this.clis.getAllPortSpeedActual(PortStatisticsTableModel.this.esn);
            String[] stringArray4 = PortStatisticsTableModel.this.clis.getAllPortDescription(PortStatisticsTableModel.this.esn);
            String[] stringArray5 = PortStatisticsTableModel.this.clis.getAllPortStatusActual(PortStatisticsTableModel.this.esn);
            this.adjustPortSpeeds(stringArray2, stringArray5, stringArray3);
            int n = 0;
            while (n < vector.size()) {
                stringArray = (String[])vector.get(n);
                stringArray.setInterfaceName(stringArray2[n]);
                stringArray.setPortSpeed(stringArray3[n]);
                stringArray.setPortDesc(stringArray4[n]);
                ++n;
            }
            if (PortStatisticsTableModel.this.supportVDSL) {
                stringArray = PortStatisticsTableModel.this.clis.getAllVdslSnrs(PortStatisticsTableModel.this.esn);
                String[] stringArray6 = PortStatisticsTableModel.this.clis.getAllVdslUsRates(PortStatisticsTableModel.this.esn);
                String[] stringArray7 = PortStatisticsTableModel.this.clis.getAllVdslDsRates(PortStatisticsTableModel.this.esn);
                String[] stringArray8 = PortStatisticsTableModel.this.clis.getAllVdslLinkStates(PortStatisticsTableModel.this.esn);
                String[] stringArray9 = PortStatisticsTableModel.this.clis.getAllVdslUsRSErrors(PortStatisticsTableModel.this.esn);
                String[] stringArray10 = PortStatisticsTableModel.this.clis.getAllVdslDsRSErrors(PortStatisticsTableModel.this.esn);
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.modelData.size()) {
                    PortStatistics portStatistics = (PortStatistics)vector.get(n3);
                    if (portStatistics.getInterfaceName().indexOf(PortStatisticsTableModel.this.VDSL_INTERFACE) != -1) {
                        portStatistics.setVdslSnr(stringArray[n2]);
                        portStatistics.setVdslUsrate(stringArray6[n2]);
                        portStatistics.setVdslDsrate(stringArray7[n2]);
                        portStatistics.setVdslLinkState(stringArray8[n2]);
                        portStatistics.setVdslUsRSErrs(stringArray9[n2]);
                        portStatistics.setVdslDsRSErrs(stringArray10[n2]);
                        ++n2;
                    } else {
                        portStatistics.setVdslSnr(PortStatisticsTableModel.this.NO_APP);
                        portStatistics.setVdslUsrate(PortStatisticsTableModel.this.NO_APP);
                        portStatistics.setVdslDsrate(PortStatisticsTableModel.this.NO_APP);
                        portStatistics.setVdslLinkState(PortStatisticsTableModel.this.NO_APP);
                        portStatistics.setVdslUsRSErrs(PortStatisticsTableModel.this.NO_APP);
                        portStatistics.setVdslDsRSErrs(PortStatisticsTableModel.this.NO_APP);
                    }
                    ++n3;
                }
            }
        }

        private void computeRates(Vector vector) {
            int n = 0;
            while (n < this.modelData.size()) {
                ((PortStatistics)this.modelData.get(n)).calculateRates((PortStatistics)vector.get(n));
                ++n;
            }
        }

        public void run() {
            StatisticsParser statisticsParser = PortStatisticsTableModel.this.getParser();
            String[] stringArray = PortStatisticsTableModel.this.clis.getAllPortStatistics(PortStatisticsTableModel.this.esn);
            long l = System.currentTimeMillis();
            this.modelData = statisticsParser.parse(stringArray, System.currentTimeMillis());
            this.completeModelData(this.modelData);
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Port Statistic Retriever Sleep interrupted");
            }
            stringArray = PortStatisticsTableModel.this.clis.getAllPortStatistics(PortStatisticsTableModel.this.esn);
            Vector vector = statisticsParser.parse(stringArray, System.currentTimeMillis());
            this.computeRates(vector);
            PortStatisticsTableModel.this.modelDataRetrieved(this.modelData);
        }
    }
}

