/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PortConfig_JDialog
extends JDialog
implements ActionListener,
ItemListener,
ListSelectionListener,
ChangeListener {
    boolean frameSizeAdjusted = false;
    boolean isBlocked = false;
    boolean isAsc = true;
    int sortingModelIndex = 0;
    JPanel deviceList_JPanel;
    JComboBox devices_JCombo;
    JScrollPane tableScrollPane;
    Component statusPanel;
    JPanel configButtonsPane = null;
    JPanel viewOnlyButtonsPane = null;
    JPanel currentButtonsPane = null;
    JButton configOK_JButton;
    JButton viewOK_JButton;
    JButton modify_JButton;
    JButton configHelp_JButton;
    JButton viewHelp_JButton;
    JButton portMapping_JButton;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;
    JTabbedPane tabPane;
    JTable configTable;
    JTable actualTable;
    PortConfigTableModel portConfigTableModel;
    JLabel hostName_JLabel = new JLabel("Host Name:");
    JLabel hostName;
    private static final String CONFIG_STATUS_TAB = "Configuration Settings";
    private static final String ACTUAL_STATUS_TAB = "Runtime Status";
    public static final int CONFIG_STATUS_INDEX = 0;
    public static final int ACTUAL_STATUS_INDEX = 1;
    private boolean isActionTab = true;
    private boolean isRowSelected = false;

    public PortConfig_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        int n;
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        this.setDefaultCloseOperation(2);
        if (commonSwitch == null) {
            commonSwitch = commonSwitchArray[0];
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.switchIndex = 0;
        n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        this.setTitle("Port Configuration");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(600, 400);
        this.setVisible(false);
        this.deviceList_JPanel = new JPanel();
        this.deviceList_JPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("North", this.deviceList_JPanel);
        this.deviceList_JPanel.setBounds(0, 0, 513, 62);
        this.deviceList_JPanel.add(this.hostName_JLabel);
        this.devices_JCombo = new JComboBox();
        this.deviceList_JPanel.add(this.devices_JCombo);
        this.devices_JCombo.setBounds(191, 25, 130, 27);
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.hostName = new JLabel("");
            this.hostName.setText(commonSwitchArray[0].switchName);
            this.deviceList_JPanel.add(this.hostName);
            this.devices_JCombo.setVisible(false);
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder("Device List"));
        }
        int n2 = 0;
        while (n2 < commonSwitchArray.length) {
            this.devices_JCombo.addItem(commonSwitchArray[n2].switchName);
            ++n2;
        }
        this.devices_JCombo.setSelectedItem(commonSwitchArray[this.switchIndex].switchName);
        this.statusPanel = this.createStatusPanel(commonSwitchArray, (String)this.devices_JCombo.getSelectedItem());
        this.getContentPane().add(this.statusPanel, "Center");
        this.configButtonsPane = new JPanel();
        this.viewOnlyButtonsPane = new JPanel();
        this.configOK_JButton = new JButton("OK");
        this.viewOK_JButton = new JButton("OK");
        this.modify_JButton = new JButton("Modify ...");
        this.modify_JButton.setEnabled(false);
        this.configHelp_JButton = new JButton("Help");
        this.viewHelp_JButton = new JButton("Help");
        this.portMapping_JButton = new JButton("Describe ...");
        this.portMapping_JButton.setEnabled(false);
        this.configButtonsPane.add(this.configOK_JButton);
        this.configButtonsPane.add(this.modify_JButton);
        this.configButtonsPane.add(this.portMapping_JButton);
        this.configButtonsPane.add(this.configHelp_JButton);
        this.currentButtonsPane = this.configButtonsPane;
        this.getContentPane().add((Component)this.configButtonsPane, "South");
        this.viewOnlyButtonsPane.add(this.viewOK_JButton);
        this.viewOnlyButtonsPane.add(this.viewHelp_JButton);
        this.devices_JCombo.addItemListener(this);
        this.modify_JButton.addActionListener(this);
        this.portMapping_JButton.addActionListener(this);
        this.configOK_JButton.addActionListener(this);
        this.viewOK_JButton.addActionListener(this);
        this.configHelp_JButton.addActionListener(this);
        this.viewHelp_JButton.addActionListener(this);
    }

    public PortConfig_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public PortConfig_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.configOK_JButton || object == this.viewOK_JButton) {
            this.clickOK();
        } else if (object == this.configHelp_JButton || object == this.viewHelp_JButton) {
            this.clickHelp();
        } else if (object == this.modify_JButton) {
            this.clickModify();
        } else if (object == this.portMapping_JButton) {
            this.clickPortMapping();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"portwin");
    }

    void clickModify() {
        int[] nArray = this.configTable.getSelectedRows();
        try {
            Vector<CommonSwitch> vector = new Vector<CommonSwitch>();
            Vector<Object> vector2 = new Vector<Object>();
            int n = 0;
            while (n < nArray.length) {
                vector.addElement(this.switches[this.switchIndex]);
                vector2.addElement(this.portConfigTableModel.getValueAt(nArray[n], 0));
                ++n;
            }
            PortConfigGroup_JDialog portConfigGroup_JDialog = new PortConfigGroup_JDialog(this.theApplet, this, vector, vector2);
            ModalDialog.show((RootPaneContainer)this, (Dialog)portConfigGroup_JDialog, null);
        }
        catch (Exception exception) {}
    }

    void clickOK() {
        this.dispose();
    }

    private void clickPortMapping() {
        int[] nArray = this.configTable.getSelectedRows();
        try {
            PortMappingBasic_JDialog portMappingBasic_JDialog = new PortMappingBasic_JDialog(this.theApplet, this.switches, this, nArray);
            ModalDialog.show((RootPaneContainer)this, (Dialog)portMappingBasic_JDialog, null);
        }
        catch (Exception exception) {}
    }

    private void createConfigurationTables(CommonSwitch[] commonSwitchArray, String string) {
        this.configTable = new JTable();
        this.actualTable = new JTable();
        this.portConfigTableModel = new PortConfigTableModel(this, commonSwitchArray, string);
        this.configTable.setAutoCreateColumnsFromModel(false);
        this.actualTable.setAutoCreateColumnsFromModel(false);
        this.configTable.setModel(this.portConfigTableModel);
        ListSelectionModel listSelectionModel = this.configTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.actualTable.setModel(this.portConfigTableModel);
        this.configTable.addColumn(new TableColumn(0));
        this.configTable.addColumn(new TableColumn(8));
        this.configTable.addColumn(new TableColumn(1));
        if (commonSwitchArray[this.switchIndex].supportVDSL()) {
            this.configTable.addColumn(new TableColumn(15));
            this.configTable.addColumn(new TableColumn(16));
        }
        this.configTable.addColumn(new TableColumn(3));
        this.configTable.addColumn(new TableColumn(5));
        this.configTable.addColumn(new TableColumn(7));
        if (commonSwitchArray[this.switchIndex].support802Dot1p()) {
            this.configTable.addColumn(new TableColumn(10));
        }
        if (commonSwitchArray[this.switchIndex].supportFlowControl()) {
            this.configTable.addColumn(new TableColumn(9));
        }
        if (commonSwitchArray[this.switchIndex].supportTel()) {
            this.configTable.addColumn(new TableColumn(11));
        }
        this.actualTable.addColumn(new TableColumn(0));
        this.actualTable.addColumn(new TableColumn(8));
        if (commonSwitchArray[this.switchIndex].supportVDSL()) {
            this.actualTable.addColumn(new TableColumn(14));
        }
        this.actualTable.addColumn(new TableColumn(2));
        this.actualTable.addColumn(new TableColumn(4));
        this.actualTable.addColumn(new TableColumn(6));
        if (commonSwitchArray[this.switchIndex].supportFlowControl()) {
            this.actualTable.addColumn(new TableColumn(17));
        }
        if (commonSwitchArray[this.switchIndex].supportTel()) {
            this.configTable.addColumn(new TableColumn(12));
        }
        JTableHeader jTableHeader = this.configTable.getTableHeader();
        jTableHeader.addMouseListener(new ColumnListener(this.configTable));
        jTableHeader = this.actualTable.getTableHeader();
        jTableHeader.addMouseListener(new ColumnListener(this.actualTable));
    }

    private Component createStatusPanel(CommonSwitch[] commonSwitchArray, String string) {
        this.resetButtonsStates();
        this.tabPane = new JTabbedPane();
        this.createConfigurationTables(commonSwitchArray, string);
        this.tabPane.addTab(CONFIG_STATUS_TAB, new JScrollPane(this.configTable));
        this.tabPane.addTab(ACTUAL_STATUS_TAB, new JScrollPane(this.actualTable));
        this.tabPane.addChangeListener(this);
        return this.tabPane;
    }

    public JTable getPortConfigTable() {
        return this.configTable;
    }

    public PortConfigTableModel getPortConfigTableModel() {
        return this.portConfigTableModel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.devices_JCombo) {
            JComboBox jComboBox = (JComboBox)object;
            String string = (String)jComboBox.getSelectedItem();
            int n = 0;
            int n2 = 0;
            while (n2 < this.switches.length) {
                if (this.switches[n2].switchName.equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == this.switchIndex) {
                return;
            }
            if (this.switches[n].statusCode.equals("Down")) {
                JOptionPane.showMessageDialog(this, "The selected switch is down.", "Port Configuration", 0);
                this.devices_JCombo.setSelectedItem(this.switches[this.switchIndex].switchName);
                return;
            }
            this.switchIndex = n;
            this.theSwitch = this.switches[this.switchIndex];
            this.getContentPane().remove(this.statusPanel);
            this.statusPanel = this.createStatusPanel(this.switches, string);
            this.getContentPane().add(this.statusPanel);
            this.validate();
            this.updateActionButtonsStates();
            this.switchButtonsPane();
            return;
        }
    }

    private void resetButtonsStates() {
        this.isActionTab = true;
        this.isRowSelected = false;
    }

    public void setCursor(Cursor cursor) {
        if (!this.isBlocked) {
            super.setCursor(cursor);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setDefaultCursor() {
        this.isBlocked = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PortConfig_JDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void setWaitingCursor() {
        this.isBlocked = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PortConfig_JDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
        this.isActionTab = n != 1;
        this.switchButtonsPane();
        this.updateActionButtonsStates();
    }

    private void switchButtonsPane() {
        if (this.isActionTab && this.currentButtonsPane == this.viewOnlyButtonsPane) {
            this.getContentPane().remove(this.currentButtonsPane);
            this.currentButtonsPane = this.configButtonsPane;
            this.getContentPane().add((Component)this.currentButtonsPane, "South");
            this.repaint();
        } else if (!this.isActionTab && this.currentButtonsPane == this.configButtonsPane) {
            this.getContentPane().remove(this.currentButtonsPane);
            this.currentButtonsPane = this.viewOnlyButtonsPane;
            this.getContentPane().add((Component)this.currentButtonsPane, "South");
            this.repaint();
        }
    }

    private void updateActionButtonsStates() {
        this.modify_JButton.setEnabled(this.isRowSelected && this.isActionTab);
        this.portMapping_JButton.setEnabled(this.isRowSelected && this.isActionTab);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.isRowSelected = this.configTable.getSelectedRowCount() > 0;
        this.updateActionButtonsStates();
    }

    class ColumnListener
    extends MouseAdapter {
        private JTable l_table;

        public ColumnListener(JTable jTable) {
            this.l_table = jTable;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            TableColumnModel tableColumnModel = this.l_table.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 < 0) {
                return;
            }
            if (n2 == PortConfig_JDialog.this.sortingModelIndex) {
                PortConfig_JDialog.this.isAsc ^= true;
            } else {
                PortConfig_JDialog.this.sortingModelIndex = n2;
                PortConfig_JDialog.this.isAsc = true;
            }
            PortConfig_JDialog.this.portConfigTableModel.sortByModelIndex(n2, PortConfig_JDialog.this.isAsc);
        }
    }
}

