/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiCastModifyDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private String vlan = null;
    private String macaddr = null;
    private JApplet theApplet = null;
    private DefaultListModel availablePortsModel = new DefaultListModel();
    private DefaultListModel currentPortsModel = new DefaultListModel();
    private MultiCastModel multicastModel = null;
    private String[] allPorts = null;
    private String[] originalMultiCastPorts = new String[0];
    private JList availablePortsList = null;
    private JList currentPortsList = null;
    JTextField newVlanTextField = null;
    JTextField macaddrTextField = null;
    boolean create = false;
    JButton addButton;
    JButton removeButton;
    Icon addIcon;
    Icon removeIcon;
    JButton okButton;
    JButton applyButton;
    JButton cancelButton;
    JButton helpButton;

    public MultiCastModifyDialog(Frame frame, JApplet jApplet, String string, String string2, MultiCastModel multiCastModel) {
        super(frame);
        Object object;
        Object object2;
        this.theApplet = jApplet;
        this.vlan = string;
        this.macaddr = string2;
        this.allPorts = multiCastModel.getAllPorts();
        this.multicastModel = multiCastModel;
        boolean bl = this.create = string == null && string2 == null;
        if (!this.create) {
            int n = 0;
            while (n < multiCastModel.getRowCount()) {
                if (multiCastModel.getValueAt(n, 0) == string) {
                    object2 = (String)multiCastModel.getValueAt(n, 3);
                    if (object2 == null) {
                        int n2 = 0;
                        while (n2 < this.allPorts.length) {
                            this.availablePortsModel.addElement(this.allPorts[n2]);
                            ++n2;
                        }
                    } else {
                        int n3;
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
                        this.originalMultiCastPorts = new String[stringTokenizer.countTokens()];
                        int n4 = 0;
                        while (n4 < this.originalMultiCastPorts.length) {
                            object = stringTokenizer.nextToken();
                            this.originalMultiCastPorts[n4] = ((String)object).startsWith("Fa") ? "FastEthernet" + ((String)object).substring(2) : (((String)object).startsWith("Gi") ? "GigabitEthernet" + ((String)object).substring(2) : object);
                            ++n4;
                        }
                        int n5 = 0;
                        while (n5 < this.allPorts.length) {
                            n3 = 0;
                            int n6 = 0;
                            while (n3 == 0 && n6 < this.originalMultiCastPorts.length) {
                                if (this.originalMultiCastPorts[n6].equals(this.allPorts[n5])) {
                                    n3 = 1;
                                }
                                ++n6;
                            }
                            if (n3 == 0) {
                                this.availablePortsModel.addElement(this.allPorts[n5]);
                            }
                            ++n5;
                        }
                        n3 = 0;
                        while (n3 < this.originalMultiCastPorts.length) {
                            this.currentPortsModel.addElement(this.originalMultiCastPorts[n3]);
                            ++n3;
                        }
                    }
                    break;
                }
                ++n;
            }
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MultiCastModifyDialog.this.dispose();
            }
        });
        this.setTitle("Modify Multicast Groups" + (string == null ? "" : " for VLAN " + string));
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setSize(420, 305);
        ((Component)this).setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (string == null && string2 == null) {
            object2 = new JPanel(new GridLayout(2, 2));
            ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(""));
            this.newVlanTextField = new JTextField();
            int n = 0;
            while (n < this.allPorts.length) {
                this.availablePortsModel.addElement(this.allPorts[n]);
                ++n;
            }
            ((Container)object2).add(new JLabel("VLAN"));
            ((Container)object2).add(this.newVlanTextField);
            ((Container)object2).add(new JLabel("Group Mac Address"));
            this.macaddrTextField = new JTextField();
            ((Container)object2).add(this.macaddrTextField);
            this.getContentPane().add((Component)object2, this.setGridBagConstraints(gridBagConstraints, 0, 0, 0.1, 0.0, 2, 0, 0, 10, 0, 0, 0, 0, 1, 3));
        }
        object2 = new JPanel(new BorderLayout(0, 0));
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder("Available Ports"));
        this.availablePortsList = new JList(this.availablePortsModel);
        ((Container)object2).add((Component)new JScrollPane(this.availablePortsList), "Center");
        this.availablePortsList.addListSelectionListener(this);
        this.getContentPane().add((Component)object2, this.setGridBagConstraints(gridBagConstraints, 0, 1, 0.1, 0.1, 1, 0, 0, 17, 0, 0, 0, 0, 1, 1));
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.addIcon = new ImageIcon(SVGetImages.rightArrow);
        this.addButton = new JButton("Add", this.addIcon);
        this.addButton.setHorizontalTextPosition(2);
        this.addButton.setEnabled(false);
        jPanel.add(this.addButton);
        this.removeIcon = new ImageIcon(SVGetImages.leftArrow);
        this.removeButton = new JButton("Remove", this.removeIcon);
        this.removeButton.setEnabled(false);
        jPanel.add(this.removeButton);
        this.getContentPane().add((Component)jPanel, this.setGridBagConstraints(gridBagConstraints, 1, 1, 0.0, 0.0, 0, 0, 0, 10, 0, 10, 0, 10, 1, 1));
        object = new JPanel(new BorderLayout(0, 0));
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Router Ports"));
        this.currentPortsList = new JList(this.currentPortsModel);
        this.currentPortsList.addListSelectionListener(this);
        ((Container)object).add((Component)new JScrollPane(this.currentPortsList), "Center");
        this.getContentPane().add((Component)object, this.setGridBagConstraints(gridBagConstraints, 2, 1, 0.1, 0.1, 1, 0, 0, 13, 0, 0, 0, 0, 1, 1));
        JPanel jPanel2 = new JPanel();
        this.okButton = new JButton("OK");
        jPanel2.add(this.okButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(false);
        jPanel2.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        jPanel2.add(this.cancelButton);
        this.helpButton = new JButton("Help");
        jPanel2.add(this.helpButton);
        this.getContentPane().add((Component)jPanel2, this.setGridBagConstraints(gridBagConstraints, 0, 2, 0.1, 0.0, 2, 0, 0, 17, 0, 0, 0, 0, 1, 3));
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.helpButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            if (this.availablePortsList.getMaxSelectionIndex() < 0) {
                JOptionPane.showMessageDialog(this, "Please select a Port to add.", "Error", 0);
            } else {
                int[] nArray = this.availablePortsList.getSelectedIndices();
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n] - n;
                    this.currentPortsModel.addElement(this.availablePortsModel.get(n2));
                    this.availablePortsModel.remove(n2);
                    ++n;
                }
                this.addButton.setEnabled(false);
                if (this.create) {
                    boolean bl = this.currentPortsModel.isEmpty();
                    this.applyButton.setEnabled(bl ^ true);
                } else {
                    this.applyButton.setEnabled(true);
                }
            }
        } else if (object == this.removeButton) {
            if (this.currentPortsList.getMaxSelectionIndex() < 0) {
                JOptionPane.showMessageDialog(this, "Please select a Port to remove.", "Error", 0);
            } else {
                int[] nArray = this.currentPortsList.getSelectedIndices();
                int n = 0;
                while (n < nArray.length) {
                    int n3 = nArray[n] - n;
                    this.availablePortsModel.addElement(this.currentPortsModel.get(n3));
                    this.currentPortsModel.remove(n3);
                    ++n;
                }
                this.removeButton.setEnabled(false);
                if (this.create) {
                    boolean bl = this.currentPortsModel.isEmpty();
                    this.applyButton.setEnabled(bl ^ true);
                } else {
                    this.applyButton.setEnabled(true);
                }
            }
        } else if (object == this.applyButton) {
            if (this.apply()) {
                if (this.create) {
                    this.create = false;
                    this.newVlanTextField.setEditable(false);
                    this.macaddrTextField.setEditable(false);
                }
                this.applyButton.setEnabled(false);
                this.multicastModel.refresh();
                this.getMultiCastPortsInfo();
                ((Component)this).setCursor(new Cursor(0));
            }
        } else if (object == this.okButton) {
            if (this.applyButton.isEnabled()) {
                if (this.apply()) {
                    this.dispose();
                    this.multicastModel.refresh();
                }
            } else {
                this.dispose();
            }
            ((Component)this).setCursor(new Cursor(0));
        } else if (object == this.cancelButton) {
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else if (object == this.helpButton) {
            if (!this.create) {
                HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"igmpmgrp");
            } else {
                HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"igmpngrp");
            }
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private boolean apply() {
        int n;
        int n2;
        boolean bl = true;
        if (this.create) {
            this.vlan = this.newVlanTextField.getText();
            n2 = -1;
            try {
                n2 = Integer.parseInt(this.vlan);
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.vlan.equals("") || n2 == -1) {
                JOptionPane.showMessageDialog(null, "Enter a VLAN ID( 1 to 64)", "Error in vlan", 0);
                this.newVlanTextField.requestFocus();
                return false;
            }
            if (!this.macaddrTextField.getText().startsWith("0100.5e")) {
                JOptionPane.showMessageDialog(null, "Enter valid group Mac address(0100.5exx.xxxx)", "Error in Mac Address", 0);
                this.macaddrTextField.requestFocus();
                return false;
            }
            this.macaddr = this.macaddrTextField.getText();
        }
        n2 = 0;
        while (n2 < this.currentPortsModel.size()) {
            String string = (String)this.currentPortsModel.getElementAt(n2);
            boolean bl2 = false;
            n = 0;
            while (!bl2 && n < this.originalMultiCastPorts.length) {
                if (this.originalMultiCastPorts[n].startsWith(string)) {
                    bl2 = true;
                }
                ++n;
            }
            if (!bl2) {
                bl = bl && this.multicastModel.addMulticastPort(this.vlan, this.macaddr, string);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.originalMultiCastPorts.length) {
            String string = this.originalMultiCastPorts[n3];
            n = 0;
            int n4 = 0;
            while (n == 0 && n4 < this.currentPortsModel.size()) {
                if (string.startsWith((String)this.currentPortsModel.getElementAt(n4))) {
                    n = 1;
                }
                ++n4;
            }
            if (n == 0) {
                bl = bl && this.multicastModel.deleteMulticastPort(this.vlan, this.macaddr, string);
            }
            ++n3;
        }
        return bl;
    }

    protected void getMultiCastPortsInfo() {
        int n;
        this.availablePortsModel.removeAllElements();
        this.currentPortsModel.removeAllElements();
        String[] stringArray = this.multicastModel.getMulticastData(this.vlan, this.macaddr);
        if (stringArray == null) {
            int n2 = 0;
            while (n2 < this.allPorts.length) {
                this.availablePortsModel.addElement(this.allPorts[n2]);
                ++n2;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[3], ",");
        this.originalMultiCastPorts = new String[stringTokenizer.countTokens()];
        int n3 = 0;
        while (n3 < this.originalMultiCastPorts.length) {
            String string = stringTokenizer.nextToken();
            this.originalMultiCastPorts[n3] = string.startsWith("Fa") ? "FastEthernet" + string.substring(2) : (string.startsWith("Gi") ? "GigabitEthernet" + string.substring(2) : string);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.allPorts.length) {
            n = 0;
            int n5 = 0;
            while (n == 0 && n5 < this.originalMultiCastPorts.length) {
                if (this.originalMultiCastPorts[n5].equals(this.allPorts[n4])) {
                    n = 1;
                }
                ++n5;
            }
            if (n == 0) {
                this.availablePortsModel.addElement(this.allPorts[n4]);
            }
            ++n4;
        }
        n = 0;
        while (n < this.originalMultiCastPorts.length) {
            this.currentPortsModel.addElement(this.originalMultiCastPorts[n]);
            ++n;
        }
    }

    public boolean isModified() {
        return false;
    }

    protected void moveData(DefaultListModel defaultListModel, int n, DefaultListModel defaultListModel2) {
        String string = (String)defaultListModel.elementAt(n);
        int n2 = -1;
        int n3 = -1;
        int n4 = string.lastIndexOf(47);
        int n5 = string.indexOf(40);
        if (n5 == -1) {
            n5 = string.length();
        }
        String string2 = string.substring(n4 + 1, n5);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        boolean bl = false;
        int n6 = 0;
        while (!bl && n6 < defaultListModel2.size()) {
            String string3 = (String)defaultListModel2.getElementAt(n6);
            n4 = string3.lastIndexOf(47);
            n5 = string3.indexOf(40);
            if (n5 == -1) {
                n5 = string3.length();
            }
            string2 = string3.substring(n4 + 1, n5);
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n2 < n3) {
                defaultListModel2.insertElementAt(string, n6);
                bl = true;
            }
            ++n6;
        }
        if (!bl) {
            defaultListModel2.addElement(string);
        }
        defaultListModel.remove(n);
    }

    public GridBagConstraints setGridBagConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n3;
        gridBagConstraints.gridheight = n11;
        gridBagConstraints.gridwidth = n12;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }

    private void setVlan(String string) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JButton jButton = null;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.availablePortsList) {
            jButton = this.addButton;
        } else if (jList == this.currentPortsList) {
            jButton = this.removeButton;
        }
        if (jList.isSelectionEmpty()) {
            jButton.setEnabled(false);
        } else {
            jButton.setEnabled(true);
        }
    }
}

