/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class IpConfig
extends DeviceComboDialog {
    protected static final String illegalChars = " /\\";
    protected static final String illegalCharsDesc = "Spaces, forward-slashes, and back-slashes\n";
    protected IpConfigGui gui;
    protected boolean readOnly;

    public IpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null, false);
    }

    public IpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(jApplet, commonSwitchArray, commonSwitch, false);
    }

    public IpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch, boolean bl) {
        super(jApplet, commonSwitchArray, commonSwitch);
        this.readOnly = bl;
        this.constructorInit();
        if (bl) {
            this.makeGuiReadOnly();
        }
    }

    public IpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray, boolean bl) {
        this(jApplet, commonSwitchArray, null, bl);
    }

    protected String getButtonsNeeded() {
        String string = this.readOnly ? "OK REFRESH HELP " : "OK APPLY REFRESH CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        if (this.gui == null) {
            this.gui = new IpConfigGui();
        }
        return this.gui;
    }

    protected String getHelpUrl() {
        return "ipmgmtdg";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new Ip());
        vector.addElement(new Dns());
    }

    protected String getWindowTitle() {
        return "IP Management";
    }

    protected boolean isDeviceSupported(CommonSwitch commonSwitch) {
        return Switch.type(commonSwitch.switchBoxName) != 0;
    }

    protected void makeGuiReadOnly() {
        DeviceDialog.setContainerReadOnly(this.gui);
        this.gui.borderNewDnsPanel.setVisible(false);
        this.gui.newDnsField.setVisible(false);
        this.gui.addDnsButton.setVisible(false);
        this.gui.removeDnsButton.setVisible(false);
        this.gui.selAllBut.setVisible(false);
    }

    protected class Ip
    implements DeviceMirrorObject,
    DocumentListener {
        String[] addr;
        String[] mask;
        String[] broadcast;
        String[] gateway;
        String[] domain;

        protected Ip() {
        }

        protected void applyBroadcastAddress() {
            boolean bl = true;
            if (this.broadcast[0].equals(this.broadcast[1])) {
                return;
            }
            if (this.broadcast[1].equals("")) {
                bl = false;
                this.broadcast[1] = this.broadcast[0];
            }
            String string = IpConfig.this.device.Cli.setIpBroadcast(IpConfig.this.device.esn, bl, this.broadcast[1]);
            IpConfig.this.displayUserError(string);
            this.broadcast[0] = bl ? this.broadcast[1] : "";
        }

        protected void applyDefaultGateway() {
            boolean bl = true;
            if (this.gateway[0].equals(this.gateway[1])) {
                return;
            }
            if (this.gateway[1].equals("")) {
                bl = false;
                this.gateway[1] = this.gateway[0];
            }
            String string = IpConfig.this.device.Cli.setIpDefaultGateway(IpConfig.this.device.esn, bl, this.gateway[1]);
            IpConfig.this.displayUserError(string);
            this.gateway[0] = bl ? this.gateway[1] : "";
        }

        protected void applyDomainName() {
            boolean bl = true;
            if (this.domain[0].equals(this.domain[1])) {
                return;
            }
            if (this.domain[1].equals("")) {
                bl = false;
                this.domain[1] = this.domain[0];
            }
            String string = IpConfig.this.device.Cli.setIpDomainName(IpConfig.this.device.esn, bl, this.domain[1]);
            IpConfig.this.displayUserError(string);
            this.domain[0] = bl ? this.domain[1] : "";
        }

        protected void applyIpAddressAndNetmask() {
            boolean bl = true;
            if (this.addr[0].equals(this.addr[1]) && this.mask[0].equals(this.mask[1])) {
                return;
            }
            if (this.addr[1].equals("")) {
                bl = false;
                this.addr[1] = this.addr[0];
                this.mask[1] = this.mask[0];
            }
            String string = IpConfig.this.device.Cli.setIpAddressAndNetmask(IpConfig.this.device.esn, bl, this.addr[1], this.mask[1]);
            IpConfig.this.displayUserError(string);
            if (bl) {
                this.addr[0] = this.addr[1];
                this.mask[0] = this.mask[1];
            } else {
                this.addr[0] = "";
                this.mask[0] = "";
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void hookupListeners() {
            if (IpConfig.this.readOnly) {
                return;
            }
            IpConfig.this.gui.addrField.getDocument().addDocumentListener(this);
            IpConfig.this.gui.maskField.getDocument().addDocumentListener(this);
            IpConfig.this.gui.broadcastField.getDocument().addDocumentListener(this);
            IpConfig.this.gui.gatewayField.getDocument().addDocumentListener(this);
            IpConfig.this.gui.domainField.getDocument().addDocumentListener(this);
        }

        public void initializeMembers() {
            this.addr = new String[2];
            this.mask = new String[2];
            this.broadcast = new String[2];
            this.gateway = new String[2];
            this.domain = new String[2];
            IllegalCharsDocument.setIllegalCharsFor((JTextComponent)IpConfig.this.gui.domainField, (String)IpConfig.illegalChars, (String)IpConfig.illegalCharsDesc);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            IpConfig.this.uiChanged = true;
            IpConfig.this.updateBottomButtons();
        }

        public void updateDeviceFromMirror() {
            this.applyIpAddressAndNetmask();
            this.applyBroadcastAddress();
            this.applyDefaultGateway();
            this.applyDomainName();
        }

        public void updateGuiFromMirror() {
            IpConfig.this.gui.addrField.setText(this.addr[0]);
            IpConfig.this.gui.maskField.setText(this.mask[0]);
            IpConfig.this.gui.broadcastField.setText(this.broadcast[0]);
            IpConfig.this.gui.gatewayField.setText(this.gateway[0]);
            IpConfig.this.gui.domainField.setText(this.domain[0]);
        }

        public void updateMirrorFromDevice() {
            this.addr[0] = IpConfig.this.device.Cli.getIpAddress(IpConfig.this.device.esn);
            this.mask[0] = IpConfig.this.device.Cli.getIpNetmask(IpConfig.this.device.esn);
            this.broadcast[0] = IpConfig.this.device.Cli.getIpBroadcast(IpConfig.this.device.esn);
            this.gateway[0] = IpConfig.this.device.Cli.getIpDefaultGateway(IpConfig.this.device.esn);
            this.domain[0] = IpConfig.this.device.Cli.getIpDomainName(IpConfig.this.device.esn);
        }

        public void updateMirrorFromGui() {
            this.addr[1] = IpConfig.this.gui.addrField.getText().trim();
            this.mask[1] = IpConfig.this.gui.maskField.getText().trim();
            this.broadcast[1] = IpConfig.this.gui.broadcastField.getText().trim();
            this.gateway[1] = IpConfig.this.gui.gatewayField.getText().trim();
            this.domain[1] = IpConfig.this.gui.domainField.getText().trim();
        }
    }

    protected class Dns
    implements DeviceMirrorObject,
    ActionListener,
    DocumentListener,
    ListSelectionListener {
        public final int MAX_DNS_SERVERS = 6;
        Vector[] dnsList;
        protected DefaultListModel currDnsListModel;

        protected Dns() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == IpConfig.this.gui.newDnsField) {
                this.addDnsButton_Action();
            } else if (object == IpConfig.this.gui.addDnsButton) {
                this.addDnsButton_Action();
            } else if (object == IpConfig.this.gui.removeDnsButton) {
                IpConfig.this.removeFromList(IpConfig.this.gui.currDnsList, IpConfig.this.gui.removeDnsButton, IpConfig.this.gui.selAllBut);
            } else if (object == IpConfig.this.gui.selAllBut) {
                this.selAllBut_Action();
            }
        }

        protected void addDnsButton_Action() {
            IpConfig.this.gui.newDnsField.selectAll();
            IpConfig.this.gui.newDnsField.requestFocus();
            String string = IpConfig.this.gui.newDnsField.getText().trim();
            if (!IpAddress.isFormatValid(string)) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(IpConfig.this, "Invalid IP address for new server.", "Error", 0);
                return;
            }
            if (this.currDnsListModel.contains(string)) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(IpConfig.this, "The server already exists.", "Error", 0);
                return;
            }
            if (this.currDnsListModel.size() >= 6) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(IpConfig.this, "Cannot add more than 6 servers.", "Error", 0);
                return;
            }
            this.currDnsListModel.addElement(string);
            IpConfig.this.gui.selAllBut.setEnabled(this.currDnsListModel.isEmpty() ^ true);
            IpConfig.this.uiChanged = true;
            IpConfig.this.updateBottomButtons();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void hookupListeners() {
            if (IpConfig.this.readOnly) {
                return;
            }
            IpConfig.this.gui.addDnsButton.addActionListener(this);
            IpConfig.this.gui.removeDnsButton.addActionListener(this);
            IpConfig.this.gui.selAllBut.addActionListener(this);
            IpConfig.this.gui.newDnsField.addActionListener(this);
            IpConfig.this.gui.newDnsField.getDocument().addDocumentListener(this);
            IpConfig.this.gui.currDnsList.addListSelectionListener(this);
        }

        public void initializeMembers() {
            this.dnsList = new Vector[2];
            this.dnsList[0] = new Vector();
            this.dnsList[1] = new Vector();
            this.currDnsListModel = new DefaultListModel();
            IpConfig.this.gui.currDnsList.setModel(this.currDnsListModel);
            IpConfig.this.gui.borderNewDnsPanel.setBorder(BorderFactory.createTitledBorder("New Server"));
            IpConfig.this.gui.borderCurrDnsPanel.setBorder(BorderFactory.createTitledBorder("Current Servers"));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void selAllBut_Action() {
            IpConfig.this.gui.currDnsList.setSelectionInterval(0, this.currDnsListModel.size() - 1);
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            String string = IpConfig.this.gui.newDnsField.getText().trim();
            IpConfig.this.gui.addDnsButton.setEnabled(string.equals("") ^ true);
            IpConfig.this.uiChanged = true;
            IpConfig.this.updateBottomButtons();
        }

        public void updateDeviceFromMirror() {
            String string;
            String string2;
            int n = 0;
            int n2 = this.dnsList[0].size();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 - n;
                string2 = (String)this.dnsList[0].elementAt(n4);
                if (!this.dnsList[1].contains(string2)) {
                    string = IpConfig.this.device.Cli.setIpNameServer(IpConfig.this.device.esn, false, string2);
                    IpConfig.this.displayUserError(string);
                    this.dnsList[0].removeElementAt(n4);
                    ++n;
                    IpConfig.this.uiNeedsRefresh = true;
                }
                ++n3;
            }
            n2 = this.dnsList[1].size();
            int n5 = 0;
            while (n5 < n2) {
                string2 = (String)this.dnsList[1].elementAt(n5);
                if (!this.dnsList[0].contains(string2)) {
                    string = IpConfig.this.device.Cli.setIpNameServer(IpConfig.this.device.esn, true, string2);
                    IpConfig.this.displayUserError(string);
                    this.dnsList[0].addElement(string2);
                    IpConfig.this.uiNeedsRefresh = true;
                }
                ++n5;
            }
        }

        public void updateGuiFromMirror() {
            this.currDnsListModel.clear();
            int n = 0;
            while (n < this.dnsList[0].size()) {
                this.currDnsListModel.addElement(this.dnsList[0].elementAt(n));
                ++n;
            }
            if (!IpConfig.this.readOnly) {
                IpConfig.this.gui.selAllBut.setEnabled(this.currDnsListModel.isEmpty() ^ true);
            }
        }

        public void updateMirrorFromDevice() {
            String[] stringArray = IpConfig.this.device.Cli.getIpNameServers(IpConfig.this.device.esn);
            this.dnsList[0].removeAllElements();
            int n = 0;
            while (n < stringArray.length) {
                this.dnsList[0].addElement(stringArray[n]);
                ++n;
            }
        }

        public void updateMirrorFromGui() {
            this.dnsList[1].removeAllElements();
            int n = 0;
            while (n < this.currDnsListModel.size()) {
                this.dnsList[1].addElement(this.currDnsListModel.elementAt(n));
                ++n;
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            IpConfig.this.gui.removeDnsButton.setEnabled(IpConfig.this.gui.currDnsList.isSelectionEmpty() ^ true);
        }
    }
}

