/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IGMPSettingsPanel
extends JPanel
implements ItemListener {
    private CommonSwitch theSwitch = null;
    private IGMPSettingsModel igmpSettingsModel = null;
    private JTable settingsTable = null;
    private TabbedPaneListener tbdListener = null;
    private JCheckBox globalIGMPSettingsCheckBox = new JCheckBox("Enable IGMP Snooping", false);
    private JApplet theApplet = null;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public IGMPSettingsPanel(JApplet jApplet, CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.theApplet = jApplet;
        this.igmpSettingsModel = new IGMPSettingsModel();
        this.igmpSettingsModel.setSwitch(commonSwitch);
        this.settingsTable = new JTable(this.igmpSettingsModel);
        this.globalIGMPSettingsCheckBox.setSelected(this.igmpSettingsModel.isIGMPSnoopingEnabled());
        this.settingsTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.settingsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.getMinSelectionIndex() >= 0 && IGMPSettingsPanel.this.tbdListener != null) {
                    IGMPSettingsPanel.this.tbdListener.readyForChanges();
                }
                if (IGMPSettingsPanel.this.getParent() != null) {
                    IGMPSnoopDialog iGMPSnoopDialog = (IGMPSnoopDialog)IGMPSettingsPanel.this.getParent().getParent().getParent().getParent().getParent().getParent();
                    if (IGMPSettingsPanel.this.settingsTable.getSelectedRowCount() > 0) {
                        iGMPSnoopDialog.modifyButton.setEnabled(true);
                    } else {
                        iGMPSnoopDialog.modifyButton.setEnabled(false);
                    }
                }
            }
        });
        if (this.settingsTable.getRowCount() > 0) {
            this.settingsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.settingsTable.clearSelection();
        this.globalIGMPSettingsCheckBox.addItemListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.settingsTable), "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.globalIGMPSettingsCheckBox);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new BorderLayout());
        this.add("Center", jPanel);
        this.add("North", jPanel2);
    }

    public void addTabbedPaneListener(TabbedPaneListener tabbedPaneListener) {
        this.tbdListener = tabbedPaneListener;
    }

    public boolean applyChanges() {
        IGMPSettingsModifyDialog iGMPSettingsModifyDialog = new IGMPSettingsModifyDialog(this.theApplet, this.getParentDialog(), this.settingsTable.getSelectedRow(), this.igmpSettingsModel);
        IGMPSnoopDialog iGMPSnoopDialog = null;
        if (this.getParent() != null) {
            iGMPSnoopDialog = (IGMPSnoopDialog)this.getParent().getParent().getParent().getParent().getParent().getParent();
        }
        ModalDialog.show(iGMPSnoopDialog, (Dialog)iGMPSettingsModifyDialog, null);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean getModifyButtonStatus() {
        return this.settingsTable.getSelectedRowCount() > 0;
    }

    JDialog getParentDialog() {
        Container container = this.getParent();
        while (container != null && container.getClass() != (class$javax$swing$JDialog != null ? class$javax$swing$JDialog : IGMPSettingsPanel.class$("javax.swing.JDialog"))) {
            container = container.getParent();
        }
        return (JDialog)container;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.globalIGMPSettingsCheckBox) {
            this.igmpSettingsModel.setIGMPSnoopingGlobally(itemEvent.getStateChange() == 1);
            this.igmpSettingsModel.refresh();
        }
    }

    public void setSwitch(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.igmpSettingsModel.setSwitch(commonSwitch);
        this.igmpSettingsModel.refresh();
    }
}

