/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class FloodingConfigDialog
extends DeviceDialog {
    protected Vector devices;
    protected Vector ports;
    protected Vector mirrorPanels;
    protected boolean newCli;

    public FloodingConfigDialog(JApplet jApplet) {
        super(jApplet);
    }

    public FloodingConfigDialog(JApplet jApplet, Vector vector, Vector vector2) {
        super(jApplet);
        this.constructorCommon(vector2, vector);
        this.mirrorPanels.addElement(new Storm("", "Broadcast Storm"));
        if (this.newCli) {
            this.mirrorPanels.addElement(new Storm("/unicast", "Unicast Storm"));
            this.mirrorPanels.addElement(new Storm("/multicast", "Multicast Storm"));
        }
        boolean bl = false;
        int n = 0;
        while (n < vector2.size()) {
            CommonSwitch commonSwitch = (CommonSwitch)vector2.elementAt(n);
            if (commonSwitch.deviceType.indexOf("2950") != -1) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.mirrorPanels.addElement(new UnknownMacs());
        }
        this.constructorInit();
    }

    public void completeConstruction(Vector vector, Vector vector2, DeviceMirrorObject deviceMirrorObject) {
        this.constructorCommon(vector, vector2);
        this.mirrorPanels.addElement(deviceMirrorObject);
        this.constructorInit();
    }

    private void constructorCommon(Vector vector, Vector vector2) {
        this.devices = vector;
        this.ports = vector2;
        CommonSwitch commonSwitch = (CommonSwitch)vector.elementAt(0);
        this.newCli = commonSwitch.Cli.isUnicastStormSupported(commonSwitch.esn);
        this.mirrorPanels = new Vector(1);
    }

    protected String getButtonsNeeded() {
        String string = "OK REFRESH CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        int n = 0;
        while (n < this.mirrorPanels.size()) {
            gridBagConstraints.gridy = n;
            JPanel jPanel2 = (JPanel)this.mirrorPanels.elementAt(n);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            ++n;
        }
        return jPanel;
    }

    protected String getHelpUrl() {
        return "fldctldg";
    }

    protected void getMirrorObjects(Vector vector) {
        int n = 0;
        while (n < this.mirrorPanels.size()) {
            vector.addElement(this.mirrorPanels.elementAt(n));
            ++n;
        }
    }

    protected String getWindowTitle() {
        return "Flooding Controls Configuration";
    }

    protected class Storm
    extends JPanel
    implements DeviceMirrorObject,
    ActionListener,
    DocumentListener {
        protected String stormCli;
        protected Vector mirrorData;
        protected int[] mirrorSelection;
        protected int filterStateCol;
        protected int trapStateCol;
        protected int risingThresholdCol;
        protected int fallingThresholdCol;
        protected String mirrorStateEnable;
        protected String mirrorStateDisable;
        protected String[] filterState;
        protected String[] trapState;
        protected String[] risingThreshold;
        protected String[] fallingThreshold;
        protected JComboBox filterStateCombo;
        protected JComboBox trapStateCombo;
        protected JTextField risingField;
        protected JTextField fallingField;

        public Storm(String string, String string2) {
            this.stormCli = string;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 0.0;
            JLabel jLabel = new JLabel("Action State:");
            JLabel jLabel2 = new JLabel("Trap State:");
            JLabel jLabel3 = new JLabel("Rising Threshold (0-4294967295):");
            JLabel jLabel4 = new JLabel("Falling Threshold (0-Rising):");
            this.filterStateCombo = new JComboBox();
            this.trapStateCombo = new JComboBox();
            this.risingField = new JTextField(5);
            this.fallingField = new JTextField(5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.filterStateCombo, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.trapStateCombo, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.risingField, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)this.fallingField, gridBagConstraints);
            this.setBorder(BorderFactory.createTitledBorder(string2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FloodingConfigDialog.this.uiChanged = true;
            FloodingConfigDialog.this.updateBottomButtons();
        }

        private void addFilterStateOptions(JComboBox jComboBox) {
            if (FloodingConfigDialog.this.ports.size() != 1) {
                jComboBox.addItem(" ");
            }
            jComboBox.addItem("Disable");
            jComboBox.addItem("Filter");
            if (FloodingConfigDialog.this.newCli) {
                jComboBox.addItem("Shutdown");
            }
        }

        private void addTrapStateOptions(JComboBox jComboBox) {
            if (FloodingConfigDialog.this.ports.size() != 1) {
                jComboBox.addItem(" ");
            }
            jComboBox.addItem("Enable");
            jComboBox.addItem("Disable");
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        private void checkThresholds() {
            String string = null;
            try {
                string = "Rising threshold must be a\nnon-negative integer.";
                long l = Long.parseLong(this.risingThreshold[1]);
                if (l < 0L) {
                    throw new NumberFormatException();
                }
                string = "Falling threshold must be a\nnon-negative integer.";
                long l2 = Long.parseLong(this.fallingThreshold[1]);
                if (l2 < 0L) {
                    throw new NumberFormatException();
                }
                string = "Rising threshold cannot be less\nthan falling threshold";
                if (l < l2) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                FloodingConfigDialog.this.displayUserError(string);
            }
        }

        private String formatGuiToMirror(String string) {
            String string2 = string.equals("Enable") ? this.mirrorStateEnable : (string.equals("Disable") ? this.mirrorStateDisable : string);
            return string2;
        }

        private String formatMirrorToGui(String string) {
            String string2 = string.equals(this.mirrorStateEnable) ? "Enable" : (string.equals(this.mirrorStateDisable) ? "Disable" : string);
            return string2;
        }

        public void hookupListeners() {
            this.filterStateCombo.addActionListener(this);
            this.trapStateCombo.addActionListener(this);
            this.risingField.getDocument().addDocumentListener(this);
            this.fallingField.getDocument().addDocumentListener(this);
        }

        public void initializeMembers() {
            this.filterState = new String[2];
            this.trapState = new String[2];
            this.risingThreshold = new String[2];
            this.fallingThreshold = new String[2];
            this.addFilterStateOptions(this.filterStateCombo);
            this.addTrapStateOptions(this.trapStateCombo);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        private void setFilterStates() {
            int n = 0;
            String[] stringArray = null;
            String string = null;
            String string2 = null;
            if (this.filterState[0].equals(this.filterState[1])) {
                return;
            }
            String string3 = this.filterState[1];
            string2 = this.formatGuiToMirror(this.filterState[1]);
            if (this.mirrorData != null) {
                stringArray = (String[])this.mirrorData.elementAt(this.filterStateCol);
            }
            int n2 = 0;
            while (n2 < FloodingConfigDialog.this.ports.size()) {
                CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(n2);
                String string4 = (String)FloodingConfigDialog.this.ports.elementAt(n2);
                if (!(this.mirrorData != null ? (string = stringArray[n = this.mirrorSelection[n2]]).equals(string2) : (string = commonSwitch.Cli.getActionStates(commonSwitch.esn, this.stormCli, FloodingConfigDialog.this.newCli, string4)).equals(string3))) {
                    String string5 = commonSwitch.Cli.setStormFilter(commonSwitch.esn, this.stormCli, FloodingConfigDialog.this.newCli, string4, string3, string);
                    FloodingConfigDialog.this.displayUserError(string5);
                    if (this.mirrorData != null) {
                        stringArray[n] = string2;
                    }
                }
                ++n2;
            }
        }

        public void setMirrorCols(int n, int n2, int n3, int n4) {
            this.filterStateCol = n;
            this.trapStateCol = n2;
            this.risingThresholdCol = n3;
            this.fallingThresholdCol = n4;
        }

        public void setMirrorData(Vector vector, int[] nArray) {
            this.mirrorData = vector;
            this.mirrorSelection = nArray;
        }

        public void setMirrorVals(String string, String string2) {
            this.mirrorStateEnable = string;
            this.mirrorStateDisable = string2;
        }

        private void setThresholds() {
            String string = null;
            String string2 = null;
            int n = 0;
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (this.risingThreshold[0].equals(this.risingThreshold[1]) && this.fallingThreshold[0].equals(this.fallingThreshold[1])) {
                return;
            }
            string = this.risingThreshold[1].trim();
            string2 = this.fallingThreshold[1].trim();
            if (this.mirrorData != null) {
                stringArray = (String[])this.mirrorData.elementAt(this.risingThresholdCol);
                stringArray2 = (String[])this.mirrorData.elementAt(this.fallingThresholdCol);
            }
            int n2 = 0;
            while (n2 < FloodingConfigDialog.this.ports.size()) {
                if (this.mirrorData == null || !stringArray[n = this.mirrorSelection[n2]].equals(string) || !stringArray2[n].equals(string2)) {
                    CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(n2);
                    String string3 = (String)FloodingConfigDialog.this.ports.elementAt(n2);
                    String string4 = commonSwitch.Cli.setStormThresholds(commonSwitch.esn, this.stormCli, string3, string, string2);
                    FloodingConfigDialog.this.displayUserError(string4);
                    if (this.mirrorData != null) {
                        stringArray[n] = string;
                        stringArray2[n] = string2;
                    }
                }
                ++n2;
            }
        }

        private void setTrapStates() {
            boolean bl = false;
            String string = null;
            int n = 0;
            String[] stringArray = null;
            if (this.trapState[0].equals(this.trapState[1])) {
                return;
            }
            if (this.trapState[1].equals("Enable")) {
                bl = true;
            }
            if (this.mirrorData != null) {
                stringArray = (String[])this.mirrorData.elementAt(this.trapStateCol);
            }
            int n2 = 0;
            while (n2 < FloodingConfigDialog.this.ports.size()) {
                if (this.mirrorData == null || !stringArray[n = this.mirrorSelection[n2]].equals(string = this.formatGuiToMirror(this.trapState[1]))) {
                    CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(n2);
                    String string2 = (String)FloodingConfigDialog.this.ports.elementAt(n2);
                    String string3 = commonSwitch.Cli.setStormTrap(commonSwitch.esn, this.stormCli, string2, bl);
                    FloodingConfigDialog.this.displayUserError(string3);
                    if (this.mirrorData != null) {
                        stringArray[n] = string;
                    }
                }
                ++n2;
            }
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            FloodingConfigDialog.this.uiChanged = true;
            FloodingConfigDialog.this.updateBottomButtons();
        }

        public void updateDeviceFromMirror() {
            this.setFilterStates();
            this.setTrapStates();
            this.setThresholds();
        }

        public void updateGuiFromMirror() {
            this.filterStateCombo.setSelectedItem(this.filterState[0]);
            this.trapStateCombo.setSelectedItem(this.trapState[0]);
            this.risingField.setText(this.risingThreshold[0]);
            this.fallingField.setText(this.fallingThreshold[0]);
        }

        public void updateMirrorFromDevice() {
            if (FloodingConfigDialog.this.ports.size() != 1) {
                this.filterState[0] = " ";
                this.trapState[0] = " ";
                this.risingThreshold[0] = "";
                this.fallingThreshold[0] = "";
                return;
            }
            if (this.mirrorData == null) {
                CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(0);
                String string = (String)FloodingConfigDialog.this.ports.elementAt(0);
                String[] stringArray = commonSwitch.Cli.getStormInfo(commonSwitch.esn, this.stormCli, string, FloodingConfigDialog.this.newCli);
                this.filterState[0] = stringArray[0];
                this.trapState[0] = stringArray[1];
                this.risingThreshold[0] = stringArray[2];
                this.fallingThreshold[0] = stringArray[3];
            } else {
                int n = this.mirrorSelection[0];
                this.filterState[0] = this.formatMirrorToGui(((String[])this.mirrorData.elementAt(this.filterStateCol))[n]);
                this.trapState[0] = this.formatMirrorToGui(((String[])this.mirrorData.elementAt(this.trapStateCol))[n]);
                this.risingThreshold[0] = ((String[])this.mirrorData.elementAt(this.risingThresholdCol))[n];
                this.fallingThreshold[0] = ((String[])this.mirrorData.elementAt(this.fallingThresholdCol))[n];
            }
        }

        public void updateMirrorFromGui() {
            this.filterState[1] = (String)this.filterStateCombo.getSelectedItem();
            this.trapState[1] = (String)this.trapStateCombo.getSelectedItem();
            this.risingThreshold[1] = this.risingField.getText().trim();
            this.fallingThreshold[1] = this.fallingField.getText().trim();
            if (this.risingThreshold[1].equals(this.risingThreshold[0]) && this.fallingThreshold[1].equals(this.fallingThreshold[0])) {
                return;
            }
            this.checkThresholds();
        }
    }

    protected class UnknownMacs
    extends JPanel
    implements DeviceMirrorObject,
    ActionListener {
        protected Vector mirrorData;
        protected int[] mirrorSelection;
        protected int unicastCol;
        protected int multicastCol;
        protected String mirrorStateEnable;
        protected String mirrorStateDisable;
        protected String[] unicast;
        protected String[] multicast;
        protected JComboBox unicastCombo;
        protected JComboBox multicastCombo;

        protected UnknownMacs() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 0.0;
            JLabel jLabel = new JLabel("Unicast:");
            JLabel jLabel2 = new JLabel("Multicast:");
            this.unicastCombo = new JComboBox();
            this.multicastCombo = new JComboBox();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.unicastCombo, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.multicastCombo, gridBagConstraints);
            this.setBorder(BorderFactory.createTitledBorder("Receive Unknown MACs"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FloodingConfigDialog.this.uiChanged = true;
            FloodingConfigDialog.this.updateBottomButtons();
        }

        private void addComboBoxOptions(JComboBox jComboBox) {
            if (FloodingConfigDialog.this.ports.size() != 1) {
                jComboBox.addItem(" ");
            }
            jComboBox.addItem("Enable");
            jComboBox.addItem("Disable");
        }

        private String formatGuiToMirror(String string) {
            String string2 = string.equals("Enable") ? this.mirrorStateEnable : this.mirrorStateDisable;
            return string2;
        }

        private String formatMirrorToGui(String string) {
            String string2 = string.equals(this.mirrorStateEnable) ? "Enable" : "Disable";
            return string2;
        }

        public void hookupListeners() {
            this.unicastCombo.addActionListener(this);
            this.multicastCombo.addActionListener(this);
        }

        public void initializeMembers() {
            this.unicast = new String[2];
            this.multicast = new String[2];
            this.addComboBoxOptions(this.unicastCombo);
            this.addComboBoxOptions(this.multicastCombo);
        }

        public void setMirrorCols(int n, int n2) {
            this.unicastCol = n;
            this.multicastCol = n2;
        }

        public void setMirrorData(Vector vector, int[] nArray) {
            this.mirrorData = vector;
            this.mirrorSelection = nArray;
        }

        public void setMirrorVals(String string, String string2) {
            this.mirrorStateEnable = string;
            this.mirrorStateDisable = string2;
        }

        private void setMulticast() {
            String string = null;
            int n = 0;
            String[] stringArray = null;
            if (this.multicast[0].equals(this.multicast[1])) {
                return;
            }
            boolean bl = this.multicast[1].equals("Enable") ^ true;
            if (this.mirrorData != null) {
                stringArray = (String[])this.mirrorData.elementAt(this.multicastCol);
            }
            int n2 = 0;
            while (n2 < FloodingConfigDialog.this.ports.size()) {
                if (this.mirrorData == null || !stringArray[n = this.mirrorSelection[n2]].equals(string = this.formatGuiToMirror(this.multicast[1]))) {
                    CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(n2);
                    String string2 = (String)FloodingConfigDialog.this.ports.elementAt(n2);
                    String string3 = commonSwitch.Cli.setUnknownMacsMulticast(commonSwitch.esn, string2, bl);
                    FloodingConfigDialog.this.displayUserError(string3);
                    if (this.mirrorData != null) {
                        stringArray[n] = string;
                    }
                }
                ++n2;
            }
        }

        private void setUnicast() {
            String string = null;
            int n = 0;
            String[] stringArray = null;
            if (this.unicast[0].equals(this.unicast[1])) {
                return;
            }
            boolean bl = this.unicast[1].equals("Enable") ^ true;
            if (this.mirrorData != null) {
                stringArray = (String[])this.mirrorData.elementAt(this.unicastCol);
            }
            int n2 = 0;
            while (n2 < FloodingConfigDialog.this.ports.size()) {
                if (this.mirrorData == null || !stringArray[n = this.mirrorSelection[n2]].equals(string = this.formatGuiToMirror(this.unicast[1]))) {
                    CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(n2);
                    String string2 = (String)FloodingConfigDialog.this.ports.elementAt(n2);
                    String string3 = commonSwitch.Cli.setUnknownMacsUnicast(commonSwitch.esn, string2, bl);
                    FloodingConfigDialog.this.displayUserError(string3);
                    if (this.mirrorData != null) {
                        stringArray[n] = string;
                    }
                }
                ++n2;
            }
        }

        public void updateDeviceFromMirror() {
            this.setUnicast();
            this.setMulticast();
        }

        public void updateGuiFromMirror() {
            this.unicastCombo.setSelectedItem(this.unicast[0]);
            this.multicastCombo.setSelectedItem(this.multicast[0]);
        }

        public void updateMirrorFromDevice() {
            if (FloodingConfigDialog.this.ports.size() != 1) {
                this.unicast[0] = " ";
                this.multicast[0] = " ";
                return;
            }
            if (this.mirrorData == null) {
                CommonSwitch commonSwitch = (CommonSwitch)FloodingConfigDialog.this.devices.elementAt(0);
                String string = (String)FloodingConfigDialog.this.ports.elementAt(0);
                String[] stringArray = commonSwitch.Cli.getUnknownMacsInfo(commonSwitch.esn, string);
                this.unicast[0] = stringArray[0];
                this.multicast[0] = stringArray[1];
            } else {
                int n = this.mirrorSelection[0];
                this.unicast[0] = this.formatMirrorToGui(((String[])this.mirrorData.elementAt(this.unicastCol))[n]);
                this.multicast[0] = this.formatMirrorToGui(((String[])this.mirrorData.elementAt(this.multicastCol))[n]);
            }
        }

        public void updateMirrorFromGui() {
            this.unicast[1] = (String)this.unicastCombo.getSelectedItem();
            this.multicast[1] = (String)this.multicastCombo.getSelectedItem();
        }
    }
}

