/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DevicePosition
extends DeviceDialog {
    protected CommonSwitch[] devices;
    protected String clusterOrder;
    ClusterManager clusterManager;
    protected DevicePositionGui gui;

    public DevicePosition(JApplet jApplet, CommonSwitch[] commonSwitchArray, String string) {
        super(jApplet);
        this.clusterManager = (ClusterManager)((Object)jApplet);
        this.devices = commonSwitchArray;
        this.clusterOrder = string;
        this.constructorInit();
    }

    protected String getButtonsNeeded() {
        String string = "OK APPLY REFRESH CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        this.gui = new DevicePositionGui();
        return this.gui;
    }

    public CommonSwitch getDeviceWithVbn(int n) {
        CommonSwitch commonSwitch = null;
        int n2 = this.devices.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.devices[n3].VBN == n) {
                commonSwitch = this.devices[n3];
                break;
            }
            ++n3;
        }
        return commonSwitch;
    }

    protected String getHelpUrl() {
        return "devposdg";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new Position());
    }

    protected String getWindowTitle() {
        return "Device Position";
    }

    protected class Position
    implements DeviceMirrorObject,
    ListSelectionListener,
    ActionListener {
        protected String[] order;
        protected NonEditableTableModel tableModel;
        protected ListSelectionModel selectionModel;
        protected String[] columnNames;

        protected Position() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DevicePosition.this.gui.upButton) {
                this.moveSelectedDevices(-1);
            } else if (object == DevicePosition.this.gui.downButton) {
                this.moveSelectedDevices(1);
            }
            DevicePosition.this.uiChanged = true;
            DevicePosition.this.updateBottomButtons();
        }

        public void hookupListeners() {
            this.selectionModel.addListSelectionListener(this);
            DevicePosition.this.gui.upButton.addActionListener(this);
            DevicePosition.this.gui.downButton.addActionListener(this);
        }

        public void initializeMembers() {
            this.order = new String[2];
            this.tableModel = new NonEditableTableModel();
            DevicePosition.this.gui.positionTable.setModel(this.tableModel);
            this.selectionModel = DevicePosition.this.gui.positionTable.getSelectionModel();
            this.columnNames = new String[]{"Host Name", "Device Type"};
            this.tableModel.setColumnIdentifiers(this.columnNames);
            DevicePosition.this.setTableColumnTitleToolTips(DevicePosition.this.gui.positionTable);
            DevicePosition.this.gui.positionTable.setSelectionMode(1);
        }

        protected void moveSelectedDevices(int n) {
            int n2 = this.selectionModel.getMinSelectionIndex();
            int n3 = this.selectionModel.getMaxSelectionIndex();
            if (n <= 0) {
                int n4 = n2 + n;
                int n5 = n2;
                while (n5 <= n3) {
                    this.tableModel.moveRow(n5, n5, n4);
                    ++n4;
                    ++n5;
                }
            } else {
                int n6 = n3 + n;
                int n7 = n3;
                while (n7 >= n2) {
                    this.tableModel.moveRow(n7, n7, n6);
                    --n6;
                    --n7;
                }
            }
            this.selectionModel.setSelectionInterval(n2 + n, n3 + n);
        }

        public void updateDeviceFromMirror() {
            if (this.order[0].equals(this.order[1])) {
                return;
            }
            CommandCLIs commandCLIs = DevicePosition.this.clusterManager.svCliInit.commandCLIs;
            String string = commandCLIs.setClusterOrder(this.order[1]);
            DevicePosition.this.displayUserError(string);
            this.order[0] = this.order[1];
        }

        public void updateGuiFromMirror() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.order[0], ",");
            int n = stringTokenizer.countTokens();
            this.tableModel.setNumRows(n);
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    int n3;
                    try {
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Error parsing VBN order: " + numberFormatException);
                        break block5;
                    }
                    CommonSwitch commonSwitch = DevicePosition.this.getDeviceWithVbn(n3);
                    if (commonSwitch == null) {
                        System.out.println("getDeviceWithVbn() returned null for " + n3);
                    } else {
                        DeviceListItem deviceListItem = new DeviceListItem(commonSwitch);
                        this.tableModel.setValueAt(deviceListItem, n2, 0);
                        this.tableModel.setValueAt(commonSwitch.switchBoxName, n2, 1);
                    }
                }
                ++n2;
            }
            DevicePosition.this.gui.positionTable.repaint();
            this.updateUpDownButtons();
        }

        public void updateMirrorFromDevice() {
            this.order[0] = DevicePosition.this.clusterOrder;
        }

        public void updateMirrorFromGui() {
            this.order[1] = "";
            int n = 0;
            while (n < this.tableModel.getRowCount()) {
                DeviceListItem deviceListItem = (DeviceListItem)this.tableModel.getValueAt(n, 0);
                CommonSwitch commonSwitch = deviceListItem.device;
                this.order[1] = String.valueOf(this.order[1]) + commonSwitch.VBN + ",";
                ++n;
            }
            DevicePosition.this.clusterManager.ClusterOrder = this.order[1];
            DevicePosition.this.clusterManager.arrangeClusterMembers();
        }

        protected void updateUpDownButtons() {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            boolean bl = n > 0;
            boolean bl2 = n2 >= 0 && n2 < this.tableModel.getRowCount() - 1;
            DevicePosition.this.gui.upButton.setEnabled(bl);
            DevicePosition.this.gui.downButton.setEnabled(bl2);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.updateUpDownButtons();
        }
    }
}

