/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CoSPanel
extends JPanel
implements ActionListener,
ItemListener {
    private CommonSwitch theSwitch;
    private CoSModel cosModel = null;
    private boolean dataChanged;
    JLabel[] cosLabels = new JLabel[]{new JLabel("0"), new JLabel("1"), new JLabel("2"), new JLabel("3"), new JLabel("4"), new JLabel("5"), new JLabel("6"), new JLabel("7")};
    String[] quids = new String[]{"1", "2", "3", "4"};
    JComboBox[] qidCombos = new JComboBox[]{new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids), new JComboBox<String>(this.quids)};
    JButton setDefaultButton = new JButton("Default");
    TabbedPaneListener tbdListener = null;
    boolean defaultButtonClicked = false;

    public CoSPanel(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.cosModel = new CoSModel();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(6, 6, 3, 6);
        jPanel.add(new JLabel("CoS"), gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(6, 18, 3, 6);
        int n = 0;
        n = 0;
        while (n < this.cosLabels.length - 1) {
            this.cosLabels[n].setHorizontalAlignment(0);
            jPanel.add(this.cosLabels[n], gridBagConstraints, -1);
            ++n;
        }
        gridBagConstraints.gridwidth = 0;
        jPanel.add(this.cosLabels[n], gridBagConstraints, -1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(6, 6, 3, 6);
        jPanel.add(new JLabel("Queue (1-4)"), gridBagConstraints, -1);
        n = 0;
        while (n < this.qidCombos.length) {
            jPanel.add(this.qidCombos[n], gridBagConstraints, -1);
            this.qidCombos[n].addItemListener(this);
            ++n;
        }
        this.fillData();
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.setDefaultButton);
        this.add((Component)jPanel2, "South");
        this.setDefaultButton.addActionListener(this);
        this.dataChanged(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.setDefaultButton) {
            this.qidCombos[0].setSelectedIndex(0);
            this.qidCombos[1].setSelectedIndex(0);
            this.qidCombos[2].setSelectedIndex(1);
            this.qidCombos[3].setSelectedIndex(1);
            this.qidCombos[4].setSelectedIndex(2);
            this.qidCombos[5].setSelectedIndex(2);
            this.qidCombos[6].setSelectedIndex(3);
            this.qidCombos[7].setSelectedIndex(3);
            this.defaultButtonClicked = true;
            this.dataChanged(true);
        }
    }

    public void addTabbedPaneListener(TabbedPaneListener tabbedPaneListener) {
        this.tbdListener = tabbedPaneListener;
    }

    public boolean applyChanges() {
        if (!this.dataChanged()) {
            return true;
        }
        if (this.validateData()) {
            if (this.defaultButtonClicked) {
                if (this.cosModel.setDefaultCoSQueues()) {
                    this.dataChanged(false);
                    return true;
                }
            } else if (this.cosModel.setCoSQueues(new String[]{(String)this.qidCombos[0].getSelectedItem(), (String)this.qidCombos[1].getSelectedItem(), (String)this.qidCombos[2].getSelectedItem(), (String)this.qidCombos[3].getSelectedItem(), (String)this.qidCombos[4].getSelectedItem(), (String)this.qidCombos[5].getSelectedItem(), (String)this.qidCombos[6].getSelectedItem(), (String)this.qidCombos[7].getSelectedItem()})) {
                this.dataChanged(false);
                return true;
            }
        }
        return false;
    }

    private boolean dataChanged() {
        return this.dataChanged;
    }

    private void dataChanged(boolean bl) {
        this.dataChanged = bl;
        if (this.dataChanged && this.tbdListener != null) {
            this.tbdListener.dataChanged();
        }
    }

    private void fillData() {
        String[][] stringArray = this.cosModel.getCoSQueues();
        int n = 0;
        while (n < this.qidCombos.length) {
            this.qidCombos[n].setSelectedItem(stringArray[1][n]);
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.defaultButtonClicked = false;
        this.dataChanged(true);
    }

    public void setSwitch(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.fillData();
    }

    public boolean validateData() {
        return true;
    }

    private class CoSModel {
        CoSModel() {
        }

        public String[][] getCoSQueues() {
            return ((CoSPanel)CoSPanel.this).theSwitch.Cli.getCoSQueues(((CoSPanel)CoSPanel.this).theSwitch.esn);
        }

        public boolean setCoSQueues(String[] stringArray) {
            return ((CoSPanel)CoSPanel.this).theSwitch.Cli.setCoSQueues(((CoSPanel)CoSPanel.this).theSwitch.esn, stringArray);
        }

        public boolean setDefaultCoSQueues() {
            return ((CoSPanel)CoSPanel.this).theSwitch.Cli.setDefaultCoSQueues(((CoSPanel)CoSPanel.this).theSwitch.esn);
        }
    }
}

